/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl;

import org.eclipse.persistence.platform.database.oracle.publisher.Util;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.Sortable;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.SqlReflector;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.SqlType;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.Type;

public class Field
implements Sortable {
    private String m_name;
    private Type m_type;
    private int m_dataLength;
    private int m_precision;
    private int m_scale;
    private boolean m_isNChar;
    private SqlReflector m_reflector;

    public Field(String string, Type type, int n, int n2, int n3, boolean bl, SqlReflector sqlReflector) {
        this.m_name = string;
        this.m_type = type;
        this.m_dataLength = n;
        this.m_precision = n2;
        this.m_scale = n3;
        this.m_reflector = sqlReflector;
        this.m_isNChar = bl;
    }

    public Field(String string, Type type, int n, int n2, int n3, String string2, SqlReflector sqlReflector) {
        this(string, type, n, n2, n3, "NCHAR_CS".equals(string2), sqlReflector);
    }

    public String getName() {
        return this.m_name;
    }

    public Type getType() {
        return this.m_type;
    }

    public int getDataLength() {
        return this.m_dataLength;
    }

    public int getPrecision() {
        return this.m_precision;
    }

    public int getScale() {
        return this.m_scale;
    }

    public boolean isNChar() {
        return this.m_isNChar;
    }

    public String printTypeWithLength() {
        String string = this.m_type.getName();
        if (this.m_type instanceof SqlType) {
            string = ((SqlType)this.m_type).getTargetTypeName();
        }
        return Util.printTypeWithLength(string, this.m_dataLength, this.m_precision, this.m_scale);
    }

    public String printTypeWithLength(int n) {
        String string = this.m_type.getName();
        if (this.m_type instanceof SqlType && ((SqlType)this.m_type).getSqlName() != null) {
            string = ((SqlType)this.m_type).getSqlName().getFullTargetTypeName(n);
        }
        return Util.printTypeWithLength(string, this.m_dataLength, this.m_precision, this.m_scale);
    }

    public String toString() {
        return this.m_type.toString() + " " + this.m_name;
    }

    @Override
    public String getSortingKey() {
        return this.getName();
    }
}

