/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.persistence.platform.database.oracle.publisher.MethodFilter;
import org.eclipse.persistence.platform.database.oracle.publisher.PublisherException;
import org.eclipse.persistence.platform.database.oracle.publisher.Util;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.DefaultArgsHolderName;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.DefaultArgsHolderType;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.Field;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.JavaBaseType;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.JavaName;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.JavaType;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.LangName;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.Method;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.Modifier;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.Name;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.PlsqlIndexTableType;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.PlsqlRecordName;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.PlsqlRecordType;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.PlsqlTableName;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.PlsqlTableType;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.SqlArrayType;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.SqlName;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.SqlObjectType;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.SqlPackageType;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.SqlRefType;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.SqlSqljType;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.SqlStmtType;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.SqlTableType;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.SqlToplevelType;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.SqlType;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.Type;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.WrapperMethodMetadata;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.WrapperPackageMetadata;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.AllCollTypes;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.AllTypes;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.ElemInfo;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.FieldInfo;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.RowtypeInfo;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.SingleColumnViewRow;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.UserArguments;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.ViewCache;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.ViewCacheManager;

public class SqlReflector {
    public static final String CHAR_CS = "CHAR_CS";
    public static final String NCHAR_CS = "NCHAR_CS";
    public static final String ROWTYPE = "ROWTYPE";
    public static final String ROWTYPE_PL = "ROWTYPE_PL";
    public static final String ROWTYPE_SQL = "ROWTYPE_SQL";
    private ViewCacheManager m_viewCacheManager;
    private ViewCache m_viewCache;
    private Connection m_conn;
    private Boolean m_isPre920 = null;
    private boolean m_geq9i;
    private boolean m_transitive = true;
    private String m_user;
    private Hashtable m_allTypes;
    private Hashtable m_predefTypes;
    private Vector m_userTypes;
    private HashSet m_allTypeNames;
    private HashSet m_allGeneratedTypeNames;
    private int m_allGeneratedTypeNamesMagicNumber;
    private static final int MAGIC_NUMBER = 0;
    private Hashtable m_allDefaultArgsHolderTypeNames;
    private HashSet m_isReused;
    private boolean m_getTypeCodeWarning = false;
    private SqlStmtType m_sqlStmtType;
    private int m_rowtypeDistinguisher = 0;
    private WrapperPackageMetadata m_wrapperPackageMetadata;
    public static final SqlType BFILE_TYPE = new SqlType("BFILE", -13);
    public static final SqlType BINARY_INTEGER_TYPE = new SqlType(new SqlName("BINARY_INTEGER", "INTEGER"), 4);
    public static final SqlType BLOB_TYPE = new SqlType("BLOB", 2004);
    public static final SqlType CHAR_TYPE = new SqlType("CHAR", 1);
    public static final SqlType CLOB_TYPE = new SqlType("CLOB", 2005);
    public static final SqlType DATE_TYPE = new SqlType("DATE", 91);
    public static final SqlType NCHAR_TYPE = new SqlType("NCHAR", -72054);
    public static final SqlType NCLOB_TYPE = new SqlType("NCLOB", -72055);
    public static final SqlType TIMESTAMP_TYPE = new SqlType("TIMESTAMP", 93);
    public static final SqlType TIMESTAMP_WTZ_TYPE = new SqlType("TIMESTAMP WITH TZ", -101);
    public static final SqlType TIMESTAMPTZ_TYPE = new SqlType("TIMESTAMP WITH TIME ZONE", -101);
    public static final SqlType TIMESTAMPTZ_TYPE0 = new SqlType("TIMESTAMPTZ", -101);
    public static final SqlType TIMESTAMP_WLTZ_TYPE = new SqlType("TIMESTAMP WITH LOCAL TZ", -102);
    public static final SqlType TIMESTAMPLTZ_TYPE = new SqlType("TIMESTAMP WITH LOCAL TIME ZONE", -102);
    public static final SqlType TIMESTAMPLTZ_TYPE0 = new SqlType("TIMESTAMPLTZ", -102);
    public static final SqlType DECIMAL_TYPE = new SqlType("DECIMAL", 3);
    public static final SqlType DOUBLE_PRECISION_TYPE = new SqlType("DOUBLE PRECISION", 8);
    public static final SqlType FLOAT_TYPE = new SqlType("FLOAT", 6);
    public static final SqlType FLOAT38TYPE = new SqlType("FLOAT38", 2);
    public static final SqlType BINARY_DOUBLE_TYPE = new SqlType("BINARY_DOUBLE", 101);
    public static final SqlType BINARY_FLOAT_TYPE = new SqlType("BINARY_FLOAT", 100);
    public static final SqlType INTEGER_TYPE = new SqlType("INTEGER", 4);
    public static final SqlType INT_TYPE = new SqlType("INT", 4);
    public static final SqlType LONG_TYPE = new SqlType(new SqlName("LONG", "VARCHAR2"), 12);
    public static final SqlType LONG_RAW_TYPE = new SqlType(new SqlName("LONG RAW", "RAW"), -2);
    public static final SqlType NUMBER_TYPE = new SqlType("NUMBER", 2);
    public static final SqlType NUMERIC_TYPE = new SqlType("NUMERIC", 2);
    public static final SqlType NVARCHAR2_TYPE = new SqlType("NVARCHAR2", -72054);
    public static final SqlType PLS_INTEGER_TYPE = new SqlType(new SqlName("PLS_INTEGER", "INTEGER"), 4);
    public static final SqlType RAW_TYPE = new SqlType("RAW", -2);
    public static final SqlType REAL_TYPE = new SqlType("REAL", 7);
    public static final SqlType REF_CURSOR_TYPE = new SqlType("REF CURSOR", -10);
    public static final SqlType PLSQL_REF_CURSOR_TYPE = new SqlType("PL/SQL REF CURSOR", -10);
    public static final SqlType ROWID_TYPE = new SqlType(new SqlName("ROWID", "VARCHAR2"), 12);
    public static final SqlType SMALLINT_TYPE = new SqlType("SMALLINT", 5);
    public static final SqlType STRING_TYPE = new SqlType("STRING", 12);
    public static final SqlType UROWID_TYPE = new SqlType(new SqlName("UROWID", "VARCHAR2"), 12);
    public static final SqlType VARCHAR_TYPE = new SqlType("VARCHAR", 12);
    public static final SqlType VARCHAR2_TYPE = new SqlType("VARCHAR2", 12);
    public static SqlType plsqlTableDouble = null;
    public static SqlType plsqlTableFloat = null;
    public static SqlType plsqlTableInt = null;
    public static SqlType plsqlTableShort = null;
    public static SqlType plsqlTableJldouble = null;
    public static SqlType plsqlTableJlfloat = null;
    public static SqlType plsqlTableJlinteger = null;
    public static SqlType plsqlTableJlshort = null;
    public static SqlType plsqlTableJmbigdecimal = null;
    public static SqlType plsqlTableString = null;
    public static final SqlType UNKNOWN_TYPE = new SqlType("<unknown type or type not found>", 1997);
    private Hashtable m_typeMap;

    public SqlReflector(Connection connection, String string) {
        this.m_viewCacheManager = new ViewCacheManager(connection);
        this.m_user = string;
        this.reset(connection);
    }

    public void reset(Connection connection) {
        if (this.m_conn != null) {
            try {
                this.m_conn.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        this.m_conn = connection;
        this.m_viewCache = this.m_viewCacheManager.get(this.m_user);
        if (this.m_viewCache == null) {
            this.m_viewCache = new ViewCache(this.m_conn, this.m_user);
            this.m_viewCacheManager.add(this.m_viewCache);
        } else {
            this.m_viewCache.reset(this.m_conn);
        }
        this.m_allTypes = new Hashtable();
        this.m_predefTypes = new Hashtable();
        this.m_userTypes = new Vector();
        this.sqlTypeInit();
        this.m_allTypeNames = new HashSet();
        this.m_allGeneratedTypeNames = new HashSet();
        this.m_allGeneratedTypeNamesMagicNumber = 0;
        this.m_allDefaultArgsHolderTypeNames = new Hashtable();
        this.m_sqlStmtType = null;
        this.m_isReused = new HashSet();
        this.m_wrapperPackageMetadata = null;
        if (connection != null) {
            this.m_geq9i = SqlReflector.geqOracle9(connection);
        }
    }

    public void loadAllTypeNames() {
        try {
            Iterator iterator = this.m_viewCache.getRows("ALL_TYPES", new String[]{"TYPE_NAME"}, new String[0], new Object[0], new String[0]);
            while (iterator.hasNext()) {
                SingleColumnViewRow singleColumnViewRow = (SingleColumnViewRow)iterator.next();
                this.m_allTypeNames.add(singleColumnViewRow.getValue());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String determineSqlName(String string, String[] stringArray, Type type, boolean[] blArray, Field[] fieldArray, SqlType sqlType, SqlType sqlType2) throws SQLException {
        Object object;
        String string2 = null;
        if (type != null && (object = (SqlName)type.getNameObject()) != null) {
            string2 = ((SqlName)object).getTypeName().toUpperCase();
        }
        object = stringArray[0];
        this.m_allGeneratedTypeNames.add(object);
        if (((String)object).indexOf(46) >= 0 && string2 != null) {
            object = string2 + "_" + ((String)object).substring(((String)object).indexOf(46) + 1);
            this.m_allGeneratedTypeNames.add(string2);
        }
        object = ((String)object).replace('.', '_').replace(' ', '_');
        boolean bl = false;
        if (stringArray[0].equals("PL/SQL RECORD")) {
            blArray[0] = true;
            stringArray[0] = ROWTYPE_PL + this.m_rowtypeDistinguisher++;
            object = ROWTYPE_SQL;
            if (string != null && !string.equals("")) {
                object = string2 != null ? string2 + "_" + (String)object : string + "_" + (String)object;
            }
            bl = true;
        }
        return this.determineSqlName((String)object, bl, fieldArray, sqlType, sqlType2);
    }

    private String determineSqlName(String string, boolean bl, Field[] fieldArray, SqlType sqlType, SqlType sqlType2) throws SQLException {
        String string2;
        String string3 = string;
        if (sqlType2 != null && (string2 = (String)this.m_allDefaultArgsHolderTypeNames.get(string3)) != null) {
            return string2;
        }
        if (this.m_allTypeNames.contains(string)) {
            Iterator iterator;
            Object object;
            boolean bl2 = true;
            if (fieldArray != null) {
                String string4;
                int n;
                object = new HashSet<String>();
                for (n = 0; n < fieldArray.length; ++n) {
                    string4 = ((SqlName)fieldArray[n].getType().getNameObject()).getTargetTypeName();
                    ((HashSet)object).add(string4 + fieldArray[n].getName());
                }
                iterator = this.m_viewCache.getRows("ALL_TYPE_ATTRS", new String[]{"CONCAT(ATTR_TYPE_NAME,ATTR_NAME)"}, new String[]{"TYPE_NAME"}, new Object[]{string}, new String[0]);
                n = 0;
                while (iterator.hasNext()) {
                    string4 = ((SingleColumnViewRow)iterator.next()).getValue();
                    if (!((HashSet)object).contains(string4)) {
                        bl2 = false;
                    }
                    ++n;
                }
                bl2 = bl2 && n == ((HashSet)object).size();
            } else if (sqlType != null) {
                iterator = this.m_viewCache.getRows("ALL_COLL_TYPES", new String[]{"ELEM_TYPE_NAME"}, new String[]{"TYPE_NAME"}, new Object[]{string}, new String[0]);
                if (iterator.hasNext()) {
                    object = ((SingleColumnViewRow)iterator.next()).getValue();
                    String string5 = sqlType.getSqlName().getTargetTypeName();
                    bl2 = ((String)object).equalsIgnoreCase(string5);
                } else {
                    bl2 = false;
                }
            } else if (sqlType2 != null) {
                iterator = this.m_viewCache.getRows("ALL_TYPE_ATTRS", new String[]{"ATTR_TYPE_NAME"}, new String[]{"TYPE_NAME"}, new Object[]{string}, new String[0]);
                if (iterator.hasNext()) {
                    object = ((SingleColumnViewRow)iterator.next()).getValue();
                    String string6 = sqlType2.getSqlName().getTargetTypeName();
                    bl2 = ((String)object).equalsIgnoreCase(string6);
                } else {
                    bl2 = false;
                }
            }
            if (bl2) {
                this.m_isReused.add(string);
                return string;
            }
        }
        if (this.m_allTypeNames.contains(string2 = string.toUpperCase()) || bl && this.m_allGeneratedTypeNames.contains(string2)) {
            do {
                int n;
                int n2;
                if ((n2 = string.length()) + (n = Integer.toString(this.m_allGeneratedTypeNamesMagicNumber++).length()) <= 29) continue;
                string = string.substring(0, 29 - n);
            } while (this.m_allTypeNames.contains(string2 = string.toUpperCase() + this.m_allGeneratedTypeNamesMagicNumber) || bl && this.m_allGeneratedTypeNames.contains(string2));
        }
        this.m_allGeneratedTypeNames.add(string2);
        if (sqlType2 != null) {
            this.m_allDefaultArgsHolderTypeNames.put(string3, string2);
        }
        return string2;
    }

    void addAllGeneratedTypeNames(String string) {
        this.m_allGeneratedTypeNames.add(string.toUpperCase());
    }

    public boolean isReused(String string) {
        return this.m_isReused.contains(string);
    }

    public void setViewCachePoolCapacity(int n) {
        this.m_viewCacheManager.setViewCachePoolCapacity(n);
    }

    private void sqlTypeInit() {
        if (!this.m_allTypes.isEmpty()) {
            this.m_allTypes = new Hashtable();
        }
        this.m_allTypes.put(SqlReflector.BFILE_TYPE.m_name, BFILE_TYPE);
        this.m_allTypes.put(SqlReflector.BINARY_INTEGER_TYPE.m_name, BINARY_INTEGER_TYPE);
        this.m_allTypes.put(SqlReflector.BLOB_TYPE.m_name, BLOB_TYPE);
        this.m_allTypes.put(SqlReflector.CHAR_TYPE.m_name, CHAR_TYPE);
        this.m_allTypes.put(SqlReflector.CLOB_TYPE.m_name, CLOB_TYPE);
        this.m_allTypes.put(SqlReflector.DATE_TYPE.m_name, DATE_TYPE);
        this.m_allTypes.put(SqlReflector.NCHAR_TYPE.m_name, NCHAR_TYPE);
        this.m_allTypes.put(SqlReflector.NCLOB_TYPE.m_name, NCLOB_TYPE);
        this.m_allTypes.put(SqlReflector.TIMESTAMP_TYPE.m_name, TIMESTAMP_TYPE);
        this.m_allTypes.put(SqlReflector.TIMESTAMP_WTZ_TYPE.m_name, TIMESTAMP_WTZ_TYPE);
        this.m_allTypes.put(SqlReflector.TIMESTAMPTZ_TYPE.m_name, TIMESTAMPTZ_TYPE);
        this.m_allTypes.put(SqlReflector.TIMESTAMPTZ_TYPE0.m_name, TIMESTAMPTZ_TYPE0);
        this.m_allTypes.put(SqlReflector.TIMESTAMP_WLTZ_TYPE.m_name, TIMESTAMP_WLTZ_TYPE);
        this.m_allTypes.put(SqlReflector.TIMESTAMPLTZ_TYPE.m_name, TIMESTAMPLTZ_TYPE);
        this.m_allTypes.put(SqlReflector.TIMESTAMPLTZ_TYPE0.m_name, TIMESTAMPLTZ_TYPE0);
        this.m_allTypes.put(SqlReflector.DECIMAL_TYPE.m_name, DECIMAL_TYPE);
        this.m_allTypes.put(SqlReflector.BINARY_DOUBLE_TYPE.m_name, BINARY_DOUBLE_TYPE);
        this.m_allTypes.put(SqlReflector.DOUBLE_PRECISION_TYPE.m_name, DOUBLE_PRECISION_TYPE);
        this.m_allTypes.put(SqlReflector.FLOAT_TYPE.m_name, FLOAT_TYPE);
        this.m_allTypes.put(SqlReflector.FLOAT38TYPE.m_name, FLOAT38TYPE);
        this.m_allTypes.put(SqlReflector.BINARY_FLOAT_TYPE.m_name, BINARY_FLOAT_TYPE);
        this.m_allTypes.put(SqlReflector.INTEGER_TYPE.m_name, INTEGER_TYPE);
        this.m_allTypes.put(SqlReflector.INT_TYPE.m_name, INT_TYPE);
        this.m_allTypes.put(SqlReflector.LONG_TYPE.m_name, LONG_TYPE);
        this.m_allTypes.put(SqlReflector.LONG_RAW_TYPE.m_name, LONG_RAW_TYPE);
        this.m_allTypes.put(SqlReflector.NUMBER_TYPE.m_name, NUMBER_TYPE);
        this.m_allTypes.put(SqlReflector.NUMERIC_TYPE.m_name, NUMERIC_TYPE);
        this.m_allTypes.put(SqlReflector.NVARCHAR2_TYPE.m_name, NVARCHAR2_TYPE);
        this.m_allTypes.put(SqlReflector.PLS_INTEGER_TYPE.m_name, PLS_INTEGER_TYPE);
        this.m_allTypes.put(SqlReflector.RAW_TYPE.m_name, RAW_TYPE);
        this.m_allTypes.put(SqlReflector.REAL_TYPE.m_name, REAL_TYPE);
        this.m_allTypes.put(SqlReflector.REF_CURSOR_TYPE.m_name, REF_CURSOR_TYPE);
        this.m_allTypes.put(SqlReflector.PLSQL_REF_CURSOR_TYPE.m_name, PLSQL_REF_CURSOR_TYPE);
        this.m_allTypes.put(SqlReflector.ROWID_TYPE.m_name, ROWID_TYPE);
        this.m_allTypes.put(SqlReflector.SMALLINT_TYPE.m_name, SMALLINT_TYPE);
        this.m_allTypes.put(SqlReflector.STRING_TYPE.m_name, STRING_TYPE);
        this.m_allTypes.put(SqlReflector.UROWID_TYPE.m_name, UROWID_TYPE);
        this.m_allTypes.put(SqlReflector.VARCHAR_TYPE.m_name, VARCHAR_TYPE);
        this.m_allTypes.put(SqlReflector.VARCHAR2_TYPE.m_name, VARCHAR2_TYPE);
        String string = "PLSQL_TABLE_DOUBLE";
        SqlName sqlName = new SqlName(string, string);
        sqlName.setAnnotation(new JavaName("", "double[]", null, "double[]", null));
        plsqlTableDouble = new PlsqlIndexTableType(sqlName, true);
        string = "PLSQL_TABLE_FLOAT";
        sqlName = new SqlName(string, string);
        sqlName.setAnnotation(new JavaName("", "float[]", null, "float[]", null));
        plsqlTableFloat = new PlsqlIndexTableType(sqlName, true);
        string = "PLSQL_TABLE_INT";
        sqlName = new SqlName(string, string);
        sqlName.setAnnotation(new JavaName("", "int[]", null, "int[]", null));
        plsqlTableInt = new PlsqlIndexTableType(sqlName, true);
        string = "PLSQL_TABLE_SHORT";
        sqlName = new SqlName(string, string);
        sqlName.setAnnotation(new JavaName("", "short[]", null, "short[]", null));
        plsqlTableShort = new PlsqlIndexTableType(sqlName, true);
        string = "PLSQL_TABLE_JLDOUBLE";
        sqlName = new SqlName(string, string);
        sqlName.setAnnotation(new JavaName("", "Double[]", null, "Double[]", null));
        plsqlTableJldouble = new PlsqlIndexTableType(sqlName, true);
        string = "PLSQL_TABLE_JLFLOAT";
        sqlName = new SqlName(string, string);
        sqlName.setAnnotation(new JavaName("", "Float[]", null, "Float[]", null));
        plsqlTableJlfloat = new PlsqlIndexTableType(sqlName, true);
        string = "PLSQL_TABLE_JLINTEGER";
        sqlName = new SqlName(string, string);
        sqlName.setAnnotation(new JavaName("", "Integer[]", null, "Integer[]", null));
        plsqlTableJlinteger = new PlsqlIndexTableType(sqlName, true);
        string = "PLSQL_TABLE_JLSHORT";
        sqlName = new SqlName(string, string);
        sqlName.setAnnotation(new JavaName("", "Short[]", null, "Short[]", null));
        plsqlTableJlshort = new PlsqlIndexTableType(sqlName, true);
        string = "PLSQL_TABLE_JLINTEGER";
        sqlName = new SqlName(string, string);
        sqlName.setAnnotation(new JavaName("", "Integer[]", null, "Integer[]", null));
        plsqlTableJlinteger = new PlsqlIndexTableType(sqlName, true);
        string = "PLSQL_TABLE_JMBIGDECIMAL";
        sqlName = new SqlName(string, string);
        sqlName.setAnnotation(new JavaName("", "java.math.BigDecimal[]", null, "java.math.BigDecimal[]", null));
        plsqlTableJmbigdecimal = new PlsqlIndexTableType(sqlName, true);
        string = "PLSQL_TABLE_STRING";
        sqlName = new SqlName(string, string);
        sqlName.setAnnotation(new JavaName("", "String[]", null, "String[]", null));
        plsqlTableString = new PlsqlIndexTableType(sqlName, false);
        this.m_allTypes.put(SqlReflector.plsqlTableDouble.m_name, plsqlTableDouble);
        this.m_allTypes.put(SqlReflector.plsqlTableFloat.m_name, plsqlTableFloat);
        this.m_allTypes.put(SqlReflector.plsqlTableInt.m_name, plsqlTableInt);
        this.m_allTypes.put(SqlReflector.plsqlTableShort.m_name, plsqlTableShort);
        this.m_allTypes.put(SqlReflector.plsqlTableJldouble.m_name, plsqlTableJldouble);
        this.m_allTypes.put(SqlReflector.plsqlTableJlfloat.m_name, plsqlTableJlfloat);
        this.m_allTypes.put(SqlReflector.plsqlTableJlshort.m_name, plsqlTableJlshort);
        this.m_allTypes.put(SqlReflector.plsqlTableJlinteger.m_name, plsqlTableJlinteger);
        this.m_allTypes.put(SqlReflector.plsqlTableJmbigdecimal.m_name, plsqlTableJmbigdecimal);
        this.m_allTypes.put(SqlReflector.plsqlTableString.m_name, plsqlTableString);
        String string2 = "/*[32767]*/";
        plsqlTableDouble.setHint(string2);
        plsqlTableFloat.setHint(string2);
        plsqlTableInt.setHint(string2);
        plsqlTableShort.setHint(string2);
        plsqlTableJldouble.setHint(string2);
        plsqlTableJlfloat.setHint(string2);
        plsqlTableJlinteger.setHint(string2);
        plsqlTableJlshort.setHint(string2);
        plsqlTableString.setHint(string2);
        plsqlTableJmbigdecimal.setHint(string2);
        this.m_allTypes.put(SqlReflector.UNKNOWN_TYPE.m_name, UNKNOWN_TYPE);
    }

    public Connection getConnection() {
        return this.m_conn;
    }

    public SqlType addSqlType(SqlName sqlName, int n, boolean bl, boolean bl2, SqlType sqlType, String string) throws SQLException, PublisherException {
        return this.addSqlType(sqlName, n, bl, bl2, sqlType, string, false, null);
    }

    public SqlType addSqlType(SqlName sqlName, int n, boolean bl, boolean bl2, SqlType sqlType, String string, boolean bl3, MethodFilter methodFilter) throws SQLException, PublisherException {
        SqlType sqlType2 = null;
        try {
            Iterator iterator;
            if (bl3) {
                if (sqlName.getTypeName().equals("CHAR")) {
                    sqlName = NCHAR_TYPE.getSqlName();
                } else if (sqlName.getTypeName().equals("VARCHAR2")) {
                    sqlName = NVARCHAR2_TYPE.getSqlName();
                } else if (sqlName.getTypeName().equals("CLOB")) {
                    sqlName = NCLOB_TYPE.getSqlName();
                }
            }
            SqlType sqlType3 = this.findType(sqlName);
            boolean bl4 = false;
            if (sqlType3 == null) {
                sqlType3 = this.findPredefType(sqlName);
                bl4 = true;
            }
            if (sqlType3 != null) {
                sqlType2 = sqlType3;
                if (bl && bl4) {
                    throw new PublisherException("duplicate type " + sqlType2.toString());
                }
                if (bl) {
                    sqlType3.setNameObject(sqlName);
                }
                return sqlType2;
            }
            String string2 = sqlName.getSchemaName();
            String string3 = sqlName.getTypeName();
            if (n == 12) {
                return new SqlToplevelType(sqlName, sqlType, methodFilter, this);
            }
            if ((n & 4) != 0) {
                iterator = this.m_viewCache.getRows("ALL_OBJECTS", new String[]{"'PACKAGE' AS TYPECODE"}, new String[]{"OWNER", "OBJECT_NAME", "OBJECT_TYPE", "STATUS"}, new Object[]{string2, string3, "PACKAGE", "VALID"}, new String[0]);
                if (iterator.hasNext()) {
                    this.m_viewCache.fetch(string3, methodFilter);
                    sqlType2 = new SqlPackageType(sqlName, sqlType, methodFilter, this);
                }
                if (sqlType2 != null) {
                    return sqlType2;
                }
                if (n == 4) {
                    throw new PublisherException("package not found " + sqlName.toString());
                }
            }
            if ((iterator = this.m_viewCache.getRows("ALL_TYPES", new String[0], new String[]{"OWNER", "TYPE_NAME", "PREDEFINED"}, new Object[]{string2, string3, "NO"}, new String[0])).hasNext()) {
                Object object;
                Object object2;
                int n2;
                int n3;
                String string4;
                block42: {
                    AllTypes allTypes = (AllTypes)iterator.next();
                    string4 = allTypes.typeCode;
                    byte[] byArray = allTypes.typeOid;
                    n3 = 0;
                    n2 = 0;
                    if (!this.m_getTypeCodeWarning) {
                        try {
                            object2 = this.m_viewCache.getOutParameters("BEGIN sys.sqljutl.get_typecode(:1, :2, :3, :4); END;", new Object[]{byArray}, new int[]{4, 12, 4});
                            if (object2 == null) {
                                throw new SQLException("no data from sqljutl.get_typecode call");
                            }
                            n3 = (Integer)object2[0];
                            String string5 = (String)object2[1];
                            n2 = (Integer)object2[2];
                        }
                        catch (SQLException sQLException) {
                            object = sQLException.getMessage();
                            if (this.isPre920()) {
                                object = null;
                                this.m_getTypeCodeWarning = true;
                            } else if (((String)object).indexOf("PLS-00201") > 0) {
                                object = "cannot determine type " + string3;
                                this.m_getTypeCodeWarning = true;
                            } else {
                                object = "error determining type " + string3;
                            }
                            if (object == null) break block42;
                            throw new PublisherException((String)object);
                        }
                    }
                }
                if (n3 == 58) {
                    sqlType2 = new SqlObjectType(sqlName, 2007, bl2, sqlType, this);
                } else if (n3 == 108 && n2 != 0) {
                    sqlType2 = new SqlSqljType(sqlName, n2, sqlType, this);
                } else if (string4.equals("OBJECT")) {
                    sqlType2 = new SqlObjectType(sqlName, bl2, sqlType, this);
                    if (SqlName.langIsOtt()) {
                        new SqlRefType(sqlName, sqlType2, sqlType, bl2, this);
                    }
                    if (Modifier.isIncomplete(sqlType2.getModifiers())) {
                        int n4 = sqlName.getLine();
                        int n5 = sqlName.getColumn();
                        String string6 = "incomplete type " + sqlName.toString();
                        if (n4 > 0 || n5 > 0) {
                            string6 = "" + n4 + "." + n5 + ": " + string6;
                        }
                        System.err.println(string6);
                    }
                } else if (string4.equals("COLLECTION")) {
                    if ((n & 2) == 0) {
                        throw new PublisherException("collection found " + sqlName.toString());
                    }
                    object2 = this.m_viewCache.getRows("ALL_COLL_TYPES", new String[0], new String[]{"OWNER", "TYPE_NAME"}, new Object[]{string2, string3}, new String[0]);
                    if (object2.hasNext()) {
                        object = (AllCollTypes)object2.next();
                        String string7 = ((AllCollTypes)object).collType;
                        sqlType2 = string7.equals("TABLE") ? new SqlTableType(sqlName, bl2, sqlType, this) : new SqlArrayType(sqlName, bl2, sqlType, this);
                    }
                }
            }
            if (sqlType2 != null) {
                return sqlType2;
            }
            if (sqlType2 != null) {
                return sqlType2;
            }
            sqlType2 = this.addPredefType(sqlName, 1997);
            if ((n & 4) != 0) {
                throw new PublisherException("type not found " + sqlName.toString());
            }
        }
        catch (SQLException sQLException) {
            System.err.println(sQLException.getMessage());
        }
        catch (PublisherException publisherException) {
            System.err.println(publisherException.getMessage());
        }
        return sqlType2;
    }

    public SqlType addSqlUserType(String string, String string2, int n, boolean bl, int n2, int n3, MethodFilter methodFilter) throws SQLException, PublisherException {
        SqlName sqlName = new SqlName(string, string2, false, n2, n3, this);
        return this.addSqlType(sqlName, n, bl, true, null, null, false, methodFilter);
    }

    private SqlType addSqlDBType(SqlName sqlName, String string, boolean bl, SqlType sqlType) throws SQLException, PublisherException {
        if (string != null && string.equals("REF")) {
            SqlType sqlType2 = this.addSqlType(sqlName, 3, false, this.m_transitive, sqlType, string);
            SqlRefType sqlRefType = new SqlRefType(sqlName, sqlType2, sqlType, this.m_transitive, this);
            return sqlRefType;
        }
        return this.addSqlType(sqlName, 3, false, this.m_transitive, sqlType, string, bl, null);
    }

    public SqlType addSqlDBType(String string, String string2, String string3, String string4, boolean bl, SqlType sqlType) throws SQLException, PublisherException {
        SqlName sqlName;
        int n = 0;
        int n2 = 0;
        if (sqlType != null) {
            sqlName = (SqlName)sqlType.getNameObject();
            n = sqlName.getLine();
            n2 = sqlName.getColumn();
        }
        if (string3 != null) {
            string2 = string2 != null ? string2 + "." + string3 : string3;
            if (string != null) {
                string2 = string + "." + string2;
                string = null;
            }
        }
        sqlName = new SqlName(string, string2, true, n, n2, this);
        sqlName.setAnnotation(this.genPattern((LangName)sqlName.getAnnotation(), sqlName.getSimpleName(), true));
        return this.addSqlDBType(sqlName, string4, bl, sqlType);
    }

    public SqlType addPlsqlDBType(String string, String string2, String string3, String string4, boolean bl, String string5, String string6, String string7, int n, SqlType sqlType) throws SQLException, PublisherException {
        return this.addPlsqlDBType(string, string2, string3, string4, bl, string5, string6, string7, n, sqlType, false);
    }

    public SqlType addPlsqlDBType(String string, String string2, String string3, String string4, boolean bl, String string5, String string6, String string7, int n, SqlType sqlType, boolean bl2) throws SQLException, PublisherException {
        SqlType sqlType2;
        Object object;
        Object object2;
        boolean bl3;
        RowtypeInfo[] rowtypeInfoArray;
        int n2 = 0;
        int n3 = 0;
        if (sqlType != null) {
            rowtypeInfoArray = (RowtypeInfo[])sqlType.getNameObject();
            n2 = rowtypeInfoArray.getLine();
            n3 = rowtypeInfoArray.getColumn();
        }
        if (string3 != null) {
            string2 = string2 != null ? string2 + "." + string3 : string3;
            if (string != null) {
                string2 = string + "." + string2;
                string = null;
            }
        }
        if (string4 == null || !string4.equals("PL/SQL RECORD") && !string4.equals("PL/SQL TABLE") && (!string4.equals("TABLE") || string3 == null && string2.indexOf(".") == -1) && (!string4.equals("VARRAY") || string3 == null && string2.indexOf(".") == -1)) {
            rowtypeInfoArray = new SqlName(string, string2, true, n2, n3, this);
            rowtypeInfoArray.setAnnotation(this.genPattern((LangName)rowtypeInfoArray.getAnnotation(), rowtypeInfoArray.getSimpleName(), true));
            return this.addSqlDBType((SqlName)rowtypeInfoArray, string4, bl, sqlType);
        }
        rowtypeInfoArray = null;
        if (string4 != null && string2 != null && string4.equals("PL/SQL RECORD") && string2.equals("PL/SQL RECORD")) {
            rowtypeInfoArray = this.reflectRowtypeInfo(string5, string6, string7, n);
            for (int i = 0; i < this.m_userTypes.size(); ++i) {
                bl3 = true;
                object2 = (Type)this.m_userTypes.elementAt(i);
                if (!(object2 instanceof PlsqlRecordType)) continue;
                object = ((PlsqlRecordType)object2).getRowtypeInfo();
                if (object == null || rowtypeInfoArray == null || rowtypeInfoArray.length != ((Field[])object).length) {
                    bl3 = false;
                    continue;
                }
                for (int j = 0; j < rowtypeInfoArray.length; ++j) {
                    boolean bl4 = false;
                    for (int k = 0; k < ((Field[])object).length; ++k) {
                        if (!rowtypeInfoArray[j].equals(object[k])) continue;
                        bl4 = true;
                        break;
                    }
                    if (bl4) continue;
                    bl3 = false;
                    break;
                }
                if (!bl3) continue;
                return (SqlType)object2;
            }
        }
        boolean bl5 = bl3 = (sqlType2 = this.findPredefType(string, string2)) != null;
        if (!bl3) {
            sqlType2 = this.findType(string, string2);
        }
        if (sqlType2 != null) {
            if (sqlType2.getTypecode() != -72057) {
                return sqlType2;
            }
            if (!bl3) {
                if (string4 != null && string4.equals("PL/SQL RECORD")) {
                    sqlType2.setTypecode(1992);
                } else if (string4 != null && string4.equals("PL/SQL TABLE")) {
                    sqlType2.setTypecode(-14);
                } else if (string4 != null && string4.equals("TABLE")) {
                    sqlType2.setTypecode(1991);
                } else if (string4 != null && string4.equals("VARRAY")) {
                    sqlType2.setTypecode(1990);
                }
                return sqlType2;
            }
        }
        if (string4 != null && string4.equals("PL/SQL RECORD")) {
            object2 = PlsqlRecordType.getFieldInfo(string5, string6, string7, n, this);
            object = PlsqlRecordType.reflectFields(false, object2, this, sqlType, true);
            if (bl3) {
                String string8 = sqlType2.getHint();
                sqlType2 = new PlsqlRecordType(sqlType2.getSqlName(), (FieldInfo[])object2, (Field[])object, rowtypeInfoArray, false, sqlType, this);
                sqlType2.setHint(string8);
            } else {
                PlsqlRecordName plsqlRecordName = new PlsqlRecordName(string, string2, true, n2, n3, string5, sqlType, (Field[])object, this);
                plsqlRecordName.setAnnotation(this.genPattern((LangName)plsqlRecordName.getAnnotation(), plsqlRecordName.getSimpleName(), true));
                sqlType2 = new PlsqlRecordType(plsqlRecordName, (FieldInfo[])object2, (Field[])object, rowtypeInfoArray, true, sqlType, this);
            }
        } else {
            int n4 = 1997;
            if (string4 != null && string4.equals("PL/SQL TABLE")) {
                n4 = -14;
            } else if (string4 != null && string4.equals("TABLE") && string2.indexOf(".") > -1) {
                n4 = 1991;
            } else if (string4 != null && string4.equals("VARRAY") && string2.indexOf(".") > -1) {
                n4 = 1990;
            }
            if (n4 != 1997) {
                object = PlsqlTableType.getElemInfo(string, string2, string5, string6, string7, this.m_viewCache);
                int[] nArray = new int[3];
                SqlType sqlType3 = (SqlType)PlsqlTableType.getComponentType((ElemInfo)object, this, sqlType, nArray);
                if (bl3) {
                    String string9 = sqlType2.getHint();
                    sqlType2 = PlsqlTableType.newInstance(sqlType2.getSqlName(), n4, (ElemInfo)object, sqlType3, nArray, false, sqlType, bl2, this);
                    sqlType2.setHint(string9);
                } else {
                    PlsqlTableName plsqlTableName = new PlsqlTableName(string, string2, true, n2, n3, string5, sqlType, sqlType3, this);
                    plsqlTableName.setAnnotation(this.genPattern((LangName)plsqlTableName.getAnnotation(), plsqlTableName.getSimpleName(), true));
                    sqlType2 = PlsqlTableType.newInstance(plsqlTableName, n4, (ElemInfo)object, sqlType3, nArray, true, sqlType, bl2, this);
                }
            }
        }
        if (sqlType2 != null) {
            return sqlType2;
        }
        throw new PublisherException("unsupported Type " + string + "." + string2);
    }

    RowtypeInfo[] reflectRowtypeInfo(String string, String string2, String string3, int n) throws SQLException {
        int n2;
        int n3;
        RowtypeInfo[] rowtypeInfoArray;
        Iterator iterator = this.m_viewCache.getRows("ALL_ARGUMENTS", new String[0], new String[]{"PACKAGE_NAME", "OBJECT_NAME", "OVERLOAD"}, new Object[]{string, string2, string3}, new String[0]);
        Vector<RowtypeInfo[]> vector = new Vector<RowtypeInfo[]>();
        while (iterator.hasNext()) {
            rowtypeInfoArray = (UserArguments)iterator.next();
            vector.addElement(rowtypeInfoArray);
        }
        rowtypeInfoArray = RowtypeInfo.getRowtypeInfo(vector);
        int n4 = 0;
        for (n3 = 0; n3 < rowtypeInfoArray.length; ++n3) {
            RowtypeInfo rowtypeInfo = rowtypeInfoArray[n3];
            if (n != -1 && n != rowtypeInfo.sequence()) continue;
            n4 = rowtypeInfo.data_level();
            break;
        }
        n3 = -1;
        for (int i = 0; i < rowtypeInfoArray.length; ++i) {
            RowtypeInfo rowtypeInfo = rowtypeInfoArray[i];
            if (n4 != rowtypeInfo.data_level() || n != -1 && n >= rowtypeInfo.sequence()) continue;
            n3 = rowtypeInfo.sequence();
            break;
        }
        ++n4;
        Vector<RowtypeInfo> vector2 = new Vector<RowtypeInfo>();
        for (n2 = 0; n2 < rowtypeInfoArray.length; ++n2) {
            RowtypeInfo rowtypeInfo = rowtypeInfoArray[n2];
            if (n != -1 && n >= rowtypeInfo.sequence() || n4 != rowtypeInfo.data_level() || n3 != -1 && n3 <= rowtypeInfo.sequence()) continue;
            vector2.addElement(rowtypeInfo);
        }
        rowtypeInfoArray = new RowtypeInfo[vector2.size()];
        for (n2 = 0; n2 < vector2.size(); ++n2) {
            rowtypeInfoArray[n2] = (RowtypeInfo)vector2.elementAt(n2);
            rowtypeInfoArray[n2].data_level(rowtypeInfoArray[n2].data_level() - n4 + 1);
        }
        return rowtypeInfoArray;
    }

    public SqlType addPredefType(String string, String string2, int n, String string3, String string4, String string5, String string6) throws PublisherException {
        String string7;
        SqlName sqlName = new SqlName(string, string2, false, false, true, string4, string5, string6, this);
        boolean bl = false;
        int n2 = Integer.valueOf("4000");
        int n3 = -1;
        boolean bl2 = true;
        int n4 = string3.indexOf("[");
        if (n4 >= 0) {
            string7 = "/*" + string3.substring(n4).trim() + "*/";
            bl = true;
            int n5 = n4;
            int n6 = string3.indexOf("]");
            if (n6 > -1) {
                try {
                    n2 = Integer.parseInt(string3.substring(n5 + 1, n6));
                }
                catch (NumberFormatException numberFormatException) {
                    System.err.println("ERROR: number format error: " + string3);
                }
            }
            n5 = string3.indexOf("(");
            n6 = string3.indexOf(")");
            if (n5 > -1 && n6 > -1) {
                try {
                    n3 = Integer.parseInt(string3.substring(n5 + 1, n6));
                }
                catch (NumberFormatException numberFormatException) {
                    System.err.println("ERROR: number format error: " + string3);
                }
            }
            if ("String".equals(string3 = string3.substring(0, n4)) || "java.lang.String".equals(string3)) {
                bl2 = false;
            }
            string3 = string3 + "[]";
            if (n3 == -1) {
                n3 = Integer.valueOf(Util.getDefaultTypeLen("VARCHAR2"));
            }
        } else {
            string7 = "";
        }
        sqlName.setLangName(null, string3, null, null, null, null, null, null, true);
        SqlType sqlType = null;
        if (bl) {
            sqlType = new PlsqlIndexTableType(sqlName, bl2, n2, n3);
            this.m_predefTypes.put(sqlName, sqlType);
        } else {
            sqlType = this.addPredefType(sqlName, n);
        }
        sqlType.setHint(string7);
        return sqlType;
    }

    public SqlType addPredefType(SqlName sqlName, int n) throws PublisherException {
        Object object;
        boolean bl = true;
        String string = (sqlName.getDeclPackage() != null && sqlName.getDeclPackage().length() > 0 ? sqlName.getDeclPackage() + "." : "") + sqlName.getDeclClass();
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string);
        }
        catch (Throwable throwable) {
            try {
                clazz = Class.forName("java.lang." + string);
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
        }
        if (clazz == null) {
            bl = false;
        } else if (clazz != null) {
            try {
                object = clazz.getField("_SQL_TYPENAME");
                bl = false;
            }
            catch (Throwable throwable) {
                try {
                    java.lang.reflect.Field field = clazz.getField("_SQL_NAME");
                    bl = false;
                }
                catch (Throwable throwable3) {
                    // empty catch block
                }
            }
        }
        if (string.equals("boolean") || string.equals("int") || string.equals("short") || string.equals("double") || string.equals("float") || string.equals("long") || string.equals("byte") || string.equals("char") || string.endsWith("[]")) {
            bl = true;
        }
        if (n == 1997 || n == -72057) {
            if ("INTEGER".equals(sqlName.getTargetTypeName())) {
                n = 4;
            }
            if ("CHAR".equals(sqlName.getTargetTypeName())) {
                n = 1;
            }
        }
        object = null;
        if (!bl) {
            try {
                object = new SqlObjectType(sqlName, n, false, null, this);
            }
            catch (Exception exception) {
                System.err.println(exception.getMessage());
            }
        } else {
            object = new SqlType(sqlName, n, false, bl, null, this);
        }
        if (object == null) {
            throw new PublisherException("Cannot find Type " + sqlName);
        }
        this.m_predefTypes.put(sqlName, object);
        return object;
    }

    public void addType(Name name, Type type, boolean bl) {
        this.m_allTypes.put(name, type);
        if (bl) {
            this.m_userTypes.addElement(type);
        }
    }

    public SqlType addDefaultArgsHolderType(SqlType sqlType, String string, SqlType sqlType2, boolean bl) throws SQLException, PublisherException {
        String string2 = "";
        string2 = sqlType.getSqlName().getTypeName().indexOf(".") > -1 ? string2 + sqlType.getSqlName().getSimpleName() : string2 + sqlType.getSqlName().getTypeName();
        DefaultArgsHolderName defaultArgsHolderName = new DefaultArgsHolderName(null, string2, true, 0, 0, string, sqlType2, sqlType, this);
        SqlType sqlType3 = this.findType(defaultArgsHolderName);
        if (sqlType3 == null) {
            defaultArgsHolderName.setAnnotation(this.genPattern((LangName)defaultArgsHolderName.getAnnotation(), defaultArgsHolderName.getSimpleName(), true));
            sqlType3 = new DefaultArgsHolderType(defaultArgsHolderName, sqlType, bl, this);
        }
        return sqlType3;
    }

    public Enumeration getPlsqlUserTypes() {
        int n;
        boolean bl;
        Object object;
        Vector<SqlType> vector = new Vector<SqlType>();
        for (int i = 0; i < this.m_userTypes.size(); ++i) {
            if (!(this.m_userTypes.elementAt(i) instanceof SqlType)) continue;
            SqlType sqlType = (SqlType)this.m_userTypes.elementAt(i);
            object = sqlType.getName();
            if (!sqlType.isPlsqlRecord() && !sqlType.isPlsqlTable() && !(sqlType instanceof DefaultArgsHolderType)) continue;
            bl = false;
            for (n = 0; n < vector.size(); ++n) {
                String string = ((SqlType)vector.elementAt(n)).getName();
                if (((String)object).compareTo(string) >= 0) continue;
                vector.insertElementAt(sqlType, n);
                bl = true;
                break;
            }
            if (bl) continue;
            vector.addElement(sqlType);
        }
        Vector<Object> vector2 = new Vector<Object>();
        for (int i = 0; i < vector.size(); ++i) {
            object = (SqlType)vector.elementAt(i);
            bl = false;
            for (n = 0; n < vector2.size(); ++n) {
                if (!((SqlType)vector2.elementAt(n)).dependsOn((SqlType)object)) continue;
                vector2.insertElementAt(object, n);
                bl = true;
                break;
            }
            if (bl) continue;
            vector2.addElement(object);
        }
        return vector2.elements();
    }

    public boolean isUserType(Type type) {
        if (type instanceof SqlType) {
            for (int i = 0; i < this.m_userTypes.size(); ++i) {
                if (!this.m_userTypes.elementAt(i).equals(type)) continue;
                return true;
            }
        }
        return false;
    }

    private SqlType findType(SqlName sqlName) {
        return this._findType(this.m_allTypes, sqlName);
    }

    private SqlType findType(String string, String string2) {
        SqlName sqlName = new SqlName(Util.getSchema(string, string2), Util.getType(string, string2), false, this);
        return this._findType(this.m_allTypes, sqlName);
    }

    private SqlType findPredefType(SqlName sqlName) {
        return this._findType(this.m_predefTypes, sqlName);
    }

    private SqlType findPredefType(String string, String string2) {
        SqlName sqlName = new SqlName(string, string2, false, this);
        return this._findType(this.m_predefTypes, sqlName);
    }

    private SqlType _findType(Hashtable hashtable, SqlName sqlName) {
        return (SqlType)hashtable.get(sqlName);
    }

    public SqlType findType(String string) {
        String string2 = Util.getSchema(null, string);
        SqlName sqlName = new SqlName(string2, string = Util.getType(null, string), false, this);
        SqlType sqlType = this.findType(sqlName);
        if (sqlType == null) {
            sqlType = this.findPredefType(sqlName);
        }
        return sqlType;
    }

    public void addAllTypes(String string) throws SQLException, PublisherException {
        if (this.m_conn != null) {
            Iterator iterator = this.m_viewCache.getRows("ALL_TYPES", new String[0], new String[]{"OWNER", "PREDEFINED"}, new Object[]{string, "NO"}, new String[]{"TYPE_NAME"});
            while (iterator.hasNext()) {
                AllTypes allTypes = (AllTypes)iterator.next();
                this.addSqlDBType(string, allTypes.typeName, null, "", false, null);
            }
        }
    }

    public void addAllPackages(String string) throws SQLException, PublisherException {
        if (this.m_conn != null) {
            int n;
            PreparedStatement preparedStatement = this.m_conn.prepareStatement("SELECT OBJECT_NAME AS TYPE_NAME FROM ALL_OBJECTS WHERE OWNER = :1 AND OBJECT_TYPE = 'PACKAGE' AND STATUS='VALID'");
            preparedStatement.setString(1, string);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                SqlName sqlName = new SqlName(string, resultSet.getString(1), true, this);
                sqlName.setAnnotation(this.genPattern((LangName)sqlName.getAnnotation(), sqlName.getSimpleName(), true));
                this.addSqlType(sqlName, 4, false, true, null, null);
            }
            resultSet.close();
            preparedStatement.close();
            preparedStatement = this.m_conn.prepareStatement("SELECT COUNT(OBJECT_NAME) AS ARG_COUNT FROM ALL_ARGUMENTS WHERE OWNER = :1 AND PACKAGE_NAME IS NULL AND DATA_LEVEL = 0");
            preparedStatement.setString(1, string);
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next() && (n = resultSet.getInt(1)) > 0) {
                SqlType sqlType = this.addSqlUserType(string, "", 12, true, 0, 0, null);
                String string2 = SqlName.sqlIdToJavaId("TOPLEVEL", true);
                sqlType.getSqlName().setLangName("", string2, null, null, null, null, null, null, true);
            }
            resultSet.close();
            preparedStatement.close();
        }
    }

    public JavaType addJavaType(String string, Field[] fieldArray, Method[] methodArray, boolean bl, Type type) throws SQLException {
        if (string == null) {
            return null;
        }
        JavaType javaType = null;
        for (int i = 0; i < this.m_userTypes.size(); ++i) {
            if (!(this.m_userTypes.elementAt(i) instanceof JavaType)) continue;
            JavaType javaType2 = (JavaType)this.m_userTypes.elementAt(i);
            JavaName javaName = new JavaName(null, string, null, null, null);
            if (!javaType2.getJavaName().equals(javaName)) continue;
            javaType = javaType2;
        }
        if (javaType != null) {
            return javaType;
        }
        JavaName javaName = new JavaName(null, string, null, null, null);
        if (bl) {
            javaName = (JavaName)this.genPattern(javaName, string, false);
        }
        javaType = new JavaBaseType(javaName, fieldArray, methodArray, type);
        this.m_userTypes.addElement(javaType);
        return javaType;
    }

    public boolean hasMethodsInSubclasses(Type type) throws SQLException, PublisherException {
        Enumeration enumeration = this.m_userTypes.elements();
        block0: while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!(e instanceof SqlType)) continue;
            SqlType sqlType = (SqlType)e;
            boolean bl = sqlType.hasMethods();
            while ((sqlType = (SqlType)sqlType.getSupertype()) != null) {
                if (type.getName() == null || !type.getName().equals(sqlType.getName())) continue;
                if (!bl) continue block0;
                return true;
            }
        }
        return false;
    }

    public void createSqlStmtType(SqlName sqlName) throws SQLException {
        if (this.m_sqlStmtType == null) {
            this.m_sqlStmtType = new SqlStmtType(sqlName, this);
        }
    }

    public boolean isPre920() {
        if (this.m_isPre920 == null) {
            try {
                String string;
                String string2 = this.m_conn.getMetaData().getDatabaseProductVersion().toUpperCase();
                if (string2.startsWith("ORACLE DATABASE 10G") || string2.startsWith("ORACLE DATABASE 11G")) {
                    this.m_isPre920 = new Boolean(false);
                    return false;
                }
                int n = string2.indexOf("ORACLE");
                if (0 < n) {
                    string2 = string2.substring(n);
                }
                if ((string = string2.substring(0, "ORACLExx".length()).toUpperCase()).equals("ORACLE12") || string.equals("ORACLE11") || string.equals("ORACLE10") || string.equals("ORACLE9I") && (string2.indexOf("9.2.") > 0 || string2.indexOf("9.3.") > 0 || string2.indexOf("9.4.") > 0)) {
                    this.m_isPre920 = new Boolean(false);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.m_isPre920 == null) {
                this.m_isPre920 = new Boolean(true);
            }
        }
        return this.m_isPre920;
    }

    public boolean geqOracle9() {
        return this.m_geq9i;
    }

    public static boolean geqOracle9(Connection connection) {
        boolean bl = false;
        try {
            String string = connection.getMetaData().getDatabaseProductVersion().toUpperCase();
            int n = string.indexOf("ORACLE");
            if (0 < n) {
                string = string.substring(n);
            }
            bl = string.startsWith("ORACLE9") || string.startsWith("ORACLE DATABASE 10G") || string.startsWith("ORACLE DATABASE 11G") || string.startsWith("ORACLE1") || string.startsWith("ORACLE2") || string.startsWith("ORACLE3");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return bl;
    }

    public void setTransitive(boolean bl) {
        this.m_transitive = bl;
    }

    public static boolean isNull(String string) {
        return string == null || string.length() == 0;
    }

    public boolean noUserTypes() {
        return this.m_userTypes.isEmpty();
    }

    public Hashtable getTypeMap() {
        return this.m_typeMap;
    }

    private LangName genPattern(LangName langName, String string, boolean bl) {
        String string2 = null;
        if (string2 == null) {
            return langName;
        }
        String string3 = string;
        if (bl) {
            string3 = SqlName.sqlIdToJavaId(string, true);
        }
        String string4 = string2;
        for (int i = string2.length() - 1; i >= 0; --i) {
            if (string2.charAt(i) != '%' || i == string2.length() - 1) continue;
            int n = string2.charAt(i + 1) - 48;
            string4 = string4.substring(0, i) + (n == 1 ? string : string3) + string4.substring(i + 2);
        }
        String string5 = null;
        String string6 = null;
        String string7 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string4, "#");
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (0 < stringTokenizer.countTokens()) {
            stringArray[n] = stringTokenizer.nextToken();
            if (n == 1) {
                string7 = stringArray[1];
                string5 = stringArray[1];
            }
            ++n;
        }
        stringTokenizer = new StringTokenizer(stringArray[0], ":");
        stringArray = new String[stringTokenizer.countTokens()];
        n = 0;
        while (0 < stringTokenizer.countTokens()) {
            stringArray[n] = stringTokenizer.nextToken();
            if (n == 0) {
                string3 = stringArray[0];
            } else if (n == 1) {
                string3 = stringArray[1];
                string6 = stringArray[0];
            }
            ++n;
        }
        if (string3 == null) {
            string5 = null;
        }
        if (string6 == null) {
            string7 = null;
        }
        if (string5 != null) {
            string7 = null;
        }
        JavaName javaName = new JavaName("", string3, string5, string6, string7);
        return javaName;
    }

    public String determineSqlName(String string, boolean bl) {
        String string2;
        if (string.length() > 29) {
            string = string.substring(0, 29);
            bl = true;
        }
        if (this.m_allTypeNames.contains(string2 = string.toUpperCase()) || bl && this.m_allGeneratedTypeNames.contains(string2)) {
            do {
                int n;
                int n2;
                if ((n2 = string.length()) + (n = Integer.toString(this.m_allGeneratedTypeNamesMagicNumber++).length()) <= 29) continue;
                string = string.substring(0, 29 - n);
            } while (this.m_allTypeNames.contains(string2 = string.toUpperCase() + this.m_allGeneratedTypeNamesMagicNumber) || bl && this.m_allGeneratedTypeNames.contains(string2));
        }
        this.m_allGeneratedTypeNames.add(string2);
        return string2;
    }

    public ViewCache getViewCache() {
        return this.m_viewCache;
    }

    public void getViewCache(ViewCache viewCache) {
        this.m_viewCache = viewCache;
    }

    public void close() {
        try {
            if (this.m_conn != null) {
                this.m_conn.close();
            }
            if (this.m_viewCache != null) {
                this.m_viewCache.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Enumeration getUserTypes() {
        return this.m_userTypes.elements();
    }

    public WrapperPackageMetadata getWrapperPackageMetadata() {
        return this.m_wrapperPackageMetadata;
    }

    public void addWrapperMethodMetadata(String string, String[] stringArray, String[] stringArray2, String string2) {
        if (this.m_wrapperPackageMetadata == null) {
            this.m_wrapperPackageMetadata = new WrapperPackageMetadata("");
        }
        this.m_wrapperPackageMetadata.addMethod(new WrapperMethodMetadata(string, stringArray, stringArray2, string2));
    }
}

