/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.database.oracle.publisher.viewcache;

import java.lang.reflect.Field;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Hashtable;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.AllArguments;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.AllCollTypes;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.AllMethodParams;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.AllMethodResults;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.AllObjects;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.AllQueueTables;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.AllSynonyms;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.AllTypeAttrs;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.AllTypeMethods;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.AllTypes;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.SingleColumnViewRow;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.UserArguments;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.ViewRow;

public class ViewRowFactory
implements ViewRow {
    private transient Hashtable m_fieldCache = new Hashtable();

    public static ViewRow createViewRow(String string, String[] stringArray, ResultSet resultSet) throws SQLException {
        ViewRow viewRow = null;
        if (stringArray.length == 1) {
            viewRow = new SingleColumnViewRow(resultSet);
        } else if (string.equalsIgnoreCase("ALL_ARGUMENTS")) {
            viewRow = new AllArguments(resultSet);
        } else if (string.equalsIgnoreCase("USER_ARGUMENTS")) {
            viewRow = new UserArguments(resultSet);
        } else if (string.equalsIgnoreCase("ALL_COLL_TYPES")) {
            viewRow = new AllCollTypes(resultSet);
        } else if (string.equalsIgnoreCase("ALL_TYPES")) {
            viewRow = new AllTypes(resultSet);
        } else if (string.equalsIgnoreCase("ALL_TYPE_METHODS")) {
            viewRow = new AllTypeMethods(resultSet);
        } else if (string.equalsIgnoreCase("ALL_TYPE_ATTRS")) {
            viewRow = new AllTypeAttrs(resultSet);
        } else if (string.equalsIgnoreCase("ALL_METHOD_RESULTS")) {
            viewRow = new AllMethodResults(resultSet);
        } else if (string.equalsIgnoreCase("ALL_METHOD_PARAMS")) {
            viewRow = new AllMethodParams(resultSet);
        } else if (string.equalsIgnoreCase("ALL_OBJECTS")) {
            viewRow = new AllObjects(resultSet);
        } else if (string.equalsIgnoreCase("ALL_QUEUE_TABLES")) {
            viewRow = new AllQueueTables(resultSet);
        } else if (string.equalsIgnoreCase("ALL_SYNONYMS")) {
            viewRow = new AllSynonyms(resultSet);
        } else {
            throw new SQLException("View cache does not support " + string);
        }
        return viewRow;
    }

    public static String getProject(String string, String[] stringArray) {
        String[] stringArray2 = null;
        if (stringArray.length > 0) {
            stringArray2 = stringArray;
        } else if (string.equalsIgnoreCase("ALL_ARGUMENTS")) {
            stringArray2 = AllArguments.getProjectList();
        } else if (string.equalsIgnoreCase("USER_ARGUMENTS")) {
            stringArray2 = UserArguments.getProjectList();
        }
        if (stringArray2 == null) {
            return "*";
        }
        String string2 = "";
        for (int i = 0; i < stringArray2.length; ++i) {
            string2 = string2 + stringArray2[i];
            if (i >= stringArray2.length - 1) continue;
            string2 = string2 + ", ";
        }
        return string2;
    }

    public static boolean hasSequence(String string) {
        return string.equalsIgnoreCase("USER_ARGUMENTS") || string.equalsIgnoreCase("ALL_ARGUMENTS");
    }

    public static boolean hasPosition(String string) {
        return string.equalsIgnoreCase("USER_ARGUMENTS") || string.equalsIgnoreCase("ALL_ARGUMENTS");
    }

    @Override
    public boolean equals(String string, Object object) {
        boolean bl = false;
        try {
            Object object2;
            Field field;
            if (this.m_fieldCache == null) {
                this.m_fieldCache = new Hashtable();
            }
            if ((field = (Field)this.m_fieldCache.get(string)) == null) {
                object2 = this.getClass();
                Field[] fieldArray = ((Class)object2).getFields();
                for (int i = 0; i < fieldArray.length; ++i) {
                    if (!fieldArray[i].getName().equalsIgnoreCase(string)) continue;
                    field = fieldArray[i];
                    this.m_fieldCache.put(string, field);
                }
            }
            if (field == null) {
                System.err.println("ERROR: " + this.getClass().getName() + " does not have field " + string);
            }
            object2 = field.get(this);
            if (string.equals("OWNER")) {
                bl = object2 == null || object2.equals(object);
            } else if (object == null) {
                bl = object2 == null || object2.equals("");
            } else if (object.equals("NOT NULL")) {
                bl = object2 != null && !object2.equals("");
            } else if (object2 == null) {
                bl = false;
            } else {
                bl = object.equals(object2);
                if (!bl && !(object instanceof String)) {
                    bl = object.toString().equals(object2.toString());
                }
            }
        }
        catch (SecurityException securityException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return bl;
    }
}

