/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.dbws;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.sql.Array;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.wsdl.WSDLException;
import javax.xml.namespace.QName;
import org.eclipse.persistence.dbws.DBWSModel;
import org.eclipse.persistence.dbws.DBWSModelProject;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.databaseaccess.DatabasePlatform;
import org.eclipse.persistence.internal.databaseaccess.Platform;
import org.eclipse.persistence.internal.dynamicpersist.BaseEntity;
import org.eclipse.persistence.internal.dynamicpersist.BaseEntityAccessor;
import org.eclipse.persistence.internal.dynamicpersist.BaseEntityClassLoader;
import org.eclipse.persistence.internal.dynamicpersist.BaseEntityVHAccessor;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseType;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.indirection.BasicIndirectionPolicy;
import org.eclipse.persistence.internal.oxm.schema.SchemaModelGenerator;
import org.eclipse.persistence.internal.oxm.schema.SchemaModelGeneratorProperties;
import org.eclipse.persistence.internal.oxm.schema.SchemaModelProject;
import org.eclipse.persistence.internal.oxm.schema.model.ComplexType;
import org.eclipse.persistence.internal.oxm.schema.model.Schema;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.internal.sessions.factories.MissingDescriptorListener;
import org.eclipse.persistence.internal.sessions.factories.ObjectPersistenceWorkbenchXMLProject;
import org.eclipse.persistence.internal.sessions.factories.XMLSessionConfigWriter;
import org.eclipse.persistence.internal.sessions.factories.model.SessionConfigs;
import org.eclipse.persistence.internal.sessions.factories.model.project.ProjectClassConfig;
import org.eclipse.persistence.internal.sessions.factories.model.project.ProjectConfig;
import org.eclipse.persistence.internal.sessions.factories.model.project.ProjectXMLConfig;
import org.eclipse.persistence.internal.xr.CollectionResult;
import org.eclipse.persistence.internal.xr.DeleteOperation;
import org.eclipse.persistence.internal.xr.InsertOperation;
import org.eclipse.persistence.internal.xr.NamedQueryHandler;
import org.eclipse.persistence.internal.xr.Operation;
import org.eclipse.persistence.internal.xr.Parameter;
import org.eclipse.persistence.internal.xr.QueryHandler;
import org.eclipse.persistence.internal.xr.QueryOperation;
import org.eclipse.persistence.internal.xr.Result;
import org.eclipse.persistence.internal.xr.UpdateOperation;
import org.eclipse.persistence.internal.xr.XRServiceModel;
import org.eclipse.persistence.internal.xr.sxf.SimpleXMLFormatProject;
import org.eclipse.persistence.mappings.AttributeAccessor;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.mappings.converters.SerializedObjectConverter;
import org.eclipse.persistence.mappings.foundation.AbstractCompositeDirectCollectionMapping;
import org.eclipse.persistence.mappings.structures.ArrayMapping;
import org.eclipse.persistence.mappings.structures.ObjectRelationalDataTypeDescriptor;
import org.eclipse.persistence.mappings.structures.ObjectRelationalDatabaseField;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLConstants;
import org.eclipse.persistence.oxm.XMLContext;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.XMLLogin;
import org.eclipse.persistence.oxm.XMLMarshaller;
import org.eclipse.persistence.oxm.XMLUnmarshaller;
import org.eclipse.persistence.oxm.mappings.XMLBinaryDataMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeDirectCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.oxm.platform.DOMPlatform;
import org.eclipse.persistence.oxm.schema.XMLSchemaReference;
import org.eclipse.persistence.oxm.schema.XMLSchemaURLReference;
import org.eclipse.persistence.platform.database.MySQLPlatform;
import org.eclipse.persistence.platform.database.jdbc.JDBCTypes;
import org.eclipse.persistence.platform.database.oracle.plsql.PLSQLCollection;
import org.eclipse.persistence.platform.database.oracle.plsql.PLSQLStoredProcedureCall;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.SqlType;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.DataModifyQuery;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.Login;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.SessionEventListener;
import org.eclipse.persistence.sessions.factories.XMLProjectReader;
import org.eclipse.persistence.sessions.factories.XMLProjectWriter;
import org.eclipse.persistence.tools.dbws.DBWSBuilderModel;
import org.eclipse.persistence.tools.dbws.DBWSBuilderModelProject;
import org.eclipse.persistence.tools.dbws.DBWSPackager;
import org.eclipse.persistence.tools.dbws.DefaultNamingConventionTransformer;
import org.eclipse.persistence.tools.dbws.NamingConventionTransformer;
import org.eclipse.persistence.tools.dbws.OperationModel;
import org.eclipse.persistence.tools.dbws.ProcedureOperationModel;
import org.eclipse.persistence.tools.dbws.SQLOperationModel;
import org.eclipse.persistence.tools.dbws.SQLX2003Transformer;
import org.eclipse.persistence.tools.dbws.TableOperationModel;
import org.eclipse.persistence.tools.dbws.Util;
import org.eclipse.persistence.tools.dbws.WSDLGenerator;
import org.eclipse.persistence.tools.dbws.XRPackager;
import org.eclipse.persistence.tools.dbws.jdbc.DbColumn;
import org.eclipse.persistence.tools.dbws.jdbc.DbStoredArgument;
import org.eclipse.persistence.tools.dbws.jdbc.DbStoredProcedure;
import org.eclipse.persistence.tools.dbws.jdbc.DbTable;
import org.eclipse.persistence.tools.dbws.jdbc.JDBCHelper;
import org.eclipse.persistence.tools.dbws.oracle.OracleHelper;
import org.eclipse.persistence.tools.dbws.oracle.PLSQLStoredArgument;

public class DBWSBuilder
extends DBWSBuilderModel {
    public static final String BUILDER_FILE_PATH = "-builderFile";
    public static final String BUILDER_PACKAGING = "-packageAs";
    public static final String STAGE_DIR = "-stageDir";
    public static final String DRIVER_KEY = "driver";
    public static final String USERNAME_KEY = "username";
    public static final String PASSWORD_KEY = "password";
    public static final String URL_KEY = "url";
    public static final String PROJNAME_KEY = "projectName";
    public static final String CONTEXT_ROOT_KEY = "contextRoot";
    public static final String DATASOURCE_KEY = "dataSource";
    public static final String SESSIONS_FILENAME_KEY = "sessionsFileName";
    public static final String NO_SESSIONS_FILENAME = "no-sessions-fileName";
    public static final String PLATFORM_CLASSNAME_KEY = "platformClassname";
    public static final String ORSESSION_CUSTOMIZER_KEY = "orSessionCustomizerClassName";
    public static final String OXSESSION_CUSTOMIZER_KEY = "oxSessionCustomizerClassName";
    public static final String WSDL_URI_KEY = "wsdlLocationURI";
    public static final String LOG_LEVEL_KEY = "logLevel";
    public static final String TARGET_NAMESPACE_KEY = "targetNamespace";
    public static final String WSI_SWAREF_XSD = "<?xml version=\"1.0\" encoding=\"UTF-8\"?> \n<xsd:schema targetNamespace=\"http://ws-i.org/profiles/basic/1.1/xsd\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"> \n  <xsd:simpleType name=\"swaref\"> \n    <xsd:restriction base=\"xsd:anyURI\"/> \n  </xsd:simpleType> \n</xsd:schema>";
    public static Map<String, DBWSPackager> PACKAGERS = new HashMap<String, DBWSPackager>();
    protected DBWSPackager packager;
    protected Logger logger;
    public boolean quiet = false;
    protected String destDir;
    protected DatabasePlatform databasePlatform;
    protected Connection conn;
    protected Project orProject;
    protected Project oxProject;
    protected WSDLGenerator wsdlGenerator = null;
    protected Schema schema = new Schema();
    protected NamespaceResolver ns = this.schema.getNamespaceResolver();
    protected XRServiceModel xrServiceModel = new DBWSModel();
    protected List<DbTable> dbTables = new ArrayList<DbTable>();
    protected List<DbStoredProcedure> dbStoredProcedures = new ArrayList<DbStoredProcedure>();
    protected SqlType sqlType;
    protected Map<DbStoredProcedure, DbStoredProcedureNameAndModel> dbStoredProcedure2QueryName = new HashMap<DbStoredProcedure, DbStoredProcedureNameAndModel>();

    public DBWSBuilder() {
        this.ns.put("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        this.ns.put("xsd", "http://www.w3.org/2001/XMLSchema");
    }

    public static void main(String[] stringArray) throws WSDLException {
        DBWSBuilder dBWSBuilder = new DBWSBuilder();
        dBWSBuilder.start(stringArray);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void start(String[] stringArray) throws WSDLException {
        Object object;
        Object object2;
        CharSequence charSequence;
        block13: {
            if (stringArray.length > 5 && BUILDER_FILE_PATH.equals(stringArray[0]) && STAGE_DIR.equals(stringArray[2]) && stringArray[4].startsWith(BUILDER_PACKAGING)) {
                File file;
                charSequence = stringArray[1];
                object2 = stringArray[3];
                object = stringArray[5];
                String string = null;
                DBWSPackager.ArchiveUse archiveUse = DBWSPackager.ArchiveUse.ignore;
                int n = stringArray[4].indexOf(58);
                if (n == 10) {
                    string = stringArray[4].substring(n + 1);
                    if (DBWSPackager.ArchiveUse.archive.name().equals(string)) {
                        archiveUse = DBWSPackager.ArchiveUse.archive;
                    } else if (DBWSPackager.ArchiveUse.noArchive.name().equals(string)) {
                        archiveUse = DBWSPackager.ArchiveUse.noArchive;
                    }
                }
                String[] stringArray2 = null;
                if (stringArray.length > 6) {
                    stringArray2 = new String[stringArray.length - 6];
                    System.arraycopy(stringArray, 6, stringArray2, 0, stringArray.length - 6);
                }
                if ((file = new File((String)charSequence)).exists() && file.isFile()) {
                    File file2 = new File((String)object2);
                    if (file2.exists() && file2.isDirectory()) {
                        XMLContext xMLContext = new XMLContext((Project)new DBWSBuilderModelProject());
                        XMLUnmarshaller xMLUnmarshaller = xMLContext.createUnmarshaller();
                        DBWSBuilderModel dBWSBuilderModel = (DBWSBuilderModel)xMLUnmarshaller.unmarshal(file);
                        this.properties = dBWSBuilderModel.properties;
                        this.operations = dBWSBuilderModel.operations;
                        if (this.operations.size() == 0) {
                            this.logMessage(Level.SEVERE, "No operations specified");
                            return;
                        }
                        this.packager = PACKAGERS.get(object);
                        if (this.packager != null) {
                            this.packager.setDBWSBuilder(this);
                            this.packager.setArchiveUse(archiveUse);
                            this.packager.setAdditionalArgs(stringArray2);
                            this.packager.setStageDir(file2);
                            this.packager.setSessionsFileName(this.getSessionsFileName());
                            this.start();
                            return;
                        }
                        break block13;
                    } else {
                        this.logMessage(Level.SEVERE, "DBWSBuilder unable to locate stage directory " + (String)object2);
                        return;
                    }
                }
                this.logMessage(Level.SEVERE, "DBWSBuilder unable to locate dbws-builder.xml file " + (String)charSequence);
                return;
            }
        }
        charSequence = new StringBuilder(30);
        ((StringBuilder)charSequence).append("DBWSBuilder usage ([] indicates optional argument):\nprompt> java -cp eclipselink.jar:eclipselink-dbwsutils.jar:your_favourite_jdbc_driver.jar \\\n\t");
        ((StringBuilder)charSequence).append(this.getClass().getName());
        ((StringBuilder)charSequence).append(" ");
        ((StringBuilder)charSequence).append(BUILDER_FILE_PATH);
        ((StringBuilder)charSequence).append(" {path_to_dbwsbuilder.xml} \\\n\t");
        ((StringBuilder)charSequence).append(STAGE_DIR);
        ((StringBuilder)charSequence).append(" ");
        ((StringBuilder)charSequence).append(" {path_to_stageDir}");
        ((StringBuilder)charSequence).append(" ");
        ((StringBuilder)charSequence).append(BUILDER_PACKAGING);
        ((StringBuilder)charSequence).append("[:archive_flag - archive, noArchive, ignore] {packager} [additional arguments]\nAvailable packagers:\n\t");
        object2 = PACKAGERS.entrySet().iterator();
        while (true) {
            if (!object2.hasNext()) {
                this.logMessage(Level.SEVERE, ((StringBuilder)charSequence).toString());
                return;
            }
            object = (Map.Entry)object2.next();
            ((StringBuilder)charSequence).append(((DBWSPackager)object.getValue()).getUsage());
            if (!object2.hasNext()) continue;
            ((StringBuilder)charSequence).append("\n\t");
        }
    }

    public void start() throws WSDLException {
        this.packager.setHasAttachments(this.hasAttachments());
        OutputStream outputStream = null;
        try {
            outputStream = this.packager.getSchemaStream();
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.logMessage(Level.SEVERE, "DBWSBuilder unable to create eclipselink-dbws-schema.xsd", fileNotFoundException);
            return;
        }
        OutputStream outputStream2 = null;
        try {
            outputStream2 = this.packager.getSessionsStream(this.getSessionsFileName());
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.logMessage(Level.SEVERE, "DBWSBuilder unable to create eclipselink-dbws-sessions.xml", fileNotFoundException);
            return;
        }
        OutputStream outputStream3 = null;
        try {
            outputStream3 = this.packager.getServiceStream();
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.logMessage(Level.SEVERE, "DBWSBuilder unable to create eclipselink-dbws.xml", fileNotFoundException);
            return;
        }
        OutputStream outputStream4 = null;
        try {
            outputStream4 = this.packager.getOrStream();
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.logMessage(Level.SEVERE, "DBWSBuilder unable to create eclipselink-dbws-or.xml", fileNotFoundException);
            return;
        }
        OutputStream outputStream5 = null;
        try {
            outputStream5 = this.packager.getOxStream();
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.logMessage(Level.SEVERE, "DBWSBuilder unable to create eclipselink-dbws-ox.xml", fileNotFoundException);
            return;
        }
        OutputStream outputStream6 = null;
        try {
            outputStream6 = this.packager.getWSDLStream();
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.logMessage(Level.SEVERE, "DBWSBuilder unable to create eclipselink-dbws.wsdl", fileNotFoundException);
            return;
        }
        OutputStream outputStream7 = null;
        try {
            outputStream7 = this.packager.getSWARefStream();
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.logMessage(Level.SEVERE, "DBWSBuilder unable to create swaref.xsd", fileNotFoundException);
            return;
        }
        OutputStream outputStream8 = null;
        try {
            outputStream8 = this.packager.getWebXmlStream();
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.logMessage(Level.SEVERE, "DBWSBuilder unable to create web.xml", fileNotFoundException);
            return;
        }
        OutputStream outputStream9 = null;
        try {
            outputStream9 = this.packager.getProviderClassStream();
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.logMessage(Level.SEVERE, "DBWSBuilder unable to create DBWSProvider.class", fileNotFoundException);
            return;
        }
        OutputStream outputStream10 = null;
        try {
            outputStream10 = this.packager.getProviderSourceStream();
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.logMessage(Level.SEVERE, "DBWSBuilder unable to create DBWSProvider.java", fileNotFoundException);
            return;
        }
        this.build(outputStream, outputStream2, outputStream3, outputStream4, outputStream5, outputStream7, outputStream8, outputStream6, outputStream9, outputStream10, this.logger);
    }

    public void build(OutputStream outputStream, OutputStream outputStream2, OutputStream outputStream3, OutputStream outputStream4, OutputStream outputStream5, OutputStream outputStream6, OutputStream outputStream7, OutputStream outputStream8, OutputStream outputStream9, OutputStream outputStream10, Logger logger) throws WSDLException {
        NamingConventionTransformer namingConventionTransformer;
        this.logger = logger;
        this.xrServiceModel.setName(this.getProjectName());
        String string = this.getSessionsFileName();
        if (string != null && string.length() > 0) {
            this.xrServiceModel.setSessionsFile(string);
        }
        ServiceLoader<NamingConventionTransformer> serviceLoader = ServiceLoader.load(NamingConventionTransformer.class);
        Iterator<NamingConventionTransformer> iterator = serviceLoader.iterator();
        NamingConventionTransformer namingConventionTransformer2 = iterator.next();
        LinkedList<NamingConventionTransformer> linkedList = new LinkedList<NamingConventionTransformer>();
        if (!((DefaultNamingConventionTransformer)namingConventionTransformer2).isDefaultTransformer()) {
            while (iterator.hasNext()) {
                namingConventionTransformer = iterator.next();
                if (!((DefaultNamingConventionTransformer)namingConventionTransformer).isDefaultTransformer()) {
                    linkedList.addLast(namingConventionTransformer);
                    continue;
                }
                if (!(namingConventionTransformer instanceof SQLX2003Transformer)) continue;
                linkedList.addLast(namingConventionTransformer);
            }
        } else {
            while (iterator.hasNext()) {
                linkedList.addLast(iterator.next());
            }
        }
        namingConventionTransformer = namingConventionTransformer2;
        for (NamingConventionTransformer namingConventionTransformer3 : linkedList) {
            ((DefaultNamingConventionTransformer)namingConventionTransformer).setNextTransformer(namingConventionTransformer3);
            namingConventionTransformer = namingConventionTransformer3;
        }
        this.packager.start();
        this.buildDbArtifacts();
        this.buildOROXProjects(namingConventionTransformer2);
        this.buildSchema(namingConventionTransformer2);
        this.buildSessionsXML(outputStream2);
        this.buildDBWSModel(namingConventionTransformer2, outputStream3);
        this.writeAttachmentSchema(outputStream6);
        this.buildWSDL(outputStream8, namingConventionTransformer2);
        this.writeWebXML(outputStream7);
        this.writeDBWSProviderClass(outputStream9);
        this.writeDBWSProviderSource(outputStream10);
        this.writeSchema(outputStream);
        this.writeOROXProjects(outputStream4, outputStream5);
        this.packager.end();
    }

    public void buildDbArtifacts() {
        StringBuilder stringBuilder;
        List<Object> list;
        String string;
        String string2;
        String string3;
        OperationModel operationModel;
        boolean bl = this.getDatabasePlatform().getClass().getName().contains("Oracle");
        for (OperationModel operationModel2 : this.operations) {
            if (!operationModel2.isTableOperation()) continue;
            string3 = bl ? null : ((TableOperationModel)operationModel).getCatalogPattern();
            list = this.checkTables(this.loadTables(string3, string2 = ((TableOperationModel)(operationModel = (TableOperationModel)operationModel2)).getSchemaPattern(), string = ((TableOperationModel)operationModel).getTablePattern()));
            if (list.isEmpty()) {
                stringBuilder = new StringBuilder();
                stringBuilder.append("No matching tables for pattern ");
                if (string3 != null) {
                    stringBuilder.append(string3);
                    stringBuilder.append(".");
                }
                if (string2 != null) {
                    stringBuilder.append(string2);
                    stringBuilder.append(".");
                }
                stringBuilder.append(string);
                this.logMessage(Level.FINEST, stringBuilder.toString());
                continue;
            }
            this.dbTables.addAll(list);
        }
        for (OperationModel operationModel2 : this.operations) {
            if (!operationModel2.isProcedureOperation()) continue;
            operationModel = (ProcedureOperationModel)operationModel2;
            string3 = ((ProcedureOperationModel)operationModel).getCatalogPattern();
            list = this.loadProcedures(string3, string2 = ((ProcedureOperationModel)operationModel).getSchemaPattern(), string = ((ProcedureOperationModel)operationModel).getProcedurePattern(), ((ProcedureOperationModel)operationModel).overload, bl);
            if (list.isEmpty()) {
                stringBuilder = new StringBuilder();
                stringBuilder.append("No matching procedures for pattern ");
                if (string3 != null) {
                    stringBuilder.append(string3);
                    stringBuilder.append(".");
                }
                if (string2 != null) {
                    stringBuilder.append(string2);
                    stringBuilder.append(".");
                }
                stringBuilder.append(string);
                this.logMessage(Level.FINEST, stringBuilder.toString());
                continue;
            }
            this.dbStoredProcedures.addAll(list);
        }
        this.buildDbStoredProcedure2QueryNameMap(this.dbStoredProcedures, this.operations, bl);
    }

    protected List<DbTable> loadTables(String string, String string2, String string3) {
        return this.checkTables(JDBCHelper.buildDbTable(this.getConnection(), this.databasePlatform, string, string2, string3));
    }

    public List<DbTable> checkTables(List<DbTable> list) {
        ArrayList<DbTable> arrayList = new ArrayList<DbTable>(list.size());
        for (DbTable dbTable : list) {
            boolean bl = false;
            for (DbColumn dbColumn : dbTable.getColumns()) {
                switch (dbColumn.getJDBCType()) {
                    case 70: 
                    case 1111: 
                    case 2000: 
                    case 2002: 
                    case 2003: {
                        bl = true;
                    }
                }
            }
            if (bl) continue;
            arrayList.add(dbTable);
        }
        return arrayList;
    }

    public void addDbTable(DbTable dbTable) {
        this.dbTables.add(dbTable);
    }

    protected List<DbStoredProcedure> loadProcedures(String string, String string2, String string3, int n, boolean bl) {
        if (bl && string != null) {
            return OracleHelper.buildStoredProcedure(this.getConnection(), this.getUsername(), this.databasePlatform, string, string2, string3, this);
        }
        return this.checkStoredProcedures(JDBCHelper.buildStoredProcedure(this.getConnection(), this.databasePlatform, string, string2, string3), n);
    }

    public List<DbStoredProcedure> checkStoredProcedures(List<DbStoredProcedure> list, int n) {
        ArrayList<DbStoredProcedure> arrayList = new ArrayList<DbStoredProcedure>(list.size());
        ArrayList<DbStoredProcedure> arrayList2 = new ArrayList<DbStoredProcedure>(list.size());
        ArrayList<DbStoredProcedure> arrayList3 = new ArrayList<DbStoredProcedure>(1);
        if (n == 0) {
            arrayList2.addAll(list);
        } else {
            for (DbStoredProcedure dbStoredProcedure : list) {
                if (dbStoredProcedure.getOverload() != n) continue;
                arrayList3.add(dbStoredProcedure);
                break;
            }
            arrayList2.addAll(arrayList3);
        }
        for (DbStoredProcedure dbStoredProcedure : arrayList2) {
            boolean bl = false;
            for (DbStoredArgument dbStoredArgument : dbStoredProcedure.getArguments()) {
                int n2 = dbStoredArgument.getJdbcType();
                if (n2 == 1111) {
                    if (dbStoredArgument.getJdbcTypeName().contains("CURSOR") && dbStoredArgument.getInOut() == Util.InOut.OUT) continue;
                    bl = true;
                    break;
                }
                if (n2 != 2003 && n2 != 2002 && n2 != 70 && n2 != 2000) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            arrayList.add(dbStoredProcedure);
        }
        return arrayList;
    }

    public void addDbStoredProcedure(DbStoredProcedure dbStoredProcedure) {
        this.dbStoredProcedures.add(dbStoredProcedure);
    }

    public void addSqlOperation(SQLOperationModel sQLOperationModel) {
        this.operations.add(sQLOperationModel);
    }

    /*
     * WARNING - void declaration
     */
    protected void buildOROXProjects(NamingConventionTransformer namingConventionTransformer) {
        ReadAllQuery readAllQuery;
        Object object;
        XMLField xMLField;
        Object object22;
        Object object3;
        Object object4;
        DataModifyQuery dataModifyQuery;
        Object object52;
        Object object6;
        NamespaceResolver namespaceResolver;
        Object object7;
        Object object8;
        String string;
        ObjectRelationalDataTypeDescriptor objectRelationalDataTypeDescriptor;
        PLSQLStoredArgument pLSQLStoredArgument;
        Object object9;
        String string2 = this.getProjectName();
        this.orProject = new Project();
        this.orProject.setName(string2 + "-" + "dbws-or");
        if (this.dbTables.isEmpty()) {
            this.logMessage(Level.FINEST, "No tables specified");
            this.oxProject = new SimpleXMLFormatProject();
        } else {
            this.oxProject = new Project();
        }
        this.oxProject.setName(string2 + "-" + "dbws-ox");
        for (DbTable object122 : this.dbTables) {
            void var13_19;
            int n;
            RelationalDescriptor relationalDescriptor = new RelationalDescriptor();
            this.orProject.addDescriptor((ClassDescriptor)relationalDescriptor);
            object9 = object122.getName();
            String string3 = namingConventionTransformer.generateSchemaAlias((String)object9);
            relationalDescriptor.addTableName((String)object9);
            relationalDescriptor.setAlias(string3);
            String string4 = this.getGeneratedJavaClassName((String)object9);
            relationalDescriptor.setJavaClassName(string4);
            relationalDescriptor.useWeakIdentityMap();
            pLSQLStoredArgument = new XMLDescriptor();
            this.oxProject.addDescriptor((ClassDescriptor)pLSQLStoredArgument);
            pLSQLStoredArgument.setJavaClassName(string4);
            pLSQLStoredArgument.setAlias(string3);
            objectRelationalDataTypeDescriptor = new NamespaceResolver();
            objectRelationalDataTypeDescriptor.setDefaultNamespaceURI(this.getTargetNamespace());
            pLSQLStoredArgument.setNamespaceResolver((NamespaceResolver)objectRelationalDataTypeDescriptor);
            pLSQLStoredArgument.setDefaultRootElement(string3);
            string = new XMLSchemaURLReference("");
            string.setSchemaContext("/" + string3);
            string.setType(1);
            pLSQLStoredArgument.setSchemaReference((XMLSchemaReference)string);
            for (DbColumn dbColumn : object122.getColumns()) {
                void var24_41;
                object8 = dbColumn.getName();
                int n2 = dbColumn.getJDBCType();
                object7 = dbColumn.getJDBCTypeName();
                this.logMessage(Level.FINE, "Building mappings for " + (String)object9 + "." + (String)object8);
                namespaceResolver = null;
                object6 = Util.getXMLTypeFromJDBCType(n2);
                n = 0;
                if (object6 == XMLConstants.BASE_64_BINARY_QNAME) {
                    block2: for (Object object52 : this.operations) {
                        if (!((OperationModel)object52).isTableOperation()) continue;
                        dataModifyQuery = (TableOperationModel)object52;
                        if (dataModifyQuery.additionalOperations.size() <= 0) continue;
                        for (OperationModel operationModel : dataModifyQuery.additionalOperations) {
                            if (!operationModel.isProcedureOperation() || !(object4 = (ProcedureOperationModel)operationModel).getBinaryAttachment()) continue;
                            n = 1;
                            continue block2;
                        }
                    }
                    if (n) {
                        namespaceResolver = new XMLBinaryDataMapping();
                        object3 = (XMLBinaryDataMapping)namespaceResolver;
                        object3.setSwaRef(n != 0);
                        object3.setMimeType("application/octet-stream");
                    } else {
                        namespaceResolver = new XMLDirectMapping();
                        object3 = new SerializedObjectConverter((DatabaseMapping)namespaceResolver);
                        namespaceResolver.setConverter((Converter)object3);
                    }
                } else {
                    namespaceResolver = new XMLDirectMapping();
                }
                object3 = new DirectToFieldMapping();
                object52 = org.eclipse.persistence.internal.xr.Util.getClassFromJDBCType((String)((String)object7).toUpperCase(), (DatabasePlatform)this.databasePlatform);
                if (object6 == XMLConstants.BASE_64_BINARY_QNAME && object52 == ClassConstants.ABYTE) {
                    object52 = ClassConstants.APBYTE;
                }
                object3.setAttributeClassificationName(((Class)object52).getName());
                dataModifyQuery = namingConventionTransformer.generateElementAlias((String)object8);
                object3.setAttributeName((String)dataModifyQuery);
                object22 = new DatabaseField((String)object8, (String)object9);
                object22.setSqlType(n2);
                object3.setField((DatabaseField)object22);
                namespaceResolver.setAttributeName((String)dataModifyQuery);
                String string5 = "";
                object4 = namingConventionTransformer.styleForElement((String)object8);
                if (object4 == NamingConventionTransformer.ElementStyle.NONE) continue;
                if (object4 == NamingConventionTransformer.ElementStyle.ATTRIBUTE) {
                    String string6 = string5 + "@" + (String)dataModifyQuery;
                } else if (object4 == NamingConventionTransformer.ElementStyle.ELEMENT) {
                    String string7 = string5 + (String)dataModifyQuery;
                }
                relationalDescriptor.addMapping((DatabaseMapping)object3);
                pLSQLStoredArgument.addMapping((DatabaseMapping)namespaceResolver);
                if (!n && object4 == NamingConventionTransformer.ElementStyle.ELEMENT) {
                    void var24_47;
                    String string8 = (String)var24_47 + "/text()";
                }
                namespaceResolver.setXPath((String)var24_41);
                xMLField = (XMLField)namespaceResolver.getField();
                xMLField.setSchemaType((QName)object6);
                if (!n && object6 == XMLConstants.BASE_64_BINARY_QNAME) {
                    objectRelationalDataTypeDescriptor.put("xsi", "http://www.w3.org/2001/XMLSchema-instance");
                    objectRelationalDataTypeDescriptor.put("xsd", "http://www.w3.org/2001/XMLSchema");
                    xMLField.setIsTypedTextField(true);
                    xMLField.addConversion(XMLConstants.BASE_64_BINARY_QNAME, ClassConstants.APBYTE);
                }
                if (!dbColumn.isPK()) continue;
                relationalDescriptor.addPrimaryKeyField((DatabaseField)object22);
            }
            object = new ReadObjectQuery();
            object.setReferenceClassName(string4);
            Object var13_22 = null;
            object8 = new ExpressionBuilder();
            object6 = relationalDescriptor.getPrimaryKeyFields();
            for (n = 0; n < object6.size(); n += 1) {
                object3 = (DatabaseField)object6.get(n);
                Expression expression = object8.getField((DatabaseField)object3);
                object7 = object8.getParameter(object3.getName().toLowerCase());
                namespaceResolver = expression.equal((Expression)object7);
                if (var13_19 == null) {
                    NamespaceResolver namespaceResolver2 = namespaceResolver;
                } else {
                    Expression expression2 = var13_19.and((Expression)namespaceResolver);
                }
                object.addArgument(object3.getName().toLowerCase());
            }
            object.setSelectionCriteria((Expression)var13_19);
            relationalDescriptor.getQueryManager().addQuery("findByPrimaryKey", (DatabaseQuery)object);
            readAllQuery = new ReadAllQuery();
            object.setReferenceClassName(string4);
            relationalDescriptor.getQueryManager().addQuery("findAll", (DatabaseQuery)readAllQuery);
        }
        for (DbStoredProcedure dbStoredProcedure : this.dbStoredProcedures) {
            int n;
            boolean bl = false;
            object9 = dbStoredProcedure.getArguments();
            int n3 = object9.size();
            for (n = 0; n < n3; ++n) {
                if (!(object9.get(n) instanceof PLSQLStoredArgument)) continue;
                bl = true;
                break;
            }
            if (!bl) continue;
            pLSQLStoredArgument = (PLSQLStoredArgument)object9.get(n);
            objectRelationalDataTypeDescriptor = new ObjectRelationalDataTypeDescriptor();
            objectRelationalDataTypeDescriptor.descriptorIsAggregate();
            string = pLSQLStoredArgument.getName();
            objectRelationalDataTypeDescriptor.setAlias(string);
            object = pLSQLStoredArgument.getPlSqlTypeName().toLowerCase() + "." + pLSQLStoredArgument.getName() + "_CollectionWrapper";
            String string9 = pLSQLStoredArgument.getJdbcTypeName();
            objectRelationalDataTypeDescriptor.setJavaClassName((String)object);
            object8 = new ArrayMapping();
            object8.setAttributeName("items");
            ObjectRelationalDatabaseField objectRelationalDatabaseField = new ObjectRelationalDatabaseField("ITEMS");
            object8.setField((DatabaseField)objectRelationalDatabaseField);
            object8.setStructureName(string9);
            objectRelationalDataTypeDescriptor.addMapping((DatabaseMapping)object8);
            object7 = new XMLDescriptor();
            object7.setAlias(string);
            object7.setJavaClassName((String)object);
            object7.setDefaultRootElement(string);
            namespaceResolver = new NamespaceResolver();
            namespaceResolver.setDefaultNamespaceURI(this.getTargetNamespace());
            object7.setNamespaceResolver(namespaceResolver);
            object6 = new XMLSchemaURLReference();
            object6.setSchemaContext("/" + string9);
            object6.setType(1);
            object7.setSchemaReference((XMLSchemaReference)object6);
            readAllQuery = new XMLCompositeDirectCollectionMapping();
            readAllQuery.useCollectionClass(Vector.class);
            readAllQuery.setAttributeName("items");
            readAllQuery.setXPath("item/text()");
            ((XMLField)readAllQuery.getField()).setUsesSingleNode(false);
            object7.addMapping((DatabaseMapping)readAllQuery);
            this.oxProject.addDescriptor((ClassDescriptor)object7);
            object3 = new PLSQLStoredProcedureCall();
            object3.setProcedureName(dbStoredProcedure.getCatalog() + "." + dbStoredProcedure.getName());
            object52 = "";
            for (Object object22 : this.operations) {
                ProcedureOperationModel procedureOperationModel;
                if (!((OperationModel)object22).isProcedureOperation() || !(procedureOperationModel = (ProcedureOperationModel)object22).getCatalogPattern().equalsIgnoreCase(dbStoredProcedure.getCatalog()) || !procedureOperationModel.getProcedurePattern().equalsIgnoreCase(dbStoredProcedure.getName())) continue;
                object52 = procedureOperationModel.getName();
                break;
            }
            dataModifyQuery = new DataModifyQuery();
            dataModifyQuery.setName((String)object52);
            dataModifyQuery.setCall((Call)object3);
            object22 = object9.iterator();
            while (object22.hasNext()) {
                DbStoredArgument dbStoredArgument = (DbStoredArgument)object22.next();
                if (dbStoredArgument instanceof PLSQLStoredArgument) {
                    object4 = (PLSQLStoredArgument)dbStoredArgument;
                    xMLField = new PLSQLCollection();
                    xMLField.setTypeName(((PLSQLStoredArgument)object4).getPlSqlTypeName());
                    xMLField.setCompatibleType(((DbStoredArgument)object4).getJdbcTypeName());
                    xMLField.setNestedType((DatabaseType)JDBCTypes.VARCHAR_TYPE);
                    object3.addNamedArgument(((DbStoredArgument)object4).getName(), (DatabaseType)xMLField);
                    dataModifyQuery.addArgument(((DbStoredArgument)object4).getName(), Array.class);
                    continue;
                }
                object4 = JDBCTypes.getDatabaseTypeForCode((int)dbStoredArgument.getJdbcType());
                object3.addNamedArgument(dbStoredArgument.getName(), (DatabaseType)object4);
                dataModifyQuery.addArgument(dbStoredArgument.getName(), String.class);
            }
            objectRelationalDataTypeDescriptor.getQueryManager().addQuery((String)object52, (DatabaseQuery)dataModifyQuery);
            this.orProject.addDescriptor((ClassDescriptor)objectRelationalDataTypeDescriptor);
        }
        Iterator<Object> iterator = new DatabaseLogin();
        iterator.removeProperty("user");
        iterator.removeProperty(PASSWORD_KEY);
        iterator.setDriverClassName(null);
        iterator.setConnectionString(null);
        this.orProject.setLogin(iterator);
        XMLLogin xMLLogin = new XMLLogin();
        xMLLogin.setDatasourcePlatform((Platform)new DOMPlatform());
        xMLLogin.getProperties().remove("user");
        xMLLogin.getProperties().remove(PASSWORD_KEY);
        this.oxProject.setLogin((Login)xMLLogin);
    }

    protected void writeOROXProjects(OutputStream outputStream, OutputStream outputStream2) {
        DbStoredProcedure dbStoredProcedure2;
        boolean bl = false;
        if (this.dbTables.size() > 0) {
            bl = true;
        } else if (this.dbStoredProcedures.size() > 0) {
            for (DbStoredProcedure dbStoredProcedure2 : this.dbStoredProcedures) {
                for (DbStoredArgument dbStoredArgument : dbStoredProcedure2.getArguments()) {
                    if (!(dbStoredArgument instanceof PLSQLStoredArgument)) continue;
                    bl = true;
                    break;
                }
                if (!bl) continue;
                break;
            }
        }
        if (bl && !this.isNullStream(outputStream)) {
            XMLContext xMLContext = new XMLContext((Project)new ObjectPersistenceWorkbenchXMLProject());
            xMLContext.getSession((Object)this.orProject).getEventManager().addListener((SessionEventListener)new MissingDescriptorListener());
            dbStoredProcedure2 = xMLContext.createMarshaller();
            dbStoredProcedure2.marshal(this.orProject, new OutputStreamWriter(outputStream));
        }
        if (!this.isNullStream(outputStream2)) {
            boolean bl2 = false;
            if (!(this.oxProject instanceof SimpleXMLFormatProject)) {
                bl2 = true;
            } else if (this.oxProject.getOrderedDescriptors().size() > 1) {
                bl2 = true;
            }
            if (bl2) {
                dbStoredProcedure2 = new XMLContext((Project)new ObjectPersistenceWorkbenchXMLProject());
                dbStoredProcedure2.getSession(this.oxProject).getEventManager().addListener((SessionEventListener)new MissingDescriptorListener());
                XMLMarshaller xMLMarshaller = dbStoredProcedure2.createMarshaller();
                xMLMarshaller.marshal((Object)this.oxProject, (Writer)new OutputStreamWriter(outputStream2));
            }
        }
        this.packager.closeOrStream(outputStream);
        this.packager.closeOxStream(outputStream2);
    }

    protected void writeDBWSProviderClass(OutputStream outputStream) {
        if (!this.isNullStream(outputStream)) {
            this.logMessage(Level.FINEST, "writing DBWSProvider.class");
            this.packager.writeProviderClass(outputStream, this);
            this.packager.closeProviderClassStream(outputStream);
        }
    }

    public void writeDBWSProviderSource(OutputStream outputStream) {
        if (!this.isNullStream(outputStream)) {
            this.logMessage(Level.FINEST, "writing DBWSProvider.java");
            this.packager.writeProviderSource(outputStream, this);
            this.packager.closeProviderSourceStream(outputStream);
        }
    }

    protected void buildSchema(NamingConventionTransformer namingConventionTransformer) {
        String string;
        ArrayList<XMLDescriptor> arrayList = new ArrayList<XMLDescriptor>();
        for (XMLDescriptor xMLDescriptor : this.oxProject.getOrderedDescriptors()) {
            string = xMLDescriptor.getAlias();
            if ("simple-xml-format".equals(string)) continue;
            arrayList.add(xMLDescriptor);
        }
        if (arrayList.size() > 0) {
            Object object;
            Object object2;
            Object object3;
            String string2;
            Object object422;
            ClassDescriptor classDescriptor22;
            XMLDescriptor xMLDescriptor;
            StringWriter stringWriter = new StringWriter();
            XMLProjectWriter.write((Project)this.oxProject, (Writer)stringWriter);
            xMLDescriptor = new BaseEntityClassLoader(this.getClass().getClassLoader());
            string = XMLProjectReader.read((Reader)new StringReader(stringWriter.toString()), (ClassLoader)xMLDescriptor);
            string.convertClassNamesToClasses((ClassLoader)xMLDescriptor);
            for (ClassDescriptor classDescriptor22 : string.getDescriptors().values()) {
                if (!BaseEntity.class.isAssignableFrom(classDescriptor22.getJavaClass())) continue;
                int n = 0;
                for (Object object422 : classDescriptor22.getMappings()) {
                    string2 = object422.getAttributeName();
                    object422.setAttributeAccessor((AttributeAccessor)new BaseEntityAccessor(string2, n));
                    if (object422 != null) {
                        if (object422.isForeignReferenceMapping()) {
                            object3 = (ForeignReferenceMapping)object422;
                            if (object3.usesIndirection() && object3.getIndirectionPolicy().getClass().isAssignableFrom(BasicIndirectionPolicy.class)) {
                                object422.setAttributeAccessor((AttributeAccessor)new BaseEntityVHAccessor(string2, n));
                            } else {
                                object422.setAttributeAccessor((AttributeAccessor)new BaseEntityAccessor(string2, n));
                            }
                        } else {
                            object422.setAttributeAccessor((AttributeAccessor)new BaseEntityAccessor(string2, n));
                            if (object422.isDirectToFieldMapping()) {
                                object3 = (XMLDirectMapping)object422;
                                object2 = (XMLField)object3.getField();
                                Class clazz = (Class)org.eclipse.persistence.internal.xr.Util.SCHEMA_2_CLASS.get(object2.getSchemaType());
                                if (clazz != null) {
                                    object2.setType(clazz);
                                } else {
                                    object2.setType(ClassConstants.OBJECT);
                                }
                            } else if (object422.isAbstractCompositeDirectCollectionMapping()) {
                                object3 = (AbstractCompositeDirectCollectionMapping)object422;
                                object2 = (XMLField)object3.getField();
                                Class clazz = (Class)org.eclipse.persistence.internal.xr.Util.SCHEMA_2_CLASS.get(object2.getSchemaType());
                                if (clazz != null) {
                                    object2.setType(clazz);
                                } else {
                                    object2.setType(ClassConstants.OBJECT);
                                }
                            }
                        }
                    }
                    ++n;
                }
                try {
                    object = classDescriptor22.getJavaClass();
                    object422 = ((Class)object).getMethod("setNumAttributes", Integer.class);
                    ((Method)object422).invoke(object, new Integer(n));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            xMLDescriptor.dontGenerateSubclasses();
            XMLLogin xMLLogin = new XMLLogin();
            classDescriptor22 = new DOMPlatform();
            classDescriptor22.getConversionManager().setLoader((ClassLoader)xMLDescriptor);
            xMLLogin.setPlatform((Platform)classDescriptor22);
            string.setLogin((Login)xMLLogin);
            string.createDatabaseSession();
            SchemaModelGenerator schemaModelGenerator = new SchemaModelGenerator();
            object = new SchemaModelGeneratorProperties();
            object.addProperty(this.getTargetNamespace(), "elementFormQualified", (Object)true);
            object422 = schemaModelGenerator.generateSchemas(arrayList, (SchemaModelGeneratorProperties)object);
            string2 = (Schema)object422.get(this.getTargetNamespace());
            if (this.schema != null && string2 != null) {
                object3 = this.schema.getTopLevelComplexTypes();
                for (Map.Entry entry : object3.entrySet()) {
                    string2.addTopLevelComplexTypes((ComplexType)entry.getValue());
                }
                object2 = this.schema.getNamespaceResolver();
                this.schema = string2;
                this.schema.setNamespaceResolver((NamespaceResolver)object2);
            }
        } else {
            Util.addSimpleXMLFormat(this.schema);
            this.schema.setTargetNamespace(this.getTargetNamespace());
        }
    }

    protected void writeSchema(OutputStream outputStream) {
        if (!this.isNullStream(outputStream)) {
            XMLDescriptor xMLDescriptor;
            boolean bl;
            SchemaModelProject schemaModelProject = new SchemaModelProject();
            boolean bl2 = bl = this.schema.getNamespaceResolver().resolveNamespacePrefix("ref") != null;
            if (bl) {
                xMLDescriptor = (XMLDescriptor)schemaModelProject.getClassDescriptor(Schema.class);
                xMLDescriptor.getNamespaceResolver().put("ref", "http://ws-i.org/profiles/basic/1.1/xsd");
            }
            xMLDescriptor = new XMLContext((Project)schemaModelProject);
            XMLMarshaller xMLMarshaller = xMLDescriptor.createMarshaller();
            xMLMarshaller.marshal((Object)this.schema, outputStream);
            this.packager.closeSchemaStream(outputStream);
        }
    }

    protected void buildSessionsXML(OutputStream outputStream) {
        if (!this.isNullStream(outputStream)) {
            this.logMessage(Level.FINEST, "Building " + this.getSessionsFileName());
            SessionConfigs sessionConfigs = this.packager.buildSessionsXML(outputStream, this);
            XMLSessionConfigWriter.write((SessionConfigs)sessionConfigs, (Writer)new OutputStreamWriter(outputStream));
            this.packager.closeSessionsStream(outputStream);
        }
    }

    protected void buildDBWSModel(NamingConventionTransformer namingConventionTransformer, OutputStream outputStream) {
        if (!this.isNullStream(outputStream)) {
            Object object;
            Object object222;
            for (Object object222 : this.orProject.getOrderedDescriptors()) {
                Parameter parameter;
                DatabaseField databaseField2;
                DbTable dbTable2;
                object = object222.getAlias();
                boolean bl = false;
                for (DbTable dbTable2 : this.dbTables) {
                    if (!namingConventionTransformer.generateSchemaAlias(dbTable2.getName()).equals(object)) continue;
                    bl = true;
                    break;
                }
                if (!bl) continue;
                QueryOperation queryOperation = new QueryOperation();
                queryOperation.setName("findByPrimaryKey_" + (String)object);
                dbTable2 = new NamedQueryHandler();
                dbTable2.setName("findByPrimaryKey");
                dbTable2.setDescriptor((String)object);
                Result result = new Result();
                QName qName = new QName(this.getTargetNamespace(), (String)object, "ns1");
                result.setType(qName);
                queryOperation.setResult(result);
                queryOperation.setQueryHandler((QueryHandler)dbTable2);
                for (DatabaseField databaseField2 : object222.getPrimaryKeyFields()) {
                    parameter = new Parameter();
                    parameter.setName(databaseField2.getName().toLowerCase());
                    parameter.setType(Util.getXMLTypeFromJDBCType(databaseField2.getSqlType()));
                    queryOperation.getParameters().add(parameter);
                }
                this.xrServiceModel.getOperations().put(queryOperation.getName(), queryOperation);
                QueryOperation queryOperation2 = new QueryOperation();
                queryOperation2.setName("findAll_" + (String)object);
                databaseField2 = new NamedQueryHandler();
                databaseField2.setName("findAll");
                databaseField2.setDescriptor((String)object);
                parameter = new CollectionResult();
                parameter.setType(qName);
                queryOperation2.setResult((Result)parameter);
                queryOperation2.setQueryHandler((QueryHandler)databaseField2);
                this.xrServiceModel.getOperations().put(queryOperation2.getName(), queryOperation2);
                InsertOperation insertOperation = new InsertOperation();
                insertOperation.setName("create_" + (String)object);
                Parameter parameter2 = new Parameter();
                parameter2.setName("theInstance");
                parameter2.setType(qName);
                insertOperation.getParameters().add(parameter2);
                this.xrServiceModel.getOperations().put(insertOperation.getName(), insertOperation);
                UpdateOperation updateOperation = new UpdateOperation();
                updateOperation.setName("update_" + (String)object);
                updateOperation.getParameters().add(parameter2);
                this.xrServiceModel.getOperations().put(updateOperation.getName(), updateOperation);
                DeleteOperation deleteOperation = new DeleteOperation();
                deleteOperation.setName("delete_" + (String)object);
                deleteOperation.getParameters().add(parameter2);
                this.xrServiceModel.getOperations().put(deleteOperation.getName(), deleteOperation);
            }
            for (Object object222 : this.operations) {
                if (((OperationModel)object222).isTableOperation()) {
                    object = (TableOperationModel)object222;
                    if (((TableOperationModel)object).additionalOperations.size() <= 0) continue;
                    for (OperationModel operationModel : ((TableOperationModel)object).additionalOperations) {
                        operationModel.buildOperation(this);
                    }
                    continue;
                }
                ((OperationModel)object222).buildOperation(this);
            }
            DBWSModelProject dBWSModelProject = new DBWSModelProject();
            dBWSModelProject.ns.put("ns1", this.getTargetNamespace());
            object222 = new XMLContext((Project)dBWSModelProject);
            object = object222.createMarshaller();
            object.marshal((Object)this.xrServiceModel, outputStream);
            this.packager.closeServiceStream(outputStream);
        }
    }

    protected void writeAttachmentSchema(OutputStream outputStream) {
        if (!this.isNullStream(outputStream)) {
            this.logMessage(Level.FINEST, "writing swaref.xsd");
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(new BufferedOutputStream(outputStream));
            try {
                outputStreamWriter.write(WSI_SWAREF_XSD);
                outputStreamWriter.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.packager.closeSWARefStream(outputStream);
        }
    }

    protected void writeWebXML(OutputStream outputStream) {
        if (!this.isNullStream(outputStream)) {
            this.logMessage(Level.FINEST, "writing web.xml");
            this.packager.writeWebXml(outputStream, this);
            this.packager.closeWebXmlStream(outputStream);
        }
    }

    public void buildWSDL(OutputStream outputStream, NamingConventionTransformer namingConventionTransformer) throws WSDLException {
        if (!this.isNullStream(outputStream)) {
            this.logMessage(Level.FINEST, "building eclipselink-dbws.wsdl");
            this.wsdlGenerator = new WSDLGenerator(this.xrServiceModel, namingConventionTransformer, this.getWsdlLocationURI(), this.packager.hasAttachments(), this.getTargetNamespace(), outputStream);
            this.wsdlGenerator.generateWSDL();
            this.packager.closeWSDLStream(outputStream);
        }
    }

    protected ProjectConfig buildORProjectConfig() {
        ProjectXMLConfig projectXMLConfig = null;
        boolean bl = false;
        if (this.dbTables.size() > 0) {
            bl = true;
        } else if (this.dbStoredProcedures.size() > 0) {
            for (DbStoredProcedure dbStoredProcedure : this.dbStoredProcedures) {
                for (DbStoredArgument dbStoredArgument : dbStoredProcedure.getArguments()) {
                    if (!(dbStoredArgument instanceof PLSQLStoredArgument)) continue;
                    bl = true;
                    break;
                }
                if (!bl) continue;
                break;
            }
        }
        if (bl) {
            projectXMLConfig = new ProjectXMLConfig();
            String string = this.packager.getOrProjectPathPrefix();
            projectXMLConfig.setProjectString(string == null ? "eclipselink-dbws-or.xml" : (String)string + "eclipselink-dbws-or.xml");
        } else {
            projectXMLConfig = new ProjectClassConfig();
            projectXMLConfig.setProjectString(Project.class.getName());
        }
        return projectXMLConfig;
    }

    protected ProjectConfig buildOXProjectConfig() {
        ProjectXMLConfig projectXMLConfig = null;
        boolean bl = false;
        if (this.dbTables.size() > 0) {
            bl = true;
        } else if (this.dbStoredProcedures.size() > 0) {
            for (DbStoredProcedure dbStoredProcedure : this.dbStoredProcedures) {
                for (DbStoredArgument dbStoredArgument : dbStoredProcedure.getArguments()) {
                    if (!(dbStoredArgument instanceof PLSQLStoredArgument)) continue;
                    bl = true;
                    break;
                }
                if (!bl) continue;
                break;
            }
        }
        if (bl) {
            projectXMLConfig = new ProjectXMLConfig();
            String string = this.packager.getOxProjectPathPrefix();
            projectXMLConfig.setProjectString(string == null ? "eclipselink-dbws-ox.xml" : (String)string + "eclipselink-dbws-ox.xml");
        } else {
            projectXMLConfig = new ProjectClassConfig();
            projectXMLConfig.setProjectString(SimpleXMLFormatProject.class.getName());
        }
        return projectXMLConfig;
    }

    protected String getGeneratedJavaClassName(String string) {
        String string2 = string.substring(0, 1).toUpperCase();
        String string3 = string.toLowerCase().substring(1);
        return this.getProjectName().toLowerCase() + "." + string2 + string3;
    }

    protected boolean hasAttachments() {
        for (Operation operation : this.xrServiceModel.getOperationsList()) {
            if (!(operation instanceof QueryOperation) || !((QueryOperation)operation).isAttachment()) continue;
            return true;
        }
        return false;
    }

    public DBWSPackager getPackager() {
        return this.packager;
    }

    public void setPackager(DBWSPackager dBWSPackager) {
        this.packager = dBWSPackager;
    }

    public String getDriver() {
        return (String)this.properties.get(DRIVER_KEY);
    }

    public void setDriver(String string) {
        this.properties.put(DRIVER_KEY, string);
    }

    public String getUsername() {
        return (String)this.properties.get(USERNAME_KEY);
    }

    public void setUsername(String string) {
        this.properties.put(USERNAME_KEY, string);
    }

    public String getPassword() {
        return (String)this.properties.get(PASSWORD_KEY);
    }

    public void setPassword(String string) {
        this.properties.put(PASSWORD_KEY, string);
    }

    public String getUrl() {
        return (String)this.properties.get(URL_KEY);
    }

    public void setUrl(String string) {
        this.properties.put(URL_KEY, string);
    }

    public Connection getConnection() {
        if (this.conn == null) {
            String string = this.getDriver();
            try {
                Class clazz = null;
                clazz = PrivilegedAccessHelper.shouldUsePrivilegedAccess() ? (Class)AccessController.doPrivileged(new PrivilegedClassForName(string)) : PrivilegedAccessHelper.getClassForName((String)string);
                Properties properties = new Properties();
                properties.put("user", this.getUsername());
                properties.put(PASSWORD_KEY, this.getPassword());
                if (this.getPlatformClassname().contains("MySQL")) {
                    properties.put("useInformationSchema", "true");
                }
                this.conn = DriverManager.getConnection(this.getUrl(), properties);
            }
            catch (Exception exception) {
                this.logMessage(Level.SEVERE, "cannot load JDBC driver " + string, exception);
            }
        }
        return this.conn;
    }

    public void setConnection(Connection connection) {
        this.conn = connection;
    }

    public String getProjectName() {
        return (String)this.properties.get(PROJNAME_KEY);
    }

    public void setProjectName(String string) {
        this.properties.put(PROJNAME_KEY, string);
    }

    public String getContextRoot() {
        String string = (String)this.properties.get(CONTEXT_ROOT_KEY);
        if (string == null) {
            string = "/" + this.getProjectName();
            this.setContextRoot(string);
        }
        return string;
    }

    public void setContextRoot(String string) {
        this.properties.put(CONTEXT_ROOT_KEY, string);
    }

    public String getDataSource() {
        return (String)this.properties.get(DATASOURCE_KEY);
    }

    public void setDataSource(String string) {
        this.properties.put(DATASOURCE_KEY, string);
    }

    public String getSessionsFileName() {
        String string = (String)this.properties.get(SESSIONS_FILENAME_KEY);
        if (NO_SESSIONS_FILENAME.equals(string)) {
            return null;
        }
        if (string == null || string.length() == 0) {
            string = "eclipselink-dbws-sessions.xml";
            this.setSessionsFileName(string);
        }
        return string;
    }

    public void setSessionsFileName(String string) {
        this.properties.put(SESSIONS_FILENAME_KEY, string);
    }

    public String getPlatformClassname() {
        String string = (String)this.properties.get(PLATFORM_CLASSNAME_KEY);
        if (string == null || string.length() == 0) {
            string = "org.eclipse.persistence.platform.database.OraclePlatform";
            this.setPlatformClassname(string);
        }
        return string;
    }

    public void setPlatformClassname(String string) {
        this.properties.put(PLATFORM_CLASSNAME_KEY, string);
    }

    public DatabasePlatform getDatabasePlatform() {
        String string = this.getPlatformClassname();
        try {
            Class clazz = null;
            clazz = PrivilegedAccessHelper.shouldUsePrivilegedAccess() ? (Class)AccessController.doPrivileged(new PrivilegedClassForName(string)) : PrivilegedAccessHelper.getClassForName((String)string);
            this.databasePlatform = (DatabasePlatform)Helper.getInstanceFromClass((Class)clazz);
        }
        catch (Exception exception) {
            this.databasePlatform = new MySQLPlatform();
        }
        return this.databasePlatform;
    }

    public void setDatabasePlatform(DatabasePlatform databasePlatform) {
        this.databasePlatform = databasePlatform;
    }

    public Project getOrProject() {
        return this.orProject;
    }

    public Project getOxProject() {
        return this.oxProject;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public XRServiceModel getXrServiceModel() {
        return this.xrServiceModel;
    }

    public String getOrSessionCustomizerClassName() {
        return (String)this.properties.get(ORSESSION_CUSTOMIZER_KEY);
    }

    public void setOrSessionCustomizerClassName(String string) {
        this.properties.put(ORSESSION_CUSTOMIZER_KEY, string);
    }

    public String getOxSessionCustomizerClassName() {
        return (String)this.properties.get(OXSESSION_CUSTOMIZER_KEY);
    }

    public void setOXSessionCustomizerClassName(String string) {
        this.properties.put(OXSESSION_CUSTOMIZER_KEY, string);
    }

    public WSDLGenerator getWSDLGenerator() {
        return this.wsdlGenerator;
    }

    public String getWsdlLocationURI() {
        String string = (String)this.properties.get(WSDL_URI_KEY);
        if (string == null || string.length() == 0) {
            string = "REPLACE_WITH_ENDPOINT_ADDRESS";
        }
        return string;
    }

    public void setWsdlLocationURI(String string) {
        this.properties.put(WSDL_URI_KEY, string);
    }

    public String getLogLevel() {
        return (String)this.properties.get(LOG_LEVEL_KEY);
    }

    public void setLogLevel(String string) {
        this.properties.put(LOG_LEVEL_KEY, string);
    }

    public String getTargetNamespace() {
        String string = (String)this.properties.get(TARGET_NAMESPACE_KEY);
        if (string == null) {
            string = "urn:" + this.getProjectName();
            this.setTargetNamespace(string);
        }
        return string;
    }

    public void setTargetNamespace(String string) {
        this.properties.put(TARGET_NAMESPACE_KEY, string);
    }

    protected void logMessage(Level level, String string) {
        if (this.logger != null) {
            this.logger.log(level, string);
        } else if (!this.quiet) {
            System.out.println(string);
        }
    }

    protected void logMessage(Level level, String string, Exception exception) {
        if (this.logger != null) {
            this.logger.log(level, string, exception);
        } else {
            PrintWriter printWriter = new PrintWriter(System.out);
            exception.printStackTrace(printWriter);
            System.out.println(string);
        }
    }

    protected boolean isNullStream(OutputStream outputStream) {
        return outputStream == null | outputStream == XRPackager.__nullStream;
    }

    public SqlType getSqlType() {
        return this.sqlType;
    }

    public void setSqlType(SqlType sqlType) {
        this.sqlType = sqlType;
    }

    protected void buildDbStoredProcedure2QueryNameMap(List<DbStoredProcedure> list, ArrayList<OperationModel> arrayList, boolean bl) {
        for (OperationModel operationModel : arrayList) {
            if (!operationModel.isProcedureOperation()) continue;
            ProcedureOperationModel procedureOperationModel = (ProcedureOperationModel)operationModel;
            ArrayList<DbStoredProcedure> arrayList2 = new ArrayList<DbStoredProcedure>();
            String string = Util.escapePunctuation(procedureOperationModel.getCatalogPattern(), bl);
            String string2 = Util.escapePunctuation(procedureOperationModel.getSchemaPattern(), bl);
            String string3 = Util.escapePunctuation(procedureOperationModel.getProcedurePattern(), bl);
            for (DbStoredProcedure dbStoredProcedure : list) {
                boolean bl2 = Util.sqlMatch(string3, dbStoredProcedure.getName());
                if (dbStoredProcedure.getCatalog() == null || string == null) {
                    if (dbStoredProcedure.getSchema() == null) {
                        if (!bl2) continue;
                        arrayList2.add(dbStoredProcedure);
                        continue;
                    }
                    if (!Util.sqlMatch(string2, dbStoredProcedure.getSchema()) || !bl2) continue;
                    arrayList2.add(dbStoredProcedure);
                    continue;
                }
                boolean bl3 = Util.sqlMatch(string, dbStoredProcedure.getCatalog());
                if (dbStoredProcedure.getSchema() == null) {
                    if (!bl3 || !bl2) continue;
                    arrayList2.add(dbStoredProcedure);
                    continue;
                }
                if (!Util.sqlMatch(string2, dbStoredProcedure.getSchema()) || !bl3 || !bl2) continue;
                arrayList2.add(dbStoredProcedure);
            }
            if (arrayList2.size() == 1) {
                DbStoredProcedureNameAndModel dbStoredProcedureNameAndModel = new DbStoredProcedureNameAndModel(procedureOperationModel.getName(), procedureOperationModel);
                this.dbStoredProcedure2QueryName.put((DbStoredProcedure)arrayList2.get(0), dbStoredProcedureNameAndModel);
                continue;
            }
            int n = arrayList2.size();
            for (int i = 0; i < n; ++i) {
                DbStoredProcedureNameAndModel dbStoredProcedureNameAndModel = new DbStoredProcedureNameAndModel(procedureOperationModel.getName() + (i + 1), procedureOperationModel);
                this.dbStoredProcedure2QueryName.put((DbStoredProcedure)arrayList2.get(i), dbStoredProcedureNameAndModel);
            }
        }
    }

    static {
        ServiceLoader<DBWSPackager> serviceLoader = ServiceLoader.load(DBWSPackager.class);
        for (DBWSPackager dBWSPackager : serviceLoader) {
            PACKAGERS.put(dBWSPackager.getPackagerLabel(), dBWSPackager);
        }
    }

    class DbStoredProcedureNameAndModel {
        String name;
        ProcedureOperationModel procOpModel;

        DbStoredProcedureNameAndModel(String string, ProcedureOperationModel procedureOperationModel) {
            this.name = string;
            this.procOpModel = procedureOperationModel;
        }
    }
}

