/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.dbws;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.eclipse.persistence.tools.dbws.DBWSBuilder;
import org.eclipse.persistence.tools.dbws.DBWSPackager;
import org.eclipse.persistence.tools.dbws.ProviderPackager;
import org.eclipse.persistence.tools.dbws.WarArchiver;

public class WebServicePackager
extends ProviderPackager {
    public static final String WEB_XML_PREAMBLE = "<?xml version='1.0' encoding='UTF-8'?>\n<web-app xmlns=\"http://java.sun.com/xml/ns/javaee\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" version=\"2.5\">\n  <display-name>";
    public static final String WEB_XML_SERVICE_NAME = "</display-name>\n  <servlet>\n    <servlet-name>DBWSProvider</servlet-name>\n    <servlet-class>_dbws.DBWSProvider</servlet-class>\n    <load-on-startup>0</load-on-startup>\n  </servlet>\n  <servlet-mapping>\n    <servlet-name>DBWSProvider</servlet-name>\n    <url-pattern>";
    public static final String WEB_XML_URL_PATTERN = "</url-pattern>\n  </servlet-mapping>\n</web-app>";

    public WebServicePackager() {
        this(new WarArchiver(), "wse", DBWSPackager.ArchiveUse.noArchive);
    }

    protected WebServicePackager(DBWSPackager.Archiver archiver, String string, DBWSPackager.ArchiveUse archiveUse) {
        super(archiver, string, archiveUse);
    }

    @Override
    public DBWSPackager.Archiver buildDefaultArchiver() {
        return new WarArchiver(this);
    }

    @Override
    public OutputStream getWebXmlStream() throws FileNotFoundException {
        return new FileOutputStream(new File(this.stageDir, "web.xml"));
    }

    @Override
    public void writeWebXml(OutputStream outputStream, DBWSBuilder dBWSBuilder) {
        StringBuilder stringBuilder = new StringBuilder(WEB_XML_PREAMBLE);
        String string = dBWSBuilder.getWSDLGenerator().getServiceName();
        stringBuilder.append(string);
        stringBuilder.append(WEB_XML_SERVICE_NAME);
        stringBuilder.append(dBWSBuilder.getContextRoot());
        stringBuilder.append(WEB_XML_URL_PATTERN);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(new BufferedOutputStream(outputStream));
        try {
            outputStreamWriter.write(stringBuilder.toString());
            outputStreamWriter.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public String getWSDLPathPrefix() {
        return "WEB-INF/" + super.getWSDLPathPrefix();
    }
}

