/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.persistence.descriptors.CMPPolicy;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataMethod;
import org.eclipse.persistence.internal.localization.ExceptionLocalization;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.internal.security.PrivilegedGetField;
import org.eclipse.persistence.internal.security.PrivilegedGetMethod;
import org.eclipse.persistence.internal.security.PrivilegedGetValueFromField;
import org.eclipse.persistence.internal.security.PrivilegedMethodInvoker;
import org.eclipse.persistence.internal.security.PrivilegedSetValueInField;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.foundation.AbstractDirectMapping;

public class CMP3Policy
extends CMPPolicy {
    protected CMPPolicy.KeyElementAccessor[] keyClassFields;
    protected DatabaseMapping[] keyMappings;
    protected String pkClassName;
    protected Class pkClass;

    public void convertClassNamesToClasses(ClassLoader classLoader) {
        if (this.getPKClassName() != null) {
            try {
                Class clazz = null;
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        clazz = (Class)AccessController.doPrivileged(new PrivilegedClassForName(this.getPKClassName(), true, classLoader));
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"pk_class_not_found", (Object[])new Object[]{this.pkClassName}), privilegedActionException.getException());
                    }
                } else {
                    clazz = PrivilegedAccessHelper.getClassForName((String)this.getPKClassName(), (boolean)true, (ClassLoader)classLoader);
                }
                this.setPKClass(clazz);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"pk_class_not_found", (Object[])new Object[]{this.pkClassName}), classNotFoundException);
            }
        }
    }

    public boolean isCMP3Policy() {
        return true;
    }

    public void setPrimaryKeyClassName(String string) {
        this.pkClassName = string;
    }

    public Class getPKClass() {
        if (this.pkClass == null && this.getPKClassName() == null) {
            this.initializePrimaryKeyFields(null);
        }
        return this.pkClass;
    }

    public void setPKClass(Class clazz) {
        this.pkClass = clazz;
    }

    public String getPKClassName() {
        return this.pkClassName;
    }

    public Object getPKClassInstance() {
        try {
            return this.getPKClass().newInstance();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Vector createPkVectorFromKey(Object object, AbstractSession abstractSession) {
        CMPPolicy.KeyElementAccessor[] keyElementAccessorArray = this.getKeyClassFields(object.getClass());
        NonSynchronizedVector nonSynchronizedVector = new NonSynchronizedVector(keyElementAccessorArray.length);
        for (int i = 0; i < keyElementAccessorArray.length; ++i) {
            DatabaseMapping databaseMapping = this.keyMappings[i];
            Object object2 = null;
            object2 = databaseMapping.isDirectToFieldMapping() ? ((AbstractDirectMapping)databaseMapping).getFieldValue(keyElementAccessorArray[i].getValue(object), abstractSession) : keyElementAccessorArray[i].getValue(object);
            nonSynchronizedVector.add(object2);
        }
        return nonSynchronizedVector;
    }

    public Object createBeanUsingKey(Object object, AbstractSession abstractSession) {
        try {
            Object object2 = this.getDescriptor().getInstantiationPolicy().buildNewInstance();
            CMPPolicy.KeyElementAccessor[] keyElementAccessorArray = this.getKeyClassFields(object.getClass());
            for (int i = 0; i < keyElementAccessorArray.length; ++i) {
                Object object3 = object2;
                Object object4 = keyElementAccessorArray[i].getValue(object);
                DatabaseField databaseField = keyElementAccessorArray[i].getDatabaseField();
                DatabaseMapping databaseMapping = this.getDescriptor().getObjectBuilder().getMappingForAttributeName(keyElementAccessorArray[i].getAttributeName());
                if (databaseMapping == null) {
                    databaseMapping = this.getDescriptor().getObjectBuilder().getMappingForField(databaseField);
                }
                while (databaseMapping.isAggregateObjectMapping()) {
                    Object object5 = databaseMapping.getRealAttributeValueFromObject(object3, abstractSession);
                    if (object5 == null) {
                        object5 = databaseMapping.getReferenceDescriptor().getJavaClass().newInstance();
                        databaseMapping.setRealAttributeValueInObject(object3, object5);
                    }
                    if ((databaseMapping = databaseMapping.getReferenceDescriptor().getObjectBuilder().getMappingForAttributeName(keyElementAccessorArray[i].getAttributeName())) == null) {
                        databaseMapping = this.getDescriptor().getObjectBuilder().getMappingForField(databaseField);
                    }
                    object3 = object5;
                }
                databaseMapping.setRealAttributeValueInObject(object3, object4);
            }
            return object2;
        }
        catch (Exception exception) {
            throw DescriptorException.errorUsingPrimaryKey((Object)object, (ClassDescriptor)this.getDescriptor(), (Exception)exception);
        }
    }

    protected CMPPolicy.KeyElementAccessor[] initializePrimaryKeyFields(Class clazz) {
        CMPPolicy.KeyElementAccessor[] keyElementAccessorArray = null;
        ClassDescriptor classDescriptor = this.getDescriptor();
        keyElementAccessorArray = new CMPPolicy.KeyElementAccessor[classDescriptor.getObjectBuilder().getPrimaryKeyMappings().size()];
        Iterator iterator = classDescriptor.getPrimaryKeyFields().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            DatabaseField databaseField = (DatabaseField)iterator.next();
            Vector<DatabaseMapping> vector = classDescriptor.getObjectBuilder().getReadOnlyMappingsForField(databaseField);
            if (vector == null) {
                vector = new Vector<DatabaseMapping>(1);
            }
            vector.add(classDescriptor.getObjectBuilder().getMappingForField(databaseField));
            NoSuchMethodException noSuchMethodException = null;
            for (int i = vector.size() - 1; i >= 0; --i) {
                block22: {
                    StringBuffer stringBuffer;
                    Object object;
                    String string;
                    DatabaseMapping databaseMapping = (DatabaseMapping)vector.get(i);
                    if (databaseMapping.isForeignReferenceMapping()) continue;
                    if (databaseMapping.isAggregateMapping()) {
                        string = databaseMapping.getReferenceDescriptor().getObjectBuilder();
                        object = string.getReadOnlyMappingsForField(databaseField);
                        if (object != null && !object.isEmpty()) {
                            vector.addAll((Collection<DatabaseMapping>)object);
                        }
                        if ((stringBuffer = string.getMappingForField(databaseField)) != null) {
                            vector.add((DatabaseMapping)stringBuffer);
                        }
                        vector.remove(databaseMapping);
                        i = vector.size();
                        continue;
                    }
                    string = databaseMapping.getAttributeName();
                    if (clazz == null) {
                        keyElementAccessorArray[n] = new CMPPolicy.KeyIsElementAccessor((CMPPolicy)this, databaseMapping.getAttributeName(), databaseField);
                        this.setPKClass(ConversionManager.getObjectClass((Class)databaseMapping.getAttributeClassification()));
                        noSuchMethodException = null;
                    } else {
                        try {
                            object = null;
                            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                                try {
                                    object = (Field)AccessController.doPrivileged(new PrivilegedGetField(clazz, string, true));
                                }
                                catch (PrivilegedActionException privilegedActionException) {
                                    throw (NoSuchFieldException)privilegedActionException.getException();
                                }
                            } else {
                                object = PrivilegedAccessHelper.getField((Class)clazz, (String)string, (boolean)true);
                            }
                            keyElementAccessorArray[n] = new FieldAccessor((Field)object, string, databaseField);
                            noSuchMethodException = null;
                        }
                        catch (NoSuchFieldException noSuchFieldException) {
                            stringBuffer = new StringBuffer();
                            stringBuffer.append("get");
                            stringBuffer.append(string.substring(0, 1).toUpperCase());
                            stringBuffer.append(string.substring(1));
                            try {
                                Method method = null;
                                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                                    try {
                                        method = (Method)AccessController.doPrivileged(new PrivilegedGetMethod(clazz, stringBuffer.toString(), new Class[0], true));
                                    }
                                    catch (PrivilegedActionException privilegedActionException) {
                                        throw (NoSuchMethodException)privilegedActionException.getException();
                                    }
                                } else {
                                    method = PrivilegedAccessHelper.getMethod((Class)clazz, (String)stringBuffer.toString(), (Class[])new Class[0], (boolean)true);
                                }
                                keyElementAccessorArray[n] = new PropertyAccessor(method, string, databaseField);
                                noSuchMethodException = null;
                            }
                            catch (NoSuchMethodException noSuchMethodException2) {
                                if (classDescriptor.getObjectBuilder().getPrimaryKeyMappings().size() == 1) {
                                    keyElementAccessorArray[n] = new CMPPolicy.KeyIsElementAccessor((CMPPolicy)this, databaseMapping.getAttributeName(), databaseField);
                                    this.setPKClass(ConversionManager.getObjectClass((Class)databaseMapping.getAttributeClassification()));
                                    noSuchMethodException = null;
                                    break block22;
                                }
                                noSuchMethodException = noSuchMethodException2;
                            }
                        }
                    }
                }
                if (noSuchMethodException == null) break;
            }
            if (noSuchMethodException != null) {
                throw DescriptorException.errorUsingPrimaryKey((Object)clazz, (ClassDescriptor)this.getDescriptor(), noSuchMethodException);
            }
            ++n;
        }
        return keyElementAccessorArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CMPPolicy.KeyElementAccessor[] getKeyClassFields(Class clazz) {
        if (this.keyClassFields == null) {
            CMP3Policy cMP3Policy = this;
            synchronized (cMP3Policy) {
                if (this.keyClassFields == null) {
                    CMPPolicy.KeyElementAccessor[] keyElementAccessorArray = this.initializePrimaryKeyFields(this.pkClass == null ? clazz : this.pkClass);
                    int n = keyElementAccessorArray.length;
                    DatabaseMapping[] databaseMappingArray = new DatabaseMapping[n];
                    for (int i = 0; i < n; ++i) {
                        CMPPolicy.KeyElementAccessor keyElementAccessor = keyElementAccessorArray[i];
                        DatabaseMapping databaseMapping = this.getDescriptor().getObjectBuilder().getMappingForAttributeName(keyElementAccessor.getAttributeName());
                        if (databaseMapping == null) {
                            databaseMapping = this.getDescriptor().getObjectBuilder().getMappingForField(keyElementAccessor.getDatabaseField());
                        }
                        while (databaseMapping.isAggregateObjectMapping()) {
                            DatabaseMapping databaseMapping2 = databaseMapping.getReferenceDescriptor().getObjectBuilder().getMappingForAttributeName(keyElementAccessor.getAttributeName());
                            if (databaseMapping2 == null) {
                                databaseMapping2 = databaseMapping.getReferenceDescriptor().getObjectBuilder().getMappingForField(keyElementAccessor.getDatabaseField());
                            }
                            databaseMapping = databaseMapping2;
                        }
                        databaseMappingArray[i] = databaseMapping;
                    }
                    this.keyMappings = databaseMappingArray;
                    this.keyClassFields = keyElementAccessorArray;
                }
            }
        }
        return this.keyClassFields;
    }

    private class FieldAccessor
    implements CMPPolicy.KeyElementAccessor {
        protected Field field;
        protected String attributeName;
        protected DatabaseField databaseField;

        public FieldAccessor(Field field, String string, DatabaseField databaseField) {
            this.field = field;
            this.attributeName = string;
            this.databaseField = databaseField;
        }

        public String getAttributeName() {
            return this.attributeName;
        }

        public DatabaseField getDatabaseField() {
            return this.databaseField;
        }

        public Object getValue(Object object) {
            try {
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        return AccessController.doPrivileged(new PrivilegedGetValueFromField(this.field, object));
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        throw DescriptorException.errorUsingPrimaryKey((Object)object, (ClassDescriptor)CMP3Policy.this.getDescriptor(), (Exception)privilegedActionException.getException());
                    }
                }
                return PrivilegedAccessHelper.getValueFromField((Field)this.field, (Object)object);
            }
            catch (Exception exception) {
                throw DescriptorException.errorUsingPrimaryKey((Object)object, (ClassDescriptor)CMP3Policy.this.getDescriptor(), (Exception)exception);
            }
        }

        public void setValue(Object object, Object object2) {
            block5: {
                try {
                    Field field = null;
                    if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                        try {
                            field = (Field)AccessController.doPrivileged(new PrivilegedGetField(object.getClass(), this.field.getName(), true));
                            AccessController.doPrivileged(new PrivilegedSetValueInField(field, object, object2));
                            break block5;
                        }
                        catch (PrivilegedActionException privilegedActionException) {
                            throw DescriptorException.errorUsingPrimaryKey((Object)object, (ClassDescriptor)CMP3Policy.this.getDescriptor(), (Exception)privilegedActionException.getException());
                        }
                    }
                    field = PrivilegedAccessHelper.getField(object.getClass(), (String)this.field.getName(), (boolean)true);
                    PrivilegedAccessHelper.setValueInField((Field)field, (Object)object, (Object)object2);
                }
                catch (Exception exception) {
                    throw DescriptorException.errorUsingPrimaryKey((Object)object, (ClassDescriptor)CMP3Policy.this.getDescriptor(), (Exception)exception);
                }
            }
        }
    }

    private class PropertyAccessor
    implements CMPPolicy.KeyElementAccessor {
        protected Method method;
        protected String attributeName;
        protected DatabaseField databaseField;

        public PropertyAccessor(Method method, String string, DatabaseField databaseField) {
            this.method = method;
            this.attributeName = string;
            this.databaseField = databaseField;
        }

        public String getAttributeName() {
            return this.attributeName;
        }

        public DatabaseField getDatabaseField() {
            return this.databaseField;
        }

        public Object getValue(Object object) {
            try {
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        return AccessController.doPrivileged(new PrivilegedMethodInvoker(this.method, object, new Object[0]));
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        Exception exception = privilegedActionException.getException();
                        if (exception instanceof IllegalAccessException) {
                            throw (IllegalAccessException)exception;
                        }
                        throw (InvocationTargetException)exception;
                    }
                }
                return PrivilegedAccessHelper.invokeMethod((Method)this.method, (Object)object, (Object[])new Object[0]);
            }
            catch (Exception exception) {
                throw DescriptorException.errorUsingPrimaryKey((Object)object, (ClassDescriptor)CMP3Policy.this.getDescriptor(), (Exception)exception);
            }
        }

        public void setValue(Object object, Object object2) {
            block6: {
                try {
                    if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                        try {
                            AccessController.doPrivileged(new PrivilegedMethodInvoker(new MetadataMethod(this.method, object.getClass()).getSetMethod(), object, new Object[]{object2}));
                            break block6;
                        }
                        catch (PrivilegedActionException privilegedActionException) {
                            Exception exception = privilegedActionException.getException();
                            if (exception instanceof IllegalAccessException) {
                                throw (IllegalAccessException)exception;
                            }
                            throw (InvocationTargetException)exception;
                        }
                    }
                    PrivilegedAccessHelper.invokeMethod((Method)new MetadataMethod(this.method, object.getClass()).getSetMethod(), (Object)object, (Object[])new Object[]{object2});
                }
                catch (Exception exception) {
                    throw DescriptorException.errorUsingPrimaryKey((Object)object, (ClassDescriptor)CMP3Policy.this.getDescriptor(), (Exception)exception);
                }
            }
        }
    }
}

