/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa;

import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityExistsException;
import javax.persistence.EntityNotFoundException;
import javax.persistence.EntityTransaction;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.OptimisticLockException;
import javax.persistence.PersistenceException;
import javax.persistence.Query;
import javax.sql.DataSource;
import org.eclipse.persistence.descriptors.CMPPolicy;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.VersionLockingPolicy;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.exceptions.JPQLException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.descriptors.OptimisticLockingPolicy;
import org.eclipse.persistence.internal.jpa.EJBQueryImpl;
import org.eclipse.persistence.internal.jpa.EntityManagerFactoryImpl;
import org.eclipse.persistence.internal.jpa.EntityManagerFactoryProvider;
import org.eclipse.persistence.internal.jpa.EntityManagerSetupImpl;
import org.eclipse.persistence.internal.jpa.QueryHintsHandler;
import org.eclipse.persistence.internal.jpa.transaction.EntityTransactionWrapper;
import org.eclipse.persistence.internal.jpa.transaction.JTATransactionWrapper;
import org.eclipse.persistence.internal.jpa.transaction.TransactionWrapper;
import org.eclipse.persistence.internal.jpa.transaction.TransactionWrapperImpl;
import org.eclipse.persistence.internal.localization.ExceptionLocalization;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.PropertiesHandler;
import org.eclipse.persistence.internal.sessions.RepeatableWriteUnitOfWork;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.jpa.JpaEntityManager;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.DataReadQuery;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.queries.ResultSetMappingQuery;
import org.eclipse.persistence.sessions.Connector;
import org.eclipse.persistence.sessions.DatasourceLogin;
import org.eclipse.persistence.sessions.DefaultConnector;
import org.eclipse.persistence.sessions.JNDIConnector;
import org.eclipse.persistence.sessions.Login;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.sessions.factories.ReferenceMode;
import org.eclipse.persistence.sessions.factories.SessionManager;
import org.eclipse.persistence.sessions.server.ConnectionPolicy;
import org.eclipse.persistence.sessions.server.ServerSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityManagerImpl
implements JpaEntityManager {
    protected TransactionWrapperImpl transaction;
    protected boolean isOpen;
    protected RepeatableWriteUnitOfWork extendedPersistenceContext;
    protected ServerSession serverSession;
    protected EntityManagerFactoryImpl factory;
    protected boolean beginEarlyTransaction;
    protected Map properties;
    protected FlushModeType flushMode;
    protected ReferenceMode referenceMode;
    protected ConnectionPolicy connectionPolicy;
    protected boolean closeOnCommit;
    protected boolean persistOnCommit;
    protected String flushClearCache;
    protected boolean shouldValidateExistence;

    public EntityManagerImpl(String string) {
        this((ServerSession)SessionManager.getManager().getSession(string), null);
    }

    public EntityManagerImpl(ServerSession serverSession) {
        this(serverSession, null);
    }

    public EntityManagerImpl(ServerSession serverSession, Map map) {
        this.serverSession = serverSession;
        this.referenceMode = ReferenceMode.HARD;
        this.flushMode = FlushModeType.AUTO;
        this.flushClearCache = "DropInvalidate";
        this.persistOnCommit = true;
        this.isOpen = true;
        this.initialize(map);
    }

    public EntityManagerImpl(EntityManagerFactoryImpl entityManagerFactoryImpl, Map map) {
        this.factory = entityManagerFactoryImpl;
        this.serverSession = entityManagerFactoryImpl.getServerSession();
        this.beginEarlyTransaction = entityManagerFactoryImpl.getBeginEarlyTransaction();
        this.closeOnCommit = entityManagerFactoryImpl.getCloseOnCommit();
        this.flushMode = entityManagerFactoryImpl.getFlushMode();
        this.persistOnCommit = entityManagerFactoryImpl.getPersistOnCommit();
        this.referenceMode = entityManagerFactoryImpl.getReferenceMode();
        this.flushClearCache = entityManagerFactoryImpl.getFlushClearCache();
        this.shouldValidateExistence = entityManagerFactoryImpl.shouldValidateExistence();
        this.isOpen = true;
        this.initialize(map);
    }

    protected void initialize(Map map) {
        this.detectTransactionWrapper();
        if (map != null) {
            this.properties = new HashMap(map);
        }
        this.processProperties();
    }

    public void clear() {
        try {
            this.verifyOpen();
            if (this.extendedPersistenceContext != null) {
                if (this.checkForTransaction(false) == null) {
                    this.extendedPersistenceContext.clearForClose(true);
                    this.extendedPersistenceContext = null;
                } else {
                    this.extendedPersistenceContext.clear(true);
                }
            }
        }
        catch (RuntimeException runtimeException) {
            this.setRollbackOnly();
            throw runtimeException;
        }
    }

    public void removeExtendedPersistenceContext() {
        this.extendedPersistenceContext = null;
    }

    public void persist(Object object) {
        try {
            this.verifyOpen();
            if (object == null) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"not_an_entity", (Object[])new Object[]{object}));
            }
            try {
                this.getActivePersistenceContext(this.checkForTransaction(false)).registerNewObjectForPersist(object, new IdentityHashMap());
            }
            catch (RuntimeException runtimeException) {
                if (runtimeException instanceof ValidationException) {
                    throw new EntityExistsException(runtimeException.getLocalizedMessage(), (Throwable)runtimeException);
                }
                throw runtimeException;
            }
        }
        catch (RuntimeException runtimeException) {
            this.setRollbackOnly();
            throw runtimeException;
        }
    }

    public <T> T merge(T t) {
        try {
            this.verifyOpen();
            return (T)this.mergeInternal(t);
        }
        catch (RuntimeException runtimeException) {
            this.setRollbackOnly();
            throw runtimeException;
        }
    }

    protected Object mergeInternal(Object object) {
        if (object == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"not_an_entity", (Object[])new Object[]{object}));
        }
        Object object2 = null;
        RepeatableWriteUnitOfWork repeatableWriteUnitOfWork = this.getActivePersistenceContext(this.checkForTransaction(false));
        try {
            object2 = repeatableWriteUnitOfWork.mergeCloneWithReferences(object, 4, true);
        }
        catch (org.eclipse.persistence.exceptions.OptimisticLockException optimisticLockException) {
            throw new OptimisticLockException((Throwable)optimisticLockException);
        }
        return object2;
    }

    public void remove(Object object) {
        try {
            this.verifyOpen();
            if (object == null) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"not_an_entity", (Object[])new Object[]{object}));
            }
            this.getActivePersistenceContext(this.checkForTransaction(false)).performRemove(object, new IdentityHashMap());
        }
        catch (RuntimeException runtimeException) {
            this.setRollbackOnly();
            throw runtimeException;
        }
    }

    public <T> T find(Class<T> clazz, Object object) {
        return this.find(clazz, object, null, null);
    }

    public <T> T find(Class<T> clazz, Object object, LockModeType lockModeType) {
        HashMap hashMap = null;
        if (this.properties != null && this.properties.containsKey("javax.persistence.lock.timeout")) {
            hashMap = new HashMap();
            hashMap.put("javax.persistence.lock.timeout", this.properties.get("javax.persistence.lock.timeout"));
        }
        return this.find(clazz, object, lockModeType, hashMap);
    }

    public <T> T find(Class<T> clazz, Object object, LockModeType lockModeType, Map map) {
        try {
            this.verifyOpen();
            AbstractSession abstractSession = (AbstractSession)this.getActiveSession();
            ClassDescriptor classDescriptor = abstractSession.getDescriptor(clazz);
            if (classDescriptor == null || classDescriptor.isAggregateDescriptor() || classDescriptor.isAggregateCollectionDescriptor()) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"unknown_bean_class", (Object[])new Object[]{clazz}));
            }
            return (T)this.findInternal(classDescriptor, abstractSession, object, lockModeType, map);
        }
        catch (RuntimeException runtimeException) {
            this.setRollbackOnly();
            throw runtimeException;
        }
    }

    public Object find(String string, Object object) {
        try {
            this.verifyOpen();
            AbstractSession abstractSession = (AbstractSession)this.getActiveSession();
            ClassDescriptor classDescriptor = abstractSession.getDescriptorForAlias(string);
            if (classDescriptor == null || classDescriptor.isAggregateDescriptor() || classDescriptor.isAggregateCollectionDescriptor()) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"unknown_entitybean_name", (Object[])new Object[]{string}));
            }
            return this.findInternal(classDescriptor, abstractSession, object, null, null);
        }
        catch (RuntimeException runtimeException) {
            this.setRollbackOnly();
            throw runtimeException;
        }
    }

    protected Object findInternal(ClassDescriptor classDescriptor, AbstractSession abstractSession, Object object, LockModeType lockModeType, Map map) {
        CMPPolicy cMPPolicy;
        List list;
        if (object == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"null_pk"));
        }
        if (object instanceof List) {
            list = (List)object;
        } else {
            cMPPolicy = classDescriptor.getCMPPolicy();
            Class clazz = cMPPolicy.getPKClass();
            if (clazz != null && clazz != object.getClass() && !clazz.isAssignableFrom(object.getClass())) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"invalid_pk_class", (Object[])new Object[]{classDescriptor.getCMPPolicy().getPKClass(), object.getClass()}));
            }
            list = cMPPolicy.createPkVectorFromKey(object, abstractSession);
        }
        cMPPolicy = classDescriptor.getQueryManager().getReadObjectQuery();
        if (cMPPolicy == null) {
            cMPPolicy = this.getReadObjectQuery(classDescriptor.getJavaClass(), list, map);
        } else {
            cMPPolicy.checkPrepare(abstractSession, null);
            cMPPolicy = (ReadObjectQuery)cMPPolicy.clone();
            QueryHintsHandler.apply(map, (DatabaseQuery)cMPPolicy, abstractSession.getLoader());
            cMPPolicy.setIsExecutionClone(true);
            cMPPolicy.setSelectionKey(list);
        }
        if (map == null || !map.containsKey("eclipselink.cache-usage")) {
            cMPPolicy.conformResultsInUnitOfWork();
        }
        return this.executeQuery((ReadObjectQuery)cMPPolicy, lockModeType, (UnitOfWork)abstractSession);
    }

    public void flush() {
        try {
            this.verifyOpen();
            try {
                this.getActivePersistenceContext(this.checkForTransaction(true)).writeChanges();
            }
            catch (RuntimeException runtimeException) {
                if (EclipseLinkException.class.isAssignableFrom(runtimeException.getClass())) {
                    throw new PersistenceException((Throwable)runtimeException);
                }
                throw runtimeException;
            }
        }
        catch (RuntimeException runtimeException) {
            this.setRollbackOnly();
            throw runtimeException;
        }
    }

    protected void detectTransactionWrapper() {
        if (this.serverSession.hasExternalTransactionController()) {
            this.setJTATransactionWrapper();
        } else {
            this.setEntityTransactionWrapper();
        }
    }

    private Object executeQuery(ReadObjectQuery readObjectQuery, LockModeType lockModeType, UnitOfWork unitOfWork) {
        if (lockModeType != null && readObjectQuery.setLockModeType(lockModeType.name(), (AbstractSession)this.getActiveSession())) {
            throw new PersistenceException(ExceptionLocalization.buildMessage((String)"ejb30-wrong-lock_called_without_version_locking-index", null));
        }
        return unitOfWork.executeQuery((DatabaseQuery)readObjectQuery);
    }

    public void refresh(Object object) {
        this.refresh(object, null);
    }

    public void refresh(Object object, LockModeType lockModeType) {
        HashMap hashMap = null;
        if (this.properties != null && this.properties.containsKey("javax.persistence.lock.timeout")) {
            hashMap = new HashMap();
            hashMap.put("javax.persistence.lock.timeout", this.properties.get("javax.persistence.lock.timeout"));
        }
        this.refresh(object, lockModeType, hashMap);
    }

    public void refresh(Object object, LockModeType lockModeType, Map map) {
        try {
            Object object2;
            this.verifyOpen();
            RepeatableWriteUnitOfWork repeatableWriteUnitOfWork = this.getActivePersistenceContext(this.checkForTransaction(false));
            if (!this.contains(object, (UnitOfWork)repeatableWriteUnitOfWork)) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"cant_refresh_not_managed_object", (Object[])new Object[]{object}));
            }
            ReadObjectQuery readObjectQuery = this.getReadObjectQuery(object, map);
            if (map == null || !map.containsKey("eclipselink.refresh")) {
                readObjectQuery.refreshIdentityMapResult();
            }
            if (map == null || !map.containsKey("eclipselink.refresh.cascade")) {
                readObjectQuery.cascadeByMapping();
            }
            if ((object2 = this.executeQuery(readObjectQuery, lockModeType, (UnitOfWork)repeatableWriteUnitOfWork)) == null) {
                throw new EntityNotFoundException(ExceptionLocalization.buildMessage((String)"entity_no_longer_exists_in_db", (Object[])new Object[]{object}));
            }
        }
        catch (RuntimeException runtimeException) {
            this.setRollbackOnly();
            throw runtimeException;
        }
    }

    public boolean contains(Object object) {
        try {
            this.verifyOpen();
            if (object == null) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"not_an_entity", (Object[])new Object[]{object}));
            }
            ClassDescriptor classDescriptor = (ClassDescriptor)this.serverSession.getDescriptors().get(object.getClass());
            if (classDescriptor == null || classDescriptor.isAggregateDescriptor() || classDescriptor.isAggregateCollectionDescriptor()) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"not_an_entity", (Object[])new Object[]{object}));
            }
            if (!this.hasActivePersistenceContext()) {
                return false;
            }
            return this.contains(object, (UnitOfWork)this.getActivePersistenceContext(this.checkForTransaction(false)));
        }
        catch (RuntimeException runtimeException) {
            this.setRollbackOnly();
            throw runtimeException;
        }
    }

    protected boolean contains(Object object, UnitOfWork unitOfWork) {
        return ((UnitOfWorkImpl)unitOfWork).isObjectRegistered(object) && !((UnitOfWorkImpl)unitOfWork).isObjectDeleted(object);
    }

    @Override
    public Query createDescriptorNamedQuery(String string, Class clazz) {
        return this.createDescriptorNamedQuery(string, clazz, null);
    }

    @Override
    public Query createDescriptorNamedQuery(String string, Class clazz, List list) {
        try {
            DatabaseQuery databaseQuery;
            this.verifyOpen();
            ClassDescriptor classDescriptor = this.serverSession.getDescriptor(clazz);
            if (classDescriptor != null && (databaseQuery = classDescriptor.getQueryManager().getLocalQueryByArgumentTypes(string, list)) != null) {
                return new EJBQueryImpl(databaseQuery, this);
            }
            return null;
        }
        catch (RuntimeException runtimeException) {
            this.setRollbackOnly();
            throw runtimeException;
        }
    }

    public Query createNamedQuery(String string) {
        try {
            this.verifyOpen();
            return new EJBQueryImpl(string, this, true);
        }
        catch (RuntimeException runtimeException) {
            this.setRollbackOnly();
            throw runtimeException;
        }
    }

    public Query createNativeQuery(String string) {
        try {
            this.verifyOpen();
            return new EJBQueryImpl(EJBQueryImpl.buildSQLDatabaseQuery(string, this.serverSession.getLoader()), this);
        }
        catch (RuntimeException runtimeException) {
            this.setRollbackOnly();
            throw runtimeException;
        }
    }

    public Query createNativeQuery(String string, Class clazz) {
        try {
            this.verifyOpen();
            DatabaseQuery databaseQuery = this.createNativeQueryInternal(string, clazz);
            return new EJBQueryImpl(databaseQuery, this);
        }
        catch (RuntimeException runtimeException) {
            this.setRollbackOnly();
            throw runtimeException;
        }
    }

    public Query createNativeQuery(String string, String string2) {
        try {
            this.verifyOpen();
            ResultSetMappingQuery resultSetMappingQuery = new ResultSetMappingQuery();
            resultSetMappingQuery.setSQLResultSetMappingName(string2);
            resultSetMappingQuery.setSQLString(string);
            resultSetMappingQuery.setIsUserDefined(true);
            return new EJBQueryImpl((DatabaseQuery)resultSetMappingQuery, this);
        }
        catch (RuntimeException runtimeException) {
            this.setRollbackOnly();
            throw runtimeException;
        }
    }

    @Override
    public Session getActiveSession() {
        return this.getActivePersistenceContext(this.checkForTransaction(false));
    }

    public Object getDelegate() {
        try {
            this.verifyOpen();
            return this;
        }
        catch (RuntimeException runtimeException) {
            this.setRollbackOnly();
            throw runtimeException;
        }
    }

    public FlushModeType getFlushMode() {
        try {
            this.verifyOpen();
            return this.flushMode;
        }
        catch (RuntimeException runtimeException) {
            this.setRollbackOnly();
            throw runtimeException;
        }
    }

    @Override
    public UnitOfWork getUnitOfWork() {
        return this.getActivePersistenceContext(this.checkForTransaction(false));
    }

    @Override
    public Session getSession() {
        if (this.checkForTransaction(false) == null) {
            return this.serverSession.acquireNonSynchronizedUnitOfWork(this.referenceMode);
        }
        return null;
    }

    public EntityTransaction getTransaction() {
        try {
            return ((TransactionWrapper)((Object)this.transaction)).getTransaction();
        }
        catch (RuntimeException runtimeException) {
            this.setRollbackOnly();
            throw runtimeException;
        }
    }

    public Object getProperty(String string) {
        Object object = null;
        if (string == null) {
            return null;
        }
        if (this.properties != null) {
            object = this.properties.get(string);
        }
        if (object == null) {
            object = this.factory.getServerSession().getProperty(string);
        }
        return object;
    }

    protected ReadObjectQuery getReadObjectQuery(Class clazz, List list, Map map) {
        ReadObjectQuery readObjectQuery = this.getReadObjectQuery(map);
        readObjectQuery.setReferenceClass(clazz);
        readObjectQuery.setSelectionKey(list);
        return readObjectQuery;
    }

    protected ReadObjectQuery getReadObjectQuery(Map map) {
        ReadObjectQuery readObjectQuery = new ReadObjectQuery();
        QueryHintsHandler.apply(map, (DatabaseQuery)readObjectQuery, this.serverSession.getDatasourcePlatform().getConversionManager().getLoader());
        readObjectQuery.setIsExecutionClone(true);
        return readObjectQuery;
    }

    protected ReadObjectQuery getReadObjectQuery(Object object, Map map) {
        ReadObjectQuery readObjectQuery = this.getReadObjectQuery(map);
        readObjectQuery.setSelectionObject(object);
        return readObjectQuery;
    }

    public <T> T getReference(Class<T> clazz, Object object) {
        try {
            this.verifyOpen();
            UnitOfWork unitOfWork = (UnitOfWork)this.getActiveSession();
            Object object2 = unitOfWork.getReference(clazz, object);
            if (object2 == null) {
                Object[] objectArray = new Object[]{object};
                String string = ExceptionLocalization.buildMessage((String)"no_entities_retrieved_for_get_reference", (Object[])objectArray);
                throw new EntityNotFoundException(string);
            }
            return (T)object2;
        }
        catch (RuntimeException runtimeException) {
            this.setRollbackOnly();
            throw runtimeException;
        }
    }

    public Session getReadOnlySession() {
        if (this.extendedPersistenceContext != null && this.extendedPersistenceContext.isActive()) {
            return this.extendedPersistenceContext.getParent();
        }
        return this.serverSession.acquireClientSession(this.connectionPolicy, this.properties);
    }

    @Override
    public ServerSession getServerSession() {
        return this.serverSession;
    }

    protected DatabaseQuery createNativeQueryInternal(String string, Class clazz) {
        ReadAllQuery readAllQuery = new ReadAllQuery(clazz);
        readAllQuery.setSQLString(string);
        readAllQuery.setIsUserDefined(true);
        return readAllQuery;
    }

    @Override
    public Query createQuery(Expression expression, Class clazz) {
        try {
            this.verifyOpen();
            DatabaseQuery databaseQuery = this.createQueryInternal(expression, clazz);
            return new EJBQueryImpl(databaseQuery, this);
        }
        catch (RuntimeException runtimeException) {
            this.setRollbackOnly();
            throw runtimeException;
        }
    }

    @Override
    public Query createQuery(DatabaseQuery databaseQuery) {
        try {
            this.verifyOpen();
            return new EJBQueryImpl(databaseQuery, this);
        }
        catch (RuntimeException runtimeException) {
            this.setRollbackOnly();
            throw runtimeException;
        }
    }

    @Override
    public Query createQueryByExample(Object object) {
        try {
            this.verifyOpen();
            ReadAllQuery readAllQuery = new ReadAllQuery(object.getClass());
            readAllQuery.setExampleObject(object);
            return new EJBQueryImpl((DatabaseQuery)readAllQuery, this);
        }
        catch (RuntimeException runtimeException) {
            this.setRollbackOnly();
            throw runtimeException;
        }
    }

    @Override
    public Query createQuery(Call call) {
        try {
            this.verifyOpen();
            DataReadQuery dataReadQuery = new DataReadQuery(call);
            return new EJBQueryImpl((DatabaseQuery)dataReadQuery, this);
        }
        catch (RuntimeException runtimeException) {
            this.setRollbackOnly();
            throw runtimeException;
        }
    }

    @Override
    public Query createQuery(Call call, Class clazz) {
        try {
            this.verifyOpen();
            ReadAllQuery readAllQuery = new ReadAllQuery(clazz, call);
            return new EJBQueryImpl((DatabaseQuery)readAllQuery, this);
        }
        catch (RuntimeException runtimeException) {
            this.setRollbackOnly();
            throw runtimeException;
        }
    }

    public Query createQuery(String string) {
        try {
            EJBQueryImpl eJBQueryImpl;
            this.verifyOpen();
            try {
                eJBQueryImpl = new EJBQueryImpl(string, this);
            }
            catch (JPQLException jPQLException) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"wrap_ejbql_exception"), jPQLException);
            }
            return eJBQueryImpl;
        }
        catch (RuntimeException runtimeException) {
            this.setRollbackOnly();
            throw runtimeException;
        }
    }

    protected DatabaseQuery createQueryInternal(Expression expression, Class clazz) {
        ReadAllQuery readAllQuery = new ReadAllQuery(clazz);
        readAllQuery.setSelectionCriteria(expression);
        return readAllQuery;
    }

    public void close() {
        try {
            this.verifyOpen();
            this.isOpen = false;
            this.factory = null;
            this.serverSession = null;
            if (this.extendedPersistenceContext != null) {
                if (this.checkForTransaction(false) == null && !this.extendedPersistenceContext.isSynchronized()) {
                    this.extendedPersistenceContext.release();
                    this.extendedPersistenceContext.getParent().release();
                } else {
                    this.extendedPersistenceContext.setResumeUnitOfWorkOnTransactionCompletion(false);
                }
                this.extendedPersistenceContext = null;
            }
        }
        catch (RuntimeException runtimeException) {
            this.setRollbackOnly();
            throw runtimeException;
        }
    }

    public boolean isFlushModeAUTO() {
        return this.flushMode == FlushModeType.AUTO;
    }

    public boolean isOpen() {
        return this.isOpen && this.factory.isOpen();
    }

    public void lock(Object object, LockModeType lockModeType) {
        HashMap hashMap = null;
        if (this.properties != null && this.properties.containsKey("javax.persistence.lock.timeout")) {
            hashMap = new HashMap();
            hashMap.put("javax.persistence.lock.timeout", this.properties.get("javax.persistence.lock.timeout"));
        }
        this.lock(object, lockModeType, hashMap);
    }

    public void lock(Object object, LockModeType lockModeType, Map map) {
        try {
            this.verifyOpen();
            if (lockModeType.name().contains("PESSIMISTIC")) {
                ReadObjectQuery readObjectQuery = this.getReadObjectQuery(object, map);
                if (map == null || !map.containsKey("eclipselink.refresh")) {
                    readObjectQuery.refreshIdentityMapResult();
                }
                if (map == null || !map.containsKey("eclipselink.refresh.cascade")) {
                    readObjectQuery.cascadePrivateParts();
                }
                this.executeQuery(readObjectQuery, lockModeType, (UnitOfWork)this.getActivePersistenceContext(this.checkForTransaction(false)));
            } else {
                RepeatableWriteUnitOfWork repeatableWriteUnitOfWork = this.getActivePersistenceContext(this.checkForTransaction(false));
                ClassDescriptor classDescriptor = repeatableWriteUnitOfWork.getDescriptor(object);
                OptimisticLockingPolicy optimisticLockingPolicy = classDescriptor.getOptimisticLockingPolicy();
                if (optimisticLockingPolicy == null || !(optimisticLockingPolicy instanceof VersionLockingPolicy)) {
                    throw new PersistenceException(ExceptionLocalization.buildMessage((String)"ejb30-wrong-lock_called_without_version_locking-index", null));
                }
                repeatableWriteUnitOfWork.forceUpdateToVersionField(object, lockModeType == LockModeType.WRITE || lockModeType.name().equals("OPTIMISTIC_FORCE_INCREMENT"));
            }
        }
        catch (RuntimeException runtimeException) {
            this.setRollbackOnly();
            throw runtimeException;
        }
    }

    public void verifyOpen() {
        if (!this.isOpen()) {
            throw new IllegalStateException(ExceptionLocalization.buildMessage((String)"operation_on_closed_entity_manager"));
        }
    }

    public RepeatableWriteUnitOfWork getActivePersistenceContext(Object object) {
        if (this.extendedPersistenceContext == null || !this.extendedPersistenceContext.isActive()) {
            this.extendedPersistenceContext = new RepeatableWriteUnitOfWork((AbstractSession)this.serverSession.acquireClientSession(this.connectionPolicy, this.properties), this.referenceMode);
            this.extendedPersistenceContext.setResumeUnitOfWorkOnTransactionCompletion(!this.closeOnCommit);
            this.extendedPersistenceContext.setShouldDiscoverNewObjects(this.persistOnCommit);
            this.extendedPersistenceContext.setFlushClearCache(this.flushClearCache);
            this.extendedPersistenceContext.setShouldValidateExistence(this.shouldValidateExistence);
            this.extendedPersistenceContext.setShouldCascadeCloneToJoinedRelationship(true);
            if (object != null) {
                this.transaction.registerUnitOfWorkWithTxn((UnitOfWorkImpl)this.extendedPersistenceContext);
            }
        }
        if (this.beginEarlyTransaction && object != null && !this.extendedPersistenceContext.isInTransaction()) {
            this.extendedPersistenceContext.beginEarlyTransaction();
        }
        return this.extendedPersistenceContext;
    }

    public void setProperties(Map map) {
        if (this.hasActivePersistenceContext()) {
            this.extendedPersistenceContext.log(6, "properties", "entity_manager_sets_properties_while_context_is_active");
        }
        this.properties = map;
        this.processProperties();
    }

    private boolean hasActivePersistenceContext() {
        return this.extendedPersistenceContext != null && this.extendedPersistenceContext.isActive();
    }

    protected Object checkForTransaction(boolean bl) {
        return this.transaction.checkForTransaction(bl);
    }

    public boolean shouldFlushBeforeQuery() {
        Object object = this.checkForTransaction(false);
        return object != null && this.transaction.shouldFlushBeforeQuery((UnitOfWorkImpl)this.getActivePersistenceContext(object));
    }

    public boolean shouldBeginEarlyTransaction() {
        return this.beginEarlyTransaction;
    }

    public void joinTransaction() {
        try {
            this.verifyOpen();
            this.transaction.registerUnitOfWorkWithTxn((UnitOfWorkImpl)this.getActivePersistenceContext(this.checkForTransaction(true)));
        }
        catch (RuntimeException runtimeException) {
            this.setRollbackOnly();
            throw runtimeException;
        }
    }

    protected void setRollbackOnly() {
        this.transaction.setRollbackOnlyInternal();
    }

    private void processProperties() {
        if (this.properties != null && !this.properties.isEmpty()) {
            String string;
            String string2;
            String string3;
            String string4;
            String string5;
            String string6 = this.getPropertiesHandlerProperty("eclipselink.transaction.join-existing");
            if (string6 != null) {
                this.beginEarlyTransaction = "true".equalsIgnoreCase(string6);
            }
            if ((string5 = this.getPropertiesHandlerProperty("eclipselink.persistence-context.reference-mode")) != null) {
                this.referenceMode = ReferenceMode.valueOf((String)string5);
            }
            if ((string4 = this.getPropertiesHandlerProperty("eclipselink.persistence-context.flush-mode")) != null) {
                this.flushMode = FlushModeType.valueOf((String)string4);
            }
            if ((string3 = this.getPropertiesHandlerProperty("eclipselink.persistence-context.close-on-commit")) != null) {
                this.closeOnCommit = "true".equalsIgnoreCase(string3);
            }
            if ((string2 = this.getPropertiesHandlerProperty("eclipselink.persistence-context.persist-on-commit")) != null) {
                this.persistOnCommit = "true".equalsIgnoreCase(string2);
            }
            if ((string = this.getPropertiesHandlerProperty("eclipselink.validate-existence")) != null) {
                this.shouldValidateExistence = "true".equalsIgnoreCase(string);
            }
            String string7 = this.getPropertiesHandlerProperty("eclipselink.flush-clear.cache");
            if (string != null) {
                this.flushClearCache = string7;
            }
        }
        this.connectionPolicy = this.processConnectionPolicyProperties();
    }

    protected String getPropertiesHandlerProperty(String string) {
        return PropertiesHandler.getPropertyValue((String)string, (Map)this.properties, (boolean)false);
    }

    protected void setEntityTransactionWrapper() {
        this.transaction = new EntityTransactionWrapper(this);
    }

    public void setFlushMode(FlushModeType flushModeType) {
        try {
            this.verifyOpen();
            this.flushMode = flushModeType;
        }
        catch (RuntimeException runtimeException) {
            this.setRollbackOnly();
            throw runtimeException;
        }
    }

    protected void setJTATransactionWrapper() {
        this.transaction = new JTATransactionWrapper(this);
    }

    protected ConnectionPolicy processConnectionPolicyProperties() {
        ConnectionPolicy.ExclusiveMode exclusiveMode;
        ConnectionPolicy connectionPolicy = this.serverSession.getDefaultConnectionPolicy();
        if (this.properties == null || this.properties.isEmpty()) {
            return connectionPolicy;
        }
        ConnectionPolicy connectionPolicy2 = (ConnectionPolicy)this.properties.get("eclipselink.jdbc.connection-policy");
        if (connectionPolicy2 != null) {
            connectionPolicy = connectionPolicy2;
        }
        ConnectionPolicy connectionPolicy3 = null;
        String string = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.jdbc.exclusive-connection.is-lazy", this.properties, (AbstractSession)this.serverSession, false);
        if (string != null) {
            boolean bl = Boolean.parseBoolean(string);
            if (connectionPolicy.isLazy() != bl) {
                if (connectionPolicy3 == null) {
                    connectionPolicy3 = (ConnectionPolicy)connectionPolicy.clone();
                }
                connectionPolicy3.setIsLazy(bl);
            }
        }
        if ((exclusiveMode = EntityManagerSetupImpl.getConnectionPolicyExclusiveModeFromProperties(this.properties, (AbstractSession)this.serverSession, false)) != null && !exclusiveMode.equals((Object)connectionPolicy.getExclusiveMode())) {
            if (connectionPolicy3 == null) {
                connectionPolicy3 = (ConnectionPolicy)connectionPolicy.clone();
            }
            connectionPolicy3.setExclusiveMode(exclusiveMode);
        }
        String string2 = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.jdbc.user", this.properties, (AbstractSession)this.serverSession, false);
        String string3 = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.jdbc.password", this.properties, (AbstractSession)this.serverSession, false);
        String string4 = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.jdbc.driver", this.properties, (AbstractSession)this.serverSession, false);
        String string5 = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.jdbc.url", this.properties, (AbstractSession)this.serverSession, false);
        Object object = EntityManagerFactoryProvider.getConfigPropertyLogDebug("javax.persistence.jtaDataSource", this.properties, (AbstractSession)this.serverSession, false);
        DataSource dataSource = null;
        String string6 = null;
        if (object != null) {
            if (object instanceof DataSource) {
                dataSource = (DataSource)object;
            } else if (object instanceof String) {
                string6 = (String)object;
            }
        }
        Object object2 = EntityManagerFactoryProvider.getConfigPropertyLogDebug("javax.persistence.nonJtaDataSource", this.properties, (AbstractSession)this.serverSession, false);
        DataSource dataSource2 = null;
        String string7 = null;
        if (object2 != null) {
            if (object2 instanceof DataSource) {
                dataSource2 = (DataSource)object2;
            } else if (object2 instanceof String) {
                string7 = (String)object2;
            }
        }
        if (string2 != null || string3 != null || string4 != null || string5 != null || object != null || object2 != null) {
            Boolean bl;
            boolean bl2;
            boolean bl3 = EntityManagerImpl.isPropertyToBeAdded(string4) || EntityManagerImpl.isPropertyToBeAdded(string5);
            boolean bl4 = bl2 = EntityManagerImpl.isPropertyToBeAdded(dataSource, string6) || EntityManagerImpl.isPropertyToBeAdded(dataSource2, string7);
            if (bl3 && bl2) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"entity_manager_properties_conflict_default_connector_vs_jndi_connector", (Object[])new Object[0]));
            }
            DatasourceLogin datasourceLogin = (DatasourceLogin)connectionPolicy.getLogin();
            if (datasourceLogin == null) {
                datasourceLogin = connectionPolicy.getPoolName() != null ? (DatasourceLogin)this.serverSession.getConnectionPool(connectionPolicy.getPoolName()).getLogin() : (DatasourceLogin)this.serverSession.getDatasourceLogin();
            }
            if (datasourceLogin.shouldUseExternalTransactionController() && bl3) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"entity_manager_properties_conflict_default_connector_vs_external_transaction_controller", (Object[])new Object[0]));
            }
            DataSource dataSource3 = null;
            String string8 = null;
            if (bl2) {
                if (datasourceLogin.shouldUseExternalTransactionController()) {
                    if (EntityManagerImpl.isPropertyToBeAdded(dataSource, string6)) {
                        dataSource3 = dataSource;
                        string8 = string6;
                    }
                    if (EntityManagerImpl.isPropertyToBeAdded(dataSource2, string7)) {
                        this.serverSession.log(6, "properties", "entity_manager_ignores_nonjta_data_source");
                    }
                } else {
                    if (EntityManagerImpl.isPropertyToBeAdded(dataSource2, string7)) {
                        dataSource3 = dataSource2;
                        string8 = string7;
                    }
                    if (EntityManagerImpl.isPropertyToBeAdded(dataSource, string6)) {
                        this.serverSession.log(6, "properties", "entity_manager_ignores_jta_data_source");
                    }
                }
            }
            Boolean bl5 = (bl = this.isPropertyValueToBeUpdated(datasourceLogin.getUserName(), string2)) != null && bl == false ? Boolean.FALSE : this.isPropertyValueToBeUpdated(datasourceLogin.getPassword(), string3);
            DefaultConnector defaultConnector = null;
            if (datasourceLogin.getConnector() instanceof DefaultConnector) {
                defaultConnector = (DefaultConnector)datasourceLogin.getConnector();
            }
            boolean bl6 = defaultConnector == null && bl3;
            JNDIConnector jNDIConnector = null;
            if (datasourceLogin.getConnector() instanceof JNDIConnector) {
                jNDIConnector = (JNDIConnector)datasourceLogin.getConnector();
            }
            boolean bl7 = jNDIConnector == null && bl2;
            Boolean bl8 = null;
            Boolean bl9 = null;
            if (bl6) {
                bl8 = this.isPropertyValueToBeUpdated(null, string4);
                bl9 = this.isPropertyValueToBeUpdated(null, string5);
            } else if (defaultConnector != null) {
                bl8 = this.isPropertyValueToBeUpdated(defaultConnector.getDriverClassName(), string4);
                bl9 = this.isPropertyValueToBeUpdated(defaultConnector.getConnectionString(), string5);
            }
            Boolean bl10 = null;
            if (bl7) {
                bl10 = Boolean.TRUE;
            } else if (jNDIConnector != null) {
                if (dataSource3 != null) {
                    if (!dataSource3.equals(jNDIConnector.getDataSource())) {
                        bl10 = Boolean.TRUE;
                    }
                } else if (string8 != null && !string8.equals(jNDIConnector.getName())) {
                    bl10 = Boolean.TRUE;
                }
            }
            if (bl != null || bl5 != null || bl8 != null || bl9 != null || bl10.booleanValue()) {
                if (connectionPolicy3 == null) {
                    connectionPolicy3 = (ConnectionPolicy)connectionPolicy.clone();
                }
                DatasourceLogin datasourceLogin2 = (DatasourceLogin)connectionPolicy3.getLogin();
                if (connectionPolicy3.getLogin() == null || connectionPolicy3.getLogin() == connectionPolicy.getLogin()) {
                    datasourceLogin2 = (DatasourceLogin)datasourceLogin.clone();
                    connectionPolicy3.setLogin((Login)datasourceLogin2);
                }
                connectionPolicy3.setPoolName(null);
                if (bl != null) {
                    if (bl.booleanValue()) {
                        datasourceLogin2.setProperty("user", (Object)string2);
                    } else {
                        datasourceLogin2.getProperties().remove("user");
                    }
                }
                if (bl5 != null) {
                    if (bl5.booleanValue()) {
                        datasourceLogin2.setProperty("password", (Object)string3);
                    } else {
                        datasourceLogin2.getProperties().remove("password");
                    }
                }
                if (bl6) {
                    datasourceLogin2.setConnector((Connector)new DefaultConnector());
                    datasourceLogin2.setUsesExternalConnectionPooling(false);
                } else if (bl7) {
                    datasourceLogin2.setConnector((Connector)new JNDIConnector());
                    datasourceLogin2.setUsesExternalConnectionPooling(true);
                }
                if (bl3) {
                    DefaultConnector defaultConnector2 = (DefaultConnector)datasourceLogin2.getConnector();
                    if (bl8 != null) {
                        if (bl8.booleanValue()) {
                            defaultConnector2.setDriverClassName(string4);
                        } else {
                            defaultConnector2.setDriverClassName(null);
                        }
                    }
                    if (bl9 != null) {
                        if (bl9.booleanValue()) {
                            defaultConnector2.setDatabaseURL(string5);
                        } else {
                            defaultConnector2.setDatabaseURL(null);
                        }
                    }
                } else if (bl10 != null) {
                    JNDIConnector jNDIConnector2 = (JNDIConnector)datasourceLogin2.getConnector();
                    if (bl10.booleanValue()) {
                        if (dataSource3 != null) {
                            jNDIConnector2.setDataSource(dataSource3);
                        } else {
                            jNDIConnector2.setName(string8);
                        }
                    }
                }
            }
        }
        if (connectionPolicy3 != null) {
            return connectionPolicy3;
        }
        return connectionPolicy;
    }

    protected static boolean isPropertyToBeAdded(String string) {
        return string != null && string.length() > 0;
    }

    protected static boolean isPropertyToBeAdded(DataSource dataSource, String string) {
        return dataSource != null || string != null && string.length() > 0;
    }

    protected static boolean isPropertyToBeRemoved(String string) {
        return string != null && string.length() == 0;
    }

    protected Boolean isPropertyValueToBeUpdated(String string, String string2) {
        if (string2 == null) {
            return null;
        }
        if (string2.length() > 0) {
            if (string != null) {
                if (string2.equals(string)) {
                    return null;
                }
                return Boolean.TRUE;
            }
            return Boolean.TRUE;
        }
        if (string != null) {
            return Boolean.FALSE;
        }
        return null;
    }
}

