/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.deployment;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.persistence.exceptions.PersistenceUnitLoadingException;
import org.eclipse.persistence.exceptions.XMLParseException;
import org.eclipse.persistence.internal.jpa.deployment.Archive;
import org.eclipse.persistence.internal.jpa.deployment.ArchiveFactoryImpl;
import org.eclipse.persistence.internal.jpa.deployment.SEPersistenceUnitInfo;
import org.eclipse.persistence.internal.jpa.deployment.xml.parser.PersistenceContentHandler;
import org.eclipse.persistence.internal.jpa.deployment.xml.parser.XMLException;
import org.eclipse.persistence.internal.jpa.deployment.xml.parser.XMLExceptionHandler;
import org.eclipse.persistence.internal.jpa.metadata.MetadataProcessor;
import org.eclipse.persistence.internal.jpa.metadata.MetadataProject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.logging.AbstractSessionLog;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceUnitProcessor {
    private static final String SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    private static final String XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    private static final String PERSISTENCE_SCHEMA_NAME = "org/eclipse/persistence/jpa/persistence_1_0.xsd";
    private static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";

    public static String buildClassNameFromEntryString(String string) {
        String string2 = string;
        if (string.endsWith(".class")) {
            string2 = string2.substring(0, string2.length() - 6);
            string2 = string2.replace("/", ".");
        }
        return string2;
    }

    public static Set<String> buildClassSet(PersistenceUnitInfo persistenceUnitInfo, ClassLoader classLoader) {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(persistenceUnitInfo.getManagedClassNames());
        Iterator iterator = persistenceUnitInfo.getJarFileUrls().iterator();
        while (iterator.hasNext()) {
            hashSet.addAll(PersistenceUnitProcessor.getClassNamesFromURL((URL)iterator.next()));
        }
        if (!persistenceUnitInfo.excludeUnlistedClasses()) {
            hashSet.addAll(PersistenceUnitProcessor.getClassNamesFromURL(persistenceUnitInfo.getPersistenceUnitRootUrl()));
        }
        hashSet.addAll(PersistenceUnitProcessor.buildPersistentClassSetFromXMLDocuments(persistenceUnitInfo, classLoader));
        return hashSet;
    }

    public static Collection<Class> buildEntityList(MetadataProject metadataProject, ClassLoader classLoader) {
        ArrayList<Class> arrayList = new ArrayList<Class>();
        for (String string : metadataProject.getWeavableClassNames()) {
            try {
                Class<?> clazz = classLoader.loadClass(string);
                arrayList.add(clazz);
            }
            catch (ClassNotFoundException classNotFoundException) {
                AbstractSessionLog.getLog().log(4, "exception_loading_entity_class", (Object)string, (Object)classNotFoundException);
            }
        }
        return arrayList;
    }

    private static Set<String> buildPersistentClassSetFromXMLDocuments(PersistenceUnitInfo persistenceUnitInfo, ClassLoader classLoader) {
        MetadataProcessor metadataProcessor = new MetadataProcessor(persistenceUnitInfo, null, classLoader, false, false);
        metadataProcessor.loadMappingFiles(false);
        return metadataProcessor.getPersistenceUnitClassSetFromMappingFiles();
    }

    public static URL computePURootURL(URL uRL) throws IOException {
        String string = uRL.getProtocol();
        if ("file".equals(string)) {
            return new URL(uRL, "..");
        }
        if ("jar".equals(string)) {
            JarURLConnection jarURLConnection = (JarURLConnection)JarURLConnection.class.cast(uRL.openConnection());
            assert (jarURLConnection.getJarEntry().getName().equals("META-INF/persistence.xml"));
            return jarURLConnection.getJarFileURL();
        }
        return new URL(uRL, "../");
    }

    public static Set<Archive> findPersistenceArchives() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        return PersistenceUnitProcessor.findPersistenceArchives(classLoader);
    }

    public static Set<Archive> findPersistenceArchives(ClassLoader classLoader) {
        HashSet<Archive> hashSet = new HashSet<Archive>();
        try {
            Enumeration<URL> enumeration = classLoader.getResources("META-INF/persistence.xml");
            while (enumeration.hasMoreElements()) {
                URL uRL = enumeration.nextElement();
                URL uRL2 = PersistenceUnitProcessor.computePURootURL(uRL);
                Archive archive = new ArchiveFactoryImpl().createArchive(uRL2);
                hashSet.add(archive);
            }
        }
        catch (IOException iOException) {
            throw PersistenceUnitLoadingException.exceptionSearchingForPersistenceResources((ClassLoader)classLoader, (Exception)iOException);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw PersistenceUnitLoadingException.exceptionSearchingForPersistenceResources((ClassLoader)classLoader, (Exception)uRISyntaxException);
        }
        return hashSet;
    }

    public static Set<String> getClassNamesFromURL(URL uRL) {
        HashSet<String> hashSet = new HashSet<String>();
        Archive archive = null;
        try {
            archive = new ArchiveFactoryImpl().createArchive(uRL);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new RuntimeException("url = [" + uRL + "]", uRISyntaxException);
        }
        catch (IOException iOException) {
            throw new RuntimeException("url = [" + uRL + "]", iOException);
        }
        Iterator<String> iterator = archive.getEntries();
        while (iterator.hasNext()) {
            String string = iterator.next();
            if (!string.endsWith(".class")) continue;
            hashSet.add(PersistenceUnitProcessor.buildClassNameFromEntryString(string));
        }
        return hashSet;
    }

    public static Annotation getEmbeddableAnnotation(Class clazz) {
        return new MetadataClass(clazz).getAnnotation(Embeddable.class);
    }

    public static Annotation getEntityAnnotation(Class clazz) {
        return new MetadataClass(clazz).getAnnotation(Entity.class);
    }

    public static List<SEPersistenceUnitInfo> getPersistenceUnits(Archive archive, ClassLoader classLoader) {
        return PersistenceUnitProcessor.processPersistenceArchive(archive, classLoader);
    }

    public static boolean isEmbeddable(Class clazz) {
        return new MetadataClass(clazz).isAnnotationPresent(Embeddable.class);
    }

    public static boolean isEntity(Class clazz) {
        return new MetadataClass(clazz).isAnnotationPresent(Entity.class);
    }

    public static Class loadClass(String string, ClassLoader classLoader, boolean bl, MetadataProject metadataProject) {
        Class<?> clazz = null;
        try {
            clazz = classLoader.loadClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (bl) {
                throw PersistenceUnitLoadingException.exceptionLoadingClassWhileLookingForAnnotations((String)string, (Exception)classNotFoundException);
            }
            AbstractSessionLog.getLog().log(6, "persistence_unit_processor_error_loading_class", (Object)classNotFoundException.getClass().getName(), (Object)classNotFoundException.getLocalizedMessage(), (Object)string);
        }
        catch (NullPointerException nullPointerException) {
            AbstractSessionLog.getLog().log(6, "persistence_unit_processor_error_loading_class_weaving_disabled", (Object)classLoader, (Object)metadataProject.getPersistenceUnitInfo().getPersistenceUnitName(), (Object)string);
            metadataProject.setWeavingEnabled(false);
        }
        catch (Exception exception) {
            AbstractSessionLog.getLog().log(6, "persistence_unit_processor_error_loading_class", (Object)exception.getClass().getName(), (Object)exception.getLocalizedMessage(), (Object)string);
        }
        catch (Error error) {
            AbstractSessionLog.getLog().log(6, "persistence_unit_processor_error_loading_class", (Object)error.getClass().getName(), (Object)error.getLocalizedMessage(), (Object)string);
            throw error;
        }
        return clazz;
    }

    public static void processORMetadata(MetadataProcessor metadataProcessor, boolean bl) {
        metadataProcessor.loadMappingFiles(bl);
        metadataProcessor.processEntityMappings();
        metadataProcessor.processORMMetadata();
    }

    public static List<SEPersistenceUnitInfo> processPersistenceArchive(Archive archive, ClassLoader classLoader) {
        URL uRL = archive.getRootURL();
        try {
            InputStream inputStream = archive.getEntry("META-INF/persistence.xml");
            return PersistenceUnitProcessor.processPersistenceXML(uRL, inputStream, classLoader);
        }
        catch (IOException iOException) {
            throw PersistenceUnitLoadingException.exceptionLoadingFromUrl((String)uRL.toString(), (Exception)iOException);
        }
    }

    private static List<SEPersistenceUnitInfo> processPersistenceXML(URL uRL, InputStream inputStream, ClassLoader classLoader) {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setNamespaceAware(true);
        XMLReader xMLReader = null;
        SAXParser sAXParser = null;
        XMLExceptionHandler xMLExceptionHandler = new XMLExceptionHandler();
        try {
            sAXParser = sAXParserFactory.newSAXParser();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw XMLParseException.exceptionCreatingSAXParser((URL)uRL, (Exception)parserConfigurationException);
        }
        catch (SAXException sAXException) {
            throw XMLParseException.exceptionCreatingSAXParser((URL)uRL, (Exception)sAXException);
        }
        try {
            xMLReader = sAXParser.getXMLReader();
            xMLReader.setErrorHandler(xMLExceptionHandler);
        }
        catch (SAXException sAXException) {
            throw XMLParseException.exceptionCreatingXMLReader((URL)uRL, (Exception)sAXException);
        }
        PersistenceContentHandler persistenceContentHandler = new PersistenceContentHandler();
        xMLReader.setContentHandler(persistenceContentHandler);
        InputSource inputSource = new InputSource(inputStream);
        try {
            xMLReader.parse(inputSource);
        }
        catch (IOException iOException) {
            throw PersistenceUnitLoadingException.exceptionProcessingPersistenceXML((URL)uRL, (Exception)iOException);
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
        XMLException xMLException = xMLExceptionHandler.getXMLException();
        if (xMLException != null) {
            throw PersistenceUnitLoadingException.exceptionProcessingPersistenceXML((URL)uRL, (Exception)xMLException);
        }
        for (SEPersistenceUnitInfo sEPersistenceUnitInfo : persistenceContentHandler.getPersistenceUnits()) {
            sEPersistenceUnitInfo.setPersistenceUnitRootUrl(uRL);
        }
        return persistenceContentHandler.getPersistenceUnits();
    }

    public static String buildPersistenceUnitName(URL uRL, String string) {
        String string2 = null;
        try {
            string2 = URLDecoder.decode(uRL.toString(), "UTF8") + string;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw PersistenceUnitLoadingException.couldNotBuildPersistenceUntiName((Exception)unsupportedEncodingException, (String)uRL.toString(), (String)string);
        }
        return string2;
    }
}

