/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.mappings;

import java.lang.annotation.Annotation;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.BasicCollectionAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MetadataHelper;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.columns.ColumnMetadata;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectCollectionMapping;
import org.eclipse.persistence.mappings.DirectMapMapping;
import org.eclipse.persistence.mappings.converters.Converter;

public class BasicMapAccessor
extends BasicCollectionAccessor {
    private ColumnMetadata m_keyColumn;
    private String m_keyConverter;
    private String m_valueConverter;
    private boolean m_keyContextProcessing;

    public BasicMapAccessor() {
        super("<basic-map>");
    }

    public BasicMapAccessor(Annotation annotation, MetadataAccessibleObject metadataAccessibleObject, ClassAccessor classAccessor) {
        super(annotation, metadataAccessibleObject, classAccessor);
        this.m_keyColumn = new ColumnMetadata((Annotation)MetadataHelper.invokeMethod("keyColumn", annotation), metadataAccessibleObject, this.getAttributeName());
        Annotation annotation2 = (Annotation)MetadataHelper.invokeMethod("keyConverter", annotation);
        this.m_keyConverter = (String)MetadataHelper.invokeMethod("value", annotation2);
        Annotation annotation3 = (Annotation)MetadataHelper.invokeMethod("valueConverter", annotation);
        this.m_valueConverter = (String)MetadataHelper.invokeMethod("value", annotation3);
        this.setValueColumn(new ColumnMetadata((Annotation)MetadataHelper.invokeMethod("valueColumn", annotation), metadataAccessibleObject, this.getAttributeName()));
        this.setFetch((Enum)MetadataHelper.invokeMethod("fetch", annotation));
    }

    protected ColumnMetadata getColumn(String string) {
        if (string.equals("metadata_default_value_column")) {
            return super.getColumn(string);
        }
        return this.m_keyColumn == null ? new ColumnMetadata(this.getAccessibleObject(), this.getAttributeName()) : this.m_keyColumn;
    }

    protected String getDefaultCollectionTableName() {
        if (this.m_keyColumn != null && this.m_keyColumn.getTable() != null && !this.m_keyColumn.getTable().equals("")) {
            return this.m_keyColumn.getTable();
        }
        return super.getDefaultCollectionTableName();
    }

    public ColumnMetadata getKeyColumn() {
        return this.m_keyColumn;
    }

    public String getKeyConverter() {
        return this.m_keyConverter;
    }

    public Class getReferenceClass() {
        if (this.m_keyContextProcessing) {
            return this.getAccessibleObject().getMapKeyClass(this.getDescriptor());
        }
        return this.getReferenceClassFromGeneric();
    }

    public String getValueConverter() {
        return this.m_valueConverter;
    }

    protected boolean hasConvert() {
        return true;
    }

    public void initXMLObject(MetadataAccessibleObject metadataAccessibleObject) {
        super.initXMLObject(metadataAccessibleObject);
        this.initXMLObject(this.m_keyColumn, metadataAccessibleObject);
        if (this.m_keyColumn != null) {
            this.m_keyColumn.setAttributeName(this.getAttributeName());
        }
    }

    protected boolean isValidBasicMapType(Class clazz) {
        return clazz.equals(Map.class);
    }

    public void process() {
        DirectMapMapping directMapMapping;
        if (this.isValidBasicMapType(this.getRawClass())) {
            directMapMapping = new DirectMapMapping();
            this.process((DirectCollectionMapping)directMapMapping);
            if (this.usesIndirection()) {
                directMapMapping.useTransparentMap();
            } else {
                directMapMapping.dontUseIndirection();
                directMapMapping.useMapClass(Hashtable.class);
            }
        } else {
            throw ValidationException.invalidTypeForBasicMapAttribute((String)this.getAttributeName(), (Class)this.getRawClass(), (Class)this.getJavaClass());
        }
        directMapMapping.setDirectKeyField(this.getDatabaseField(directMapMapping.getReferenceTable(), "metadata_default_key_column"));
        this.processMappingConverter((DatabaseMapping)directMapMapping, this.m_keyConverter);
        directMapMapping.setDirectField(this.getDatabaseField(directMapMapping.getReferenceTable(), "metadata_default_value_column"));
        this.processMappingConverter((DatabaseMapping)directMapMapping, this.m_valueConverter);
        this.processProperties((DatabaseMapping)directMapMapping);
    }

    public void processConvert() {
        DatabaseMapping databaseMapping = this.getDescriptor().getMappingForAttributeName(this.getAttributeName());
        this.m_keyContextProcessing = true;
        this.processConvert(databaseMapping, this.m_keyConverter);
        this.m_keyContextProcessing = false;
        this.processConvert(databaseMapping, this.m_valueConverter);
    }

    public void setConverter(DatabaseMapping databaseMapping, Converter converter) {
        if (this.m_keyContextProcessing) {
            ((DirectMapMapping)databaseMapping).setKeyConverter(converter);
        } else {
            ((DirectMapMapping)databaseMapping).setValueConverter(converter);
        }
    }

    public void setConverterClassName(DatabaseMapping databaseMapping, String string) {
        if (this.m_keyContextProcessing) {
            ((DirectMapMapping)databaseMapping).setKeyConverterClassName(string);
        } else {
            ((DirectMapMapping)databaseMapping).setValueConverterClassName(string);
        }
    }

    public void setFieldClassification(DatabaseMapping databaseMapping, Class clazz) {
        if (this.m_keyContextProcessing) {
            ((DirectMapMapping)databaseMapping).setDirectKeyFieldClassification(clazz);
        } else {
            super.setFieldClassification(databaseMapping, clazz);
        }
    }

    public void setKeyColumn(ColumnMetadata columnMetadata) {
        this.m_keyColumn = columnMetadata;
    }

    public void setKeyConverter(String string) {
        this.m_keyConverter = string;
    }

    public void setValueConverter(String string) {
        this.m_valueConverter = string;
    }
}

