/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.queries;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.JPAQuery;
import org.eclipse.persistence.internal.jpa.QueryHintsHandler;
import org.eclipse.persistence.internal.jpa.metadata.ORMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.queries.MetadataHelper;
import org.eclipse.persistence.internal.jpa.metadata.queries.QueryHintMetadata;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.DatabaseQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamedQueryMetadata
extends ORMetadata {
    private Enum m_lockMode;
    private List<QueryHintMetadata> m_hints = new ArrayList<QueryHintMetadata>();
    private String m_name;
    private String m_query;

    public NamedQueryMetadata() {
        super("<named-query>");
    }

    protected NamedQueryMetadata(String string) {
        super(string);
    }

    public NamedQueryMetadata(Annotation annotation, MetadataAccessibleObject metadataAccessibleObject) {
        super(annotation, metadataAccessibleObject);
        this.m_name = (String)MetadataHelper.invokeMethod("name", annotation);
        this.m_query = (String)MetadataHelper.invokeMethod("query", annotation);
        this.m_lockMode = (Enum)MetadataHelper.invokeMethod("lockMode", annotation);
        for (Annotation annotation2 : (Annotation[])MetadataHelper.invokeMethod("hints", annotation)) {
            this.m_hints.add(new QueryHintMetadata(annotation2, metadataAccessibleObject));
        }
    }

    public boolean equals(Object object) {
        if (object instanceof NamedQueryMetadata) {
            NamedQueryMetadata namedQueryMetadata = (NamedQueryMetadata)object;
            if (!this.valuesMatch(this.m_name, namedQueryMetadata.getName())) {
                return false;
            }
            if (!this.valuesMatch(this.m_query, namedQueryMetadata.getQuery())) {
                return false;
            }
            return this.valuesMatch(this.m_hints, namedQueryMetadata.getHints());
        }
        return false;
    }

    public List<QueryHintMetadata> getHints() {
        return this.m_hints;
    }

    @Override
    public String getIdentifier() {
        return this.m_name;
    }

    public Enum getLockMode() {
        return this.m_lockMode;
    }

    public String getName() {
        return this.m_name;
    }

    public String getQuery() {
        return this.m_query;
    }

    public void process(AbstractSession abstractSession, ClassLoader classLoader) {
        try {
            Map<String, Object> map = this.processQueryHints(abstractSession);
            abstractSession.addJPAQuery((DatabaseQuery)new JPAQuery(this.getName(), this.getQuery(), this.getLockMode(), map));
        }
        catch (Exception exception) {
            throw ValidationException.errorProcessingNamedQuery(this.getClass(), (String)this.getName(), (Exception)exception);
        }
    }

    protected Map<String, Object> processQueryHints(AbstractSession abstractSession) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (QueryHintMetadata queryHintMetadata : this.m_hints) {
            QueryHintsHandler.verify(queryHintMetadata.getName(), queryHintMetadata.getValue(), this.m_name, abstractSession);
            Object v = hashMap.get(queryHintMetadata.getName());
            if (v != null) {
                Object[] objectArray = null;
                if (v instanceof Object[]) {
                    ArrayList<Object> arrayList = new ArrayList<Object>(Arrays.asList((Object[])v));
                    arrayList.add(queryHintMetadata.getValue());
                    objectArray = arrayList.toArray();
                } else {
                    objectArray = new Object[]{v, queryHintMetadata.getValue()};
                }
                hashMap.put(queryHintMetadata.getName(), objectArray);
                continue;
            }
            hashMap.put(queryHintMetadata.getName(), queryHintMetadata.getValue());
        }
        return hashMap;
    }

    public void setHints(List<QueryHintMetadata> list) {
        this.m_hints = list;
    }

    public void setLockMode(Enum enum_) {
        this.m_lockMode = enum_;
    }

    public void setName(String string) {
        this.m_name = string;
    }

    public void setQuery(String string) {
        this.m_query = string;
    }
}

