/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.eis.mappings;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.eis.mappings.EISMapping;
import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.queries.JoinedAttributeManager;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.ObjectReferenceMapping;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ObjectBuildingQuery;
import org.eclipse.persistence.queries.ObjectLevelModifyQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.queries.ReadQuery;

public class EISOneToOneMapping
extends ObjectReferenceMapping
implements EISMapping {
    protected Map sourceToTargetKeyFields;
    protected Map targetToSourceKeyFields;
    protected boolean shouldVerifyDelete;
    protected transient Expression privateOwnedCriteria;

    public EISOneToOneMapping() {
        this.selectionQuery = new ReadObjectQuery();
        this.foreignKeyFields = NonSynchronizedVector.newInstance(1);
        this.sourceToTargetKeyFields = new HashMap(2);
        this.targetToSourceKeyFields = new HashMap(2);
    }

    public boolean isEISMapping() {
        return true;
    }

    public boolean isOneToOneMapping() {
        return true;
    }

    public void addForeignKeyField(DatabaseField databaseField, DatabaseField databaseField2) {
        this.getSourceToTargetKeyFields().put(databaseField, databaseField2);
        this.getTargetToSourceKeyFields().put(databaseField2, databaseField);
        this.getForeignKeyFields().add(databaseField);
        this.setIsForeignKeyRelationship(true);
    }

    public void addForeignKeyFieldName(String string, String string2) {
        this.addForeignKeyField(new DatabaseField(string), new DatabaseField(string2));
    }

    public Object clone() {
        DatabaseField databaseField;
        DatabaseField databaseField2;
        DatabaseField databaseField32;
        EISOneToOneMapping eISOneToOneMapping = (EISOneToOneMapping)super.clone();
        eISOneToOneMapping.setForeignKeyFields(NonSynchronizedVector.newInstance(this.getForeignKeyFields().size()));
        eISOneToOneMapping.setSourceToTargetKeyFields(new HashMap(this.getSourceToTargetKeyFields().size()));
        eISOneToOneMapping.setTargetToSourceKeyFields(new HashMap(this.getTargetToSourceKeyFields().size()));
        HashMap<Object, DatabaseField> hashMap = new HashMap<Object, DatabaseField>(this.getTargetToSourceKeyFields().size());
        Enumeration<DatabaseField> enumeration = this.getForeignKeyFields().elements();
        while (enumeration.hasMoreElements()) {
            Object object = enumeration.nextElement();
            databaseField32 = (DatabaseField)((DatabaseField)object).clone();
            hashMap.put(object, databaseField32);
            eISOneToOneMapping.getForeignKeyFields().addElement(databaseField32);
        }
        for (Object object : this.getSourceToTargetKeyFields().keySet()) {
            databaseField32 = (DatabaseField)this.getSourceToTargetKeyFields().get(object);
            databaseField2 = (DatabaseField)hashMap.get(databaseField32);
            if (databaseField2 == null) {
                databaseField2 = (DatabaseField)databaseField32.clone();
                hashMap.put(databaseField32, databaseField2);
            }
            if ((databaseField = (DatabaseField)((DatabaseField)object).clone()) == null) {
                databaseField = (DatabaseField)((DatabaseField)object).clone();
                hashMap.put(object, databaseField);
            }
            eISOneToOneMapping.getSourceToTargetKeyFields().put(databaseField, databaseField2);
        }
        for (DatabaseField databaseField32 : this.getTargetToSourceKeyFields().keySet()) {
            DatabaseField databaseField4;
            databaseField2 = (DatabaseField)this.getTargetToSourceKeyFields().get(databaseField32);
            databaseField = (DatabaseField)hashMap.get(databaseField32);
            if (databaseField == null) {
                databaseField = (DatabaseField)databaseField32.clone();
                hashMap.put(databaseField32, databaseField);
            }
            if ((databaseField4 = (DatabaseField)hashMap.get(databaseField2)) == null) {
                databaseField4 = (DatabaseField)databaseField2.clone();
                hashMap.put(databaseField2, databaseField4);
            }
            eISOneToOneMapping.getTargetToSourceKeyFields().put(databaseField, databaseField4);
        }
        return eISOneToOneMapping;
    }

    protected Vector extractForeignKeyFromRow(AbstractRecord abstractRecord, AbstractSession abstractSession) {
        Vector<Object> vector = new Vector<Object>();
        for (DatabaseField databaseField : this.getSourceToTargetKeyFields().keySet()) {
            Object object = abstractRecord.get(databaseField);
            try {
                object = abstractSession.getDatasourcePlatform().getConversionManager().convertObject(object, this.getDescriptor().getObjectBuilder().getFieldClassification(databaseField));
            }
            catch (ConversionException conversionException) {
                throw ConversionException.couldNotBeConverted((Object)this, this.getDescriptor(), conversionException);
            }
            vector.addElement(object);
        }
        return vector;
    }

    protected Vector extractKeyFromReferenceObject(Object object, AbstractSession abstractSession) {
        Vector<Object> vector = new Vector<Object>();
        for (DatabaseField databaseField : this.getSourceToTargetKeyFields().keySet()) {
            if (object == null) {
                vector.addElement(null);
                continue;
            }
            vector.addElement(this.getReferenceDescriptor().getObjectBuilder().extractValueFromObjectForField(object, databaseField, abstractSession));
        }
        return vector;
    }

    public Vector extractPrimaryKeysForReferenceObjectFromRow(AbstractRecord abstractRecord) {
        List<DatabaseField> list = this.getReferenceDescriptor().getPrimaryKeyFields();
        Vector<Object> vector = new Vector<Object>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            DatabaseField databaseField = list.get(i);
            DatabaseField databaseField2 = (DatabaseField)this.getTargetToSourceKeyFields().get(databaseField);
            if (databaseField2 == null) {
                return new Vector(1);
            }
            vector.addElement(abstractRecord.get(databaseField2));
        }
        return vector;
    }

    public void initialize(AbstractSession abstractSession) throws DescriptorException {
        super.initialize(abstractSession);
        Vector<DatabaseField> vector = this.getForeignKeyFields();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            DatabaseField databaseField = (DatabaseField)vector.get(i);
            databaseField = this.getDescriptor().buildField(databaseField);
            vector.set(i, databaseField);
        }
        this.initializeForeignKeys(abstractSession);
        if (this.shouldInitializeSelectionCriteria()) {
            this.initializeSelectionCriteria(abstractSession);
        } else {
            this.setShouldVerifyDelete(false);
        }
        this.setFields(this.collectFields());
    }

    protected void initializeForeignKeys(AbstractSession abstractSession) {
        HashMap<DatabaseField, DatabaseField> hashMap = new HashMap<DatabaseField, DatabaseField>(this.getSourceToTargetKeyFields().size());
        HashMap<DatabaseField, DatabaseField> hashMap2 = new HashMap<DatabaseField, DatabaseField>(this.getTargetToSourceKeyFields().size());
        for (Map.Entry entry : this.getSourceToTargetKeyFields().entrySet()) {
            DatabaseField databaseField = (DatabaseField)entry.getKey();
            DatabaseField databaseField2 = (DatabaseField)entry.getValue();
            databaseField = this.getDescriptor().buildField(databaseField);
            databaseField2 = this.getReferenceDescriptor().buildField(databaseField2);
            hashMap.put(databaseField, databaseField2);
            hashMap2.put(databaseField2, databaseField);
        }
        this.setSourceToTargetKeyFields(hashMap);
        this.setTargetToSourceKeyFields(hashMap2);
    }

    protected void initializeSelectionCriteria(AbstractSession abstractSession) {
        if (this.getSourceToTargetKeyFields().isEmpty()) {
            throw DescriptorException.noForeignKeysAreSpecified(this);
        }
        ExpressionBuilder expressionBuilder = new ExpressionBuilder();
        for (DatabaseField databaseField : this.getSourceToTargetKeyFields().keySet()) {
            DatabaseField databaseField2 = (DatabaseField)this.getSourceToTargetKeyFields().get(databaseField);
            Expression expression = ((Expression)expressionBuilder).getField(databaseField2).equal(expressionBuilder.getParameter(databaseField));
            Expression expression2 = expression.and(this.getSelectionCriteria());
            this.setSelectionCriteria(expression2);
        }
    }

    protected Object readPrivateOwnedForObject(ObjectLevelModifyQuery objectLevelModifyQuery) throws DatabaseException {
        if (objectLevelModifyQuery.getSession().isUnitOfWork()) {
            return this.getRealAttributeValueFromObject(objectLevelModifyQuery.getBackupClone(), objectLevelModifyQuery.getSession());
        }
        if (!this.shouldVerifyDelete()) {
            return null;
        }
        ReadObjectQuery readObjectQuery = (ReadObjectQuery)this.getSelectionQuery().clone();
        readObjectQuery.setSelectionCriteria(this.getPrivateOwnedCriteria());
        return objectLevelModifyQuery.getSession().executeQuery((DatabaseQuery)readObjectQuery, objectLevelModifyQuery.getTranslationRow());
    }

    protected void initializePrivateOwnedCriteria() {
        if (!this.isForeignKeyRelationship()) {
            this.setPrivateOwnedCriteria(this.getSelectionCriteria());
        } else {
            Expression expression = this.getDescriptor().getObjectBuilder().getPrimaryKeyExpression();
            ExpressionBuilder expressionBuilder = new ExpressionBuilder();
            Expression expression2 = expressionBuilder.getManualQueryKey(this.getAttributeName() + "-back-ref", this.getDescriptor());
            Expression expression3 = expression.rebuildOn(expression2);
            Expression expression4 = expression2.twist(this.getSelectionCriteria(), expressionBuilder);
            if (this.getDescriptor().getQueryManager().getAdditionalJoinExpression() != null) {
                Expression expression5 = this.getDescriptor().getQueryManager().getAdditionalJoinExpression().rebuildOn(expression2);
                expression4 = expression4 == null ? expression5 : expression4.and(expression5);
            }
            this.setPrivateOwnedCriteria(expression3.and(expression4));
        }
    }

    public Object valueFromRow(AbstractRecord abstractRecord, JoinedAttributeManager joinedAttributeManager, ObjectBuildingQuery objectBuildingQuery, AbstractSession abstractSession) throws DatabaseException {
        Object object;
        if (!objectBuildingQuery.hasPartialAttributeExpressions()) {
            object = this.getFields().elements();
            while (object.hasMoreElements()) {
                DatabaseField databaseField = (DatabaseField)object.nextElement();
                if (abstractRecord.get(databaseField) != null) continue;
                return this.getIndirectionPolicy().nullValueFromRow();
            }
        }
        if (((DatabaseQuery)(object = this.getSelectionQuery())).isObjectLevelReadQuery() && (objectBuildingQuery.shouldCascadeAllParts() || objectBuildingQuery.shouldCascadePrivateParts() && this.isPrivateOwned() || objectBuildingQuery.shouldCascadeByMapping() && this.cascadeRefresh)) {
            object = (ObjectLevelReadQuery)((DatabaseQuery)object).clone();
            ((ObjectLevelReadQuery)object).setShouldRefreshIdentityMapResult(objectBuildingQuery.shouldRefreshIdentityMapResult());
            ((DatabaseQuery)object).setCascadePolicy(objectBuildingQuery.getCascadePolicy());
            ((ReadQuery)object).setQueryId(objectBuildingQuery.getQueryId());
            if (((DatabaseQuery)object).shouldMaintainCache()) {
                ((DatabaseQuery)object).setShouldMaintainCache(objectBuildingQuery.shouldMaintainCache());
            }
        }
        return this.getIndirectionPolicy().valueFromQuery((ReadQuery)object, abstractRecord, objectBuildingQuery.getSession());
    }

    public void writeFromObjectIntoRow(Object object, AbstractRecord abstractRecord, AbstractSession abstractSession) {
        if (this.isReadOnly() || !this.isForeignKeyRelationship()) {
            return;
        }
        AbstractRecord abstractRecord2 = this.getIndirectionPolicy().extractReferenceRow(this.getAttributeValueFromObject(object));
        if (abstractRecord2 == null) {
            Object object2 = this.getRealAttributeValueFromObject(object, abstractSession);
            for (int i = 0; i < this.getForeignKeyFields().size(); ++i) {
                DatabaseField databaseField = this.getForeignKeyFields().get(i);
                DatabaseField databaseField2 = (DatabaseField)this.getSourceToTargetKeyFields().get(databaseField);
                Object object3 = null;
                if (object2 != null) {
                    object3 = this.getReferenceDescriptor().getObjectBuilder().extractValueFromObjectForField(object2, databaseField2, abstractSession);
                }
                abstractRecord.add(databaseField, object3);
            }
        } else {
            for (int i = 0; i < this.getForeignKeyFields().size(); ++i) {
                DatabaseField databaseField = this.getForeignKeyFields().get(i);
                abstractRecord.add(databaseField, abstractRecord2.get(databaseField));
            }
        }
    }

    public Class getFieldClassification(DatabaseField databaseField) throws DescriptorException {
        DatabaseField databaseField2 = (DatabaseField)this.getSourceToTargetKeyFields().get(databaseField);
        if (databaseField2 == null) {
            return null;
        }
        DatabaseMapping databaseMapping = this.getReferenceDescriptor().getObjectBuilder().getMappingForField(databaseField2);
        if (databaseMapping == null) {
            return null;
        }
        return databaseMapping.getFieldClassification(databaseField2);
    }

    public Expression getPrivateOwnedCriteria() {
        if (this.privateOwnedCriteria == null) {
            this.initializePrivateOwnedCriteria();
        }
        return this.privateOwnedCriteria;
    }

    protected void setPrivateOwnedCriteria(Expression expression) {
        this.privateOwnedCriteria = expression;
    }

    public void setShouldVerifyDelete(boolean bl) {
        this.shouldVerifyDelete = bl;
    }

    public boolean shouldVerifyDelete() {
        return this.shouldVerifyDelete;
    }

    public Map getSourceToTargetKeyFields() {
        return this.sourceToTargetKeyFields;
    }

    public Map getTargetToSourceKeyFields() {
        return this.targetToSourceKeyFields;
    }

    public void setSourceToTargetKeyFields(Map map) {
        this.sourceToTargetKeyFields = map;
    }

    public void setTargetToSourceKeyFields(Map map) {
        this.targetToSourceKeyFields = map;
    }

    public void setSelectionSQLString(String string) {
        throw DescriptorException.invalidMappingOperation(this, "setSelectionSQLString");
    }

    public void setUsesBatchReading(boolean bl) {
        throw DescriptorException.invalidMappingOperation(this, "setUsesBatchReading");
    }

    public boolean shouldUseBatchReading() {
        throw DescriptorException.invalidMappingOperation(this, "shouldUseBatchReading");
    }

    public void useBatchReading() {
        throw DescriptorException.invalidMappingOperation(this, "useBatchReading");
    }

    public void dontUseBatchReading() {
        throw DescriptorException.invalidMappingOperation(this, "dontUseBatchReading");
    }

    public void addAscendingOrdering(String string) {
        throw DescriptorException.invalidMappingOperation(this, "addAscendingOrdering");
    }

    public void addDescendingOrdering(String string) {
        throw DescriptorException.invalidMappingOperation(this, "addDescendingOrdering");
    }
}

