/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.expressions;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.history.AsOfClause;
import org.eclipse.persistence.internal.expressions.BaseExpression;
import org.eclipse.persistence.internal.expressions.ExpressionIterator;
import org.eclipse.persistence.internal.expressions.ExpressionNormalizer;
import org.eclipse.persistence.internal.expressions.ExpressionSQLPrinter;
import org.eclipse.persistence.internal.expressions.FieldExpression;
import org.eclipse.persistence.internal.expressions.TableAliasLookup;
import org.eclipse.persistence.internal.expressions.TableExpression;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.history.DecoratedDatabaseTable;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.querykeys.QueryKey;

public abstract class DataExpression
extends BaseExpression {
    protected Vector derivedTables;
    protected Vector derivedFields;
    protected boolean hasBeenNormalized = false;
    protected TableAliasLookup tableAliases;
    protected AsOfClause asOfClause;

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        DataExpression dataExpression = (DataExpression)object;
        return (this.getBaseExpression() == dataExpression.getBaseExpression() || this.getBaseExpression() != null && this.getBaseExpression().equals(dataExpression.getBaseExpression())) && (this.getAsOfClause() == dataExpression.getAsOfClause() || this.getAsOfClause() != null && this.getAsOfClause().equals(dataExpression.getAsOfClause()));
    }

    public void addDerivedField(Expression expression) {
        if (this.derivedFields == null) {
            this.derivedFields = NonSynchronizedVector.newInstance(4);
        }
        this.derivedFields.addElement(expression);
    }

    public void addDerivedTable(Expression expression) {
        if (this.derivedTables == null) {
            this.derivedTables = NonSynchronizedVector.newInstance(4);
        }
        this.derivedTables.addElement(expression);
    }

    public Expression asOf(AsOfClause asOfClause) {
        this.asOfClause = asOfClause;
        return this;
    }

    public DatabaseTable aliasForTable(DatabaseTable databaseTable) {
        if (this.tableAliases == null) {
            if (this.getBaseExpression() == null) {
                return null;
            }
            return this.getBaseExpression().aliasForTable(databaseTable);
        }
        return this.tableAliases.keyAtValue(databaseTable);
    }

    protected void assignAlias(String string, DatabaseTable databaseTable) {
        if (!this.getBuilder().getSession().getProject().hasGenericHistorySupport()) {
            this.assignAlias(new DecoratedDatabaseTable(string, this.getAsOfClause()), databaseTable);
        } else {
            this.assignAlias(new DatabaseTable(string), databaseTable);
        }
    }

    protected void assignAlias(DatabaseTable databaseTable, DatabaseTable databaseTable2) {
        if (this.tableAliases == null) {
            this.tableAliases = new TableAliasLookup();
        }
        this.tableAliases.put(databaseTable, databaseTable2);
    }

    public void clearAliases() {
        this.tableAliases = null;
    }

    public Vector copyCollection(Vector vector, Map map) {
        if (vector == null) {
            return null;
        }
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance(vector.size());
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Expression expression = (Expression)enumeration.nextElement();
            ((Vector)nonSynchronizedVector).addElement(expression.copiedVersionFrom(map));
        }
        return nonSynchronizedVector;
    }

    public Expression existingDerivedField(DatabaseField databaseField) {
        if (this.derivedFields == null) {
            return null;
        }
        Enumeration enumeration = this.derivedFields.elements();
        while (enumeration.hasMoreElements()) {
            FieldExpression fieldExpression = (FieldExpression)enumeration.nextElement();
            if (!fieldExpression.getField().equals(databaseField)) continue;
            return fieldExpression;
        }
        return null;
    }

    public Expression existingDerivedTable(DatabaseTable databaseTable) {
        if (this.derivedTables == null) {
            return null;
        }
        Enumeration enumeration = this.derivedTables.elements();
        while (enumeration.hasMoreElements()) {
            TableExpression tableExpression = (TableExpression)enumeration.nextElement();
            if (!tableExpression.getTable().equals(databaseTable)) continue;
            return tableExpression;
        }
        return null;
    }

    public DatabaseField getAliasedField() {
        return null;
    }

    public AsOfClause getAsOfClause() {
        return this.asOfClause;
    }

    public ClassDescriptor getDescriptor() {
        return null;
    }

    public DatabaseField getField() {
        return null;
    }

    public Expression getField(String string) {
        DatabaseField databaseField = new DatabaseField(string);
        return this.getField(databaseField);
    }

    public Expression getField(DatabaseField databaseField) {
        Expression expression = this.existingDerivedField(databaseField);
        if (expression != null) {
            return expression;
        }
        return this.newDerivedField(databaseField);
    }

    public DatabaseMapping getMapping() {
        if (this.getBaseExpression() == null) {
            return null;
        }
        ClassDescriptor classDescriptor = ((DataExpression)this.getBaseExpression()).getDescriptor();
        if (classDescriptor == null) {
            return null;
        }
        return classDescriptor.getObjectBuilder().getMappingForAttributeName(this.getName());
    }

    public Vector getOwnedTables() {
        if (this.getDescriptor() == null) {
            return null;
        }
        if (this.getDescriptor().isAggregateDescriptor()) {
            return null;
        }
        if (this.getDescriptor().getHistoryPolicy() != null && this.getAsOfClause().getValue() != null) {
            return this.getDescriptor().getHistoryPolicy().getHistoricalTables();
        }
        return this.getDescriptor().getTables();
    }

    public QueryKey getQueryKeyOrNull() {
        return null;
    }

    public Expression getTable(String string) {
        DatabaseTable databaseTable = new DatabaseTable(string);
        return this.getTable(databaseTable);
    }

    public Expression getTable(DatabaseTable databaseTable) {
        Expression expression = this.existingDerivedTable(databaseTable);
        if (expression != null) {
            return expression;
        }
        return this.newDerivedTable(databaseTable);
    }

    public TableAliasLookup getTableAliases() {
        return this.tableAliases;
    }

    public boolean hasBeenNormalized() {
        return this.hasBeenNormalized;
    }

    public boolean hasAsOfClause() {
        return this.getAsOfClause() != null && this.getAsOfClause().getValue() != null;
    }

    public boolean hasBeenAliased() {
        return this.tableAliases != null && this.tableAliases.size() != 0;
    }

    protected boolean hasDerivedFields() {
        return this.derivedFields != null;
    }

    protected boolean hasDerivedTables() {
        return this.derivedTables != null;
    }

    public boolean isAttribute() {
        return false;
    }

    public boolean isDataExpression() {
        return true;
    }

    public void iterateOn(ExpressionIterator expressionIterator) {
        super.iterateOn(expressionIterator);
        if (this.baseExpression != null) {
            this.baseExpression.iterateOn(expressionIterator);
        }
    }

    public Expression mappingCriteria() {
        return null;
    }

    public Expression newDerivedField(DatabaseField databaseField) {
        FieldExpression fieldExpression = new FieldExpression(databaseField, this);
        this.addDerivedField(fieldExpression);
        return fieldExpression;
    }

    public Expression newDerivedTable(DatabaseTable databaseTable) {
        TableExpression tableExpression = new TableExpression(databaseTable);
        tableExpression.setBaseExpression(this);
        this.addDerivedTable(tableExpression);
        return tableExpression;
    }

    public Expression normalize(ExpressionNormalizer expressionNormalizer) {
        if (this.getBaseExpression() != null) {
            this.setBaseExpression(this.getBaseExpression().normalize(expressionNormalizer));
            if (this.getAsOfClause() == null) {
                this.asOf(this.getBaseExpression().getAsOfClause());
            }
        }
        return super.normalize(expressionNormalizer);
    }

    protected void postCopyIn(Map map) {
        super.postCopyIn(map);
        this.clearAliases();
        this.derivedFields = this.copyCollection(this.derivedFields, map);
        this.derivedTables = this.copyCollection(this.derivedTables, map);
    }

    public void printSQL(ExpressionSQLPrinter expressionSQLPrinter) {
        expressionSQLPrinter.printField(this.getAliasedField());
    }

    public void setHasBeenNormalized(boolean bl) {
        this.hasBeenNormalized = bl;
    }

    public void setTableAliases(TableAliasLookup tableAliasLookup) {
        if (this.tableAliases == null) {
            this.tableAliases = tableAliasLookup;
        }
    }

    public String tableAliasesDescription() {
        if (this.tableAliases == null) {
            return "";
        }
        return this.tableAliases.toString();
    }

    public void writeSubexpressionsTo(BufferedWriter bufferedWriter, int n) throws IOException {
        if (this.getBaseExpression() != null) {
            this.getBaseExpression().toString(bufferedWriter, n);
        }
    }
}

