/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.indirection;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.indirection.ValueHolderInterface;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedGetClassLoaderForClass;
import org.eclipse.persistence.internal.security.PrivilegedMethodInvoker;

public class ProxyIndirectionHandler
implements InvocationHandler,
Serializable {
    private ValueHolderInterface valueHolder;

    public ProxyIndirectionHandler() {
    }

    private ProxyIndirectionHandler(ValueHolderInterface valueHolderInterface) {
        this.valueHolder = valueHolderInterface;
    }

    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        Object object2 = null;
        try {
            if (method.getName().equals("toString")) {
                if (this.valueHolder.isInstantiated()) {
                    if (this.valueHolder.getValue() == null) {
                        object2 = "null";
                    } else if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                        String string = (String)AccessController.doPrivileged(new PrivilegedMethodInvoker(method, this.valueHolder.getValue(), objectArray));
                        object2 = "{ " + string + " }";
                    } else {
                        String string = (String)PrivilegedAccessHelper.invokeMethod(method, this.valueHolder.getValue(), objectArray);
                        object2 = "{ " + string + " }";
                    }
                } else {
                    object2 = "{ IndirectProxy: not instantiated }";
                }
            } else if (method.getName().equals("equals") && this.valueHolder.getValue() == null && objectArray[0] == null) {
                object2 = Boolean.TRUE;
            } else {
                Object object3 = this.valueHolder.getValue();
                if (object3 == null) {
                    throw ValidationException.nullUnderlyingValueHolderValue(method.getName());
                }
                object2 = PrivilegedAccessHelper.shouldUsePrivilegedAccess() ? AccessController.doPrivileged(new PrivilegedMethodInvoker(method, object3, objectArray)) : PrivilegedAccessHelper.invokeMethod(method, object3, objectArray);
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException.getTargetException();
        }
        catch (ValidationException validationException) {
            throw validationException;
        }
        catch (Exception exception) {
            throw QueryException.unexpectedInvocation(exception.getMessage());
        }
        return object2;
    }

    public static Object newProxyInstance(Class clazz, Class[] classArray, ValueHolderInterface valueHolderInterface) {
        ClassLoader classLoader = null;
        if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
            try {
                classLoader = (ClassLoader)AccessController.doPrivileged(new PrivilegedGetClassLoaderForClass(clazz));
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (RuntimeException)privilegedActionException.getCause();
            }
        } else {
            classLoader = PrivilegedAccessHelper.getClassLoaderForClass(clazz);
        }
        return Proxy.newProxyInstance(classLoader, classArray, (InvocationHandler)new ProxyIndirectionHandler(valueHolderInterface));
    }

    public ValueHolderInterface getValueHolder() {
        return this.valueHolder;
    }

    public void setValueHolder(ValueHolderInterface valueHolderInterface) {
        this.valueHolder = valueHolderInterface;
    }
}

