/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.parsing;

import java.util.Vector;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.expressions.ConstantExpression;
import org.eclipse.persistence.internal.jpa.parsing.GenerationContext;
import org.eclipse.persistence.internal.jpa.parsing.Node;
import org.eclipse.persistence.internal.jpa.parsing.ParseTreeContext;
import org.eclipse.persistence.internal.jpa.parsing.SubqueryNode;
import org.eclipse.persistence.internal.jpa.parsing.TypeHelper;
import org.eclipse.persistence.internal.queries.ReportItem;
import org.eclipse.persistence.queries.ReportQuery;

public class ExistsNode
extends Node {
    private boolean notIndicated = false;

    public void validate(ParseTreeContext parseTreeContext) {
        if (this.left != null) {
            SubqueryNode subqueryNode = (SubqueryNode)this.getLeft();
            subqueryNode.validate(parseTreeContext);
            TypeHelper typeHelper = parseTreeContext.getTypeHelper();
            this.setType(typeHelper.getBooleanType());
        }
    }

    public Expression generateExpression(GenerationContext generationContext) {
        Cloneable cloneable2;
        SubqueryNode subqueryNode = (SubqueryNode)this.getLeft();
        ReportQuery reportQuery = subqueryNode.getReportQuery(generationContext);
        Vector vector = reportQuery.getItems();
        for (Cloneable cloneable2 : vector) {
            Expression expression = ((ReportItem)cloneable2).getAttributeExpression();
            reportQuery.addNonFetchJoinedAttribute(expression);
        }
        reportQuery.clearItems();
        ConstantExpression constantExpression = new ConstantExpression(new Integer(1), new ExpressionBuilder());
        reportQuery.addItem("one", constantExpression);
        reportQuery.dontUseDistinct();
        cloneable2 = generationContext.getBaseExpression();
        return this.notIndicated() ? ((Expression)cloneable2).notExists(reportQuery) : ((Expression)cloneable2).exists(reportQuery);
    }

    public void indicateNot() {
        this.notIndicated = true;
    }

    public boolean notIndicated() {
        return this.notIndicated;
    }
}

