/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.queries;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.internal.databaseaccess.DatabaseCall;
import org.eclipse.persistence.internal.databaseaccess.DatasourceCall;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.queries.DatabaseQueryMechanism;
import org.eclipse.persistence.internal.queries.ReportItem;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.DeleteAllQuery;
import org.eclipse.persistence.queries.ReportQuery;
import org.eclipse.persistence.queries.UpdateAllQuery;
import org.eclipse.persistence.queries.WriteObjectQuery;

public class DatasourceCallQueryMechanism
extends DatabaseQueryMechanism {
    protected DatasourceCall call;
    protected Vector calls;

    public DatasourceCallQueryMechanism(DatabaseQuery databaseQuery) {
        super(databaseQuery);
    }

    public DatasourceCallQueryMechanism(DatabaseQuery databaseQuery, DatasourceCall datasourceCall) {
        super(databaseQuery);
        this.call = datasourceCall;
        datasourceCall.setQuery(databaseQuery);
    }

    public void addCall(DatasourceCall datasourceCall) {
        this.getCalls().addElement(datasourceCall);
        datasourceCall.setQuery(this.getQuery());
    }

    public DatabaseCall cursorSelectAllRows() throws DatabaseException {
        try {
            return (DatabaseCall)this.executeCall();
        }
        catch (ClassCastException classCastException) {
            throw QueryException.mustUseCursorStreamPolicy();
        }
    }

    public Integer deleteAll() throws DatabaseException {
        if (((DeleteAllQuery)this.getQuery()).isPreparedUsingTempStorage()) {
            return this.deleteAllUsingTempTables();
        }
        if (this.hasMultipleCalls()) {
            Integer n = null;
            for (int i = this.getCalls().size() - 1; i >= 0; --i) {
                DatasourceCall datasourceCall = (DatasourceCall)this.getCalls().elementAt(i);
                n = (Integer)this.executeCall(datasourceCall);
            }
            return n;
        }
        return (Integer)this.executeCall();
    }

    public Integer deleteAllUsingTempTables() throws DatabaseException {
        DatasourceCall datasourceCall;
        DatabaseException databaseException = null;
        Integer n = null;
        try {
            datasourceCall = (DatasourceCall)this.getCalls().elementAt(this.getCalls().size() - 1);
            this.executeCall(datasourceCall);
        }
        catch (DatabaseException databaseException2) {
            // empty catch block
        }
        if (databaseException == null) {
            try {
                datasourceCall = (DatasourceCall)this.getCalls().elementAt(this.getCalls().size() - 2);
                this.executeCall(datasourceCall);
            }
            catch (DatabaseException databaseException3) {
                databaseException = databaseException3;
            }
        }
        for (int i = this.getCalls().size() - 3; i >= 1 && databaseException == null; --i) {
            DatasourceCall datasourceCall2 = (DatasourceCall)this.getCalls().elementAt(i);
            try {
                n = (Integer)this.executeCall(datasourceCall2);
                continue;
            }
            catch (DatabaseException databaseException4) {
                databaseException = databaseException4;
            }
        }
        try {
            DatasourceCall datasourceCall3 = (DatasourceCall)this.getCalls().elementAt(0);
            this.executeCall(datasourceCall3);
        }
        catch (DatabaseException databaseException5) {
            // empty catch block
        }
        if (databaseException != null) {
            throw databaseException;
        }
        return n;
    }

    public Integer deleteObject() throws DatabaseException {
        if (this.hasMultipleCalls()) {
            Integer n = null;
            for (int i = this.getCalls().size() - 1; i >= 0; --i) {
                DatasourceCall datasourceCall = (DatasourceCall)this.getCalls().elementAt(i);
                Integer n2 = (Integer)this.executeCall(datasourceCall);
                if (i != this.getCalls().size() - 1 && n2 > 0) continue;
                n = n2;
            }
            return n;
        }
        return (Integer)this.executeCall();
    }

    protected Object executeCall() throws DatabaseException {
        return this.executeCall(this.getCall());
    }

    protected Object executeCall(DatasourceCall datasourceCall) throws DatabaseException {
        AbstractSession abstractSession = this.getQuery().getExecutionSession();
        DatasourceCall datasourceCall2 = (DatasourceCall)datasourceCall.clone();
        datasourceCall2.setQuery(this.getQuery());
        datasourceCall2.translate(this.getTranslationRow(), this.getModifyRow(), abstractSession);
        return abstractSession.executeCall(datasourceCall2, this.getTranslationRow(), this.getQuery());
    }

    public Integer executeNoSelect() throws DatabaseException {
        return this.executeNoSelectCall();
    }

    public Integer executeNoSelectCall() throws DatabaseException {
        if (this.hasMultipleCalls()) {
            Integer n = null;
            for (int i = 0; i < this.getCalls().size(); ++i) {
                DatasourceCall datasourceCall = (DatasourceCall)this.getCalls().elementAt(i);
                Integer n2 = (Integer)this.executeCall(datasourceCall);
                if (i != 0 && n2 > 0) continue;
                n = n2;
            }
            return n;
        }
        return (Integer)this.executeCall();
    }

    public Vector executeSelect() throws DatabaseException {
        return this.executeSelectCall();
    }

    public Vector executeSelectCall() throws DatabaseException {
        if (this.hasMultipleCalls()) {
            Vector vector = new Vector();
            Enumeration enumeration = this.getCalls().elements();
            while (enumeration.hasMoreElements()) {
                DatasourceCall datasourceCall = (DatasourceCall)enumeration.nextElement();
                Helper.addAllToVector(vector, (Vector)this.executeCall(datasourceCall));
            }
            return vector;
        }
        return (Vector)this.executeCall();
    }

    public DatasourceCall getCall() {
        return this.call;
    }

    public Vector getCalls() {
        if (this.calls == null) {
            this.calls = NonSynchronizedVector.newInstance(3);
        }
        return this.calls;
    }

    public boolean hasMultipleCalls() {
        return this.calls != null && !this.calls.isEmpty();
    }

    public void insertObject() throws DatabaseException {
        ClassDescriptor classDescriptor = this.getDescriptor();
        boolean bl = classDescriptor.usesSequenceNumbers();
        boolean bl2 = false;
        if (bl) {
            bl2 = classDescriptor.getSequence().shouldAcquireValueAfterInsert();
        }
        Collection collection = null;
        if (classDescriptor.hasReturningPolicy()) {
            collection = classDescriptor.getReturningPolicy().getFieldsToMergeInsert();
        }
        if (bl && !bl2 && this.getWriteObjectQuery().getObjectChangeSet() == null) {
            this.updateObjectAndRowWithSequenceNumber();
        }
        if (this.hasMultipleCalls()) {
            int n = this.getCalls().size();
            for (int i = 0; i < n; ++i) {
                DatasourceCall datasourceCall = (DatasourceCall)this.getCalls().get(i);
                this.executeCall(datasourceCall);
                if (collection != null) {
                    this.updateObjectAndRowWithReturnRow(collection, i == 0);
                }
                if (i != 0 || !bl || !bl2) continue;
                this.updateObjectAndRowWithSequenceNumber();
            }
        } else {
            this.executeCall();
            if (collection != null) {
                this.updateObjectAndRowWithReturnRow(collection, true);
            }
            if (bl && bl2) {
                this.updateObjectAndRowWithSequenceNumber();
            }
        }
        AbstractSession abstractSession = this.getQuery().getExecutionSession();
        abstractSession.getAccessor().flushSelectCalls(abstractSession);
    }

    public boolean isCallQueryMechanism() {
        return true;
    }

    public void prepare() {
        if (!this.hasMultipleCalls() && this.getCall() == null) {
            throw QueryException.sqlStatementNotSetProperly(this.getQuery());
        }
    }

    public void prepareCall() throws QueryException {
        DatabaseQuery databaseQuery = this.getQuery();
        AbstractSession abstractSession = databaseQuery.getExecutionSession();
        if (this.hasMultipleCalls()) {
            Enumeration enumeration = this.getCalls().elements();
            while (enumeration.hasMoreElements()) {
                DatasourceCall datasourceCall = (DatasourceCall)enumeration.nextElement();
                datasourceCall.prepare(abstractSession);
            }
        } else if (this.getCall() != null) {
            this.getCall().prepare(abstractSession);
        }
    }

    public void prepareCursorSelectAllRows() throws QueryException {
        this.getCall().returnCursor();
        this.prepareCall();
    }

    public void prepareDeleteAll() {
        if (this.hasMultipleCalls()) {
            Enumeration enumeration = this.getCalls().elements();
            while (enumeration.hasMoreElements()) {
                DatasourceCall datasourceCall = (DatasourceCall)enumeration.nextElement();
                datasourceCall.returnNothing();
            }
        } else {
            this.getCall().returnNothing();
        }
        this.prepareCall();
    }

    public void prepareDeleteObject() {
        if (this.hasMultipleCalls()) {
            Enumeration enumeration = this.getCalls().elements();
            while (enumeration.hasMoreElements()) {
                DatasourceCall datasourceCall = (DatasourceCall)enumeration.nextElement();
                datasourceCall.returnNothing();
            }
        } else {
            this.getCall().returnNothing();
        }
        this.prepareCall();
    }

    public void prepareDoesExist(DatabaseField databaseField) {
        if (this.hasMultipleCalls()) {
            Enumeration enumeration = this.getCalls().elements();
            while (enumeration.hasMoreElements()) {
                ((DatasourceCall)enumeration.nextElement()).returnOneRow();
            }
        } else {
            this.getCall().returnOneRow();
        }
        this.prepareCall();
    }

    public void prepareExecuteNoSelect() {
        if (this.hasMultipleCalls()) {
            Enumeration enumeration = this.getCalls().elements();
            while (enumeration.hasMoreElements()) {
                ((DatasourceCall)enumeration.nextElement()).returnNothing();
            }
        } else {
            this.getCall().returnNothing();
        }
        this.prepareCall();
    }

    public void prepareExecuteSelect() {
        if (this.hasMultipleCalls()) {
            Enumeration enumeration = this.getCalls().elements();
            while (enumeration.hasMoreElements()) {
                DatasourceCall datasourceCall = (DatasourceCall)enumeration.nextElement();
                datasourceCall.returnManyRows();
            }
        } else {
            this.getCall().returnManyRows();
        }
        this.prepareCall();
    }

    public void prepareInsertObject() {
        if (this.hasMultipleCalls()) {
            Enumeration enumeration = this.getCalls().elements();
            while (enumeration.hasMoreElements()) {
                ((DatasourceCall)enumeration.nextElement()).returnNothing();
            }
        } else {
            this.getCall().returnNothing();
        }
        this.prepareCall();
    }

    protected void prepareReportQueryItems() {
        int n = 0;
        for (ReportItem reportItem : ((ReportQuery)this.getQuery()).getItems()) {
            reportItem.setResultIndex(n);
            if (reportItem.getAttributeExpression() == null) continue;
            if (reportItem.hasJoining()) {
                n = reportItem.getJoinedAttributeManager().computeJoiningMappingIndexes(true, this.getSession(), n);
                continue;
            }
            if (reportItem.getDescriptor() != null) {
                n += reportItem.getDescriptor().getAllFields().size();
                continue;
            }
            ++n;
        }
    }

    public void prepareReportQuerySelectAllRows() {
        this.prepareReportQueryItems();
        this.prepareExecuteSelect();
    }

    public void prepareReportQuerySubSelect() {
        this.prepareReportQueryItems();
        this.prepareCall();
    }

    public void prepareSelectAllRows() {
        if (this.hasMultipleCalls()) {
            Enumeration enumeration = this.getCalls().elements();
            while (enumeration.hasMoreElements()) {
                DatasourceCall datasourceCall = (DatasourceCall)enumeration.nextElement();
                datasourceCall.returnManyRows();
            }
        } else {
            this.getCall().returnManyRows();
        }
        this.prepareCall();
    }

    public void prepareSelectOneRow() {
        if (this.hasMultipleCalls()) {
            Enumeration enumeration = this.getCalls().elements();
            while (enumeration.hasMoreElements()) {
                DatasourceCall datasourceCall = (DatasourceCall)enumeration.nextElement();
                datasourceCall.returnOneRow();
            }
        } else {
            this.getCall().returnOneRow();
        }
        this.prepareCall();
    }

    public void prepareUpdateObject() {
        if (this.hasMultipleCalls()) {
            Enumeration enumeration = this.getCalls().elements();
            while (enumeration.hasMoreElements()) {
                DatasourceCall datasourceCall = (DatasourceCall)enumeration.nextElement();
                datasourceCall.returnNothing();
            }
        } else if (this.getCall() != null) {
            this.getCall().returnNothing();
        }
        this.prepareCall();
    }

    public void prepareUpdateAll() {
        if (this.getCall() != null) {
            this.getCall().returnNothing();
        }
        this.prepareCall();
    }

    public Vector selectAllReportQueryRows() throws DatabaseException {
        return this.executeSelect();
    }

    public Vector selectAllRows() throws DatabaseException {
        return this.executeSelectCall();
    }

    public AbstractRecord selectOneRow() throws DatabaseException {
        if (this.hasMultipleCalls()) {
            Enumeration enumeration = this.getCalls().elements();
            while (enumeration.hasMoreElements()) {
                DatasourceCall datasourceCall = (DatasourceCall)enumeration.nextElement();
                AbstractRecord abstractRecord = (AbstractRecord)this.executeCall(datasourceCall);
                if (abstractRecord == null) continue;
                return abstractRecord;
            }
            return null;
        }
        return (AbstractRecord)this.executeCall();
    }

    public AbstractRecord selectRowForDoesExist(DatabaseField databaseField) throws DatabaseException {
        if (this.hasMultipleCalls()) {
            Enumeration enumeration = this.getCalls().elements();
            while (enumeration.hasMoreElements()) {
                DatasourceCall datasourceCall = (DatasourceCall)enumeration.nextElement();
                AbstractRecord abstractRecord = (AbstractRecord)this.executeCall(datasourceCall);
                if (abstractRecord == null) continue;
                return abstractRecord;
            }
            return null;
        }
        return (AbstractRecord)this.executeCall();
    }

    public void setCall(DatasourceCall datasourceCall) {
        this.call = datasourceCall;
        if (datasourceCall != null) {
            datasourceCall.setQuery(this.getQuery());
        }
    }

    protected void setCalls(Vector vector) {
        this.calls = vector;
    }

    public Integer updateObject() throws DatabaseException {
        Collection collection = null;
        if (this.getDescriptor().hasReturningPolicy()) {
            collection = this.getDescriptor().getReturningPolicy().getFieldsToMergeUpdate();
        }
        Integer n = null;
        if (this.hasMultipleCalls()) {
            for (int i = 0; i < this.getCalls().size(); ++i) {
                DatasourceCall datasourceCall = (DatasourceCall)this.getCalls().elementAt(i);
                Integer n2 = (Integer)this.executeCall(datasourceCall);
                if (i == 0 || n2 <= 0) {
                    n = n2;
                }
                if (collection == null) continue;
                this.updateObjectAndRowWithReturnRow(collection, false);
            }
        } else {
            n = (Integer)this.executeCall();
            if (collection != null) {
                this.updateObjectAndRowWithReturnRow(collection, false);
            }
        }
        AbstractSession abstractSession = this.getQuery().getExecutionSession();
        abstractSession.getAccessor().flushSelectCalls(abstractSession);
        return n;
    }

    public Integer updateAll() throws DatabaseException {
        if (((UpdateAllQuery)this.getQuery()).isPreparedUsingTempStorage() && this.getSession().getPlatform().supportsTempTables()) {
            return this.updateAllUsingTempTables();
        }
        Integer n = this.executeNoSelectCall();
        if (((UpdateAllQuery)this.getQuery()).isPreparedUsingTempStorage()) {
            AbstractRecord abstractRecord = (AbstractRecord)this.getQuery().getProperty("output");
            n = (Integer)abstractRecord.get("ROW_COUNT");
        }
        return n;
    }

    public Integer updateAllUsingTempTables() throws DatabaseException {
        DatasourceCall datasourceCall;
        int n;
        int n2 = this.getCalls().size() / 4;
        DatabaseException databaseException = null;
        Integer n3 = null;
        for (n = 0; n < n2; ++n) {
            try {
                datasourceCall = (DatasourceCall)this.getCalls().elementAt(n);
                this.executeCall(datasourceCall);
                continue;
            }
            catch (DatabaseException databaseException2) {
                // empty catch block
            }
        }
        for (n = n2; n < n2 * 2 && databaseException == null; ++n) {
            try {
                datasourceCall = (DatasourceCall)this.getCalls().elementAt(n);
                this.executeCall(datasourceCall);
                continue;
            }
            catch (DatabaseException databaseException3) {
                databaseException = databaseException3;
            }
        }
        for (n = n2 * 2; n < n2 * 3 && databaseException == null; ++n) {
            try {
                datasourceCall = (DatasourceCall)this.getCalls().elementAt(n);
                Integer n4 = (Integer)this.executeCall(datasourceCall);
                if (n != n2 * 2 && n4 > 0) continue;
                n3 = n4;
                continue;
            }
            catch (DatabaseException databaseException4) {
                databaseException = databaseException4;
            }
        }
        for (n = n2 * 3; n < n2 * 4; ++n) {
            try {
                datasourceCall = (DatasourceCall)this.getCalls().elementAt(n);
                this.executeCall(datasourceCall);
                continue;
            }
            catch (DatabaseException databaseException5) {
                // empty catch block
            }
        }
        if (databaseException != null) {
            throw databaseException;
        }
        return n3;
    }

    protected void updateForeignKeyFieldAfterInsert(WriteObjectQuery writeObjectQuery) {
        writeObjectQuery.setModifyRow(this.getDescriptor().getObjectBuilder().buildRow(writeObjectQuery.getObject(), this.getSession()));
        AbstractSession abstractSession = this.getQuery().getExecutionSession();
        Vector vector = ((DatasourceCallQueryMechanism)this.getDescriptor().getQueryManager().getUpdateQuery().getQueryMechanism()).getCalls();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            DatasourceCall datasourceCall = (DatasourceCall)((DatasourceCall)enumeration.nextElement()).clone();
            datasourceCall.setQuery(writeObjectQuery);
            abstractSession.executeCall(datasourceCall, this.getTranslationRow(), writeObjectQuery);
        }
    }
}

