/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.weaving;

import org.eclipse.persistence.internal.libraries.asm.Type;
import org.eclipse.persistence.mappings.DatabaseMapping;

public class AttributeDetails {
    protected String attributeName;
    protected String referenceClassName;
    protected Type referenceClassType;
    protected boolean weaveValueHolders = false;
    protected boolean weaveTransientFieldValueHolders;
    protected DatabaseMapping mapping;
    protected String getterMethodName;
    protected String setterMethodName;
    protected boolean attributeOnSuperClass = false;
    protected boolean hasField = false;
    protected Type declaringType;
    protected String setMethodSignature;

    public AttributeDetails(String string, DatabaseMapping databaseMapping) {
        this.attributeName = string;
        this.mapping = databaseMapping;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public DatabaseMapping getMapping() {
        return this.mapping;
    }

    public String getGetterMethodName() {
        return this.getterMethodName;
    }

    public String getSetterMethodSignature() {
        if (this.setMethodSignature == null) {
            this.setMethodSignature = "(" + this.getReferenceClassType().getDescriptor() + ")V";
        }
        return this.setMethodSignature;
    }

    public String getSetterMethodName() {
        return this.setterMethodName;
    }

    public String getReferenceClassName() {
        return this.referenceClassName;
    }

    public void setReferenceClassName(String string) {
        this.referenceClassName = string;
    }

    public Type getDeclaringType() {
        return this.declaringType;
    }

    public void setDeclaringType(Type type) {
        this.declaringType = type;
    }

    public Type getReferenceClassType() {
        return this.referenceClassType;
    }

    public void setReferenceClassType(Type type) {
        this.referenceClassType = type;
    }

    public void setAttributeOnSuperClass(boolean bl) {
        this.attributeOnSuperClass = bl;
    }

    public boolean isAttributeOnSuperClass() {
        return this.attributeOnSuperClass;
    }

    public void setWeaveTransientFieldValueHolders() {
        this.weaveTransientFieldValueHolders = true;
    }

    public boolean weaveTransientFieldValueHolders() {
        return this.weaveTransientFieldValueHolders;
    }

    public boolean weaveValueHolders() {
        return this.weaveValueHolders;
    }

    public void weaveVH(boolean bl, DatabaseMapping databaseMapping) {
        this.weaveValueHolders = bl;
    }

    public void setGetterMethodName(String string) {
        this.getterMethodName = string;
    }

    public void setSetterMethodName(String string) {
        this.setterMethodName = string;
    }

    public void setHasField(boolean bl) {
        this.hasField = bl;
    }

    public boolean hasField() {
        return this.hasField;
    }

    public boolean isCollectionMapping() {
        return this.mapping.isCollectionMapping();
    }

    public boolean isMappedWithAttributeAccess() {
        return this.getterMethodName == null;
    }

    public boolean isOneToOneMapping() {
        return this.mapping.isOneToOneMapping();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.attributeName);
        if (this.referenceClassName != null) {
            stringBuffer.append("[");
            stringBuffer.append(this.referenceClassName);
            stringBuffer.append("]");
        }
        stringBuffer.append(" weaveVH: ");
        if (this.weaveValueHolders()) {
            stringBuffer.append("true");
        } else {
            stringBuffer.append("false");
        }
        stringBuffer.append(" CM: ");
        if (this.isCollectionMapping()) {
            stringBuffer.append("true");
        } else {
            stringBuffer.append("false");
        }
        return stringBuffer.toString();
    }
}

