/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm;

import java.util.ArrayList;
import javax.xml.namespace.QName;
import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.oxm.XMLField;

public class XMLUnionField
extends XMLField {
    private ArrayList schemaTypes = new ArrayList();

    public XMLUnionField() {
    }

    public XMLUnionField(String string) {
        super(string);
    }

    public ArrayList getSchemaTypes() {
        return this.schemaTypes;
    }

    public void setSchemaTypes(ArrayList arrayList) {
        this.schemaTypes = arrayList;
    }

    public void addSchemaType(QName qName) {
        if (qName != null) {
            if (this.schemaTypes == null) {
                this.schemaTypes = new ArrayList();
            }
            if (!this.contains(this.schemaTypes, qName)) {
                this.schemaTypes.add(qName);
            }
        }
    }

    public QName getSchemaType() {
        if (this.schemaTypes != null) {
            return (QName)this.getSchemaTypes().get(0);
        }
        return null;
    }

    public void setSchemaType(QName qName) {
        this.addSchemaType(qName);
    }

    private boolean contains(ArrayList arrayList, QName qName) {
        for (QName qName2 : arrayList) {
            if (!qName2.equals(qName)) continue;
            return true;
        }
        return false;
    }

    public boolean isUnionField() {
        return true;
    }

    public Object convertValueBasedOnSchemaType(Object object, XMLConversionManager xMLConversionManager) {
        Object object2 = object;
        for (int i = 0; i < this.schemaTypes.size(); ++i) {
            QName qName = (QName)this.schemaTypes.get(i);
            try {
                if (qName == null) continue;
                Class clazz = this.getType();
                clazz = this.getJavaClass(qName);
                object2 = xMLConversionManager.convertObject(object, clazz, qName);
                break;
            }
            catch (ConversionException conversionException) {
                if (i != this.schemaTypes.size() - 1) continue;
                throw conversionException;
            }
        }
        return object2;
    }

    public Class getJavaClass(QName qName) {
        if (this.userXMLTypes != null && this.userXMLTypes.containsKey(qName)) {
            return (Class)this.userXMLTypes.get(qName);
        }
        Class clazz = (Class)XMLConversionManager.getDefaultXMLTypes().get(qName);
        return XMLConversionManager.getObjectClass(clazz);
    }
}

