/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.transaction;

import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.TransactionException;
import org.eclipse.persistence.internal.helper.JavaPlatform;
import org.eclipse.persistence.internal.sequencing.SequencingCallback;
import org.eclipse.persistence.internal.sequencing.SequencingCallbackFactory;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.DatabaseSessionImpl;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.ExternalTransactionController;
import org.eclipse.persistence.sessions.broker.SessionBroker;
import org.eclipse.persistence.transaction.AbstractSynchronizationListener;
import org.eclipse.persistence.transaction.SynchronizationListenerFactory;

public abstract class AbstractTransactionController
implements ExternalTransactionController {
    protected Map unitsOfWork = JavaPlatform.getConcurrentMap();
    protected AbstractSession session;
    protected SynchronizationListenerFactory listenerFactory;
    protected ThreadLocal activeUnitOfWorkThreadLocal = new ThreadLocal();
    protected Map<Object, AbstractSynchronizationListener> sequencingListeners;
    protected Map<Object, AbstractSynchronizationListener> currentlyProcessedListeners;
    protected int numSessionsRequiringSequencingCallback;

    public void bindToCurrentTransaction(UnitOfWorkImpl unitOfWorkImpl, AbstractSession abstractSession) {
        Object object = this.getTransactionStatus();
        this.logTxStateTrace(unitOfWorkImpl, "TX_bind", object);
        try {
            Object object2 = this.getTransaction();
            if (object2 == null) {
                unitOfWorkImpl.beginTransaction();
                object2 = this.getTransaction();
            }
            if (object2 == null) {
                throw TransactionException.externalTransactionNotActive();
            }
            AbstractSynchronizationListener abstractSynchronizationListener = this.getListenerFactory().newSynchronizationListener(unitOfWorkImpl, abstractSession, object2, this);
            this.registerSynchronization_impl(abstractSynchronizationListener, object2);
            unitOfWorkImpl.setSynchronized(true);
        }
        catch (Exception exception) {
            throw TransactionException.errorBindingToExternalTransaction(exception);
        }
    }

    public void beginTransaction(AbstractSession abstractSession) {
        try {
            Object object = this.getTransactionStatus();
            this.logTxStateTrace(abstractSession, "TX_begin", object);
            if (this.canBeginTransaction_impl(object)) {
                this.logTxTrace(abstractSession, "TX_beginningTxn", null);
                this.beginTransaction_impl();
                abstractSession.setWasJTSTransactionInternallyStarted(true);
            }
        }
        catch (Exception exception) {
            throw TransactionException.errorBeginningExternalTransaction(exception);
        }
    }

    public void commitTransaction(AbstractSession abstractSession) {
        try {
            Object object = this.getTransactionStatus();
            this.logTxStateTrace(abstractSession, "TX_commit", object);
            if (this.canCommitTransaction_impl(object)) {
                this.logTxTrace(abstractSession, "TX_committingTxn", null);
                abstractSession.setWasJTSTransactionInternallyStarted(false);
                this.commitTransaction_impl();
            }
        }
        catch (Exception exception) {
            throw TransactionException.errorCommittingExternalTransaction(exception);
        }
    }

    public void rollbackTransaction(AbstractSession abstractSession) {
        try {
            Object object = this.getTransactionStatus();
            this.logTxStateTrace(abstractSession, "TX_rollback", object);
            abstractSession.setWasJTSTransactionInternallyStarted(false);
            if (this.canRollbackTransaction_impl(object) && this.getTransaction() != null) {
                this.logTxTrace(abstractSession, "TX_rollingBackTxn", null);
                this.rollbackTransaction_impl();
            }
        }
        catch (Exception exception) {
            throw TransactionException.errorRollingBackExternalTransaction(exception);
        }
    }

    public void markTransactionForRollback() {
        try {
            this.markTransactionForRollback_impl();
        }
        catch (Exception exception) {
            throw TransactionException.errorMarkingTransactionForRollback(exception);
        }
    }

    public Object getTransaction() {
        try {
            return this.getTransaction_impl();
        }
        catch (Exception exception) {
            throw TransactionException.errorGettingExternalTransaction(exception);
        }
    }

    public Object getTransactionKey(Object object) {
        try {
            return this.getTransactionKey_impl(object);
        }
        catch (Exception exception) {
            throw TransactionException.errorGettingExternalTransaction(exception);
        }
    }

    public Object getTransactionStatus() {
        try {
            return this.getTransactionStatus_impl();
        }
        catch (Exception exception) {
            throw TransactionException.errorGettingExternalTransactionStatus(exception);
        }
    }

    public boolean noTransactionOrRolledBackOrCommited() {
        try {
            Object object = this.getTransactionStatus();
            return this.canBeginTransaction_impl(object) || this.canMergeUnitOfWork_impl(object) || this.isRolledBack_impl(object);
        }
        catch (Exception exception) {
            throw TransactionException.errorGettingExternalTransactionStatus(exception);
        }
    }

    public abstract boolean isRolledBack_impl(Object var1);

    public boolean hasActiveUnitOfWork() {
        return this.lookupActiveUnitOfWork() != null;
    }

    public UnitOfWorkImpl getActiveUnitOfWork() {
        Object object = this.getTransaction();
        if (object == null) {
            return null;
        }
        UnitOfWorkImpl unitOfWorkImpl = this.lookupActiveUnitOfWork(object);
        if (unitOfWorkImpl == null) {
            unitOfWorkImpl = this.getSession().acquireUnitOfWork();
            Object object2 = this.getTransactionKey(object);
            this.addUnitOfWork(object2, unitOfWorkImpl);
            unitOfWorkImpl.setTransaction(object);
            this.activeUnitOfWorkThreadLocal.set(unitOfWorkImpl);
        }
        return unitOfWorkImpl;
    }

    public UnitOfWorkImpl lookupActiveUnitOfWork() {
        return this.lookupActiveUnitOfWork(this.getTransaction());
    }

    public UnitOfWorkImpl lookupActiveUnitOfWork(Object object) {
        if (object == null) {
            return null;
        }
        Object object2 = this.getTransactionKey(object);
        UnitOfWorkImpl unitOfWorkImpl = (UnitOfWorkImpl)this.activeUnitOfWorkThreadLocal.get();
        if (unitOfWorkImpl != null && object == unitOfWorkImpl.getTransaction()) {
            return unitOfWorkImpl;
        }
        unitOfWorkImpl = (UnitOfWorkImpl)this.getUnitsOfWork().get(object2);
        if (unitOfWorkImpl != null) {
            unitOfWorkImpl.setTransaction(object);
        }
        this.activeUnitOfWorkThreadLocal.set(unitOfWorkImpl);
        return unitOfWorkImpl;
    }

    public void addUnitOfWork(Object object, UnitOfWorkImpl unitOfWorkImpl) {
        this.activeUnitOfWorkThreadLocal.set(null);
        this.getUnitsOfWork().put(object, unitOfWorkImpl);
    }

    public void removeUnitOfWork(Object object) {
        if (object != null) {
            this.getUnitsOfWork().remove(object);
        }
        this.activeUnitOfWorkThreadLocal.set(null);
    }

    public AbstractSession getSession() {
        return this.session;
    }

    public void setSession(AbstractSession abstractSession) {
        this.session = abstractSession;
        this.initializeSequencingListeners();
    }

    public Map getUnitsOfWork() {
        return this.unitsOfWork;
    }

    protected void setUnitsOfWork(Map map) {
        this.unitsOfWork = map;
    }

    public SynchronizationListenerFactory getListenerFactory() {
        return this.listenerFactory;
    }

    public void setListenerFactory(SynchronizationListenerFactory synchronizationListenerFactory) {
        this.listenerFactory = synchronizationListenerFactory;
    }

    public void registerSynchronizationListener(UnitOfWorkImpl unitOfWorkImpl, AbstractSession abstractSession) throws DatabaseException {
        this.bindToCurrentTransaction(unitOfWorkImpl, abstractSession);
    }

    public Object jndiLookup(String string) {
        InitialContext initialContext = null;
        Object object = null;
        try {
            initialContext = new InitialContext();
            object = initialContext.lookup(string);
        }
        catch (NamingException namingException) {
            throw TransactionException.jndiLookupException(string, namingException);
        }
        finally {
            try {
                initialContext.close();
            }
            catch (Exception exception) {}
        }
        return object;
    }

    public void initializeSequencingListeners() {
        this.clearSequencingListeners();
        if (this.session == null) {
            return;
        }
        AbstractSession abstractSession = this.session;
        while (abstractSession.getParent() != null) {
            abstractSession = abstractSession.getParent();
        }
        if (abstractSession.isBroker()) {
            this.numSessionsRequiringSequencingCallback = ((SessionBroker)abstractSession).howManySequencingCallbacks();
        } else if (((DatabaseSessionImpl)abstractSession).isSequencingCallbackRequired()) {
            this.numSessionsRequiringSequencingCallback = 1;
        }
        if (this.numSessionsRequiringSequencingCallback != 0) {
            this.sequencingListeners = JavaPlatform.getConcurrentMap();
            this.currentlyProcessedListeners = JavaPlatform.getConcurrentMap();
        }
    }

    public SequencingCallback getActiveSequencingCallback(DatabaseSession databaseSession, SequencingCallbackFactory sequencingCallbackFactory) {
        Object object = this.getTransaction();
        if (object == null) {
            throw TransactionException.externalTransactionNotActive();
        }
        Object object2 = this.getTransactionKey(object);
        AbstractSynchronizationListener abstractSynchronizationListener = this.sequencingListeners.get(object2);
        if (abstractSynchronizationListener == null) {
            abstractSynchronizationListener = this.currentlyProcessedListeners.get(object2);
            if (abstractSynchronizationListener == null) {
                abstractSynchronizationListener = this.getListenerFactory().newSynchronizationListener(null, null, object, this);
                try {
                    this.registerSynchronization_impl(abstractSynchronizationListener, object);
                }
                catch (Exception exception) {
                    throw TransactionException.errorBindingToExternalTransaction(exception);
                }
            }
            this.sequencingListeners.put(object2, abstractSynchronizationListener);
        }
        return abstractSynchronizationListener.getSequencingCallback(databaseSession, sequencingCallbackFactory);
    }

    public void clearSequencingListeners() {
        this.sequencingListeners = null;
        this.currentlyProcessedListeners = null;
        this.numSessionsRequiringSequencingCallback = 0;
    }

    public boolean isSequencingCallbackRequired() {
        return this.numSessionsRequiringSequencingCallback > 0;
    }

    public int numSessionsRequiringSequencingCallback() {
        return this.numSessionsRequiringSequencingCallback;
    }

    public void removeSequencingListener(Object object) {
        if (object != null) {
            this.sequencingListeners.remove(object);
        }
    }

    public void logTxTrace(AbstractSession abstractSession, String string, Object[] objectArray) {
        abstractSession.log(2, "transaction", string, objectArray);
    }

    public void logTxStateTrace(AbstractSession abstractSession, String string, Object object) {
        if (abstractSession.shouldLog(2, "transaction")) {
            String string2 = this.statusToString_impl(object);
            Object[] objectArray = new Object[]{string2};
            abstractSession.log(2, "transaction", string, objectArray);
        }
    }

    protected abstract void registerSynchronization_impl(AbstractSynchronizationListener var1, Object var2) throws Exception;

    protected abstract Object getTransaction_impl() throws Exception;

    protected abstract Object getTransactionKey_impl(Object var1) throws Exception;

    protected abstract Object getTransactionStatus_impl() throws Exception;

    protected abstract void beginTransaction_impl() throws Exception;

    protected abstract void commitTransaction_impl() throws Exception;

    protected abstract void rollbackTransaction_impl() throws Exception;

    protected abstract void markTransactionForRollback_impl() throws Exception;

    protected abstract boolean canBeginTransaction_impl(Object var1);

    protected abstract boolean canCommitTransaction_impl(Object var1);

    protected abstract boolean canRollbackTransaction_impl(Object var1);

    protected abstract boolean canIssueSQLToDatabase_impl(Object var1);

    protected abstract boolean canMergeUnitOfWork_impl(Object var1);

    protected abstract String statusToString_impl(Object var1);
}

