/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.xr;

import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.DBWSException;
import org.eclipse.persistence.internal.xr.QueryHandler;
import org.eclipse.persistence.internal.xr.QueryOperation;
import org.eclipse.persistence.internal.xr.XRServiceAdapter;

public class NamedQueryHandler
extends QueryHandler {
    protected String name;
    protected String descriptor;

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(String string) {
        this.descriptor = string;
    }

    public void validate(XRServiceAdapter xRServiceAdapter, QueryOperation queryOperation) {
        if (this.descriptor != null) {
            if (!xRServiceAdapter.getORSession().getProject().getAliasDescriptors().containsKey(this.descriptor)) {
                throw DBWSException.couldNotLocateDescriptorForOperation((String)this.descriptor, (String)this.getName());
            }
            ClassDescriptor classDescriptor = xRServiceAdapter.getORSession().getProject().getDescriptorForAlias(this.descriptor);
            if (classDescriptor.getQueryManager().getQuery(this.name) == null) {
                throw DBWSException.couldNotLocateQueryForDescriptor((String)this.name, (String)this.descriptor);
            }
        } else if (xRServiceAdapter.getORSession().getQuery(this.name) == null) {
            throw DBWSException.couldNotLocateQueryForSession((String)this.name, (String)xRServiceAdapter.getORSession().getName());
        }
    }

    public void initialize(XRServiceAdapter xRServiceAdapter, QueryOperation queryOperation) {
        if (this.descriptor != null) {
            ClassDescriptor classDescriptor = xRServiceAdapter.getORSession().getProject().getDescriptorForAlias(this.descriptor);
            this.databaseQuery = classDescriptor.getQueryManager().getQuery(this.name);
        } else {
            this.databaseQuery = xRServiceAdapter.getORSession().getQuery(this.name);
        }
    }
}

