/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jaxb;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.HashMap;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.namespace.QName;
import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.internal.oxm.XMLBinaryDataHelper;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.internal.security.PrivilegedGetDeclaredMethods;
import org.eclipse.persistence.internal.security.PrivilegedNewInstanceFromClass;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLMarshaller;
import org.eclipse.persistence.oxm.XMLUnmarshaller;
import org.eclipse.persistence.oxm.mappings.XMLBinaryDataMapping;
import org.eclipse.persistence.oxm.mappings.converters.XMLConverterAdapter;
import org.eclipse.persistence.sessions.Session;

public class XMLJavaTypeConverter
extends XMLConverterAdapter {
    protected Class boundType = Object.class;
    protected Class valueType = Object.class;
    protected Class xmlAdapterClass;
    protected String xmlAdapterClassName;
    protected XmlAdapter xmlAdapter;
    protected QName schemaType;
    protected DatabaseMapping mapping;

    public XMLJavaTypeConverter() {
    }

    public XMLJavaTypeConverter(Class clazz) {
        this.setXmlAdapterClass(clazz);
    }

    public XMLJavaTypeConverter(String string) {
        this.xmlAdapterClassName = string;
    }

    public XMLJavaTypeConverter(Class clazz, QName qName) {
        this.setSchemaType(qName);
        this.setXmlAdapterClass(clazz);
    }

    public XMLJavaTypeConverter(String string, QName qName) {
        this.setSchemaType(qName);
        this.setXmlAdapterClassName(string);
    }

    public Object convertDataValueToObjectValue(Object object, Session session, XMLUnmarshaller xMLUnmarshaller) {
        try {
            XmlAdapter xmlAdapter;
            Object object2;
            XmlAdapter xmlAdapter2 = this.xmlAdapter;
            if (xMLUnmarshaller != null && (object2 = (HashMap)xMLUnmarshaller.getProperty((Object)"xml-javatype-adapters")) != null && (xmlAdapter = (XmlAdapter)((HashMap)object2).get(this.xmlAdapterClass)) != null) {
                xmlAdapter2 = xmlAdapter;
            }
            object2 = object;
            if (object != null && object.getClass() != this.valueType) {
                object2 = this.mapping instanceof XMLBinaryDataMapping ? XMLBinaryDataHelper.getXMLBinaryDataHelper().convertObject(object, this.valueType, (AbstractSession)session) : (this.getSchemaType() != null ? ((XMLConversionManager)session.getDatasourcePlatform().getConversionManager()).convertObject(object, this.valueType, this.getSchemaType()) : session.getDatasourcePlatform().getConversionManager().convertObject(object, this.valueType));
            }
            return xmlAdapter2.unmarshal(object2);
        }
        catch (Exception exception) {
            throw ConversionException.couldNotBeConverted((Object)object, (Class)this.boundType);
        }
    }

    public Object convertObjectValueToDataValue(Object object, Session session, XMLMarshaller xMLMarshaller) {
        try {
            XmlAdapter xmlAdapter;
            HashMap hashMap;
            XmlAdapter xmlAdapter2 = this.xmlAdapter;
            if (xMLMarshaller != null && (hashMap = (HashMap)xMLMarshaller.getProperty((Object)"xml-javatype-adapters")) != null && (xmlAdapter = (XmlAdapter)hashMap.get(this.xmlAdapterClass)) != null) {
                xmlAdapter2 = xmlAdapter;
            }
            return xmlAdapter2.marshal(object);
        }
        catch (Exception exception) {
            throw ConversionException.couldNotBeConverted((Object)object, (Class)this.valueType);
        }
    }

    public QName getSchemaType() {
        return this.schemaType;
    }

    public Class getXmlAdapterClass() {
        return this.xmlAdapterClass;
    }

    public String getXmlAdapterClassName() {
        if (this.xmlAdapterClassName == null) {
            this.xmlAdapterClassName = "";
        }
        return this.xmlAdapterClassName;
    }

    public void initialize(DatabaseMapping databaseMapping, Session session) {
        block20: {
            block19: {
                if (this.xmlAdapterClass == null) {
                    try {
                        if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                            try {
                                this.xmlAdapterClass = (Class)AccessController.doPrivileged(new PrivilegedClassForName(this.getXmlAdapterClassName()));
                                break block19;
                            }
                            catch (PrivilegedActionException privilegedActionException) {
                                if (privilegedActionException.getCause() instanceof ClassNotFoundException) {
                                    throw (ClassNotFoundException)privilegedActionException.getCause();
                                }
                                throw (RuntimeException)privilegedActionException.getCause();
                            }
                        }
                        this.xmlAdapterClass = PrivilegedAccessHelper.getClassForName((String)this.getXmlAdapterClassName());
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        return;
                    }
                }
            }
            this.mapping = databaseMapping;
            Method[] methodArray = null;
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                try {
                    methodArray = (Method[])AccessController.doPrivileged(new PrivilegedGetDeclaredMethods(this.xmlAdapterClass));
                }
                catch (PrivilegedActionException privilegedActionException) {
                    throw (RuntimeException)privilegedActionException.getCause();
                }
            } else {
                methodArray = PrivilegedAccessHelper.getDeclaredMethods((Class)this.xmlAdapterClass);
            }
            for (int i = 0; i < methodArray.length; ++i) {
                Method method = methodArray[i];
                if (!method.getName().equals("marshal") || method.getReturnType() == Object.class || method.getParameterTypes()[0] == Object.class) continue;
                this.valueType = method.getReturnType();
                this.boundType = method.getParameterTypes()[0];
                break;
            }
            try {
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        this.xmlAdapter = (XmlAdapter)AccessController.doPrivileged(new PrivilegedNewInstanceFromClass(this.getXmlAdapterClass()));
                        break block20;
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        if (privilegedActionException.getCause() instanceof IllegalAccessException) {
                            throw (IllegalAccessException)privilegedActionException.getCause();
                        }
                        if (privilegedActionException.getCause() instanceof InstantiationException) {
                            throw (InstantiationException)privilegedActionException.getCause();
                        }
                        throw (RuntimeException)privilegedActionException.getCause();
                    }
                }
                this.xmlAdapter = (XmlAdapter)PrivilegedAccessHelper.newInstanceFromClass((Class)this.getXmlAdapterClass());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean isMutable() {
        return false;
    }

    public void setSchemaType(QName qName) {
        this.schemaType = qName;
    }

    public void setXmlAdapterClass(Class clazz) {
        this.xmlAdapterClass = clazz;
    }

    public void setXmlAdapterClassName(String string) {
        this.xmlAdapterClassName = string;
    }
}

