/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.bind.JAXBException;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.jaxb.JaxbClassLoader;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.jaxb.JAXBContext;
import org.eclipse.persistence.jaxb.compiler.Generator;
import org.eclipse.persistence.jaxb.javamodel.reflection.JavaModelImpl;
import org.eclipse.persistence.jaxb.javamodel.reflection.JavaModelInputImpl;
import org.eclipse.persistence.oxm.XMLContext;
import org.eclipse.persistence.sessions.Project;

public class JAXBContextFactory {
    public static javax.xml.bind.JAXBContext createContext(Class[] classArray, Map map) throws JAXBException {
        ClassLoader classLoader = null;
        if (classArray.length > 0) {
            classLoader = classArray[0].getClassLoader();
        }
        return JAXBContextFactory.createContext(classArray, map, classLoader);
    }

    public static javax.xml.bind.JAXBContext createContext(Class[] classArray, Map map, ClassLoader classLoader) throws JAXBException {
        JAXBContext jAXBContext = null;
        XMLContext xMLContext = null;
        JaxbClassLoader jaxbClassLoader = new JaxbClassLoader(classLoader);
        Generator generator = new Generator(new JavaModelInputImpl(classArray, new JavaModelImpl(jaxbClassLoader)));
        try {
            Project project = generator.generateProject();
            ConversionManager conversionManager = null;
            if (classLoader != null) {
                conversionManager = new ConversionManager();
                conversionManager.setLoader((ClassLoader)jaxbClassLoader);
            } else {
                conversionManager = ConversionManager.getDefaultManager();
            }
            for (ClassDescriptor classDescriptor : project.getOrderedDescriptors()) {
                if (classDescriptor.getJavaClass() != null) continue;
                classDescriptor.setJavaClass(conversionManager.convertClassNameToClass(classDescriptor.getJavaClassName()));
            }
            xMLContext = new XMLContext(project, (ClassLoader)jaxbClassLoader);
            jAXBContext = new JAXBContext(xMLContext, generator);
        }
        catch (Exception exception) {
            throw new JAXBException((Throwable)exception);
        }
        return jAXBContext;
    }

    public static javax.xml.bind.JAXBContext createContext(String string, ClassLoader classLoader) throws JAXBException {
        Class[] classArray;
        try {
            XMLContext xMLContext = new XMLContext(string, classLoader);
            return new JAXBContext(xMLContext);
        }
        catch (ValidationException validationException) {
            if (validationException.getErrorCode() != 7095) {
                throw new JAXBException((Throwable)validationException);
            }
        }
        catch (Exception exception) {
            throw new JAXBException((Throwable)exception);
        }
        ArrayList arrayList = new ArrayList();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        while (stringTokenizer.hasMoreElements()) {
            Object object;
            classArray = stringTokenizer.nextToken();
            try {
                object = classLoader.loadClass((String)classArray + ".ObjectFactory");
                if (JAXBContextFactory.isJAXB2ObjectFactory(object)) {
                    arrayList.add((Class<?>)object);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                classLoader.loadClass((String)classArray + ".package-info");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if ((object = classLoader.getResourceAsStream(classArray.replace('.', '/') + "/jaxb.index")) == null) continue;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)object));
            try {
                String string2 = bufferedReader.readLine();
                while (string2 != null) {
                    String string3 = (String)classArray + "." + string2.trim();
                    try {
                        arrayList.add(classLoader.loadClass(string3));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    string2 = bufferedReader.readLine();
                }
            }
            catch (Exception exception) {
            }
        }
        if (arrayList.size() == 0) {
            throw new JAXBException((Throwable)org.eclipse.persistence.exceptions.JAXBException.noObjectFactoryOrJaxbIndexInPath((String)string));
        }
        classArray = new Class[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            classArray[i] = (Class)arrayList.get(i);
        }
        return JAXBContextFactory.createContext(classArray, null, classLoader);
    }

    private static boolean isJAXB2ObjectFactory(Class clazz) {
        try {
            Class clazz2 = PrivilegedAccessHelper.getClassForName((String)"javax.xml.bind.annotation.XmlRegistry");
            return clazz.isAnnotationPresent(clazz2);
        }
        catch (Exception exception) {
            return false;
        }
    }
}

