/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Map;
import javax.xml.bind.Marshaller;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedMethodInvoker;
import org.eclipse.persistence.jaxb.compiler.MarshalCallback;
import org.eclipse.persistence.oxm.XMLMarshalListener;

public class JAXBMarshalListener
implements XMLMarshalListener {
    private Marshaller.Listener listener;
    private Map classBasedMarshalEvents;
    private Marshaller marshaller;

    public JAXBMarshalListener(Marshaller marshaller) {
        this.marshaller = marshaller;
    }

    public void setListener(Marshaller.Listener listener) {
        this.listener = listener;
    }

    public Marshaller.Listener getListener() {
        return this.listener;
    }

    public void beforeMarshal(Object object) {
        block9: {
            MarshalCallback marshalCallback;
            if (this.classBasedMarshalEvents != null && (marshalCallback = (MarshalCallback)this.classBasedMarshalEvents.get(object.getClass().getName())) != null && marshalCallback.getBeforeMarshalCallback() != null) {
                try {
                    if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                        try {
                            AccessController.doPrivileged(new PrivilegedMethodInvoker(marshalCallback.getBeforeMarshalCallback(), object, new Object[]{this.marshaller}));
                            break block9;
                        }
                        catch (PrivilegedActionException privilegedActionException) {
                            if (privilegedActionException.getCause() instanceof IllegalAccessException) {
                                throw (IllegalAccessException)privilegedActionException.getCause();
                            }
                            if (privilegedActionException.getCause() instanceof InvocationTargetException) {
                                throw (InvocationTargetException)privilegedActionException.getCause();
                            }
                            throw (RuntimeException)privilegedActionException.getCause();
                        }
                    }
                    PrivilegedAccessHelper.invokeMethod((Method)marshalCallback.getBeforeMarshalCallback(), (Object)object, (Object[])new Object[]{this.marshaller});
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (this.listener != null) {
            this.listener.beforeMarshal(object);
        }
    }

    public void afterMarshal(Object object) {
        block9: {
            MarshalCallback marshalCallback;
            if (this.classBasedMarshalEvents != null && (marshalCallback = (MarshalCallback)this.classBasedMarshalEvents.get(object.getClass().getName())) != null && marshalCallback.getAfterMarshalCallback() != null) {
                try {
                    if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                        try {
                            AccessController.doPrivileged(new PrivilegedMethodInvoker(marshalCallback.getAfterMarshalCallback(), object, new Object[]{this.marshaller}));
                            break block9;
                        }
                        catch (PrivilegedActionException privilegedActionException) {
                            if (privilegedActionException.getCause() instanceof IllegalAccessException) {
                                throw (IllegalAccessException)privilegedActionException.getCause();
                            }
                            if (privilegedActionException.getCause() instanceof InvocationTargetException) {
                                throw (InvocationTargetException)privilegedActionException.getCause();
                            }
                            throw (RuntimeException)privilegedActionException.getCause();
                        }
                    }
                    PrivilegedAccessHelper.invokeMethod((Method)marshalCallback.getAfterMarshalCallback(), (Object)object, (Object[])new Object[]{this.marshaller});
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (this.listener != null) {
            this.listener.afterMarshal(object);
        }
    }

    public void setClassBasedMarshalEvents(Map map) {
        this.classBasedMarshalEvents = map;
    }
}

