/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb.compiler;

import java.beans.Introspector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Set;
import javax.xml.bind.annotation.XmlAnyAttribute;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlIDREF;
import javax.xml.bind.annotation.XmlList;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlValue;
import javax.xml.namespace.QName;
import org.eclipse.persistence.internal.oxm.schema.model.All;
import org.eclipse.persistence.internal.oxm.schema.model.Any;
import org.eclipse.persistence.internal.oxm.schema.model.AnyAttribute;
import org.eclipse.persistence.internal.oxm.schema.model.Attribute;
import org.eclipse.persistence.internal.oxm.schema.model.Choice;
import org.eclipse.persistence.internal.oxm.schema.model.ComplexContent;
import org.eclipse.persistence.internal.oxm.schema.model.ComplexType;
import org.eclipse.persistence.internal.oxm.schema.model.Element;
import org.eclipse.persistence.internal.oxm.schema.model.Extension;
import org.eclipse.persistence.internal.oxm.schema.model.Import;
import org.eclipse.persistence.internal.oxm.schema.model.List;
import org.eclipse.persistence.internal.oxm.schema.model.Restriction;
import org.eclipse.persistence.internal.oxm.schema.model.Schema;
import org.eclipse.persistence.internal.oxm.schema.model.Sequence;
import org.eclipse.persistence.internal.oxm.schema.model.SimpleContent;
import org.eclipse.persistence.internal.oxm.schema.model.SimpleType;
import org.eclipse.persistence.internal.oxm.schema.model.TypeDefParticle;
import org.eclipse.persistence.jaxb.compiler.AnyProperty;
import org.eclipse.persistence.jaxb.compiler.ChoiceProperty;
import org.eclipse.persistence.jaxb.compiler.ElementDeclaration;
import org.eclipse.persistence.jaxb.compiler.EnumTypeInfo;
import org.eclipse.persistence.jaxb.compiler.NamespaceInfo;
import org.eclipse.persistence.jaxb.compiler.Property;
import org.eclipse.persistence.jaxb.compiler.ReferenceProperty;
import org.eclipse.persistence.jaxb.compiler.SchemaTypeInfo;
import org.eclipse.persistence.jaxb.compiler.TypeInfo;
import org.eclipse.persistence.jaxb.javamodel.Helper;
import org.eclipse.persistence.jaxb.javamodel.JavaClass;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaGenerator {
    private HashMap<String, Schema> schemaForNamespace;
    private Schema schema;
    private int schemaCount;
    private Helper helper;
    private HashMap<String, TypeInfo> typeInfo;
    private HashMap<String, NamespaceInfo> packageToNamespaceMappings;
    private HashMap<String, SchemaTypeInfo> schemaTypeInfo;
    private HashMap<String, QName> userDefinedSchemaTypes;

    public SchemaGenerator(Helper helper) {
        this.helper = helper;
    }

    public Schema generateSchema(ArrayList<JavaClass> arrayList, HashMap<String, TypeInfo> hashMap, HashMap<String, QName> hashMap2, HashMap<String, NamespaceInfo> hashMap3, HashMap<QName, ElementDeclaration> hashMap4) {
        this.typeInfo = hashMap;
        this.userDefinedSchemaTypes = hashMap2;
        this.packageToNamespaceMappings = hashMap3;
        this.schemaCount = 0;
        this.schemaTypeInfo = new HashMap(hashMap.size());
        for (JavaClass javaClass : arrayList) {
            this.addSchemaComponents(javaClass);
        }
        this.populateSchemaTypes();
        if (hashMap4 != null) {
            this.addGlobalElements(hashMap4);
        }
        return this.schema;
    }

    public void addSchemaComponents(JavaClass javaClass) {
        Object object;
        Object object2;
        Object object3;
        XmlRootElement xmlRootElement;
        String string = javaClass.getQualifiedName();
        Element element = null;
        TypeInfo typeInfo = this.typeInfo.get(string);
        SchemaTypeInfo schemaTypeInfo = new SchemaTypeInfo();
        schemaTypeInfo.setSchemaTypeName(new QName(typeInfo.getClassNamespace(), typeInfo.getSchemaTypeName()));
        this.schemaTypeInfo.put(javaClass.getQualifiedName(), schemaTypeInfo);
        NamespaceInfo namespaceInfo = this.packageToNamespaceMappings.get(javaClass.getPackage().getQualifiedName());
        Schema schema = this.getSchemaForNamespace(typeInfo.getClassNamespace());
        typeInfo.setSchema(schema);
        String string2 = typeInfo.getSchemaTypeName();
        String[] stringArray = typeInfo.getPropOrder();
        String string3 = "";
        Property property = null;
        if (this.helper.isAnnotationPresent(javaClass, XmlRootElement.class)) {
            int n;
            char c;
            xmlRootElement = (XmlRootElement)this.helper.getAnnotation(javaClass, XmlRootElement.class);
            element = new Element();
            object3 = xmlRootElement.name();
            if ((((String)object3).equals("##default") || ((String)object3).equals("")) && ((String)(object3 = string.indexOf("$") != -1 ? Introspector.decapitalize(string.substring(string.lastIndexOf(36) + 1)) : Introspector.decapitalize(string.substring(string.lastIndexOf(46) + 1)))).length() >= 3 && Character.isDigit(c = ((String)object3).charAt((n = ((String)object3).length() - 1) - 1))) {
                char c2 = Character.toUpperCase(((String)object3).charAt(n));
                object3 = ((String)object3).substring(0, n) + c2;
            }
            element.setName((String)object3);
            object2 = xmlRootElement.namespace();
            if (((String)object2).equals("##default")) {
                this.getSchemaForNamespace(namespaceInfo.getNamespace()).addTopLevelElement(element);
                schemaTypeInfo.getGlobalElementDeclarations().add(new QName(namespaceInfo.getNamespace(), (String)object2));
                object2 = namespaceInfo.getNamespace();
            } else {
                this.getSchemaForNamespace((String)object2).addTopLevelElement(element);
                schemaTypeInfo.getGlobalElementDeclarations().add(new QName((String)object2, (String)object3));
            }
            object = this.getSchemaForNamespace((String)object2);
            if (schema != object) {
                Import import_ = new Import();
                import_.setNamespace(schema.getTargetNamespace());
                import_.setSchemaLocation(schema.getName());
                object.getImports().add(import_);
            }
            if (!typeInfo.getClassNamespace().equals("")) {
                string3 = this.getPrefixForNamespace(typeInfo.getClassNamespace(), object.getNamespaceResolver());
                if (string3 == null) {
                    string3 = object.getNamespaceResolver().generatePrefix();
                    object.getNamespaceResolver().put(string3, typeInfo.getClassNamespace());
                }
                string3 = string3 + ":";
            }
        }
        xmlRootElement = typeInfo.getPropertyNames();
        if (typeInfo.isEnumerationType() || xmlRootElement.size() == 1 && this.helper.isAnnotationPresent(typeInfo.getProperties().get(xmlRootElement.get(0)).getElement(), XmlValue.class)) {
            object3 = new SimpleType();
            if (string2.equals("")) {
                if (element != null) {
                    element.setSimpleType((SimpleType)object3);
                }
            } else {
                object3.setName(string2);
                schema.addTopLevelSimpleTypes((SimpleType)object3);
                if (element != null) {
                    element.setType(string3 + object3.getName());
                }
            }
            object2 = null;
            object = new Restriction();
            if (typeInfo.isEnumerationType()) {
                object2 = ((EnumTypeInfo)typeInfo).getRestrictionBase();
                object.setEnumerationFacets(this.getEnumerationFacetsFor((EnumTypeInfo)typeInfo));
                object.setBaseType("xsd:" + ((QName)object2).getLocalPart());
                object3.setRestriction((Restriction)object);
            } else {
                property = typeInfo.getProperties().get(xmlRootElement.get(0));
                QName qName = this.getSchemaTypeFor(property.getType());
                if (this.helper.isAnnotationPresent(property.getElement(), XmlList.class)) {
                    List list = new List();
                    list.setItemType("xsd:" + qName.getLocalPart());
                    object3.setList(list);
                } else {
                    if (this.helper.isAnnotationPresent(property.getElement(), XmlSchemaType.class)) {
                        XmlSchemaType xmlSchemaType = (XmlSchemaType)this.helper.getAnnotation(property.getElement(), XmlSchemaType.class);
                        qName = new QName("http://www.w3.org/2001/XMLSchema-instance", xmlSchemaType.name());
                    }
                    object.setBaseType("xsd:" + qName.getLocalPart());
                    object3.setRestriction((Restriction)object);
                }
            }
            typeInfo.setSimpleType((SimpleType)object3);
        } else {
            property = this.getXmlValueFieldForSimpleContent(typeInfo.getPropertyList());
            if (property != null) {
                object3 = new ComplexType();
                object2 = new SimpleContent();
                if (string2.equals("")) {
                    if (element != null) {
                        element.setComplexType((ComplexType)object3);
                    }
                    typeInfo.setComplexType((ComplexType)object3);
                } else {
                    object3.setName(string2);
                    schema.addTopLevelComplexTypes((ComplexType)object3);
                    if (element != null) {
                        element.setType(string3 + object3.getName());
                    }
                }
                object = this.getSchemaTypeFor(property.getType());
                if (this.helper.isAnnotationPresent(property.getElement(), XmlSchemaType.class)) {
                    XmlSchemaType xmlSchemaType = (XmlSchemaType)this.helper.getAnnotation(property.getElement(), XmlSchemaType.class);
                    object = new QName("http://www.w3.org/2001/XMLSchema-instance", xmlSchemaType.name());
                }
                Extension extension = new Extension();
                extension.setBaseType("xsd:" + ((QName)object).getLocalPart());
                object2.setExtension(extension);
                object3.setSimpleContent((SimpleContent)object2);
                typeInfo.setComplexType((ComplexType)object3);
            } else {
                Object object4;
                object3 = new ComplexType();
                object2 = javaClass.getSuperclass();
                object = this.typeInfo.get(object2.getQualifiedName());
                Extension extension = null;
                if (object != null) {
                    extension = new Extension();
                    object4 = this.getPrefixForNamespace(((TypeInfo)object).getClassNamespace(), namespaceInfo.getNamespaceResolver());
                    if (object4 != null) {
                        extension.setBaseType((String)object4 + ":" + ((TypeInfo)object).getSchemaTypeName());
                    } else {
                        extension.setBaseType(((TypeInfo)object).getSchemaTypeName());
                    }
                    ComplexContent complexContent = new ComplexContent();
                    complexContent.setExtension(extension);
                    object3.setComplexContent(complexContent);
                }
                object4 = null;
                if (stringArray.length == 0) {
                    if (typeInfo.hasElementRefs()) {
                        object4 = new Sequence();
                        if (extension != null) {
                            extension.setSequence(object4);
                        } else {
                            object3.setSequence(object4);
                        }
                    } else if (extension != null) {
                        object4 = new All();
                        extension.setAll((All)object4);
                    } else {
                        object4 = new All();
                        object3.setAll((All)object4);
                    }
                } else {
                    object4 = new Sequence();
                    if (extension != null) {
                        extension.setSequence(object4);
                    } else {
                        object3.setSequence(object4);
                    }
                }
                if (string2.equals("")) {
                    if (element != null) {
                        element.setComplexType((ComplexType)object3);
                    }
                    typeInfo.setComplexType((ComplexType)object3);
                    typeInfo.setCompositor((TypeDefParticle)object4);
                } else {
                    object3.setName(string2);
                    if (element != null) {
                        element.setType(string3 + object3.getName());
                    }
                    schema.addTopLevelComplexTypes((ComplexType)object3);
                    typeInfo.setComplexType((ComplexType)object3);
                    typeInfo.setCompositor((TypeDefParticle)object4);
                }
                typeInfo.setPropOrder(stringArray);
            }
        }
    }

    public void addToSchemaType(ArrayList<Property> arrayList, TypeDefParticle typeDefParticle, ComplexType complexType, Schema schema) {
        for (Property property : arrayList) {
            JavaClass javaClass;
            String string;
            Object object;
            Object object2;
            Object object4;
            JavaClass javaClass2;
            java.util.List<ElementDeclaration> list;
            Object object5;
            if (property == null) continue;
            Object object6 = typeDefParticle;
            boolean bl = object6 instanceof Choice;
            Object object7 = complexType;
            if (this.helper.isAnnotationPresent(property.getElement(), XmlTransient.class)) continue;
            if (!bl && this.helper.isAnnotationPresent(property.getElement(), XmlElementWrapper.class)) {
                object5 = (XmlElementWrapper)this.helper.getAnnotation(property.getElement(), XmlElementWrapper.class);
                list = new Element();
                list.setName(object5.name());
                list.setMinOccurs("0");
                typeDefParticle.addElement((Element)list);
                javaClass2 = new ComplexType();
                object4 = new Sequence();
                javaClass2.setSequence((Sequence)object4);
                list.setComplexType((ComplexType)javaClass2);
                object7 = javaClass2;
                object6 = object4;
            }
            if (this.helper.isAnnotationPresent(property.getElement(), XmlAttribute.class)) {
                List list2;
                object5 = new Attribute();
                list = property.getSchemaName();
                object5.setName(((QName)((Object)list)).getLocalPart());
                if (property.isRequired()) {
                    object5.setUse("required");
                }
                javaClass2 = property.getType();
                if (property.getGenericType() != null) {
                    javaClass2 = property.getGenericType();
                }
                object4 = null;
                TypeInfo typeInfo = this.typeInfo.get(property.getType().getQualifiedName());
                if (typeInfo != null) {
                    if (!typeInfo.isComplexType()) {
                        object4 = typeInfo.getSimpleType().getName();
                    }
                } else if (this.helper.isAnnotationPresent(property.getElement(), XmlID.class)) {
                    object4 = "xsd:ID";
                } else if (this.helper.isAnnotationPresent(property.getElement(), XmlIDREF.class)) {
                    object4 = "xsd:IDREF";
                } else {
                    object2 = property.getSchemaType();
                    if (object2 == null) {
                        object2 = this.getSchemaTypeFor(javaClass2);
                    }
                    object4 = object2 != null ? "xsd:" + ((QName)object2).getLocalPart() : "xsd:anySimpleType";
                }
                if (this.isCollectionType(property)) {
                    object2 = new SimpleType();
                    list2 = new List();
                    list2.setItemType((String)object4);
                    object2.setList(list2);
                    object5.setSimpleType((SimpleType)object2);
                } else {
                    if (object4 != null && !((String)object4).contains(":") && typeInfo.getSchema() == schema && (object2 = this.getPrefixForNamespace(schema.getTargetNamespace(), schema.getNamespaceResolver())) != null) {
                        object4 = (String)object2 + ":" + (String)object4;
                    }
                    object5.setType((String)object4);
                }
                if (!((QName)((Object)list)).getNamespaceURI().equals("")) {
                    object2 = this.getSchemaForNamespace(((QName)((Object)list)).getNamespaceURI());
                    if (object2.getTopLevelAttributes().get(object5.getName()) == null) {
                        object2.getTopLevelAttributes().put(object5.getName(), object5);
                    }
                    if (!this.importExists(schema, object2.getName())) {
                        list2 = new Import();
                        list2.setNamespace(object2.getTargetNamespace());
                        list2.setSchemaLocation(object2.getName());
                        schema.getImports().add(list2);
                        schema.getNamespaceResolver().put(schema.getNamespaceResolver().generatePrefix(), object2.getTargetNamespace());
                    }
                    list2 = new Attribute();
                    object = this.getPrefixForNamespace(object2.getTargetNamespace(), schema.getNamespaceResolver());
                    if (object == null) {
                        list2.setRef(object5.getName());
                    } else {
                        list2.setRef((String)object + ":" + object5.getName());
                    }
                    if (object7.getSimpleContent() != null) {
                        object7.getSimpleContent().getExtension().getOrderedAttributes().add(list2);
                        continue;
                    }
                    object7.getOrderedAttributes().add(list2);
                    continue;
                }
                if (object7.getSimpleContent() != null) {
                    object7.getSimpleContent().getExtension().getOrderedAttributes().add(object5);
                    continue;
                }
                object7.getOrderedAttributes().add(object5);
                continue;
            }
            if (this.helper.isAnnotationPresent(property.getElement(), XmlAnyAttribute.class)) {
                object5 = new AnyAttribute();
                object5.setProcessContents("lax");
                if (complexType.getSimpleContent() != null) {
                    list = complexType.getSimpleContent();
                    list.getRestriction().setAnyAttribute((AnyAttribute)object5);
                    continue;
                }
                complexType.setAnyAttribute((AnyAttribute)object5);
                continue;
            }
            if (property.isChoice()) {
                object5 = new Choice();
                list = (ArrayList)((ChoiceProperty)property).getChoiceProperties();
                this.addToSchemaType((ArrayList<Property>)list, (TypeDefParticle)object5, (ComplexType)object7, schema);
                if (object6 instanceof Sequence) {
                    ((Sequence)object6).addChoice((Choice)object5);
                    continue;
                }
                if (!(object6 instanceof Choice)) continue;
                ((Choice)object6).addChoice((Choice)object5);
                continue;
            }
            if (property.isAny()) {
                object5 = new Any();
                list = (AnyProperty)property;
                if (((AnyProperty)((Object)list)).isLax()) {
                    object5.setProcessContents("lax");
                }
                if (object6 instanceof Sequence) {
                    ((Sequence)object6).addAny((Any)object5);
                    continue;
                }
                if (!(object6 instanceof Choice)) continue;
                ((Choice)object6).addAny((Any)object5);
                continue;
            }
            if (property.isReference()) {
                object5 = (ReferenceProperty)property;
                list = ((ReferenceProperty)object5).getReferencedElements();
                if (list.size() == 1) {
                    String string2;
                    javaClass2 = new Element();
                    object4 = list.get(0);
                    String string3 = ((ElementDeclaration)object4).getElementName().getLocalPart();
                    object2 = this.getSchemaForNamespace(((ElementDeclaration)object4).getElementName().getNamespaceURI());
                    if (object2 != schema && !this.importExists(schema, object2.getName())) {
                        Import import_ = new Import();
                        import_.setSchemaLocation(object2.getName());
                        import_.setNamespace(object2.getTargetNamespace());
                        schema.getImports().add(import_);
                        if (import_.getNamespace() != null) {
                            schema.getNamespaceResolver().put(schema.getNamespaceResolver().generatePrefix(), import_.getNamespace());
                        }
                    }
                    if ((string2 = this.getPrefixForNamespace(((ElementDeclaration)object4).getElementName().getNamespaceURI(), schema.getNamespaceResolver())) == null || string2.equals("")) {
                        javaClass2.setRef(string3);
                    } else {
                        javaClass2.setRef(string2 + ":" + string3);
                    }
                    if (this.isCollectionType(property)) {
                        javaClass2.setMaxOccurs("unbounded");
                    }
                    object6.addElement((Element)javaClass2);
                    continue;
                }
                javaClass2 = new Choice();
                if (this.isCollectionType(property)) {
                    javaClass2.setMaxOccurs("unbounded");
                }
                for (ElementDeclaration elementDeclaration : list) {
                    object2 = new Element();
                    String string4 = elementDeclaration.getElementName().getLocalPart();
                    object = this.getSchemaForNamespace(elementDeclaration.getElementName().getNamespaceURI());
                    if (object != schema && !this.importExists(schema, object.getName())) {
                        string = new Import();
                        string.setSchemaLocation(object.getName());
                        string.setNamespace(object.getTargetNamespace());
                        schema.getImports().add(string);
                        if (string.getNamespace() != null) {
                            schema.getNamespaceResolver().put(schema.getNamespaceResolver().generatePrefix(), string.getNamespace());
                        }
                    }
                    if ((string = this.getPrefixForNamespace(elementDeclaration.getElementName().getNamespaceURI(), schema.getNamespaceResolver())) == null || string.equals("")) {
                        object2.setRef(string4);
                    } else {
                        object2.setRef(string + ":" + string4);
                    }
                    javaClass2.addElement((Element)object2);
                }
                if (object6 instanceof Sequence) {
                    ((Sequence)object6).addChoice((Choice)javaClass2);
                    continue;
                }
                if (!(object6 instanceof Choice)) continue;
                ((Choice)object6).addChoice((Choice)javaClass2);
                continue;
            }
            if (this.helper.isAnnotationPresent(property.getElement(), XmlValue.class)) continue;
            object5 = new Element();
            object5.setMinOccurs(property.isRequired() ? "1" : "0");
            list = property.getSchemaName();
            javaClass2 = property.getType();
            boolean bl2 = this.isCollectionType(property);
            if (bl2 && (javaClass = property.getGenericType()) != null && javaClass.hasActualTypeArguments()) {
                object2 = javaClass.getActualTypeArguments().toArray();
                javaClass2 = (JavaClass)object2[0];
            }
            object5.setName(((QName)((Object)list)).getLocalPart());
            TypeInfo typeInfo = this.typeInfo.get(javaClass2.getQualifiedName());
            object2 = null;
            boolean bl3 = false;
            if (typeInfo != null) {
                if (this.helper.isAnnotationPresent(property.getElement(), XmlID.class)) {
                    object2 = "xsd:ID";
                } else if (this.helper.isAnnotationPresent(property.getElement(), XmlIDREF.class)) {
                    object2 = "xsd:IDREF";
                } else {
                    bl3 = typeInfo.isComplexType();
                    object2 = typeInfo.isComplexType() ? typeInfo.getComplexType().getName() : typeInfo.getSimpleType().getName();
                }
                if (object2 == null && !typeInfo.hasRootElement()) {
                    if (typeInfo.isComplexType()) {
                        object5.setComplexType(typeInfo.getComplexType());
                    } else {
                        object5.setSimpleType(typeInfo.getSimpleType());
                    }
                }
                if (typeInfo.getSchema() != schema && !this.importExists(schema, typeInfo.getSchema().getName())) {
                    object = new Import();
                    object.setSchemaLocation(typeInfo.getSchema().getName());
                    object.setNamespace(typeInfo.getSchema().getTargetNamespace());
                    schema.getImports().add(object);
                    if (object.getNamespace() != null) {
                        schema.getNamespaceResolver().put(schema.getNamespaceResolver().generatePrefix(), object.getNamespace());
                    }
                    if ((string = this.getPrefixForNamespace(typeInfo.getSchema().getTargetNamespace(), schema.getNamespaceResolver())) != null && !((String)object2).equals("")) {
                        object2 = string + ":" + (String)object2;
                    }
                }
            } else {
                object = property.getSchemaType();
                if (object == null) {
                    object = this.getSchemaTypeFor(javaClass2);
                }
                if (object != null) {
                    object2 = "xsd:" + ((QName)object).getLocalPart();
                }
            }
            if (object2 != null && !((String)object2).contains(":") && typeInfo.getSchema() == schema && (object = this.getPrefixForNamespace(schema.getTargetNamespace(), schema.getNamespaceResolver())) != null) {
                object2 = (String)object + ":" + (String)object2;
            }
            if (bl2) {
                if (this.helper.isAnnotationPresent(property.getElement(), XmlList.class)) {
                    if (bl3) {
                        // empty if block
                    }
                    object = new SimpleType();
                    string = new List();
                    string.setItemType((String)object2);
                    object.setList((List)string);
                    object5.setSimpleType((SimpleType)object);
                } else {
                    object5.setMaxOccurs("unbounded");
                    object5.setType((String)object2);
                }
            } else {
                object5.setType((String)object2);
            }
            if (!((QName)((Object)list)).getNamespaceURI().equals("")) {
                String string5;
                object = new Element();
                object.setMinOccurs(object5.getMinOccurs());
                object.setMaxOccurs(object5.getMaxOccurs());
                string = this.getSchemaForNamespace(((QName)((Object)list)).getNamespaceURI());
                if (string.getTopLevelElements().get(object5.getName()) == null) {
                    object5.setMinOccurs(null);
                    object5.setMaxOccurs(null);
                    string.getTopLevelElements().put(object5.getName(), object5);
                }
                if (string != schema && !this.importExists(schema, string.getName())) {
                    string5 = new Import();
                    string5.setNamespace(string.getTargetNamespace());
                    string5.setSchemaLocation(string.getName());
                    schema.getImports().add(string5);
                    schema.getNamespaceResolver().put(schema.getNamespaceResolver().generatePrefix(), string.getTargetNamespace());
                }
                if ((string5 = this.getPrefixForNamespace(string.getTargetNamespace(), schema.getNamespaceResolver())) == null) {
                    object.setRef(object5.getName());
                } else {
                    object.setRef(string5 + ":" + object5.getName());
                }
                object6.addElement((Element)object);
                continue;
            }
            object6.addElement((Element)object5);
        }
    }

    public QName getSchemaTypeFor(JavaClass javaClass) {
        QName qName = this.userDefinedSchemaTypes.get(javaClass.getQualifiedName());
        if (qName == null) {
            qName = (QName)this.helper.getXMLToJavaTypeMap().get(javaClass.getRawName());
        }
        if (qName == null) {
            return XMLConstants.ANY_SIMPLE_TYPE_QNAME;
        }
        return qName;
    }

    public void populateSchemaTypes() {
        for (String string : this.typeInfo.keySet()) {
            TypeInfo typeInfo = this.typeInfo.get(string);
            if (!typeInfo.isComplexType()) continue;
            ComplexType complexType = typeInfo.getComplexType();
            TypeDefParticle typeDefParticle = typeInfo.getCompositor();
            String[] stringArray = typeInfo.getPropOrder();
            if (stringArray.length == 0 || stringArray[0].equals("")) {
                stringArray = typeInfo.getPropertyNames().toArray(new String[typeInfo.getPropertyNames().size()]);
            }
            ArrayList<Property> arrayList = new ArrayList<Property>(stringArray.length);
            for (int i = 0; i < stringArray.length; ++i) {
                Property property = typeInfo.getProperties().get(stringArray[i]);
                arrayList.add(property);
            }
            this.addToSchemaType(arrayList, typeDefParticle, complexType, typeInfo.getSchema());
        }
    }

    public String getSchemaTypeNameForClassName(String string) {
        String string2 = Introspector.decapitalize(string.substring(string.lastIndexOf(46) + 1));
        return string2;
    }

    public ArrayList getEnumerationFacetsFor(EnumTypeInfo enumTypeInfo) {
        Collection<String> collection = enumTypeInfo.getObjectValuesToFieldValues().values();
        return new ArrayList<String>(collection);
    }

    public Property getXmlValueFieldForSimpleContent(ArrayList<Property> arrayList) {
        boolean bl = false;
        boolean bl2 = false;
        Property property = null;
        for (Property property2 : arrayList) {
            if (this.helper.isAnnotationPresent(property2.getElement(), XmlValue.class)) {
                bl = true;
                property = property2;
                continue;
            }
            if (this.helper.isAnnotationPresent(property2.getElement(), XmlAttribute.class) || this.helper.isAnnotationPresent(property2.getElement(), XmlTransient.class) || this.helper.isAnnotationPresent(property2.getElement(), XmlAnyAttribute.class)) continue;
            bl2 = true;
        }
        if (bl && !bl2) {
            return property;
        }
        return null;
    }

    public boolean isCollectionType(Property property) {
        JavaClass javaClass = property.getType();
        return this.helper.getJavaClass(Collection.class).isAssignableFrom(javaClass) || this.helper.getJavaClass(java.util.List.class).isAssignableFrom(javaClass) || this.helper.getJavaClass(Set.class).isAssignableFrom(javaClass);
    }

    private Schema getSchemaForNamespace(String string) {
        Schema schema;
        if (this.schemaForNamespace == null) {
            this.schemaForNamespace = new HashMap();
        }
        if ((schema = this.schemaForNamespace.get(string)) == null) {
            NamespaceInfo namespaceInfo = this.getNamespaceInfoForNamespace(string);
            schema = new Schema();
            schema.setName("schema" + this.schemaCount + ".xsd");
            ++this.schemaCount;
            if (!string.equals("")) {
                schema.setTargetNamespace(string);
                String string2 = null;
                if (namespaceInfo != null) {
                    string2 = namespaceInfo.getNamespaceResolver().resolveNamespaceURI(string);
                }
                if (string2 == null) {
                    string2 = schema.getNamespaceResolver().generatePrefix();
                }
                schema.getNamespaceResolver().put(string2, string);
            }
            if (namespaceInfo != null) {
                schema.setAttributeFormDefault(namespaceInfo.isAttributeFormQualified());
                schema.setElementFormDefault(namespaceInfo.isElementFormQualified());
            }
            this.schemaForNamespace.put(string, schema);
        }
        return schema;
    }

    public Collection<Schema> getAllSchemas() {
        if (this.schemaForNamespace == null) {
            this.schemaForNamespace = new HashMap();
        }
        return this.schemaForNamespace.values();
    }

    public NamespaceInfo getNamespaceInfoForNamespace(String string) {
        Collection<NamespaceInfo> collection = this.packageToNamespaceMappings.values();
        for (NamespaceInfo namespaceInfo : collection) {
            if (!namespaceInfo.getNamespace().equals(string)) continue;
            return namespaceInfo;
        }
        return null;
    }

    public String getPrefixForNamespace(String string, NamespaceResolver namespaceResolver) {
        Enumeration enumeration = namespaceResolver.getPrefixes();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            String string3 = namespaceResolver.resolveNamespacePrefix(string2);
            if (!string3.equals(string)) continue;
            return string2;
        }
        return null;
    }

    public void addGlobalElements(HashMap<QName, ElementDeclaration> hashMap) {
        for (QName qName : hashMap.keySet()) {
            String string;
            String string2;
            Object object;
            String string3 = qName.getNamespaceURI();
            Schema schema = this.getSchemaForNamespace(string3);
            Element element = new Element();
            element.setName(qName.getLocalPart());
            ElementDeclaration elementDeclaration = hashMap.get(qName);
            JavaClass javaClass = this.helper.getJavaClass(elementDeclaration.getJavaTypeName());
            QName qName2 = (QName)this.helper.getXMLToJavaTypeMap().get(javaClass.getRawName());
            if (qName2 != null) {
                element.setType("xsd:" + qName2.getLocalPart());
            } else {
                object = this.typeInfo.get(javaClass.getQualifiedName());
                if (object != null) {
                    string2 = null;
                    string2 = ((TypeInfo)object).isComplexType() ? ((TypeInfo)object).getComplexType().getName() : ((TypeInfo)object).getSimpleType().getName();
                    if (((TypeInfo)object).getClassNamespace().equals(string3)) {
                        element.setType(string2);
                    } else {
                        Object object2;
                        string = this.getSchemaForNamespace(((TypeInfo)object).getClassNamespace());
                        String string4 = string.getTargetNamespace();
                        if (string4 == null) {
                            string4 = "";
                        }
                        if (!this.importExists(schema, string.getName())) {
                            object2 = new Import();
                            object2.setNamespace(string.getTargetNamespace());
                            object2.setSchemaLocation(string.getName());
                            schema.getImports().add(object2);
                            if (!string4.equals("")) {
                                schema.getNamespaceResolver().put(schema.getNamespaceResolver().generatePrefix(), string4);
                            }
                        }
                        if ((object2 = schema.getNamespaceResolver().resolveNamespaceURI(string.getTargetNamespace())) != null) {
                            element.setType((String)object2 + ":" + string2);
                        } else {
                            element.setType(string2);
                        }
                    }
                }
            }
            if (elementDeclaration.getSubstitutionHead() != null) {
                object = elementDeclaration.getSubstitutionHead().getLocalPart();
                string2 = elementDeclaration.getSubstitutionHead().getNamespaceURI();
                string = this.getPrefixForNamespace(string2, schema.getNamespaceResolver());
                if (string == null || string.equals("")) {
                    element.setSubstitutionGroup((String)object);
                } else {
                    element.setSubstitutionGroup(string + ":" + (String)object);
                }
            }
            schema.addTopLevelElement(element);
            object = this.schemaTypeInfo.get(javaClass.getQualifiedName());
            if (object == null) {
                object = new SchemaTypeInfo();
                ((SchemaTypeInfo)object).setSchemaTypeName(qName2);
                this.schemaTypeInfo.put(javaClass.getQualifiedName(), (SchemaTypeInfo)object);
            }
            ((SchemaTypeInfo)object).getGlobalElementDeclarations().add(qName);
        }
    }

    public HashMap<String, SchemaTypeInfo> getSchemaTypeInfo() {
        return this.schemaTypeInfo;
    }

    private boolean importExists(Schema schema, String string) {
        java.util.List list = schema.getImports();
        for (int i = 0; i < list.size(); ++i) {
            Import import_ = (Import)list.get(i);
            if (import_.getSchemaLocation() == null || !import_.getSchemaLocation().equals(string)) continue;
            return true;
        }
        return false;
    }
}

