/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl;

import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.Member;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.Sortable;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.Type;

public class Method
extends Member
implements Sortable {
    public static final int IN = 1;
    public static final int OUT = 2;
    public static final int INOUT = 3;
    public static final int RETURN = 4;
    public static final int ALL = 0;
    protected Type m_returnType;
    protected Type[] m_paramTypes;
    protected String[] m_paramNames;
    protected int[] m_paramModes;
    protected boolean[] m_paramDefaults;
    protected boolean m_hasDefault;
    protected boolean m_keepMethodName = false;
    protected String m_overloadNumber;

    public Method(String string, String string2, int n, Type type, Type[] typeArray, String[] stringArray, int[] nArray, boolean[] blArray, int n2) {
        super(string, n);
        this.m_returnType = type;
        this.m_overloadNumber = string2;
        if (n2 > -1 && typeArray != null && stringArray != null && nArray != null && blArray != null) {
            this.m_paramTypes = new Type[n2];
            this.m_paramNames = new String[n2];
            this.m_paramModes = new int[n2];
            this.m_paramDefaults = new boolean[n2];
            this.m_hasDefault = false;
            for (int i = 0; i < n2; ++i) {
                this.m_paramModes[i] = nArray[i];
                this.m_paramNames[i] = stringArray[i];
                this.m_paramTypes[i] = typeArray[i];
                this.m_paramDefaults[i] = blArray[i];
                if (!this.m_paramDefaults[i]) continue;
                this.m_hasDefault = true;
            }
        }
    }

    public Type getReturnType() {
        return this.m_returnType;
    }

    public String[] getParamNames() {
        return this.m_paramNames;
    }

    public Type[] getParamTypes() {
        return this.m_paramTypes;
    }

    public int[] getParamModes() {
        return this.m_paramModes;
    }

    public boolean[] getParamDefaults() {
        return this.m_paramDefaults;
    }

    public boolean hasDefault() {
        return this.m_hasDefault;
    }

    public String getSqlStatement() {
        return null;
    }

    public String toString() {
        String string = this.m_returnType + " " + this.m_name + "(";
        for (int i = 0; i < this.m_paramTypes.length; ++i) {
            string = string + this.m_paramTypes[i].toString() + " " + this.m_paramNames[i].toString();
            if (i >= this.m_paramTypes.length - 1) continue;
            string = string + ",";
        }
        string = string + ");";
        return string;
    }

    public boolean keepMethodName() {
        return this.m_keepMethodName;
    }

    public void setKeepMethodName(boolean bl) {
        this.m_keepMethodName = bl;
    }

    @Override
    public String getSortingKey() {
        int n;
        String string = this.m_name;
        if (this.m_overloadNumber != null) {
            for (n = 0; n < 6 - this.m_overloadNumber.length(); ++n) {
                string = string + "9";
            }
            string = string + this.m_overloadNumber;
        }
        for (n = 0; n < this.m_paramTypes.length; ++n) {
            if (n > 0) {
                string = string + ",";
            }
            string = string + this.m_paramTypes[n].getName();
        }
        return string;
    }
}

