/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.JavaName;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.LangName;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.Name;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.SqlReflector;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.SqlType;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.Type;

public class SqlName
extends Name {
    static String m_defaultSchema;
    static int m_case;
    static int m_targetLang;
    protected boolean m_fromDB;
    private boolean m_contextFromIntype;
    private int m_line = 0;
    private int m_column = 0;
    private boolean m_quoted;
    private boolean m_printAsIs;
    protected String m_sourceName;
    protected boolean m_isRowType = false;
    protected boolean m_isReused = false;
    private boolean m_predefined = false;
    private Boolean m_hasConversion;
    private String m_convertOutOf;
    private String m_convertInto;
    private String m_convertOutOfQualified;
    private String m_convertIntoQualified;
    private static int m_sql2PLCounter;
    private static int m_pl2SQLCounter;
    public static final String ROWTYPE = "ROWTYPE";
    public static final String ROWTYPE_PL = "ROWTYPE_PL";
    public static final String ROWTYPE_SQL = "ROWTYPE_SQL";
    private static int m_rowtypeDistinguisher;
    private static final String PUBLIC = "PUBLIC.";

    public SqlName(String string, String string2, boolean bl, int n, int n2, SqlReflector sqlReflector) {
        this(string, string2, bl, n, n2, false, false, null, null, null, sqlReflector);
    }

    public SqlName(String string, String string2, boolean bl, SqlReflector sqlReflector) {
        this(string, string2, bl, 0, 0, false, false, null, null, null, sqlReflector);
    }

    SqlName(String string, String string2) {
        this(null, string, true, true, true, null, null, string2, null);
    }

    public SqlName(String string, String string2, boolean bl, boolean bl2, boolean bl3, String string3, String string4, String string5, SqlReflector sqlReflector) {
        this(string, string2, bl, 0, 0, bl2, bl3, string3, string4, string5, sqlReflector);
    }

    protected SqlName(String string, String string2, boolean bl, int n, int n2, boolean bl2, boolean bl3, String string3, String string4, String string5, SqlReflector sqlReflector) {
        super(SqlName.massageSchema(string, bl, bl3, sqlReflector), bl ? string2 : sqlReflector.getViewCache().dbifyName(string2));
        if (this.m_context == null) {
            this.m_context = "";
        }
        this.m_fromDB = bl;
        this.m_contextFromIntype = string != null && !bl;
        this.m_line = n;
        this.m_column = n2;
        this.m_quoted = SqlName.isQuoted(string2);
        this.m_printAsIs = bl2;
        this.m_predefined = bl3;
        this.m_convertOutOf = string4;
        this.m_convertInto = string3;
        if (string5 != null) {
            this.m_sourceName = this.m_name;
            this.m_name = string5;
        } else {
            this.m_sourceName = this.m_name;
        }
        this.m_convertOutOfQualified = string4;
        this.m_convertIntoQualified = string3;
    }

    public SqlName(String string, String string2, boolean bl, int n, int n2, String string3, SqlType sqlType, SqlReflector sqlReflector) {
        this(string, null, bl, n, n2, false, false, null, null, null, sqlReflector);
        this.m_sourceName = string2;
        if ((this.m_context == null || this.m_context.equals("")) && string2.indexOf(46) >= 0) {
            this.m_context = string2.substring(0, string2.indexOf(46));
            this.m_sourceName = string2.substring(string2.indexOf(46) + 1);
        }
        String[] stringArray = new String[]{this.m_sourceName};
        boolean[] blArray = new boolean[]{this.m_isRowType};
        this.m_name = SqlName.determineSqlName(string3, stringArray, sqlType, blArray, sqlReflector);
        this.m_sourceName = stringArray[0];
        this.m_isRowType = blArray[0];
        this.m_name = this.m_fromDB ? this.m_name : SqlName.dbifyName(this.m_name, sqlReflector);
    }

    public static String interfaceIfPossible(SqlName sqlName, boolean bl) {
        if (bl && sqlName.hasUseItf()) {
            return sqlName.getUseItf();
        }
        if (sqlName.hasUseClass()) {
            return sqlName.getUseClass();
        }
        if (bl && sqlName.hasDeclItf()) {
            return sqlName.getDeclItf();
        }
        return sqlName.getDeclClass();
    }

    public static String determineSqlName(String string, String[] stringArray, Type type, boolean[] blArray, SqlReflector sqlReflector) {
        Object object;
        String string2 = null;
        if (type != null && (object = (SqlName)type.getNameObject()) != null) {
            string2 = SqlName.interfaceIfPossible((SqlName)object, true).toUpperCase();
        }
        object = stringArray[0];
        sqlReflector.addAllGeneratedTypeNames((String)object);
        if (((String)object).indexOf(46) >= 0 && string2 != null) {
            object = string2 + "_" + ((String)object).substring(((String)object).indexOf(46) + 1);
            sqlReflector.addAllGeneratedTypeNames(string2);
        }
        object = ((String)object).replace('.', '_').replace(' ', '_');
        boolean bl = false;
        if (stringArray[0].equals("PL/SQL RECORD")) {
            blArray[0] = true;
            stringArray[0] = ROWTYPE_PL + m_rowtypeDistinguisher++;
            object = ROWTYPE_SQL;
            if (string != null && !string.equals("")) {
                object = string2 != null ? string2 + "_" + (String)object : string + "_" + (String)object;
            }
            bl = true;
        }
        return sqlReflector.determineSqlName((String)object, bl);
    }

    public static void initStaticVariables() {
        SqlName.setDefaultSchema("");
        m_rowtypeDistinguisher = 0;
        m_sql2PLCounter = 0;
        m_pl2SQLCounter = 0;
    }

    public String getSchemaName() {
        return this.m_context;
    }

    public String getTypeName() {
        return this.m_sourceName;
    }

    public String getTargetTypeName() {
        if (this.m_name.equals("TIMESTAMP WITH LOCAL TZ")) {
            return "TIMESTAMP WITH LOCAL TIME ZONE";
        }
        if (this.m_name.equals("TIMESTAMP WITH TZ")) {
            return "TIMESTAMP WITH TIME ZONE";
        }
        return this.m_name;
    }

    public String getFullTargetTypeName(int n) {
        return this.getFullTypeName(this.getTargetTypeName(), n);
    }

    @Override
    public String getUseClass(String string) {
        return ((JavaName)this.getLangName()).getUseClass(string);
    }

    @Override
    public String getUseClass() {
        return ((JavaName)this.getLangName()).getUseClass();
    }

    @Override
    public String getUseClass(boolean bl) {
        return ((JavaName)this.getLangName()).getUseClass(bl);
    }

    @Override
    public String getUsePackage() {
        return ((JavaName)this.getLangName()).getUsePackage();
    }

    @Override
    public boolean hasUseClass() {
        return ((JavaName)this.getLangName()).hasUseClass();
    }

    @Override
    public String getUseItf() {
        return ((JavaName)this.getLangName()).getUseItf();
    }

    public String getUseItf(String string) {
        return ((JavaName)this.getLangName()).getUseItf(string);
    }

    @Override
    public String getUseItfPackage() {
        return ((JavaName)this.getLangName()).getUseItfPackage();
    }

    @Override
    public boolean hasUseItf() {
        return this.getUseItf() != null;
    }

    @Override
    public boolean hasDeclItf() {
        return this.getDeclItf() != null;
    }

    public boolean getFromDB() {
        return this.m_fromDB;
    }

    public int getLine() {
        return this.m_line;
    }

    public int getColumn() {
        return this.m_column;
    }

    public boolean isQuoted() {
        return this.m_quoted;
    }

    public static boolean isQuoted(String string) {
        return string != null && string.startsWith("\"") && string.endsWith("\"");
    }

    @Override
    public String getDeclClass() {
        return this.getLangName().getDeclClass();
    }

    @Override
    public String getDeclPackage() {
        return this.getLangName().getDeclPackage();
    }

    public String getDeclClass(String string) {
        return ((JavaName)this.getLangName()).getDeclClass(string);
    }

    @Override
    public String getDeclItf() {
        return ((JavaName)this.getLangName()).getDeclItf();
    }

    public String getDeclItf(String string) {
        return ((JavaName)this.getLangName()).getDeclItf(string);
    }

    @Override
    public String getDeclItfPackage() {
        return ((JavaName)this.getLangName()).getDeclItfPackage();
    }

    public LangName getLangName() {
        LangName langName = (LangName)this.getAnnotation();
        if (langName == null) {
            langName = this.setLangName("", null, null, null, null, null, null, null, true);
        }
        return langName;
    }

    public LangName setLangName(String string, String string2, String string3, String string4, String string5, String string6, SqlType sqlType, String string7, boolean bl) {
        LangName langName = (LangName)this.getAnnotation();
        if (langName == null) {
            if (string2 == null) {
                string2 = SqlName.sqlIdToJavaId(this.m_name, true);
            }
            langName = new JavaName(string, string2, string3, string4, string5);
            this.setAnnotation(langName);
        }
        return langName;
    }

    @Override
    public String toString() {
        String string;
        String string2 = this.m_sourceName.equals("") ? "<top-level scope>" : (string = this.m_printAsIs || this.m_sourceName.indexOf(".") < 0 ? this.m_sourceName : "\"" + this.m_sourceName + "\"");
        if (this.m_context != "") {
            String string3 = this.m_printAsIs || this.m_context.indexOf(".") < 0 ? this.m_context : "\"" + this.m_context + "\"";
            string = string3 + "." + string;
        }
        return this.stripPublic(string);
    }

    public String toQuotedString(boolean bl) {
        return "\"" + this.toString(bl) + "\"";
    }

    private String toString(boolean bl) {
        if (!this.m_context.equals(m_defaultSchema)) {
            bl = false;
        }
        String string = null;
        string = bl || this.m_context == null || this.m_context.equals("") ? this.getTargetTypeName() : this.m_context + "." + this.getTargetTypeName();
        return this.stripPublic(string);
    }

    public String getQuotedSimpleName() {
        return (this.m_quoted ? "\"" : "") + this.getSimpleName() + (this.m_quoted ? "\"" : "");
    }

    public static void setDefaultSchema(String string) {
        m_defaultSchema = string;
    }

    public static void setCase(int n) {
        m_case = n;
    }

    public static int getCase() {
        return m_case;
    }

    public static void setTargetLang(int n) {
        m_targetLang = n;
    }

    public static int getTargetLang() {
        return m_targetLang;
    }

    public static boolean langIsOtt() {
        return false;
    }

    public static boolean langIsC() {
        return false;
    }

    public static boolean langIsCpp() {
        return false;
    }

    public static boolean containsLowerChar(String string) {
        for (char c : string.toCharArray()) {
            if (!Character.isLetterOrDigit(c) || !Character.isLowerCase(c)) continue;
            return true;
        }
        return false;
    }

    public static String sqlIdToJavaId(String string, boolean bl) {
        return SqlName.sqlIdToJavaId(string, bl, false);
    }

    public static String sqlIdToJavaId(String string, boolean bl, boolean bl2) {
        if (string.equals("__return")) {
            return "_return";
        }
        boolean bl3 = false;
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        if (m_case == 4) {
            for (int i = 0; i < n; ++i) {
                char c = cArray[i];
                if (Character.isLetterOrDigit(c)) {
                    cArray[n2++] = bl ? Character.toTitleCase(c) : Character.toLowerCase(c);
                    bl = false;
                    continue;
                }
                bl = true;
            }
        } else {
            for (int i = 0; i < n; ++i) {
                char c = cArray[i];
                if (Character.isJavaIdentifierPart(c)) {
                    switch (m_case) {
                        case 2: {
                            cArray[n2] = Character.toUpperCase(c);
                            break;
                        }
                        case 3: {
                            cArray[n2] = Character.toLowerCase(c);
                            break;
                        }
                        case 5: {
                            if (Character.isUpperCase(c)) {
                                cArray[n2] = Character.toLowerCase(c);
                                break;
                            }
                            if (!Character.isLowerCase(c)) break;
                            cArray[n2] = Character.toUpperCase(c);
                            break;
                        }
                        default: {
                            cArray[n2] = c;
                        }
                    }
                    ++n2;
                    continue;
                }
                bl3 = true;
            }
        }
        if (n2 == 0 || bl3) {
            // empty if block
        }
        return new String(cArray, 0, n2);
    }

    public static boolean isAlpha(char c) {
        String string = new String("abcdefghijklmnopqrstuvwxyz");
        char[] cArray = string.toCharArray();
        c = Character.toLowerCase(c);
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            if (cArray[i] != c) continue;
            return true;
        }
        return false;
    }

    private static String massageSchema(String string, boolean bl, boolean bl2, SqlReflector sqlReflector) {
        if (string == null) {
            string = "";
        }
        if (bl2) {
            string = string.length() > 0 ? sqlReflector.getViewCache().dbifyName(string) : string;
        } else if (!bl) {
            string = string.length() > 0 ? sqlReflector.getViewCache().dbifyName(string) : m_defaultSchema;
        }
        return string;
    }

    @Override
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof SqlName)) {
            return false;
        }
        SqlName sqlName = (SqlName)object;
        boolean bl = this.m_context == null || sqlName.m_context == null || this.m_context.equals("") || sqlName.m_context.equals("") ? this.m_sourceName.equalsIgnoreCase(sqlName.m_sourceName) : this.m_context.equalsIgnoreCase(sqlName.m_context) && this.m_sourceName.equalsIgnoreCase(sqlName.m_sourceName);
        return bl;
    }

    @Override
    public int hashCode() {
        return this.m_sourceName.hashCode();
    }

    public boolean isRowType() {
        return this.m_isRowType;
    }

    public boolean isPredefined() {
        return this.m_predefined;
    }

    public boolean hasConversion() {
        if (this.m_hasConversion == null) {
            this.m_hasConversion = new Boolean(this.getIntoConversion() != null || this.getOutOfConversion() != null);
        }
        return this.m_hasConversion;
    }

    public String getOutOfConversion() {
        if (this.m_name.equals(this.m_sourceName)) {
            return null;
        }
        if (this.isPredefined()) {
            return this.m_convertOutOf;
        }
        if (this.m_convertOutOf != null) {
            return this.m_convertOutOf;
        }
        this.m_convertOutOf = "PL_TO_SQL" + m_pl2SQLCounter++;
        return this.m_convertOutOf;
    }

    public String getIntoConversion() {
        if (this.m_name.equals(this.m_sourceName)) {
            return null;
        }
        if (this.isPredefined()) {
            return this.m_convertInto;
        }
        if (this.m_convertInto != null) {
            return this.m_convertInto;
        }
        this.m_convertInto = "SQL_TO_PL" + m_sql2PLCounter++;
        return this.m_convertInto;
    }

    public String getOutOfConversionQualified() {
        if (this.getOutOfConversion() == null) {
            return null;
        }
        return this.m_convertOutOfQualified;
    }

    public String getIntoConversionQualified() {
        if (this.getIntoConversion() == null) {
            return null;
        }
        return this.m_convertIntoQualified;
    }

    public String getFullTypeName(int n) {
        return this.getFullTypeName(this.getTypeName(), n);
    }

    private String getFullTypeName(String string, int n) {
        String string2 = null;
        string2 = this.m_context != null && !this.m_context.equals("") && this.m_contextFromIntype ? this.m_context + "." + string : string;
        return this.stripPublic(string2);
    }

    public boolean isReused() {
        return this.m_isReused;
    }

    public static String dbifyName(String string, SqlReflector sqlReflector) {
        if (string == null || string.equals("") || sqlReflector == null || sqlReflector.getConnection() == null) {
            return string;
        }
        return SqlName.dbifyName(string, sqlReflector.getConnection());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String dbifyName(String string, Connection connection) {
        String string2 = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement("SELECT UPPER(:1) AS UPPER_NAME FROM DUAL");
            preparedStatement.setString(1, string);
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                string2 = resultSet.getString(1);
            }
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
            string2 = string;
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
            }
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        String string3 = SqlName.isQuoted(string) ? string.substring(1, string.length() - 1) : (string2 == null ? "" : string2);
        return string3;
    }

    private String stripPublic(String string) {
        if (string.startsWith(PUBLIC)) {
            string = string.substring(PUBLIC.length());
        }
        return string;
    }

    static {
        m_sql2PLCounter = 0;
        m_pl2SQLCounter = 0;
        m_rowtypeDistinguisher = 0;
    }
}

