/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl;

import java.lang.reflect.Array;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.persistence.platform.database.oracle.publisher.PublisherException;
import org.eclipse.persistence.platform.database.oracle.publisher.Util;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.DefaultArgsHolderType;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.Field;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.PlsqlRecordType;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.PlsqlTableType;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.SqlName;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.SqlReflector;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.Type;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.ViewCache;

public class SqlType
extends Type {
    public static final int CODE_OPAQUE = 58;
    public static final int CODE_SQLJTYPE = 108;
    public static final int SQLJTYPE_SQLDATA = 1;
    public static final int SQLJTYPE_CUSTOMDATUM = 2;
    public static final int SQLJTYPE_SERIALIZABLE = 3;
    public static final int SQLJTYPE_ORADATA = 5;
    public static final int SQLJTYPE_BOTH = 6;
    public static final int SQLJTYPE_BOTH8I = 7;
    public static final int ORACLE_TYPES_NCHAR = -72054;
    public static final int ORACLE_TYPES_NCLOB = -72055;
    public static final int ORACLE_TYPES_BOOLEAN = -72056;
    public static final int ORACLE_TYPES_TBD = -72057;
    private Vector m_dependTypes = null;
    static Hashtable m_convFuns = new Hashtable();
    private String m_version;
    protected SqlReflector m_reflector;
    protected ViewCache m_viewCache;
    protected SqlType m_parentType;
    protected boolean m_isReused;

    public SqlName getSqlName() {
        return (SqlName)this.m_name;
    }

    public boolean isRef() {
        return this.getTypecode() == 2006;
    }

    public boolean isCollection() {
        return this.getTypecode() == 2003 || this.getTypecode() == 1995 || this.isPlsqlTable();
    }

    public boolean isPlsqlTable() {
        return this.getTypecode() == -14 || this.getTypecode() == 1991 || this.getTypecode() == 1990;
    }

    public boolean isPlsqlRecord() {
        return this.getTypecode() == 1992;
    }

    public boolean isOpaque() {
        return this.getTypecode() == 2007;
    }

    public boolean isJavaStruct() {
        return this.getTypecode() == 2008;
    }

    public boolean isSqlStatement() {
        return false;
    }

    public int getSqljKind() {
        return 0;
    }

    public boolean isStruct() {
        return this.getTypecode() == 2002;
    }

    public String getVersion() {
        return this.m_version;
    }

    public void setVersion(String string) {
        this.m_version = string;
    }

    public Hashtable getAttributes() {
        return (Hashtable)this.getAnnotation();
    }

    public void addAttribute(String string, String string2) {
        String string3 = this.m_viewCache.dbifyName(string);
        if (string2 == null) {
            string2 = string;
        }
        Hashtable<String, String> hashtable = (Hashtable<String, String>)this.getAnnotation();
        Vector<String> vector = this.getNamedTranslations();
        if (hashtable == null) {
            hashtable = new Hashtable<String, String>();
            this.setAnnotation(hashtable);
        }
        if (vector == null) {
            vector = new Vector<String>();
            this.setNamedTranslations(vector);
        }
        String string4 = hashtable.put(string3, string2);
        vector.addElement(string);
        if (string4 != null) {
            throw new IllegalArgumentException("Redeclaration of field " + string3 + " in " + this + "!");
        }
    }

    protected SqlType(SqlName sqlName, int n, boolean bl, SqlType sqlType, SqlReflector sqlReflector) {
        this(sqlName, n, bl, false, sqlType, sqlReflector);
        this.m_isReused = false;
    }

    SqlType(SqlName sqlName, int n, boolean bl, boolean bl2, SqlType sqlType, SqlReflector sqlReflector) {
        super(sqlName, n, bl2);
        this.m_isReused = false;
        this.m_reflector = sqlReflector;
        if (this.m_reflector != null) {
            this.m_viewCache = this.m_reflector.getViewCache();
        }
        if (sqlName != null && this.m_reflector != null) {
            this.m_reflector.addType(sqlName, this, bl);
        }
        this.m_parentType = sqlType;
    }

    public SqlType(String string, int n) {
        super(new SqlName(null, string, true, false, true, null, null, null, null), n, true);
    }

    SqlType(SqlName sqlName, int n) {
        super(sqlName, n, true);
    }

    boolean dependsOn(SqlType sqlType) {
        if (this.m_dependTypes == null) {
            Object object;
            this.m_dependTypes = new Vector();
            if (this.isPlsqlRecord() || this instanceof DefaultArgsHolderType) {
                try {
                    object = this.getDeclaredFields(true);
                    for (int i = 0; i < ((Field[])object).length; ++i) {
                        SqlType sqlType2 = (SqlType)((Field)object[i]).getType();
                        if (!sqlType2.isPlsqlRecord() && !sqlType2.isPlsqlTable()) continue;
                        this.m_dependTypes.addElement(sqlType2);
                    }
                }
                catch (Exception exception) {
                    System.err.println(exception.getMessage());
                }
            } else if (this instanceof PlsqlTableType) {
                try {
                    object = (SqlType)((PlsqlTableType)this).getComponentType();
                    if (((SqlType)object).isPlsqlRecord() || ((SqlType)object).isPlsqlTable()) {
                        this.m_dependTypes.addElement(object);
                    }
                }
                catch (Exception exception) {
                    System.err.println(exception.getMessage());
                }
            }
        }
        if (this.m_dependTypes.contains(sqlType)) {
            return true;
        }
        for (int i = 0; i < this.m_dependTypes.size(); ++i) {
            if (!((SqlType)this.m_dependTypes.elementAt(i)).dependsOn(sqlType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasConversion() {
        if (this.getSqlName() == null) {
            return false;
        }
        return this.getSqlName().hasConversion();
    }

    public String getTargetTypeName() {
        return this.getSqlName().getTargetTypeName();
    }

    public String getTargetTypeName(int n) {
        return this.getSqlName().getFullTargetTypeName(n);
    }

    public String getTypeName() {
        return this.getSqlName().getTypeName();
    }

    @Override
    public String getOutOfConversion() {
        if (this.getSqlName() == null) {
            return null;
        }
        return this.getSqlName().getOutOfConversion();
    }

    @Override
    public String getIntoConversion() {
        if (this.getSqlName() == null) {
            return null;
        }
        return this.getSqlName().getIntoConversion();
    }

    @Override
    public String getOutOfConversionQualified() {
        if (this.getSqlName() == null) {
            return null;
        }
        return this.getSqlName().getOutOfConversionQualified();
    }

    @Override
    public String getIntoConversionQualified() {
        if (this.getSqlName() == null) {
            return null;
        }
        return this.getSqlName().getIntoConversionQualified();
    }

    public String getSqlTypeDecl() throws SQLException, PublisherException {
        String string = "";
        if (this.isPlsqlRecord() && !this.getSqlName().isReused()) {
            string = string + "CREATE OR REPLACE TYPE " + this.getTargetTypeName() + " AS OBJECT (\n";
            Field[] fieldArray = ((PlsqlRecordType)this).getFields(true);
            for (int i = 0; i < fieldArray.length; ++i) {
                if (i != 0) {
                    string = string + ",\n";
                }
                string = string + "      " + Util.unreserveSql(fieldArray[i].getName()) + " ";
                string = string + fieldArray[i].printTypeWithLength(2);
            }
            string = string + "\n);";
        } else if (this.isPlsqlTable() && !this.getSqlName().isReused()) {
            PlsqlTableType plsqlTableType = (PlsqlTableType)this;
            SqlType sqlType = (SqlType)plsqlTableType.getComponentType();
            string = string + "CREATE OR REPLACE TYPE " + this.getTargetTypeName();
            string = string + " AS TABLE OF ";
            string = string + Util.printTypeWithLength(sqlType.getTargetTypeName(2), plsqlTableType.getElemTypeLength(), plsqlTableType.getElemTypePrecision(), plsqlTableType.getElemTypeScale());
            string = string + ";";
        } else if (this instanceof DefaultArgsHolderType && !this.getSqlName().isReused()) {
            DefaultArgsHolderType defaultArgsHolderType = (DefaultArgsHolderType)this;
            string = string + "CREATE OR REPLACE TYPE " + this.getTypeName() + " AS OBJECT (\n";
            Field field = defaultArgsHolderType.getFields(false)[0];
            string = string + "      " + field.getName() + " ";
            string = string + field.printTypeWithLength();
            string = string + "\n);";
        }
        return string;
    }

    public String getSqlTypeDrop() throws SQLException, PublisherException {
        return this.getSqlName().isReused() ? "" : "DROP TYPE " + this.getTargetTypeName() + " FORCE; \n" + "show errors\n";
    }

    public String getConversionFunDecl() throws PublisherException, SQLException {
        if (!this.hasConversion()) {
            return "";
        }
        String string = "";
        if (this.getSqlName().isRowType()) {
            string = string + "\t-- Redefine a PL/SQL RECORD type originally defined via CURSOR%ROWTYPE\n";
            string = string + "\tTYPE " + this.getTypeName() + " IS RECORD (\n";
            Field[] fieldArray = ((PlsqlRecordType)this).getFields(true);
            for (int i = 0; i < fieldArray.length; ++i) {
                if (i != 0) {
                    string = string + ",\n";
                }
                string = string + "\t\t" + fieldArray[i].getName() + " " + fieldArray[i].printTypeWithLength();
            }
            string = string + ");";
        }
        string = string + "\t-- Declare the conversion functions the PL/SQL type " + this.getTypeName() + "\n" + "\tFUNCTION " + this.getOutOfConversion() + "(aPlsqlItem " + this.getTypeName() + ")\n" + " \tRETURN " + this.getTargetTypeName() + ";\n";
        string = string + "\tFUNCTION " + this.getIntoConversion() + "(aSqlItem " + this.getTargetTypeName() + ")\n" + "\tRETURN " + this.getTypeName() + ";";
        return string;
    }

    public String getConversionPL2SQLFunBody() throws SQLException, PublisherException {
        if (!this.hasConversion()) {
            return "";
        }
        String string = "\tFUNCTION " + this.getOutOfConversion() + "(aPlsqlItem " + this.getTypeName() + ")\n " + "\tRETURN " + this.getTargetTypeName() + " IS \n" + "\taSqlItem " + this.getTargetTypeName() + "; \n" + "\tBEGIN \n" + this.getOutOfConvStmts("\t\t", "aPlsqlItem", "aSqlItem") + "\t\tRETURN aSqlItem;\n" + "\tEND " + this.getOutOfConversion() + ";\n";
        return string;
    }

    public String getConversionSQL2PLFunBody() throws SQLException, PublisherException {
        if (!this.hasConversion()) {
            return "";
        }
        String string = "\tFUNCTION " + this.getIntoConversion() + "(aSqlItem " + this.getTargetTypeName() + ") \n" + "\tRETURN " + this.getTypeName() + " IS \n" + "\taPlsqlItem " + this.getTypeName() + "; \n" + "\tBEGIN \n" + this.getIntoConvStmts("\t\t", "aSqlItem", "aPlsqlItem") + "\t\tRETURN aPlsqlItem;\n" + "\tEND " + this.getIntoConversion() + ";\n";
        return string;
    }

    public String getBothConversions() throws SQLException, PublisherException {
        return this.getConversionSQL2PLFunBody() + this.getConversionPL2SQLFunBody();
    }

    public String getIntoConvStmts(String string, String string2, String string3) throws SQLException, PublisherException {
        if (!this.isPlsqlRecord() && !this.isPlsqlTable()) {
            return string + string3 + "." + this.getName() + " := " + string2 + this.getName() + ";\n";
        }
        String string4 = "";
        if (this.isPlsqlRecord()) {
            Field[] fieldArray = this.getFields(true);
            for (int i = 0; i < Array.getLength(fieldArray); ++i) {
                string4 = string4 + string + string3 + "." + fieldArray[i].getName() + " := " + (fieldArray[i].getType().hasConversion() && fieldArray[i].getType().getIntoConversion() != null ? fieldArray[i].getType().getIntoConversion() + "(" + string2 + "." + Util.unreserveSql(fieldArray[i].getName()) + ");\n" : string2 + "." + Util.unreserveSql(fieldArray[i].getName()) + ";\n");
            }
        } else {
            Type type = ((PlsqlTableType)this).getComponentType();
            if (this.getTypecode() == 1991 || this.getTypecode() == 1990) {
                string4 = string4 + string + string3 + " := " + this.getTypeName() + "();\n";
                string4 = string4 + string + string3 + ".EXTEND" + "(" + string2 + ".COUNT);\n";
            }
            string4 = string4 + string + "IF " + string2 + ".COUNT>0 THEN\n" + string + "FOR I IN 1.." + string2 + ".COUNT LOOP\n" + string + "\t" + string3 + "(I)" + " := " + (type.hasConversion() && type.getIntoConversion() != null ? type.getIntoConversion() + "(" + string2 + "(I)" + ");\n" : string2 + "(I);\n") + string + "END LOOP; \n" + string + "END IF;\n";
        }
        return string4;
    }

    public String getOutOfConvStmts(String string, String string2, String string3) throws SQLException, PublisherException {
        if (!this.isPlsqlRecord() && !this.isPlsqlTable()) {
            return string + string3 + " := " + string2 + ";\n";
        }
        String string4 = "";
        if (this.isPlsqlRecord()) {
            int n;
            Field[] fieldArray = this.getFields(true);
            string4 = string4 + string + string3 + " := " + this.getTargetTypeName() + "(NULL";
            for (n = 1; n < fieldArray.length; ++n) {
                string4 = string4 + ", NULL";
            }
            string4 = string4 + ");\n";
            for (n = 0; n < fieldArray.length; ++n) {
                string4 = string4 + string + string3 + "." + Util.unreserveSql(fieldArray[n].getName()) + " := " + (fieldArray[n].getType().hasConversion() && fieldArray[n].getType().getOutOfConversion() != null ? fieldArray[n].getType().getOutOfConversion() + "(" + string2 + "." + fieldArray[n].getName() + ");\n" : string2 + "." + fieldArray[n].getName() + ";\n");
            }
        } else {
            Type type = ((PlsqlTableType)this).getComponentType();
            string4 = string4 + string + string3 + " := " + this.getTargetTypeName() + "();\n" + string + string3 + ".EXTEND(" + string2 + ".COUNT);\n" + string + "IF " + string2 + ".COUNT>0 THEN\n" + string + "FOR I IN " + string2 + ".FIRST.." + string2 + ".LAST LOOP\n" + string + "\t" + string3 + "(I + 1 - " + string2 + ".FIRST)" + " := " + (type.hasConversion() || type.getOutOfConversion() != null ? type.getOutOfConversion() + "(" + string2 + "(I)" + ");\n" : string2 + "(I);\n") + string + "END LOOP; \n" + string + "END IF; \n";
        }
        return string4;
    }
}

