/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.database.oracle.publisher.viewcache;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.SqlReflector;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.AllMethodParams;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.UserArguments;

public class ParamInfo {
    public String paramName;
    public String paramMode;
    public int paramNo;
    public String paramTypeName;
    public String paramTypeSubname;
    public boolean ncharFormOfUse;
    public String paramTypeOwner;
    public String paramTypeMod;
    public String methodName;
    public String methodNo;
    public int sequence;
    public int dataLength;
    public int dataPrecision;
    public int dataScale;
    public int objectId;

    public ParamInfo(AllMethodParams allMethodParams) throws SQLException {
        this.paramName = allMethodParams.paramName;
        this.paramMode = allMethodParams.paramMode;
        this.paramTypeMod = allMethodParams.paramTypeMod;
        this.paramTypeOwner = allMethodParams.paramTypeOwner;
        this.paramTypeName = allMethodParams.paramTypeName;
        if ("PL/SQL BINARY INTEGER".equalsIgnoreCase(this.paramTypeName)) {
            this.paramTypeName = "BINARY_INTEGER";
        } else if ("PL/SQL BOOLEAN".equalsIgnoreCase(this.paramTypeName)) {
            this.paramTypeName = "BOOLEAN";
        } else if ("PL/SQL PLS INTEGER".equalsIgnoreCase(this.paramTypeName)) {
            this.paramTypeName = "PLS_INTEGER";
        } else if ("PL/SQL LONG".equalsIgnoreCase(this.paramTypeName)) {
            this.paramTypeName = "LONG";
        } else if ("PL/SQL LONG RAW".equalsIgnoreCase(this.paramTypeName)) {
            this.paramTypeName = "LONG RAW";
        } else if ("PL/SQL RAWID".equalsIgnoreCase(this.paramTypeName)) {
            this.paramTypeName = "RAWID";
        } else if ("PL/SQL URAWID".equalsIgnoreCase(this.paramTypeName)) {
            this.paramTypeName = "URAWID";
        }
        this.paramTypeSubname = null;
        this.ncharFormOfUse = false;
        if ("NCHAR_CS".equals(allMethodParams.characterSetName)) {
            this.ncharFormOfUse = true;
        }
        this.methodName = allMethodParams.methodName;
        this.methodNo = allMethodParams.methodNo;
        this.sequence = -1;
        this.dataLength = 0;
        this.dataPrecision = 0;
        this.dataScale = 0;
    }

    public ParamInfo(UserArguments userArguments) throws SQLException {
        this.paramName = userArguments.ARGUMENT_NAME;
        this.paramNo = userArguments.POSITION;
        this.paramMode = userArguments.IN_OUT;
        if ("IN/OUT".equalsIgnoreCase(this.paramMode)) {
            this.paramMode = "IN OUT";
        }
        this.paramTypeMod = "";
        if ("REF".equalsIgnoreCase(userArguments.DATA_TYPE) || "PL/SQL RECORD".equalsIgnoreCase(userArguments.DATA_TYPE) || "PL/SQL TABLE".equalsIgnoreCase(userArguments.DATA_TYPE) || "VARRAY".equalsIgnoreCase(userArguments.DATA_TYPE) || "TABLE".equalsIgnoreCase(userArguments.DATA_TYPE)) {
            this.paramTypeMod = userArguments.DATA_TYPE;
        }
        this.paramTypeOwner = userArguments.TYPE_OWNER;
        if ("PUBLIC".equalsIgnoreCase(this.paramTypeOwner)) {
            this.paramTypeOwner = "SYS";
        }
        this.paramTypeName = userArguments.TYPE_NAME;
        if (SqlReflector.isNull(this.paramTypeName)) {
            this.paramTypeName = userArguments.PLS_TYPE;
        }
        if (SqlReflector.isNull(this.paramTypeName)) {
            this.paramTypeName = userArguments.DATA_TYPE;
        }
        if ("PL/SQL BOOLEAN".equalsIgnoreCase(this.paramTypeName)) {
            this.paramTypeName = "BOOLEAN";
        }
        this.paramTypeSubname = userArguments.TYPE_SUBNAME;
        this.ncharFormOfUse = false;
        if ("NCHAR_CS".equals(userArguments.CHARACTER_SET_NAME)) {
            this.ncharFormOfUse = true;
        }
        this.methodName = userArguments.OBJECT_NAME;
        this.methodNo = userArguments.OVERLOAD;
        this.sequence = userArguments.sequence;
        this.dataLength = userArguments.DATA_LENGTH;
        this.dataPrecision = userArguments.DATA_PRECISION;
        this.dataScale = userArguments.DATA_SCALE;
        this.objectId = userArguments.OBJECT_ID;
    }

    public static ParamInfo[] getParamInfo(Iterator iterator) throws SQLException {
        ArrayList arrayList = new ArrayList();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        return ParamInfo.getParamInfo(arrayList);
    }

    public static ParamInfo[] getParamInfo(ArrayList arrayList) throws SQLException {
        ArrayList<ParamInfo> arrayList2 = new ArrayList<ParamInfo>();
        for (int i = 0; i < arrayList.size(); ++i) {
            Object e = arrayList.get(i);
            if (e instanceof AllMethodParams) {
                arrayList2.add(new ParamInfo((AllMethodParams)e));
                continue;
            }
            arrayList2.add(new ParamInfo((UserArguments)e));
        }
        ParamInfo[] paramInfoArray = new ParamInfo[arrayList2.size()];
        for (int i = 0; i < arrayList2.size(); ++i) {
            paramInfoArray[i] = (ParamInfo)arrayList2.get(i);
        }
        return paramInfoArray;
    }
}

