/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.dbws;

import java.util.ArrayList;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.queries.ListContainerPolicy;
import org.eclipse.persistence.mappings.Association;
import org.eclipse.persistence.mappings.AttributeAccessor;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.mappings.converters.ObjectTypeConverter;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLChoiceCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.tools.dbws.BindingModel;
import org.eclipse.persistence.tools.dbws.DBWSBuilderModel;
import org.eclipse.persistence.tools.dbws.PLSQLProcedureOperationModel;
import org.eclipse.persistence.tools.dbws.ProcedureOperationModel;
import org.eclipse.persistence.tools.dbws.SQLOperationModel;
import org.eclipse.persistence.tools.dbws.TableOperationModel;

public class DBWSBuilderModelProject
extends Project {
    protected NamespaceResolver ns;

    public DBWSBuilderModelProject() {
        this.setName("DBWSBuilderModelProject");
        this.ns = new NamespaceResolver();
        this.ns.put("xsd", "http://www.w3.org/2001/XMLSchema");
        this.addDescriptor(this.buildAssociationDescriptor());
        this.addDescriptor(this.buildDBWSBuilderModelDescriptor());
        this.addDescriptor(this.buildTableOperationModelDescriptor());
        this.addDescriptor(this.buildProcedureOperationModelDescriptor());
        this.addDescriptor(this.buildPLSQLProcedureOperationModelDescriptor());
        this.addDescriptor(this.buildSQLOperationModelDescriptor());
        this.addDescriptor(this.buildBindingModelDescriptor());
        for (XMLDescriptor xMLDescriptor : this.getDescriptors().values()) {
            xMLDescriptor.setNamespaceResolver(this.ns);
        }
    }

    protected ClassDescriptor buildAssociationDescriptor() {
        XMLDescriptor xMLDescriptor = new XMLDescriptor();
        xMLDescriptor.setJavaClass(Association.class);
        xMLDescriptor.setDefaultRootElement("property");
        XMLDirectMapping xMLDirectMapping = new XMLDirectMapping();
        xMLDirectMapping.setAttributeName("key");
        xMLDirectMapping.setXPath("@name");
        xMLDescriptor.addMapping((DatabaseMapping)xMLDirectMapping);
        XMLDirectMapping xMLDirectMapping2 = new XMLDirectMapping();
        xMLDirectMapping2.setAttributeName("value");
        xMLDirectMapping2.setXPath("text()");
        xMLDescriptor.addMapping((DatabaseMapping)xMLDirectMapping2);
        return xMLDescriptor;
    }

    protected ClassDescriptor buildDBWSBuilderModelDescriptor() {
        XMLDescriptor xMLDescriptor = new XMLDescriptor();
        xMLDescriptor.setJavaClass(DBWSBuilderModel.class);
        xMLDescriptor.setDefaultRootElement("dbws-builder");
        XMLCompositeCollectionMapping xMLCompositeCollectionMapping = new XMLCompositeCollectionMapping();
        xMLCompositeCollectionMapping.setReferenceClass(Association.class);
        xMLCompositeCollectionMapping.setAttributeAccessor(new AttributeAccessor(){

            public String getAttributeName() {
                return "properties";
            }

            public Object getAttributeValueFromObject(Object object) throws DescriptorException {
                DBWSBuilderModel dBWSBuilderModel = (DBWSBuilderModel)object;
                Vector<Association> vector = new Vector<Association>();
                for (Map.Entry<String, String> entry : dBWSBuilderModel.properties.entrySet()) {
                    vector.add(new Association((Object)entry.getKey(), (Object)entry.getValue()));
                }
                return vector;
            }

            public void setAttributeValueInObject(Object object, Object object2) throws DescriptorException {
                DBWSBuilderModel dBWSBuilderModel = (DBWSBuilderModel)object;
                Vector vector = (Vector)object2;
                for (Association association : vector) {
                    dBWSBuilderModel.properties.put((String)association.getKey(), (String)association.getValue());
                }
            }
        });
        xMLCompositeCollectionMapping.setXPath("properties/property");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeCollectionMapping);
        XMLChoiceCollectionMapping xMLChoiceCollectionMapping = new XMLChoiceCollectionMapping();
        xMLChoiceCollectionMapping.setAttributeName("operations");
        xMLChoiceCollectionMapping.setContainerPolicy((ContainerPolicy)new ListContainerPolicy(ArrayList.class));
        xMLChoiceCollectionMapping.addChoiceElement("table", TableOperationModel.class);
        xMLChoiceCollectionMapping.addChoiceElement("procedure", ProcedureOperationModel.class);
        xMLChoiceCollectionMapping.addChoiceElement("plsql-procedure", PLSQLProcedureOperationModel.class);
        xMLChoiceCollectionMapping.addChoiceElement("sql", SQLOperationModel.class);
        xMLDescriptor.addMapping((DatabaseMapping)xMLChoiceCollectionMapping);
        return xMLDescriptor;
    }

    protected ClassDescriptor buildTableOperationModelDescriptor() {
        XMLDescriptor xMLDescriptor = new XMLDescriptor();
        xMLDescriptor.setJavaClass(TableOperationModel.class);
        XMLDirectMapping xMLDirectMapping = new XMLDirectMapping();
        xMLDirectMapping.setAttributeName("name");
        xMLDirectMapping.setXPath("@name");
        xMLDescriptor.addMapping((DatabaseMapping)xMLDirectMapping);
        ObjectTypeConverter objectTypeConverter = new ObjectTypeConverter();
        objectTypeConverter.addConversionValue((Object)"true", (Object)Boolean.TRUE);
        objectTypeConverter.addConversionValue((Object)"false", (Object)Boolean.FALSE);
        objectTypeConverter.setFieldClassification(String.class);
        XMLDirectMapping xMLDirectMapping2 = new XMLDirectMapping();
        xMLDirectMapping2.setAttributeName("simpleXMLFormatTag");
        xMLDirectMapping2.setGetMethodName("getSimpleXMLFormatTag");
        xMLDirectMapping2.setSetMethodName("setSimpleXMLFormatTag");
        xMLDirectMapping2.setXPath("@simpleXMLFormatTag");
        xMLDescriptor.addMapping((DatabaseMapping)xMLDirectMapping2);
        XMLDirectMapping xMLDirectMapping3 = new XMLDirectMapping();
        xMLDirectMapping3.setAttributeName("xmlTag");
        xMLDirectMapping3.setGetMethodName("getXmlTag");
        xMLDirectMapping3.setSetMethodName("setXmlTag");
        xMLDirectMapping3.setXPath("@xmlTag");
        xMLDescriptor.addMapping((DatabaseMapping)xMLDirectMapping3);
        XMLDirectMapping xMLDirectMapping4 = new XMLDirectMapping();
        xMLDirectMapping4.setAttributeName("isCollection");
        xMLDirectMapping4.setConverter((Converter)objectTypeConverter);
        xMLDirectMapping4.setNullValue((Object)Boolean.FALSE);
        xMLDirectMapping4.setXPath("@isCollection");
        xMLDescriptor.addMapping((DatabaseMapping)xMLDirectMapping4);
        XMLDirectMapping xMLDirectMapping5 = new XMLDirectMapping();
        xMLDirectMapping5.setAttributeName("binaryAttachment");
        xMLDirectMapping5.setConverter((Converter)objectTypeConverter);
        xMLDirectMapping5.setNullValue((Object)Boolean.FALSE);
        xMLDirectMapping5.setXPath("@binaryAttachment");
        xMLDescriptor.addMapping((DatabaseMapping)xMLDirectMapping5);
        XMLDirectMapping xMLDirectMapping6 = new XMLDirectMapping();
        xMLDirectMapping6.setAttributeName("returnType");
        xMLDirectMapping6.setXPath("@returnType");
        xMLDescriptor.addMapping((DatabaseMapping)xMLDirectMapping6);
        XMLDirectMapping xMLDirectMapping7 = new XMLDirectMapping();
        xMLDirectMapping7.setAttributeName("catalogPattern");
        xMLDirectMapping7.setXPath("@catalogPattern");
        xMLDescriptor.addMapping((DatabaseMapping)xMLDirectMapping7);
        XMLDirectMapping xMLDirectMapping8 = new XMLDirectMapping();
        xMLDirectMapping8.setAttributeName("schemaPattern");
        xMLDirectMapping8.setXPath("@schemaPattern");
        xMLDescriptor.addMapping((DatabaseMapping)xMLDirectMapping8);
        XMLDirectMapping xMLDirectMapping9 = new XMLDirectMapping();
        xMLDirectMapping9.setAttributeName("tablePattern");
        xMLDirectMapping9.setXPath("@tableNamePattern");
        xMLDescriptor.addMapping((DatabaseMapping)xMLDirectMapping9);
        XMLChoiceCollectionMapping xMLChoiceCollectionMapping = new XMLChoiceCollectionMapping();
        xMLChoiceCollectionMapping.setAttributeName("additionalOperations");
        xMLChoiceCollectionMapping.setContainerPolicy((ContainerPolicy)new ListContainerPolicy(ArrayList.class));
        xMLChoiceCollectionMapping.addChoiceElement("procedure", ProcedureOperationModel.class);
        xMLChoiceCollectionMapping.addChoiceElement("plsql-procedure", PLSQLProcedureOperationModel.class);
        xMLChoiceCollectionMapping.addChoiceElement("sql", SQLOperationModel.class);
        xMLDescriptor.addMapping((DatabaseMapping)xMLChoiceCollectionMapping);
        return xMLDescriptor;
    }

    protected ClassDescriptor buildProcedureOperationModelDescriptor() {
        XMLDescriptor xMLDescriptor = new XMLDescriptor();
        xMLDescriptor.setJavaClass(ProcedureOperationModel.class);
        xMLDescriptor.setDefaultRootElement("procedure");
        XMLDirectMapping xMLDirectMapping = new XMLDirectMapping();
        xMLDirectMapping.setAttributeName("name");
        xMLDirectMapping.setXPath("@name");
        xMLDescriptor.addMapping((DatabaseMapping)xMLDirectMapping);
        XMLDirectMapping xMLDirectMapping2 = new XMLDirectMapping();
        xMLDirectMapping2.setAttributeName("simpleXMLFormatTag");
        xMLDirectMapping2.setGetMethodName("getSimpleXMLFormatTag");
        xMLDirectMapping2.setSetMethodName("setSimpleXMLFormatTag");
        xMLDirectMapping2.setXPath("@simpleXMLFormatTag");
        xMLDescriptor.addMapping((DatabaseMapping)xMLDirectMapping2);
        XMLDirectMapping xMLDirectMapping3 = new XMLDirectMapping();
        xMLDirectMapping3.setAttributeName("xmlTag");
        xMLDirectMapping3.setGetMethodName("getXmlTag");
        xMLDirectMapping3.setSetMethodName("setXmlTag");
        xMLDirectMapping3.setXPath("@xmlTag");
        xMLDescriptor.addMapping((DatabaseMapping)xMLDirectMapping3);
        ObjectTypeConverter objectTypeConverter = new ObjectTypeConverter();
        objectTypeConverter.addConversionValue((Object)"true", (Object)Boolean.TRUE);
        objectTypeConverter.addConversionValue((Object)"false", (Object)Boolean.FALSE);
        objectTypeConverter.setFieldClassification(String.class);
        XMLDirectMapping xMLDirectMapping4 = new XMLDirectMapping();
        xMLDirectMapping4.setAttributeName("isCollection");
        xMLDirectMapping4.setConverter((Converter)objectTypeConverter);
        xMLDirectMapping4.setNullValue((Object)Boolean.FALSE);
        xMLDirectMapping4.setXPath("@isCollection");
        xMLDescriptor.addMapping((DatabaseMapping)xMLDirectMapping4);
        XMLDirectMapping xMLDirectMapping5 = new XMLDirectMapping();
        xMLDirectMapping5.setAttributeName("isSimpleXMLFormat");
        xMLDirectMapping5.setConverter((Converter)objectTypeConverter);
        xMLDirectMapping5.setNullValue((Object)Boolean.FALSE);
        xMLDirectMapping5.setXPath("@isSimpleXMLFormat");
        xMLDescriptor.addMapping((DatabaseMapping)xMLDirectMapping5);
        XMLDirectMapping xMLDirectMapping6 = new XMLDirectMapping();
        xMLDirectMapping6.setAttributeName("binaryAttachment");
        xMLDirectMapping6.setConverter((Converter)objectTypeConverter);
        xMLDirectMapping6.setNullValue((Object)Boolean.FALSE);
        xMLDirectMapping6.setXPath("@binaryAttachment");
        xMLDescriptor.addMapping((DatabaseMapping)xMLDirectMapping6);
        XMLDirectMapping xMLDirectMapping7 = new XMLDirectMapping();
        xMLDirectMapping7.setAttributeName("returnType");
        xMLDirectMapping7.setXPath("@returnType");
        xMLDescriptor.addMapping((DatabaseMapping)xMLDirectMapping7);
        XMLDirectMapping xMLDirectMapping8 = new XMLDirectMapping();
        xMLDirectMapping8.setAttributeName("catalogPattern");
        xMLDirectMapping8.setXPath("@catalogPattern");
        xMLDescriptor.addMapping((DatabaseMapping)xMLDirectMapping8);
        XMLDirectMapping xMLDirectMapping9 = new XMLDirectMapping();
        xMLDirectMapping9.setAttributeName("schemaPattern");
        xMLDirectMapping9.setXPath("@schemaPattern");
        xMLDescriptor.addMapping((DatabaseMapping)xMLDirectMapping9);
        XMLDirectMapping xMLDirectMapping10 = new XMLDirectMapping();
        xMLDirectMapping10.setAttributeName("procedurePattern");
        xMLDirectMapping10.setXPath("@procedurePattern");
        xMLDescriptor.addMapping((DatabaseMapping)xMLDirectMapping10);
        return xMLDescriptor;
    }

    protected ClassDescriptor buildPLSQLProcedureOperationModelDescriptor() {
        XMLDescriptor xMLDescriptor = (XMLDescriptor)this.buildProcedureOperationModelDescriptor();
        xMLDescriptor.setJavaClass(PLSQLProcedureOperationModel.class);
        xMLDescriptor.setDefaultRootElement("plsql-procedure");
        return xMLDescriptor;
    }

    protected ClassDescriptor buildSQLOperationModelDescriptor() {
        XMLDescriptor xMLDescriptor = new XMLDescriptor();
        xMLDescriptor.setJavaClass(SQLOperationModel.class);
        xMLDescriptor.setDefaultRootElement("sql");
        XMLDirectMapping xMLDirectMapping = new XMLDirectMapping();
        xMLDirectMapping.setAttributeName("name");
        xMLDirectMapping.setXPath("@name");
        xMLDescriptor.addMapping((DatabaseMapping)xMLDirectMapping);
        ObjectTypeConverter objectTypeConverter = new ObjectTypeConverter();
        objectTypeConverter.addConversionValue((Object)"true", (Object)Boolean.TRUE);
        objectTypeConverter.addConversionValue((Object)"false", (Object)Boolean.FALSE);
        objectTypeConverter.setFieldClassification(String.class);
        XMLDirectMapping xMLDirectMapping2 = new XMLDirectMapping();
        xMLDirectMapping2.setAttributeName("simpleXMLFormatTag");
        xMLDirectMapping2.setGetMethodName("getSimpleXMLFormatTag");
        xMLDirectMapping2.setSetMethodName("setSimpleXMLFormatTag");
        xMLDirectMapping2.setXPath("@simpleXMLFormatTag");
        xMLDescriptor.addMapping((DatabaseMapping)xMLDirectMapping2);
        XMLDirectMapping xMLDirectMapping3 = new XMLDirectMapping();
        xMLDirectMapping3.setAttributeName("xmlTag");
        xMLDirectMapping3.setGetMethodName("getXmlTag");
        xMLDirectMapping3.setSetMethodName("setXmlTag");
        xMLDirectMapping3.setXPath("@xmlTag");
        xMLDescriptor.addMapping((DatabaseMapping)xMLDirectMapping3);
        XMLDirectMapping xMLDirectMapping4 = new XMLDirectMapping();
        xMLDirectMapping4.setAttributeName("isCollection");
        xMLDirectMapping4.setConverter((Converter)objectTypeConverter);
        xMLDirectMapping4.setNullValue((Object)Boolean.FALSE);
        xMLDirectMapping4.setXPath("@isCollection");
        xMLDescriptor.addMapping((DatabaseMapping)xMLDirectMapping4);
        XMLDirectMapping xMLDirectMapping5 = new XMLDirectMapping();
        xMLDirectMapping5.setAttributeName("binaryAttachment");
        xMLDirectMapping5.setConverter((Converter)objectTypeConverter);
        xMLDirectMapping5.setNullValue((Object)Boolean.FALSE);
        xMLDirectMapping5.setXPath("@binaryAttachment");
        xMLDescriptor.addMapping((DatabaseMapping)xMLDirectMapping5);
        XMLDirectMapping xMLDirectMapping6 = new XMLDirectMapping();
        xMLDirectMapping6.setAttributeName("returnType");
        xMLDirectMapping6.setXPath("@returnType");
        xMLDescriptor.addMapping((DatabaseMapping)xMLDirectMapping6);
        XMLDirectMapping xMLDirectMapping7 = new XMLDirectMapping();
        xMLDirectMapping7.setAttributeName("sqlText");
        xMLDirectMapping7.setXPath("text/text()");
        xMLDirectMapping7.setIsCDATA(true);
        xMLDescriptor.addMapping((DatabaseMapping)xMLDirectMapping7);
        XMLCompositeCollectionMapping xMLCompositeCollectionMapping = new XMLCompositeCollectionMapping();
        xMLCompositeCollectionMapping.setAttributeName("bindings");
        xMLCompositeCollectionMapping.setReferenceClass(BindingModel.class);
        xMLCompositeCollectionMapping.setContainerPolicy((ContainerPolicy)new ListContainerPolicy(ArrayList.class));
        xMLCompositeCollectionMapping.setXPath("binding");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeCollectionMapping);
        return xMLDescriptor;
    }

    protected ClassDescriptor buildBindingModelDescriptor() {
        XMLDescriptor xMLDescriptor = new XMLDescriptor();
        xMLDescriptor.setJavaClass(BindingModel.class);
        xMLDescriptor.setDefaultRootElement("binding");
        XMLDirectMapping xMLDirectMapping = new XMLDirectMapping();
        xMLDirectMapping.setAttributeName("name");
        xMLDirectMapping.setXPath("@name");
        xMLDescriptor.addMapping((DatabaseMapping)xMLDirectMapping);
        XMLDirectMapping xMLDirectMapping2 = new XMLDirectMapping();
        xMLDirectMapping2.setAttributeName("type");
        xMLDirectMapping2.setXPath("@type");
        xMLDescriptor.addMapping((DatabaseMapping)xMLDirectMapping2);
        return xMLDescriptor;
    }
}

