/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.dbws.oracle;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.persistence.internal.databaseaccess.DatabasePlatform;
import org.eclipse.persistence.platform.database.oracle.publisher.MethodFilter;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.Method;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.Name;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.SqlName;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.SqlReflector;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.SqlTypeWithMethods;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.Type;
import org.eclipse.persistence.tools.dbws.DBWSBuilder;
import org.eclipse.persistence.tools.dbws.Util;
import org.eclipse.persistence.tools.dbws.jdbc.DbStoredArgument;
import org.eclipse.persistence.tools.dbws.jdbc.DbStoredFunction;
import org.eclipse.persistence.tools.dbws.jdbc.DbStoredProcedure;
import org.eclipse.persistence.tools.dbws.oracle.PLSQLStoredArgument;

public class OracleHelper {
    public static List<DbStoredProcedure> buildStoredProcedure(Connection connection, String string, DatabasePlatform databasePlatform, String string2, String string3, String string4, DBWSBuilder dBWSBuilder) {
        ArrayList<DbStoredProcedure> arrayList = null;
        String string5 = Util.escapePunctuation(string2, true);
        String string6 = Util.escapePunctuation(string3, true);
        final String string7 = Util.escapePunctuation(string4, true);
        if (string6 == null || string6.length() == 0) {
            string6 = string;
        }
        SqlReflector sqlReflector = new SqlReflector(connection, string);
        try {
            SqlTypeWithMethods sqlTypeWithMethods = (SqlTypeWithMethods)sqlReflector.addSqlUserType(string6, string5, 4, true, 0, 0, new MethodFilter(){

                @Override
                public boolean acceptMethod(Method method, boolean bl) {
                    String string = method.getName();
                    return Util.sqlMatch(string7, string);
                }
            });
            Method[] methodArray = sqlTypeWithMethods.getDeclaredMethods();
            if (methodArray.length > 0) {
                dBWSBuilder.setSqlType(sqlTypeWithMethods);
                arrayList = new ArrayList<DbStoredProcedure>();
                for (Method method : methodArray) {
                    String string8;
                    DbStoredProcedure dbStoredProcedure = null;
                    Type type = method.getReturnType();
                    if (type == null) {
                        dbStoredProcedure = new DbStoredProcedure(method.getName());
                    } else {
                        dbStoredProcedure = new DbStoredFunction(method.getName());
                        DbStoredArgument dbStoredArgument = new DbStoredArgument(type.getName());
                        dbStoredArgument.setInOut(Util.InOut.RETURN);
                        dbStoredArgument.setSeq(0);
                        dbStoredArgument.setJdbcType(type.getJdbcTypecode());
                        Name name = type.getNameObject();
                        string8 = name instanceof SqlName ? ((SqlName)name).getTypeName() : name.getSimpleName();
                        dbStoredArgument.setJdbcTypeName(string8);
                        ((DbStoredFunction)dbStoredProcedure).setReturnArg(dbStoredArgument);
                    }
                    dbStoredProcedure.setCatalog(string5);
                    dbStoredProcedure.setSchema(string3);
                    int n = method.getParamNames().length;
                    for (int i = 0; i < n; ++i) {
                        string8 = method.getParamNames()[i];
                        Type type2 = method.getParamTypes()[i];
                        DbStoredArgument dbStoredArgument = null;
                        dbStoredArgument = type2.isPrimitive() ? new DbStoredArgument(string8) : new PLSQLStoredArgument(string8);
                        int n2 = method.getParamModes()[i];
                        Util.InOut inOut = Util.InOut.IN;
                        if (n2 == 2) {
                            inOut = Util.InOut.OUT;
                        } else if (n2 == 3) {
                            inOut = Util.InOut.INOUT;
                        }
                        dbStoredArgument.setInOut(inOut);
                        dbStoredArgument.setSeq(i);
                        dbStoredArgument.setJdbcType(type2.getJdbcTypecode());
                        Name name = type2.getNameObject();
                        String string9 = name instanceof SqlName ? ((SqlName)name).getTypeName() : name.getSimpleName();
                        if (type2.isPrimitive()) {
                            dbStoredArgument.setJdbcTypeName(string9);
                        } else {
                            PLSQLStoredArgument pLSQLStoredArgument = (PLSQLStoredArgument)dbStoredArgument;
                            pLSQLStoredArgument.setPlSqlTypeName(string9);
                            pLSQLStoredArgument.setJdbcTypeName(name.getSimpleName());
                        }
                        dbStoredProcedure.getArguments().add(dbStoredArgument);
                    }
                    arrayList.add(dbStoredProcedure);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return arrayList;
    }

    public static QName getXMLTypeFromJDBCType(DbStoredArgument dbStoredArgument, String string) {
        if (2003 == dbStoredArgument.getJdbcType() || 2002 == dbStoredArgument.getJdbcType()) {
            return new QName(string, dbStoredArgument.getJdbcTypeName());
        }
        return Util.getXMLTypeFromJDBCType(dbStoredArgument.getJdbcType());
    }
}

