/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.descriptors;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;

public class InterfacePolicy
implements Serializable {
    protected Vector parentInterfaces;
    protected Vector parentInterfaceNames;
    protected Vector parentDescriptors;
    protected Vector childDescriptors = NonSynchronizedVector.newInstance();
    protected ClassDescriptor descriptor;
    protected Class implementorDescriptor;
    protected String implementorDescriptorClassName;

    public InterfacePolicy() {
        this.parentInterfaces = NonSynchronizedVector.newInstance(2);
        this.parentInterfaceNames = NonSynchronizedVector.newInstance(2);
        this.parentDescriptors = NonSynchronizedVector.newInstance(2);
    }

    public InterfacePolicy(ClassDescriptor classDescriptor) {
        this();
        this.descriptor = classDescriptor;
    }

    public void addChildDescriptor(ClassDescriptor classDescriptor) {
        this.getChildDescriptors().addElement(classDescriptor);
    }

    public void addParentDescriptor(ClassDescriptor classDescriptor) {
        this.getParentDescriptors().addElement(classDescriptor);
    }

    public void addParentInterface(Class clazz) {
        this.getParentInterfaces().addElement(clazz);
    }

    public void addParentInterfaceName(String string) {
        this.getParentInterfaceNames().addElement(string);
    }

    public Vector getChildDescriptors() {
        return this.childDescriptors;
    }

    protected ClassDescriptor getDescriptor() {
        return this.descriptor;
    }

    public Class getImplementorDescriptor() {
        return this.implementorDescriptor;
    }

    public String getImplementorDescriptorClassName() {
        if (this.implementorDescriptorClassName == null && this.implementorDescriptor != null) {
            this.implementorDescriptorClassName = this.implementorDescriptor.getName();
        }
        return this.implementorDescriptorClassName;
    }

    public Vector getParentDescriptors() {
        return this.parentDescriptors;
    }

    public Vector getParentInterfaces() {
        return this.parentInterfaces;
    }

    public Vector getParentInterfaceNames() {
        if (this.parentInterfaceNames.isEmpty() && !this.parentInterfaces.isEmpty()) {
            for (int i = 0; i < this.parentInterfaces.size(); ++i) {
                this.parentInterfaceNames.addElement(((Class)this.parentInterfaces.elementAt(i)).getName());
            }
        }
        return this.parentInterfaceNames;
    }

    public void initialize(AbstractSession abstractSession) {
    }

    public boolean isInterfaceChildDescriptor() {
        return this.parentInterfaces != null && !this.parentInterfaces.isEmpty() || this.parentInterfaceNames != null && !this.parentInterfaceNames.isEmpty();
    }

    public boolean isTablePerClassPolicy() {
        return false;
    }

    protected Object selectAllObjects(ReadAllQuery readAllQuery) {
        ReadAllQuery readAllQuery2 = (ReadAllQuery)readAllQuery.deepClone();
        readAllQuery2.setReferenceClass(this.descriptor.getJavaClass());
        readAllQuery2.setDescriptor(this.descriptor);
        readAllQuery2.setIsExecutionClone(true);
        readAllQuery2.getExpressionBuilder().setQueryClassAndDescriptor(this.descriptor.getJavaClass(), this.descriptor);
        if (readAllQuery2.getQueryMechanism().getSelectionCriteria() != null) {
            readAllQuery2.getQueryMechanism().getSelectionCriteria().getBuilder().setQueryClassAndDescriptor(this.descriptor.getJavaClass(), this.descriptor);
            return readAllQuery.getSession().executeQuery((DatabaseQuery)readAllQuery2, readAllQuery.getTranslationRow());
        }
        return readAllQuery.getSession().executeQuery(readAllQuery2);
    }

    public Object selectAllObjectsUsingMultipleTableSubclassRead(ReadAllQuery readAllQuery) throws DatabaseException {
        ContainerPolicy containerPolicy = readAllQuery.getContainerPolicy();
        Object object = containerPolicy.containerInstance(1);
        Enumeration enumeration = this.getChildDescriptors().elements();
        while (enumeration.hasMoreElements()) {
            ClassDescriptor classDescriptor = (ClassDescriptor)enumeration.nextElement();
            object = containerPolicy.concatenateContainers(object, classDescriptor.getInterfacePolicy().selectAllObjects(readAllQuery));
        }
        return object;
    }

    protected Object selectOneObject(ReadObjectQuery readObjectQuery) throws DescriptorException {
        ReadObjectQuery readObjectQuery2 = (ReadObjectQuery)readObjectQuery.clone();
        Class clazz = this.descriptor.getJavaClass();
        readObjectQuery2.setReferenceClass(clazz);
        readObjectQuery2.setDescriptor(this.descriptor);
        return readObjectQuery.getSession().executeQuery((DatabaseQuery)readObjectQuery2, readObjectQuery2.getTranslationRow());
    }

    public Object selectOneObjectUsingMultipleTableSubclassRead(ReadObjectQuery readObjectQuery) throws DatabaseException, QueryException {
        Object object = null;
        Enumeration enumeration = this.getChildDescriptors().elements();
        while (enumeration.hasMoreElements() && object == null) {
            ClassDescriptor classDescriptor = (ClassDescriptor)enumeration.nextElement();
            object = classDescriptor.getInterfacePolicy().selectOneObject(readObjectQuery);
        }
        return object;
    }

    public void setDescriptor(ClassDescriptor classDescriptor) {
        this.descriptor = classDescriptor;
    }

    public void setImplementorDescriptor(Class clazz) {
        this.implementorDescriptor = clazz;
    }

    public void setImplementorDescriptorClassName(String string) {
        this.implementorDescriptorClassName = string;
    }

    public void setParentInterfaces(Vector vector) {
        this.parentInterfaces = vector;
    }

    public void setParentInterfaceNames(Vector vector) {
        this.parentInterfaceNames = vector;
    }

    public boolean usesImplementorDescriptor() {
        return this.implementorDescriptor != null;
    }
}

