/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.expressions;

import java.util.Enumeration;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.expressions.SQLSelectStatement;
import org.eclipse.persistence.internal.expressions.SubSelectExpression;
import org.eclipse.persistence.internal.sessions.AbstractSession;

public class ExpressionNormalizer {
    protected Expression additionalExpression;
    protected SQLSelectStatement statement;
    protected Vector subSelectExpressions;
    protected AbstractSession session;

    public ExpressionNormalizer(SQLSelectStatement sQLSelectStatement) {
        this.statement = sQLSelectStatement;
    }

    public void addAdditionalExpression(Expression expression) {
        this.additionalExpression = this.additionalExpression == null ? expression : this.additionalExpression.and(expression);
    }

    public void addSubSelectExpression(SubSelectExpression subSelectExpression) {
        if (this.subSelectExpressions == null) {
            this.subSelectExpressions = new Vector(1);
        }
        this.subSelectExpressions.add(subSelectExpression);
    }

    public Expression getAdditionalExpression() {
        return this.additionalExpression;
    }

    public AbstractSession getSession() {
        return this.session;
    }

    public SQLSelectStatement getStatement() {
        return this.statement;
    }

    public boolean encounteredSubSelectExpressions() {
        return this.subSelectExpressions != null;
    }

    public void normalizeSubSelects(Map map) {
        Enumeration enumeration = this.subSelectExpressions.elements();
        while (enumeration.hasMoreElements()) {
            SubSelectExpression subSelectExpression = (SubSelectExpression)enumeration.nextElement();
            subSelectExpression.normalizeSubSelect(this, map);
        }
    }

    public void setAdditionalExpression(Expression expression) {
        this.additionalExpression = expression;
    }

    public void setSession(AbstractSession abstractSession) {
        this.session = abstractSession;
    }

    public void setStatement(SQLSelectStatement sQLSelectStatement) {
        this.statement = sQLSelectStatement;
    }
}

