/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.helper;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Vector;
import org.eclipse.persistence.exceptions.ValidationException;

public class ThreadCursoredList
extends Vector {
    protected boolean isComplete = false;
    protected RuntimeException exception;

    public ThreadCursoredList() {
        this(10);
    }

    public ThreadCursoredList(int n) {
        this(n, 0);
    }

    public ThreadCursoredList(int n, int n2) {
        super(0);
    }

    public synchronized void add(int n, Object object) {
        super.add(n, object);
        this.notifyAll();
    }

    public synchronized boolean add(Object object) {
        boolean bl = super.add(object);
        this.notifyAll();
        return bl;
    }

    public synchronized boolean addAll(int n, Collection collection) {
        boolean bl = super.addAll(n, collection);
        this.notifyAll();
        return bl;
    }

    public synchronized boolean addAll(Collection collection) {
        boolean bl = super.addAll(collection);
        this.notifyAll();
        return bl;
    }

    public synchronized void addElement(Object object) {
        super.addElement(object);
        this.notifyAll();
    }

    public synchronized void clear() {
        this.waitUntilComplete();
        super.clear();
    }

    public synchronized Object clone() {
        this.waitUntilComplete();
        return super.clone();
    }

    public boolean hasException() {
        return this.getException() != null;
    }

    public RuntimeException getException() {
        return this.exception;
    }

    public synchronized void throwException(RuntimeException runtimeException) {
        this.exception = runtimeException;
        this.setIsComplete(true);
    }

    public synchronized boolean isComplete() {
        if (this.hasException()) {
            RuntimeException runtimeException = this.exception;
            this.exception = null;
            throw runtimeException;
        }
        return this.isComplete;
    }

    public synchronized void setIsComplete(boolean bl) {
        this.isComplete = bl;
        this.notifyAll();
    }

    public synchronized void waitUntilComplete() {
        while (!this.isComplete()) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public synchronized void waitUntilAdd() {
        try {
            this.wait();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public synchronized boolean contains(Object object) {
        boolean bl = super.contains(object);
        if (!bl && !this.isComplete()) {
            this.waitUntilComplete();
            bl = super.contains(object);
        }
        return bl;
    }

    public synchronized boolean containsAll(Collection collection) {
        boolean bl = super.containsAll(collection);
        if (!bl && !this.isComplete()) {
            this.waitUntilComplete();
            bl = super.containsAll(collection);
        }
        return bl;
    }

    public synchronized void copyInto(Object[] objectArray) {
        this.waitUntilComplete();
        super.copyInto(objectArray);
    }

    public synchronized Object elementAt(int n) {
        Object e = super.elementAt(n);
        if (e == null && !this.isComplete()) {
            this.waitUntilComplete();
            e = super.elementAt(n);
        }
        return e;
    }

    protected int getSize() {
        return super.size();
    }

    public Enumeration elements() {
        return new Enumeration(){
            int count = 0;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean hasMoreElements() {
                ThreadCursoredList threadCursoredList = ThreadCursoredList.this;
                synchronized (threadCursoredList) {
                    boolean bl;
                    boolean bl2 = bl = this.count < ThreadCursoredList.this.getSize();
                    while (!bl && !ThreadCursoredList.this.isComplete()) {
                        ThreadCursoredList.this.waitUntilAdd();
                        bl = this.count < ThreadCursoredList.this.getSize();
                    }
                    return bl;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object nextElement() {
                ThreadCursoredList threadCursoredList = ThreadCursoredList.this;
                synchronized (threadCursoredList) {
                    boolean bl;
                    boolean bl2 = bl = this.count < ThreadCursoredList.this.getSize();
                    while (!bl && !ThreadCursoredList.this.isComplete()) {
                        ThreadCursoredList.this.waitUntilAdd();
                        bl = this.count < ThreadCursoredList.this.getSize();
                    }
                    if (bl) {
                        return ThreadCursoredList.this.get(this.count++);
                    }
                }
                throw new NoSuchElementException("Vector Enumeration");
            }
        };
    }

    public synchronized boolean equals(Object object) {
        this.waitUntilComplete();
        return super.equals(object);
    }

    public synchronized Object firstElement() {
        while (!this.isComplete() && super.size() < 1) {
            this.waitUntilAdd();
        }
        return super.firstElement();
    }

    public synchronized Object get(int n) {
        while (!this.isComplete() && super.size() < n) {
            this.waitUntilAdd();
        }
        return super.get(n);
    }

    public synchronized int hashCode() {
        this.waitUntilComplete();
        return super.hashCode();
    }

    public int indexOf(Object object) {
        int n = super.indexOf(object);
        if (n == -1 && !this.isComplete()) {
            this.waitUntilComplete();
            n = super.indexOf(object);
        }
        return n;
    }

    public synchronized int indexOf(Object object, int n) {
        int n2 = super.indexOf(object, n);
        if (n2 == -1 && !this.isComplete()) {
            this.waitUntilComplete();
            n2 = super.indexOf(object, n);
        }
        return n2;
    }

    public synchronized void insertElementAt(Object object, int n) {
        super.insertElementAt(object, n);
        this.notify();
    }

    public boolean isEmpty() {
        boolean bl = super.isEmpty();
        if (bl && !this.isComplete()) {
            this.waitUntilAdd();
            bl = super.isEmpty();
        }
        return bl;
    }

    public Iterator iterator() {
        throw ValidationException.operationNotSupported("iterator");
    }

    public synchronized Object lastElement() {
        this.waitUntilComplete();
        return super.lastElement();
    }

    public int lastIndexOf(Object object) {
        this.waitUntilComplete();
        return super.lastIndexOf(object);
    }

    public synchronized int lastIndexOf(Object object, int n) {
        this.waitUntilComplete();
        return super.lastIndexOf(object, n);
    }

    public ListIterator listIterator() {
        throw ValidationException.operationNotSupported("iterator");
    }

    public ListIterator listIterator(int n) {
        throw ValidationException.operationNotSupported("iterator");
    }

    public synchronized Object remove(int n) {
        while (!this.isComplete() && super.size() < n) {
            this.waitUntilAdd();
        }
        return super.remove(n);
    }

    public boolean remove(Object object) {
        boolean bl = super.remove(object);
        if (!bl && !this.isComplete()) {
            this.waitUntilAdd();
            bl = super.remove(object);
        }
        return bl;
    }

    public synchronized boolean removeAll(Collection collection) {
        this.waitUntilComplete();
        return super.removeAll(collection);
    }

    public synchronized void removeAllElements() {
        this.waitUntilComplete();
        super.removeAllElements();
    }

    public synchronized boolean removeElement(Object object) {
        boolean bl = super.removeElement(object);
        if (!bl && !this.isComplete()) {
            this.waitUntilAdd();
            bl = super.removeElement(object);
        }
        return bl;
    }

    public synchronized void removeElementAt(int n) {
        while (!this.isComplete() && super.size() < n) {
            this.waitUntilAdd();
        }
        super.removeElementAt(n);
    }

    public synchronized boolean retainAll(Collection collection) {
        this.waitUntilComplete();
        return super.retainAll(collection);
    }

    public synchronized Object set(int n, Object object) {
        while (!this.isComplete() && super.size() < n) {
            this.waitUntilAdd();
        }
        return super.set(n, object);
    }

    public synchronized void setElementAt(Object object, int n) {
        while (!this.isComplete() && super.size() < n) {
            this.waitUntilAdd();
        }
        super.setElementAt(object, n);
    }

    public int size() {
        this.waitUntilComplete();
        return super.size();
    }

    public List subList(int n, int n2) {
        while (!this.isComplete() && super.size() < n2) {
            this.waitUntilAdd();
        }
        return super.subList(n, n2);
    }

    public synchronized Object[] toArray() {
        this.waitUntilComplete();
        return super.toArray();
    }

    public synchronized Object[] toArray(Object[] objectArray) {
        this.waitUntilComplete();
        return super.toArray(objectArray);
    }

    public synchronized String toString() {
        this.waitUntilComplete();
        return super.toString();
    }

    public synchronized void trimToSize() {
        this.waitUntilComplete();
        super.trimToSize();
    }
}

