/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.indirection;

import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.util.Map;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.IntegrityChecker;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.ValueHolderInterface;
import org.eclipse.persistence.indirection.WeavedAttributeValueHolderInterface;
import org.eclipse.persistence.internal.descriptors.DescriptorIterator;
import org.eclipse.persistence.internal.indirection.BackupValueHolder;
import org.eclipse.persistence.internal.indirection.BasicIndirectionPolicy;
import org.eclipse.persistence.internal.indirection.BatchValueHolder;
import org.eclipse.persistence.internal.indirection.DatabaseValueHolder;
import org.eclipse.persistence.internal.indirection.ProxyIndirectionHandler;
import org.eclipse.persistence.internal.indirection.QueryBasedValueHolder;
import org.eclipse.persistence.internal.indirection.TransformerBasedValueHolder;
import org.eclipse.persistence.internal.indirection.UnitOfWorkValueHolder;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedNewInstanceFromClass;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.MergeManager;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.internal.sessions.remote.RemoteSessionController;
import org.eclipse.persistence.internal.sessions.remote.RemoteUnitOfWork;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadQuery;
import org.eclipse.persistence.sessions.remote.RemoteSession;

public class ProxyIndirectionPolicy
extends BasicIndirectionPolicy {
    private Class[] targetInterfaces;

    public ProxyIndirectionPolicy(Class[] classArray) {
        this.targetInterfaces = classArray;
    }

    public ProxyIndirectionPolicy() {
        this.targetInterfaces = new Class[0];
    }

    public void initialize() {
    }

    public void reset(Object object) {
    }

    public boolean hasTargetInterfaces() {
        return this.targetInterfaces != null && this.targetInterfaces.length != 0;
    }

    public Object valueFromRow(Object object) {
        ValueHolder valueHolder = new ValueHolder(object);
        return ProxyIndirectionHandler.newProxyInstance(object.getClass(), this.targetInterfaces, valueHolder);
    }

    public Object valueFromQuery(ReadQuery readQuery, AbstractRecord abstractRecord, AbstractSession abstractSession) {
        ClassDescriptor classDescriptor = null;
        try {
            classDescriptor = abstractSession.getDescriptor(readQuery.getReferenceClass());
            if (classDescriptor.isDescriptorForInterface()) {
                classDescriptor = (ClassDescriptor)classDescriptor.getInterfacePolicy().getChildDescriptors().firstElement();
            }
        }
        catch (Exception exception) {
            return null;
        }
        QueryBasedValueHolder queryBasedValueHolder = new QueryBasedValueHolder(readQuery, abstractRecord, abstractSession);
        return ProxyIndirectionHandler.newProxyInstance(classDescriptor.getJavaClass(), this.targetInterfaces, queryBasedValueHolder);
    }

    public Object valueFromMethod(Object object, AbstractRecord abstractRecord, AbstractSession abstractSession) {
        TransformerBasedValueHolder transformerBasedValueHolder = new TransformerBasedValueHolder(this.getTransformationMapping().getAttributeTransformer(), object, abstractRecord, abstractSession);
        return ProxyIndirectionHandler.newProxyInstance(object.getClass(), this.targetInterfaces, transformerBasedValueHolder);
    }

    public Object valueFromBatchQuery(ReadQuery readQuery, AbstractRecord abstractRecord, ObjectLevelReadQuery objectLevelReadQuery) {
        Object object;
        Cloneable cloneable;
        try {
            cloneable = objectLevelReadQuery.getDescriptor();
            if (cloneable.isDescriptorForInterface()) {
                cloneable = (ClassDescriptor)objectLevelReadQuery.getDescriptor().getInterfacePolicy().getChildDescriptors().firstElement();
            }
            object = PrivilegedAccessHelper.shouldUsePrivilegedAccess() ? AccessController.doPrivileged(new PrivilegedNewInstanceFromClass(cloneable.getJavaClass())) : PrivilegedAccessHelper.newInstanceFromClass(cloneable.getJavaClass());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        cloneable = new BatchValueHolder(readQuery, abstractRecord, this.getForeignReferenceMapping(), objectLevelReadQuery);
        return ProxyIndirectionHandler.newProxyInstance(object.getClass(), this.targetInterfaces, (ValueHolderInterface)cloneable);
    }

    public boolean objectIsInstantiated(Object object) {
        if (object instanceof Proxy) {
            ProxyIndirectionHandler proxyIndirectionHandler = (ProxyIndirectionHandler)Proxy.getInvocationHandler(object);
            ValueHolderInterface valueHolderInterface = proxyIndirectionHandler.getValueHolder();
            return valueHolderInterface.isInstantiated();
        }
        return true;
    }

    public Object nullValueFromRow() {
        return null;
    }

    public void mergeRemoteValueHolder(Object object, Object object2, MergeManager mergeManager) {
        this.getMapping().setAttributeValueInObject(object, object2);
    }

    public Object getRealAttributeValueFromObject(Object object, Object object2) {
        if (object2 instanceof Proxy) {
            ProxyIndirectionHandler proxyIndirectionHandler = (ProxyIndirectionHandler)Proxy.getInvocationHandler(object2);
            ValueHolderInterface valueHolderInterface = proxyIndirectionHandler.getValueHolder();
            return valueHolderInterface.getValue();
        }
        return object2;
    }

    public static Object getValueFromProxy(Object object) {
        if (Proxy.isProxyClass(object.getClass())) {
            return ((ProxyIndirectionHandler)Proxy.getInvocationHandler(object)).getValueHolder().getValue();
        }
        return object;
    }

    public void setRealAttributeValueInObject(Object object, Object object2) {
        this.getMapping().setAttributeValueInObject(object, object2);
    }

    public Object getOriginalIndirectionObject(Object object, AbstractSession abstractSession) {
        if (object instanceof UnitOfWorkValueHolder) {
            ValueHolderInterface valueHolderInterface = ((UnitOfWorkValueHolder)object).getWrappedValueHolder();
            if (valueHolderInterface == null && abstractSession.isRemoteUnitOfWork()) {
                RemoteSessionController remoteSessionController = ((RemoteUnitOfWork)abstractSession).getParentSessionController();
                valueHolderInterface = (ValueHolderInterface)remoteSessionController.getRemoteValueHolders().get(((UnitOfWorkValueHolder)object).getWrappedValueHolderRemoteID());
            }
            return valueHolderInterface;
        }
        if (object == null) {
            System.out.println("Debug line");
        }
        return object;
    }

    public void fixObjectReferences(Object object, Map map, Map map2, ObjectLevelReadQuery objectLevelReadQuery, RemoteSession remoteSession) {
    }

    public AbstractRecord extractReferenceRow(Object object) {
        if (object == null || !Proxy.isProxyClass(object.getClass())) {
            return null;
        }
        ProxyIndirectionHandler proxyIndirectionHandler = (ProxyIndirectionHandler)Proxy.getInvocationHandler(object);
        ValueHolderInterface valueHolderInterface = proxyIndirectionHandler.getValueHolder();
        if (valueHolderInterface.isInstantiated()) {
            return null;
        }
        return ((DatabaseValueHolder)valueHolderInterface).getRow();
    }

    public Object cloneAttribute(Object object, Object object2, Object object3, UnitOfWorkImpl unitOfWorkImpl, boolean bl) {
        WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface;
        if (!(object instanceof Proxy)) {
            boolean bl2 = unitOfWorkImpl.isObjectRegistered(object3) && !unitOfWorkImpl.isOriginalNewObject(object2);
            return this.getMapping().buildCloneForPartObject(object, object2, object3, unitOfWorkImpl, bl2);
        }
        ProxyIndirectionHandler proxyIndirectionHandler = (ProxyIndirectionHandler)Proxy.getInvocationHandler(object);
        ValueHolderInterface valueHolderInterface = proxyIndirectionHandler.getValueHolder();
        if (!bl && unitOfWorkImpl.isOriginalNewObject(object2)) {
            if (valueHolderInterface instanceof DatabaseValueHolder && !((DatabaseValueHolder)valueHolderInterface).isInstantiated() && ((DatabaseValueHolder)valueHolderInterface).getSession() == null && !((DatabaseValueHolder)valueHolderInterface).isSerializedRemoteUnitOfWorkValueHolder()) {
                throw DescriptorException.attemptToRegisterDeadIndirection(object2, this.getMapping());
            }
            weavedAttributeValueHolderInterface = new ValueHolder();
            weavedAttributeValueHolderInterface.setValue(this.getMapping().buildCloneForPartObject(valueHolderInterface.getValue(), object2, object3, unitOfWorkImpl, false));
        } else {
            AbstractRecord abstractRecord = null;
            if (valueHolderInterface instanceof DatabaseValueHolder) {
                abstractRecord = ((DatabaseValueHolder)valueHolderInterface).getRow();
            }
            weavedAttributeValueHolderInterface = this.getMapping().createUnitOfWorkValueHolder(valueHolderInterface, object2, object3, abstractRecord, unitOfWorkImpl, bl);
        }
        return ProxyIndirectionHandler.newProxyInstance(object.getClass(), this.targetInterfaces, weavedAttributeValueHolderInterface);
    }

    public Object backupCloneAttribute(Object object, Object object2, Object object3, UnitOfWorkImpl unitOfWorkImpl) {
        if (!(object instanceof Proxy)) {
            return this.getMapping().buildBackupCloneForPartObject(object, object2, object3, unitOfWorkImpl);
        }
        ProxyIndirectionHandler proxyIndirectionHandler = (ProxyIndirectionHandler)Proxy.getInvocationHandler(object);
        ValueHolderInterface valueHolderInterface = proxyIndirectionHandler.getValueHolder();
        ValueHolderInterface valueHolderInterface2 = null;
        if (!(valueHolderInterface instanceof UnitOfWorkValueHolder) || valueHolderInterface.isInstantiated()) {
            valueHolderInterface2 = (ValueHolderInterface)super.backupCloneAttribute(valueHolderInterface, object2, object3, unitOfWorkImpl);
        } else {
            valueHolderInterface2 = new BackupValueHolder(valueHolderInterface);
            ((UnitOfWorkValueHolder)valueHolderInterface).setBackupValueHolder((ValueHolder)valueHolderInterface2);
        }
        return ProxyIndirectionHandler.newProxyInstance(object.getClass(), this.targetInterfaces, valueHolderInterface2);
    }

    public void iterateOnAttributeValue(DescriptorIterator descriptorIterator, Object object) {
        if (object instanceof Proxy) {
            ProxyIndirectionHandler proxyIndirectionHandler = (ProxyIndirectionHandler)Proxy.getInvocationHandler(object);
            ValueHolderInterface valueHolderInterface = proxyIndirectionHandler.getValueHolder();
            descriptorIterator.iterateValueHolderForMapping(valueHolderInterface, this.getMapping());
        } else if (object != null) {
            this.getMapping().iterateOnRealAttributeValue(descriptorIterator, object);
        }
    }

    public Object validateAttributeOfInstantiatedObject(Object object) {
        if (object != null && object.getClass().getInterfaces().length == 0 && object instanceof Proxy) {
            System.err.println("** ProxyIndirection attribute validation failed.");
        }
        return object;
    }

    public void validateDeclaredAttributeType(Class clazz, IntegrityChecker integrityChecker) throws DescriptorException {
        if (!this.isValidType(clazz)) {
            integrityChecker.handleError(DescriptorException.invalidAttributeTypeForProxyIndirection(clazz, this.targetInterfaces, this.getMapping()));
        }
    }

    public void validateGetMethodReturnType(Class clazz, IntegrityChecker integrityChecker) throws DescriptorException {
        if (!this.isValidType(clazz)) {
            integrityChecker.handleError(DescriptorException.invalidGetMethodReturnTypeForProxyIndirection(clazz, this.targetInterfaces, this.getMapping()));
        }
    }

    public void validateSetMethodParameterType(Class clazz, IntegrityChecker integrityChecker) throws DescriptorException {
        if (!this.isValidType(clazz)) {
            integrityChecker.handleError(DescriptorException.invalidSetMethodParameterTypeForProxyIndirection(clazz, this.targetInterfaces, this.getMapping()));
        }
    }

    public boolean isValidType(Class clazz) {
        if (!clazz.isInterface()) {
            return false;
        }
        for (int i = 0; i < this.targetInterfaces.length; ++i) {
            if (clazz != this.targetInterfaces[i]) continue;
            return true;
        }
        return false;
    }
}

