/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.deployment;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import org.eclipse.persistence.internal.jpa.deployment.Archive;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JarFileArchive
implements Archive {
    private JarFile jarFile;
    private URL rootURL;
    private Logger logger;

    public JarFileArchive(JarFile jarFile) throws MalformedURLException {
        this(jarFile, Logger.global);
    }

    public JarFileArchive(JarFile jarFile, Logger logger) throws MalformedURLException {
        logger.entering("JarFileArchive", "JarFileArchive", new Object[]{jarFile});
        this.logger = logger;
        this.jarFile = jarFile;
        this.rootURL = new File(jarFile.getName()).toURI().toURL();
        logger.logp(Level.FINER, "JarFileArchive", "JarFileArchive", "rootURL = {0}", this.rootURL);
    }

    @Override
    public Iterator<String> getEntries() {
        Enumeration<JarEntry> enumeration = this.jarFile.entries();
        ArrayList<String> arrayList = new ArrayList<String>();
        while (enumeration.hasMoreElements()) {
            JarEntry jarEntry = enumeration.nextElement();
            if (jarEntry.isDirectory()) continue;
            arrayList.add(jarEntry.getName());
        }
        return arrayList.iterator();
    }

    @Override
    public InputStream getEntry(String string) throws IOException {
        InputStream inputStream = null;
        ZipEntry zipEntry = this.jarFile.getEntry(string);
        if (zipEntry != null) {
            inputStream = this.jarFile.getInputStream(zipEntry);
        }
        return inputStream;
    }

    @Override
    public URL getEntryAsURL(String string) throws IOException {
        return this.jarFile.getEntry(string) != null ? new URL("jar:" + this.rootURL + "!/" + string) : null;
    }

    @Override
    public URL getRootURL() {
        return this.rootURL;
    }
}

