/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.deployment.osgi.equinox;

import java.security.ProtectionDomain;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Map;
import javax.persistence.spi.ClassTransformer;
import javax.persistence.spi.PersistenceUnitInfo;
import org.eclipse.osgi.baseadaptor.BaseData;
import org.eclipse.osgi.baseadaptor.bundlefile.ZipBundleFile;
import org.eclipse.osgi.baseadaptor.loader.ClasspathEntry;
import org.eclipse.osgi.baseadaptor.loader.ClasspathManager;
import org.eclipse.osgi.framework.adaptor.ClassLoaderDelegate;
import org.eclipse.osgi.internal.baseadaptor.DefaultClassLoader;
import org.eclipse.persistence.internal.jpa.EntityManagerFactoryProvider;
import org.eclipse.persistence.internal.jpa.deployment.JPAInitializer;
import org.eclipse.persistence.internal.jpa.deployment.PersistenceInitializationHelper;
import org.eclipse.persistence.internal.jpa.deployment.osgi.CompositeClassLoader;
import org.eclipse.persistence.internal.jpa.deployment.osgi.equinox.EquinoxWeaver;
import org.eclipse.persistence.jpa.equinox.weaving.IWeaver;
import org.eclipse.persistence.jpa.osgi.Activator;
import org.eclipse.persistence.logging.AbstractSessionLog;

public class EquinoxInitializer
extends JPAInitializer {
    public EquinoxInitializer(ClassLoader classLoader, Map map, PersistenceInitializationHelper persistenceInitializationHelper) {
        this.initializationClassloader = classLoader;
        this.initialize(map, persistenceInitializationHelper);
    }

    public void checkWeaving(Map map) {
        String string = EntityManagerFactoryProvider.getConfigPropertyAsString("eclipselink.weaving", map, null);
        if (string == null) {
            string = "false";
            map.put("eclipselink.weaving", string);
        }
        if (string != null && (string.equalsIgnoreCase("false") || string.equalsIgnoreCase("static"))) {
            this.shouldCreateInternalLoader = false;
        }
    }

    protected ClassLoader createTempLoader(Collection collection) {
        return this.createTempLoader(collection, true);
    }

    protected ClassLoader createTempLoader(Collection collection, boolean bl) {
        if (!this.shouldCreateInternalLoader) {
            return this.initializationClassloader;
        }
        if (this.initializationClassloader instanceof CompositeClassLoader) {
            CompositeClassLoader compositeClassLoader = (CompositeClassLoader)this.initializationClassloader;
            ClassLoader classLoader = compositeClassLoader.getClassLoaders().get(0);
            if (classLoader instanceof DefaultClassLoader) {
                Object object;
                DefaultClassLoader defaultClassLoader = (DefaultClassLoader)classLoader;
                ClassLoaderDelegate classLoaderDelegate = defaultClassLoader.getDelegate();
                ProtectionDomain protectionDomain = defaultClassLoader.getDomain();
                ClasspathManager classpathManager = defaultClassLoader.getClasspathManager();
                ClasspathEntry[] classpathEntryArray = classpathManager.getHostClasspathEntries();
                String[] stringArray = new String[classpathEntryArray.length];
                for (int i = 0; i < classpathEntryArray.length; ++i) {
                    object = classpathEntryArray[i].getBundleFile();
                    stringArray[i] = object instanceof ZipBundleFile ? "." : object.getBaseFile().getAbsolutePath();
                }
                BaseData baseData = classpathManager.getBaseData();
                object = new TempEquinoxEntityLoader((ClassLoader)defaultClassLoader, classLoaderDelegate, protectionDomain, baseData, stringArray, collection, true);
                AbstractSessionLog.getLog().log(2, "cmp_init_tempLoader_created", object);
                AbstractSessionLog.getLog().log(2, "cmp_init_shouldOverrideLoadClassForCollectionMembers", bl);
                return object;
            }
            return compositeClassLoader;
        }
        return this.initializationClassloader;
    }

    public void registerTransformer(ClassTransformer classTransformer, PersistenceUnitInfo persistenceUnitInfo) {
        if (classTransformer != null) {
            AbstractSessionLog.getLog().log(2, "cmp_init_register_transformer", persistenceUnitInfo.getPersistenceUnitName());
            EquinoxWeaver equinoxWeaver = new EquinoxWeaver(classTransformer);
            Activator.getContext().registerService(IWeaver.class.getName(), (Object)equinoxWeaver, new Hashtable());
            AbstractSessionLog.getLog().log(2, "Registering Weaving Service");
        } else if (classTransformer == null) {
            AbstractSessionLog.getLog().log(2, "cmp_init_transformer_is_null");
        }
    }

    private class TempEquinoxEntityLoader
    extends DefaultClassLoader {
        Collection classNames;
        boolean shouldOverrideLoadClassForCollectionMembers;

        public TempEquinoxEntityLoader(ClassLoader classLoader, ClassLoaderDelegate classLoaderDelegate, ProtectionDomain protectionDomain, BaseData baseData, String[] stringArray) {
            super(classLoader, classLoaderDelegate, protectionDomain, baseData, stringArray);
            this.shouldOverrideLoadClassForCollectionMembers = true;
            this.initialize();
        }

        public TempEquinoxEntityLoader(ClassLoader classLoader, ClassLoaderDelegate classLoaderDelegate, ProtectionDomain protectionDomain, BaseData baseData, String[] stringArray, Collection collection, boolean bl) {
            this(classLoader, classLoaderDelegate, protectionDomain, baseData, stringArray);
            this.classNames = collection;
            this.shouldOverrideLoadClassForCollectionMembers = bl;
        }

        protected boolean shouldOverrideLoadClass(String string) {
            if (this.shouldOverrideLoadClassForCollectionMembers) {
                return this.classNames != null && this.classNames.contains(string);
            }
            return !string.startsWith("java.") && !string.startsWith("javax.") && (this.classNames == null || !this.classNames.contains(string));
        }

        protected synchronized Class loadClass(String string, boolean bl) throws ClassNotFoundException {
            if (this.shouldOverrideLoadClass(string)) {
                Class clazz = this.findLoadedClass(string);
                if (clazz == null) {
                    clazz = this.findLocalClass(string);
                }
                if (bl) {
                    this.resolveClass(clazz);
                }
                return clazz;
            }
            return super.loadClass(string, bl);
        }
    }
}

