/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.classes;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import org.eclipse.persistence.exceptions.EntityManagerSetupException;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedGetDeclaredFields;
import org.eclipse.persistence.internal.security.PrivilegedGetDeclaredMethods;
import org.eclipse.persistence.internal.security.PrivilegedGetField;
import org.eclipse.persistence.internal.security.PrivilegedGetMethod;
import org.eclipse.persistence.internal.security.PrivilegedMethodInvoker;

public class MetadataHelper {
    public static final String PERSISTENCE_PACKAGE_PREFIX = "javax.persistence";

    static Method[] getDeclaredMethods(Class clazz) {
        if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
            try {
                return (Method[])AccessController.doPrivileged(new PrivilegedGetDeclaredMethods(clazz));
            }
            catch (PrivilegedActionException privilegedActionException) {
                return null;
            }
        }
        return PrivilegedAccessHelper.getDeclaredMethods(clazz);
    }

    static Field getFieldForName(String string, Class clazz) {
        Field field;
        block5: {
            field = null;
            try {
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        field = (Field)AccessController.doPrivileged(new PrivilegedGetField(clazz, string, false));
                        break block5;
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        return null;
                    }
                }
                field = PrivilegedAccessHelper.getField(clazz, string, false);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                return null;
            }
        }
        return field;
    }

    static Field[] getFields(Class clazz) {
        if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
            try {
                return (Field[])AccessController.doPrivileged(new PrivilegedGetDeclaredFields(clazz));
            }
            catch (PrivilegedActionException privilegedActionException) {
                return null;
            }
        }
        return PrivilegedAccessHelper.getDeclaredFields(clazz);
    }

    static Method getMethod(String string, Class clazz, Class[] classArray) {
        try {
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                try {
                    return AccessController.doPrivileged(new PrivilegedGetMethod(clazz, string, classArray, true));
                }
                catch (PrivilegedActionException privilegedActionException) {
                    return null;
                }
            }
            return PrivilegedAccessHelper.getMethod(clazz, string, classArray, true);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    static Method getMethodForPropertyName(String string, Class clazz) {
        String string2 = String.valueOf(string.charAt(0)).toUpperCase();
        String string3 = string.substring(1);
        Method method = MetadataHelper.getMethod("get".concat(string2).concat(string3), clazz, new Class[0]);
        if (method == null) {
            method = MetadataHelper.getMethod("is".concat(string2).concat(string3), clazz, new Class[0]);
        }
        return method;
    }

    static Object invokeMethod(String string, Object object) {
        Method method = null;
        try {
            method = Helper.getDeclaredMethod(object.getClass(), string);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            EntityManagerSetupException.methodInvocationFailed(method, object, noSuchMethodException);
        }
        if (method != null) {
            try {
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        return AccessController.doPrivileged(new PrivilegedMethodInvoker(method, object));
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        Exception exception = privilegedActionException.getException();
                        if (exception instanceof IllegalAccessException) {
                            throw EntityManagerSetupException.cannotAccessMethodOnObject(method, object);
                        }
                        throw EntityManagerSetupException.methodInvocationFailed(method, object, exception);
                    }
                }
                return PrivilegedAccessHelper.invokeMethod(method, object);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw EntityManagerSetupException.cannotAccessMethodOnObject(method, object);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw EntityManagerSetupException.methodInvocationFailed(method, object, invocationTargetException);
            }
        }
        return null;
    }
}

