/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.mappings;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.persistence.FetchType;
import org.eclipse.persistence.annotations.CollectionTable;
import org.eclipse.persistence.annotations.JoinFetch;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.DirectAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MetadataHelper;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.columns.ColumnMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.PrimaryKeyJoinColumnMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.PrimaryKeyJoinColumnsMetadata;
import org.eclipse.persistence.internal.jpa.metadata.tables.CollectionTableMetadata;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectCollectionMapping;
import org.eclipse.persistence.mappings.converters.Converter;

public class BasicCollectionAccessor
extends DirectAccessor {
    private ColumnMetadata m_valueColumn;
    private CollectionTableMetadata m_collectionTable;
    private Enum m_joinFetch;

    public BasicCollectionAccessor() {
        super("<basic-collection>");
    }

    protected BasicCollectionAccessor(String string) {
        super(string);
    }

    public BasicCollectionAccessor(Annotation annotation, MetadataAccessibleObject metadataAccessibleObject, ClassAccessor classAccessor) {
        super(annotation, metadataAccessibleObject, classAccessor);
        Object t;
        if (annotation != null) {
            this.m_valueColumn = new ColumnMetadata((Annotation)MetadataHelper.invokeMethod("valueColumn", annotation), metadataAccessibleObject, this.getAttributeName());
            this.setFetch((Enum)MetadataHelper.invokeMethod("fetch", annotation));
        }
        if (this.isAnnotationPresent(CollectionTable.class)) {
            this.m_collectionTable = new CollectionTableMetadata((Annotation)this.getAnnotation(CollectionTable.class), metadataAccessibleObject);
        }
        if ((t = this.getAnnotation(JoinFetch.class)) != null) {
            this.m_joinFetch = (Enum)MetadataHelper.invokeMethod("value", t);
        }
    }

    protected CollectionTableMetadata getCollectionTable() {
        return this.m_collectionTable;
    }

    protected ColumnMetadata getColumn(String string) {
        return this.m_valueColumn == null ? new ColumnMetadata(this.getAccessibleObject(), this.getAttributeName()) : this.m_valueColumn;
    }

    protected DatabaseField getDatabaseField(DatabaseTable databaseTable, String string) {
        DatabaseField databaseField = super.getDatabaseField(databaseTable, string);
        if (this.getAccessibleObject().isGenericCollectionType()) {
            databaseField.setType(this.getReferenceClass());
        }
        return databaseField;
    }

    protected String getDefaultCollectionTableName() {
        if (this.m_valueColumn != null && this.m_valueColumn.getTable() != null && !this.m_valueColumn.getTable().equals("")) {
            return this.m_valueColumn.getTable();
        }
        return this.getUpperCaseShortJavaClassName() + "_" + this.getUpperCaseAttributeName();
    }

    public FetchType getDefaultFetchType() {
        return FetchType.LAZY;
    }

    public Enum getJoinFetch() {
        return this.m_joinFetch;
    }

    public String getPrivateOwned() {
        return null;
    }

    public Class getReferenceClass() {
        Class clazz = this.getReferenceClassFromGeneric();
        return clazz == null ? Void.TYPE : clazz;
    }

    public ColumnMetadata getValueColumn() {
        return this.m_valueColumn;
    }

    public void initXMLObject(MetadataAccessibleObject metadataAccessibleObject) {
        super.initXMLObject(metadataAccessibleObject);
        this.initXMLObject(this.m_valueColumn, metadataAccessibleObject);
        this.initXMLObject(this.m_collectionTable, metadataAccessibleObject);
        if (this.m_valueColumn != null) {
            this.m_valueColumn.setAttributeName(this.getAttributeName());
        }
    }

    public boolean isBasicCollection() {
        return true;
    }

    protected boolean isValidBasicCollectionType() {
        Class clazz = this.getRawClass();
        return clazz.equals(Collection.class) || clazz.equals(Set.class) || clazz.equals(List.class);
    }

    public void process() {
        if (!this.isValidBasicCollectionType()) {
            throw ValidationException.invalidTypeForBasicCollectionAttribute(this.getAttributeName(), this.getRawClass(), this.getJavaClass());
        }
        DirectCollectionMapping directCollectionMapping = new DirectCollectionMapping();
        this.process(directCollectionMapping);
        this.setIndirectionPolicy(directCollectionMapping, null, this.usesIndirection());
        directCollectionMapping.setDirectField(this.getDatabaseField(directCollectionMapping.getReferenceTable(), "metadata_default_value_column"));
        this.processMappingConverter(directCollectionMapping);
        this.processProperties(directCollectionMapping);
    }

    protected void process(DirectCollectionMapping directCollectionMapping) {
        directCollectionMapping.setAttributeName(this.getAttributeName());
        this.setAccessorMethods(directCollectionMapping);
        directCollectionMapping.setJoinFetch(this.getMappingJoinFetchType(this.m_joinFetch));
        this.processCollectionTable(directCollectionMapping);
        this.processReturnInsertAndUpdate();
        this.getDescriptor().addMapping(directCollectionMapping);
    }

    protected void processCollectionTable(DirectCollectionMapping directCollectionMapping) {
        if (this.m_collectionTable == null) {
            this.m_collectionTable = new CollectionTableMetadata(null, this.getAccessibleObject());
        }
        this.processTable(this.m_collectionTable, this.getDefaultCollectionTableName());
        directCollectionMapping.setReferenceTable(this.m_collectionTable.getDatabaseTable());
        for (PrimaryKeyJoinColumnMetadata primaryKeyJoinColumnMetadata : this.processPrimaryKeyJoinColumns(new PrimaryKeyJoinColumnsMetadata(this.m_collectionTable.getPrimaryKeyJoinColumns()))) {
            DatabaseField databaseField = primaryKeyJoinColumnMetadata.getPrimaryKeyField();
            databaseField.setName(this.getName(databaseField, this.getDescriptor().getPrimaryKeyFieldName(), "metadata_default_pk_column"));
            databaseField.setTable(this.getDescriptor().getPrimaryTable());
            DatabaseField databaseField2 = primaryKeyJoinColumnMetadata.getForeignKeyField();
            databaseField2.setName(this.getName(databaseField2, this.getDescriptor().getPrimaryKeyFieldName(), "metadata_default_fk_column"));
            databaseField2.setTable(this.m_collectionTable.getDatabaseTable());
            directCollectionMapping.addReferenceKeyField(databaseField2, databaseField);
        }
    }

    protected void setCollectionTable(CollectionTableMetadata collectionTableMetadata) {
        this.m_collectionTable = collectionTableMetadata;
    }

    public void setConverter(DatabaseMapping databaseMapping, Converter converter) {
        ((DirectCollectionMapping)databaseMapping).setValueConverter(converter);
    }

    public void setConverterClassName(DatabaseMapping databaseMapping, String string) {
        ((DirectCollectionMapping)databaseMapping).setValueConverterClassName(string);
    }

    public void setFieldClassification(DatabaseMapping databaseMapping, Class clazz) {
        ((DirectCollectionMapping)databaseMapping).setDirectFieldClassification(clazz);
    }

    public void setJoinFetch(Enum enum_) {
        this.m_joinFetch = enum_;
    }

    public void setValueColumn(ColumnMetadata columnMetadata) {
        this.m_valueColumn = columnMetadata;
    }
}

