/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.mappings;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.GregorianCalendar;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Lob;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.eclipse.persistence.annotations.Convert;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MappingAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MetadataHelper;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.columns.ColumnMetadata;
import org.eclipse.persistence.internal.jpa.metadata.converters.AbstractConverterMetadata;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.ClassInstanceConverter;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.mappings.converters.EnumTypeConverter;
import org.eclipse.persistence.mappings.converters.SerializedObjectConverter;
import org.eclipse.persistence.mappings.converters.TypeConversionConverter;

public abstract class DirectAccessor
extends MappingAccessor {
    private static final String CONVERT_NONE = "none";
    private static final String CONVERT_SERIALIZED = "serialized";
    private static final String CONVERT_CLASS_INSTANCE = "class-instance";
    private static final String DEFAULT_MAP_KEY_COLUMN_SUFFIX = "_KEY";
    private boolean m_lob;
    private Boolean m_optional;
    private Enum m_fetch;
    private Enum m_enumerated;
    private Enum m_temporal;
    private String m_convert;

    protected DirectAccessor(String string) {
        super(string);
    }

    protected DirectAccessor(Annotation annotation, MetadataAccessibleObject metadataAccessibleObject, ClassAccessor classAccessor) {
        super(annotation, metadataAccessibleObject, classAccessor);
        Object t;
        Object t2;
        this.m_lob = this.isAnnotationPresent(Lob.class);
        Object t3 = this.getAnnotation(Enumerated.class);
        if (t3 != null) {
            this.m_enumerated = (Enum)MetadataHelper.invokeMethod("value", t3);
        }
        if ((t2 = this.getAnnotation(Temporal.class)) != null) {
            this.m_temporal = (Enum)MetadataHelper.invokeMethod("value", t2);
        }
        if ((t = this.getAnnotation(Convert.class)) != null) {
            this.m_convert = (String)MetadataHelper.invokeMethod("value", t);
        }
    }

    protected abstract ColumnMetadata getColumn(String var1);

    public String getConvert() {
        return this.m_convert;
    }

    protected DatabaseField getDatabaseField(DatabaseTable databaseTable, String string) {
        ColumnMetadata columnMetadata = this.getDescriptor().hasAttributeOverrideFor(this.getAttributeName()) && !string.equals("metadata_default_key_column") ? this.getDescriptor().getAttributeOverrideFor(this.getAttributeName()).getColumn() : this.getColumn(string);
        DatabaseField databaseField = columnMetadata.getDatabaseField();
        if (databaseField.getTableName().equals("")) {
            databaseField.setTable(databaseTable);
        }
        String string2 = columnMetadata.getUpperCaseAttributeName();
        if (string.equals("metadata_default_key_column")) {
            string2 = string2 + DEFAULT_MAP_KEY_COLUMN_SUFFIX;
        }
        databaseField.setName(this.getName(databaseField.getName(), string2, string));
        return databaseField;
    }

    public abstract FetchType getDefaultFetchType();

    public Enum getEnumerated() {
        return this.m_enumerated;
    }

    public Enum getFetch() {
        return this.m_fetch;
    }

    protected Class getFieldClassification(Enum enum_) {
        if (enum_.name().equals(TemporalType.DATE.name())) {
            return Date.class;
        }
        if (enum_.name().equals(TemporalType.TIME.name())) {
            return Time.class;
        }
        if (enum_.name().equals(TemporalType.TIMESTAMP.name())) {
            return Timestamp.class;
        }
        return null;
    }

    public String getLob() {
        return null;
    }

    public Boolean getOptional() {
        return this.m_optional;
    }

    public Enum getTemporal() {
        return this.m_temporal;
    }

    protected boolean hasConvert() {
        return this.m_convert != null;
    }

    public boolean isEnumerated() {
        if (this.hasConvert()) {
            if (this.m_enumerated != null) {
                this.getLogger().logWarningMessage("metadata_warning_ignore_enumerated", this.getJavaClass(), this.getAnnotatedElement());
            }
            return false;
        }
        return this.m_enumerated != null || this.isValidEnumeratedType(this.getReferenceClass());
    }

    public boolean isLob() {
        if (this.hasConvert()) {
            if (this.m_lob) {
                this.getLogger().logWarningMessage("metadata_warning_ignore_lob", this.getJavaClass(), this.getAnnotatedElement());
            }
            return false;
        }
        return this.m_lob;
    }

    public boolean isOptional() {
        if (this.m_optional == null) {
            return true;
        }
        return this.m_optional;
    }

    protected boolean isPrimitiveWrapperClass(Class clazz) {
        return Long.class.isAssignableFrom(clazz) || Short.class.isAssignableFrom(clazz) || Float.class.isAssignableFrom(clazz) || Byte.class.isAssignableFrom(clazz) || Double.class.isAssignableFrom(clazz) || Number.class.isAssignableFrom(clazz) || Boolean.class.isAssignableFrom(clazz) || Integer.class.isAssignableFrom(clazz) || Character.class.isAssignableFrom(clazz) || String.class.isAssignableFrom(clazz) || BigInteger.class.isAssignableFrom(clazz) || BigDecimal.class.isAssignableFrom(clazz) || java.util.Date.class.isAssignableFrom(clazz) || Calendar.class.isAssignableFrom(clazz);
    }

    public boolean isSerialized() {
        if (this.hasConvert()) {
            this.getLogger().logWarningMessage("metadata_warning_ignore_serialized", this.getJavaClass(), this.getAnnotatedElement());
            return false;
        }
        return this.isValidSerializedType(this.getReferenceClass());
    }

    public boolean isTemporal() {
        if (this.hasConvert()) {
            if (this.m_temporal != null) {
                this.getLogger().logWarningMessage("metadata_warning_ignore_temporal", this.getJavaClass(), this.getAnnotatedElement());
            }
            return false;
        }
        return this.m_temporal != null || this.isValidTemporalType(this.getReferenceClass());
    }

    protected boolean isValidBlobType(Class clazz) {
        return clazz.equals(byte[].class) || clazz.equals(Byte[].class) || clazz.equals(Blob.class);
    }

    protected boolean isValidClobType(Class clazz) {
        return clazz.equals(char[].class) || clazz.equals(String.class) || clazz.equals(Character[].class) || clazz.equals(Clob.class);
    }

    protected boolean isValidLobType(Class clazz) {
        return this.isValidClobType(clazz) || this.isValidBlobType(clazz);
    }

    protected boolean isValidEnumeratedType(Class clazz) {
        return clazz.isEnum();
    }

    protected boolean isValidSerializedType(Class clazz) {
        if (clazz.isPrimitive()) {
            return false;
        }
        if (this.isPrimitiveWrapperClass(clazz)) {
            return false;
        }
        if (this.isValidLobType(clazz)) {
            return false;
        }
        return !this.isValidTemporalType(clazz);
    }

    protected boolean isValidTemporalType(Class clazz) {
        return clazz.equals(java.util.Date.class) || clazz.equals(Calendar.class) || clazz.equals(GregorianCalendar.class);
    }

    protected void processClassInstance(DatabaseMapping databaseMapping) {
        ClassInstanceConverter classInstanceConverter = new ClassInstanceConverter();
        this.setConverter(databaseMapping, classInstanceConverter);
    }

    public void processConvert() {
        this.processConvert(this.getDescriptor().getMappingForAttributeName(this.getAttributeName()), this.m_convert);
    }

    protected void processConvert(DatabaseMapping databaseMapping, String string) {
        if (!string.equals(CONVERT_NONE)) {
            if (string.equals(CONVERT_SERIALIZED)) {
                this.processSerialized(databaseMapping);
            } else if (string.equals(CONVERT_CLASS_INSTANCE)) {
                this.processClassInstance(databaseMapping);
            } else {
                AbstractConverterMetadata abstractConverterMetadata = this.getProject().getConverter(string);
                if (abstractConverterMetadata == null) {
                    throw ValidationException.converterNotFound(this.getJavaClass(), string, this.getAnnotatedElement());
                }
                abstractConverterMetadata.process(databaseMapping, this);
            }
        }
    }

    protected void processEnumerated(DatabaseMapping databaseMapping) {
        if (this.m_enumerated != null && !this.isValidEnumeratedType(this.getReferenceClass())) {
            throw ValidationException.invalidTypeForEnumeratedAttribute(databaseMapping.getAttributeName(), this.getReferenceClass(), this.getJavaClass());
        }
        if (this.m_enumerated == null) {
            this.setConverter(databaseMapping, new EnumTypeConverter(databaseMapping, this.getReferenceClass(), true));
        } else {
            this.setConverter(databaseMapping, new EnumTypeConverter(databaseMapping, this.getReferenceClass(), this.m_enumerated.name().equals(EnumType.ORDINAL.name())));
        }
    }

    protected void processJPAConverters(DatabaseMapping databaseMapping) {
        if (this.isEnumerated()) {
            this.processEnumerated(databaseMapping);
        } else if (this.isLob()) {
            this.processLob(databaseMapping);
        } else if (this.isTemporal()) {
            this.processTemporal(databaseMapping);
        } else if (this.isSerialized()) {
            this.processSerialized(databaseMapping);
        }
    }

    protected void processLob(DatabaseMapping databaseMapping) {
        if (this.isValidClobType(this.getReferenceClass())) {
            this.setFieldClassification(databaseMapping, Clob.class);
            this.setConverter(databaseMapping, new TypeConversionConverter(databaseMapping));
        } else if (this.isValidBlobType(this.getReferenceClass())) {
            this.setFieldClassification(databaseMapping, Blob.class);
            this.setConverter(databaseMapping, new TypeConversionConverter(databaseMapping));
        } else if (Helper.classImplementsInterface(this.getReferenceClass(), Serializable.class)) {
            this.setFieldClassification(databaseMapping, Blob.class);
            this.setConverter(databaseMapping, new SerializedObjectConverter(databaseMapping));
        } else {
            throw ValidationException.invalidTypeForLOBAttribute(databaseMapping.getAttributeName(), this.getReferenceClass(), this.getJavaClass());
        }
    }

    protected void processMappingConverter(DatabaseMapping databaseMapping) {
        if (this.m_convert == null) {
            this.processJPAConverters(databaseMapping);
        } else {
            this.processMappingConverter(databaseMapping, this.m_convert);
        }
    }

    protected void processMappingConverter(DatabaseMapping databaseMapping, String string) {
        if (string != null && !string.equals(CONVERT_NONE)) {
            this.getProject().addConvertAccessor(this);
        }
        this.processJPAConverters(databaseMapping);
    }

    protected void processSerialized(DatabaseMapping databaseMapping) {
        if (!Helper.classImplementsInterface(this.getReferenceClass(), Serializable.class)) {
            throw ValidationException.invalidTypeForSerializedAttribute(databaseMapping.getAttributeName(), this.getReferenceClass(), this.getJavaClass());
        }
        SerializedObjectConverter serializedObjectConverter = new SerializedObjectConverter(databaseMapping);
        this.setConverter(databaseMapping, serializedObjectConverter);
    }

    protected void processTemporal(DatabaseMapping databaseMapping) {
        if (this.m_temporal == null) {
            throw ValidationException.noTemporalTypeSpecified(this.getAttributeName(), this.getJavaClass());
        }
        if (this.isValidTemporalType(this.getReferenceClass())) {
            if (this.m_temporal.name().equals(TemporalType.DATE.name())) {
                this.setFieldClassification(databaseMapping, Date.class);
            } else if (this.m_temporal.name().equals(TemporalType.TIME.name())) {
                this.setFieldClassification(databaseMapping, Time.class);
            } else {
                this.setFieldClassification(databaseMapping, Timestamp.class);
            }
        } else {
            throw ValidationException.invalidTypeForTemporalAttribute(this.getAttributeName(), this.getReferenceClass(), this.getJavaClass());
        }
        this.setConverter(databaseMapping, new TypeConversionConverter(databaseMapping));
    }

    public void setConvert(String string) {
        this.m_convert = string;
    }

    public abstract void setConverter(DatabaseMapping var1, Converter var2);

    public abstract void setConverterClassName(DatabaseMapping var1, String var2);

    public void setEnumerated(Enum enum_) {
        this.m_enumerated = enum_;
    }

    public void setFetch(Enum enum_) {
        this.m_fetch = enum_;
    }

    public abstract void setFieldClassification(DatabaseMapping var1, Class var2);

    public void setLob(String string) {
        this.m_lob = true;
    }

    public void setOptional(Boolean bl) {
        this.m_optional = bl;
    }

    public void setTemporal(Enum enum_) {
        this.m_temporal = enum_;
    }

    public boolean usesIndirection() {
        Enum enum_ = this.getFetch();
        if (enum_ == null) {
            enum_ = this.getDefaultFetchType();
        }
        return enum_.name().equals(FetchType.LAZY.name());
    }
}

