/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.objects;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import javax.persistence.PostLoad;
import javax.persistence.PostPersist;
import javax.persistence.PostRemove;
import javax.persistence.PostUpdate;
import javax.persistence.PrePersist;
import javax.persistence.PreRemove;
import javax.persistence.PreUpdate;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.MetadataLogger;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotatedElement;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedGetMethod;

public class MetadataMethod
extends MetadataAnnotatedElement {
    public static final String IS_PROPERTY_METHOD_PREFIX = "is";
    public static final String GET_PROPERTY_METHOD_PREFIX = "get";
    private static final String SET_PROPERTY_METHOD_PREFIX = "set";
    private static final String SET_IS_PROPERTY_METHOD_PREFIX = "setIs";
    private static final int POSITION_AFTER_IS_PREFIX = "is".length();
    private static final int POSITION_AFTER_GET_PREFIX = "get".length();
    protected Method m_getMethod;
    protected Method m_setMethod;

    public MetadataMethod(Method method, Class clazz) {
        super(method);
        this.init(method, clazz);
    }

    public MetadataMethod(Method method, MetadataLogger metadataLogger) {
        super((AnnotatedElement)method, metadataLogger);
        this.init(method, method.getDeclaringClass());
    }

    public MetadataMethod(Method method, Method method2, String string, XMLEntityMappings xMLEntityMappings) {
        super((AnnotatedElement)method, xMLEntityMappings);
        this.m_getMethod = method;
        this.m_setMethod = method2;
        this.setName(method.getName());
        this.setAttributeName(string);
        this.setRelationType(method.getGenericReturnType());
    }

    public MetadataMethod(Method method, XMLEntityMappings xMLEntityMappings) {
        super((AnnotatedElement)method, xMLEntityMappings);
        this.init(method, method.getDeclaringClass());
    }

    public static String getAttributeNameFromMethodName(String string) {
        String string2 = "";
        String string3 = string;
        if (string.equals(GET_PROPERTY_METHOD_PREFIX) || string.equals(IS_PROPERTY_METHOD_PREFIX)) {
            return "";
        }
        if (string.startsWith(GET_PROPERTY_METHOD_PREFIX)) {
            string2 = string.substring(POSITION_AFTER_GET_PREFIX, POSITION_AFTER_GET_PREFIX + 1);
            string3 = string.substring(POSITION_AFTER_GET_PREFIX + 1);
        } else if (string.startsWith(IS_PROPERTY_METHOD_PREFIX)) {
            string2 = string.substring(POSITION_AFTER_IS_PREFIX, POSITION_AFTER_IS_PREFIX + 1);
            string3 = string.substring(POSITION_AFTER_IS_PREFIX + 1);
        }
        return string2.toLowerCase().concat(string3);
    }

    protected Method getMethod() {
        return (Method)this.getAnnotatedElement();
    }

    public Method getSetMethod() {
        return this.m_setMethod;
    }

    public Method getSetMethod(Method method, Class clazz) {
        String string = method.getName();
        Class[] classArray = new Class[]{method.getReturnType()};
        if (string.startsWith(GET_PROPERTY_METHOD_PREFIX)) {
            return this.getMethod(SET_PROPERTY_METHOD_PREFIX + string.substring(3), clazz, classArray);
        }
        Method method2 = this.getMethod(SET_PROPERTY_METHOD_PREFIX + string.substring(2), clazz, classArray);
        if (method2 == null) {
            return this.getMethod(SET_IS_PROPERTY_METHOD_PREFIX + string.substring(2), clazz, classArray);
        }
        return method2;
    }

    protected Method getMethod(String string, Class clazz, Class[] classArray) {
        try {
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                try {
                    return AccessController.doPrivileged(new PrivilegedGetMethod(clazz, string, classArray, true));
                }
                catch (PrivilegedActionException privilegedActionException) {
                    return null;
                }
            }
            return PrivilegedAccessHelper.getMethod(clazz, string, classArray, true);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    public String getSetMethodName() {
        return this.m_setMethod.getName();
    }

    public boolean hasAttributeName() {
        return !this.getAttributeName().equals("");
    }

    public boolean hasParameters() {
        return this.m_getMethod.getParameterTypes().length > 0;
    }

    public boolean hasSetMethod() {
        return this.m_setMethod != null;
    }

    protected void init(Method method, Class clazz) {
        this.m_getMethod = method;
        this.m_setMethod = this.getSetMethod(method, clazz);
        this.setName(method.getName());
        this.setAttributeName(MetadataMethod.getAttributeNameFromMethodName(method.getName()));
        this.setRelationType(method.getGenericReturnType());
    }

    protected boolean isALifeCycleCallbackMethod() {
        return this.isAnnotationPresent(PostLoad.class) || this.isAnnotationPresent(PostPersist.class) || this.isAnnotationPresent(PostRemove.class) || this.isAnnotationPresent(PostUpdate.class) || this.isAnnotationPresent(PrePersist.class) || this.isAnnotationPresent(PreRemove.class) || this.isAnnotationPresent(PreUpdate.class);
    }

    protected boolean isValidPersistenceMethod() {
        return this.isValidPersistenceMethodName() && !this.hasParameters() && this.hasSetMethod();
    }

    public boolean isValidPersistenceMethod(boolean bl, MetadataDescriptor metadataDescriptor) {
        if (this.isValidPersistenceElement(bl, "PROPERTY", metadataDescriptor)) {
            return !this.isALifeCycleCallbackMethod() && this.isValidPersistenceMethod(metadataDescriptor, this.hasDeclaredAnnotations(metadataDescriptor));
        }
        return false;
    }

    public boolean isValidPersistenceMethod(MetadataDescriptor metadataDescriptor, boolean bl) {
        if (!this.isValidPersistenceElement(this.getMethod().getModifiers()) || !this.isValidPersistenceMethod()) {
            if (bl) {
                if (this.hasParameters()) {
                    throw ValidationException.mappingMetadataAppliedToMethodWithArguments(this.getMethod(), metadataDescriptor.getJavaClass());
                }
                if (!this.hasSetMethod()) {
                    throw ValidationException.noCorrespondingSetterMethodDefined(metadataDescriptor.getJavaClass(), this.getMethod());
                }
                throw ValidationException.mappingMetadataAppliedToInvalidAttribute(this.getMethod(), metadataDescriptor.getJavaClass());
            }
            return false;
        }
        return true;
    }

    public boolean isValidPersistenceMethodName() {
        return (this.getName().startsWith(GET_PROPERTY_METHOD_PREFIX) || this.getName().startsWith(IS_PROPERTY_METHOD_PREFIX)) && this.hasAttributeName();
    }
}

