/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.queries;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.changetracking.CollectionChangeEvent;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.indirection.IndirectCollection;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.queries.ArrayListContainerPolicy;
import org.eclipse.persistence.internal.queries.CollectionContainerPolicy;
import org.eclipse.persistence.internal.queries.IndirectListContainerPolicy;
import org.eclipse.persistence.internal.queries.ListContainerPolicy;
import org.eclipse.persistence.internal.queries.MapContainerPolicy;
import org.eclipse.persistence.internal.queries.OrderedListContainerPolicy;
import org.eclipse.persistence.internal.queries.SortedCollectionContainerPolicy;
import org.eclipse.persistence.internal.queries.VectorContainerPolicy;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedGetConstructorFor;
import org.eclipse.persistence.internal.security.PrivilegedInvokeConstructor;
import org.eclipse.persistence.internal.security.PrivilegedNewInstanceFromClass;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.CollectionChangeRecord;
import org.eclipse.persistence.internal.sessions.MergeManager;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.queries.CursoredStreamPolicy;
import org.eclipse.persistence.queries.DataReadQuery;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadQuery;
import org.eclipse.persistence.queries.ScrollableCursorPolicy;

public abstract class ContainerPolicy
implements Cloneable,
Serializable {
    protected static Class defaultContainerClass = ClassConstants.Vector_class;
    protected transient ClassDescriptor elementDescriptor;
    protected transient Constructor constructor;

    public static Class getDefaultContainerClass() {
        return defaultContainerClass;
    }

    public static void setDefaultContainerClass(Class clazz) {
        defaultContainerClass = clazz;
    }

    protected boolean addInto(Object object, Object object2, Object object3) {
        throw QueryException.cannotAddToContainer(object2, object3, this);
    }

    public boolean addInto(Object object, Object object2, AbstractSession abstractSession) {
        return this.addInto(null, object, object2, abstractSession);
    }

    public boolean addInto(Object object, Object object2, Object object3, AbstractSession abstractSession) {
        Object object4 = object2;
        if (this.elementDescriptor != null) {
            object4 = this.elementDescriptor.getObjectBuilder().wrapObject(object2, abstractSession);
        }
        return this.addInto(object, object4, object3);
    }

    public void addIntoWithOrder(Integer n, Object object, Object object2) {
        throw QueryException.methodDoesNotExistInContainerClass("set", this.getContainerClass());
    }

    public void addIntoWithOrder(Integer n, Object object, Object object2, AbstractSession abstractSession) {
        Object object3 = object;
        if (this.elementDescriptor != null) {
            object3 = this.elementDescriptor.getObjectBuilder().wrapObject(object, abstractSession);
        }
        this.addIntoWithOrder(n, object3, object2);
    }

    public void addIntoWithOrder(Vector vector, Hashtable hashtable, Object object, AbstractSession abstractSession) {
        throw QueryException.methodDoesNotExistInContainerClass("set", this.getContainerClass());
    }

    public Object buildContainerFromVector(Vector vector, AbstractSession abstractSession) {
        Object object = this.containerInstance(vector.size());
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            this.addInto(vector.get(i), object, abstractSession);
        }
        return object;
    }

    public static ContainerPolicy buildDefaultPolicy() {
        return ContainerPolicy.buildPolicyFor(ContainerPolicy.getDefaultContainerClass());
    }

    public static ContainerPolicy buildPolicyFor(Class clazz) {
        return ContainerPolicy.buildPolicyFor(clazz, false);
    }

    public static ContainerPolicy buildPolicyFor(Class clazz, boolean bl) {
        if (Helper.classImplementsInterface(clazz, ClassConstants.List_Class)) {
            if (bl) {
                return new OrderedListContainerPolicy(clazz);
            }
            if (clazz == ClassConstants.Vector_class) {
                return new VectorContainerPolicy(clazz);
            }
            if (clazz == ClassConstants.IndirectList_Class) {
                return new IndirectListContainerPolicy(clazz);
            }
            if (clazz == ClassConstants.ArrayList_class) {
                return new ArrayListContainerPolicy(clazz);
            }
            return new ListContainerPolicy(clazz);
        }
        if (Helper.classImplementsInterface(clazz, ClassConstants.SortedSet_Class)) {
            return new SortedCollectionContainerPolicy(clazz);
        }
        if (Helper.classImplementsInterface(clazz, ClassConstants.Collection_Class)) {
            return new CollectionContainerPolicy(clazz);
        }
        if (Helper.classImplementsInterface(clazz, ClassConstants.Map_Class)) {
            return new MapContainerPolicy(clazz);
        }
        if (clazz.equals(ClassConstants.CursoredStream_Class)) {
            return new CursoredStreamPolicy();
        }
        if (clazz.equals(ClassConstants.ScrollableCursor_Class)) {
            return new ScrollableCursorPolicy();
        }
        throw ValidationException.illegalContainerClass(clazz);
    }

    public void clear(Object object) {
        throw QueryException.methodNotValid(this, "clear(Object container)");
    }

    public boolean equals(Object object) {
        return object != null && this.getClass().equals(object.getClass());
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public ContainerPolicy clone(ReadQuery readQuery) {
        return (ContainerPolicy)this.clone();
    }

    public Object cloneFor(Object object) {
        throw QueryException.cannotCreateClone(this, object);
    }

    public void compareCollectionsForChange(Object object, Object object2, CollectionChangeRecord collectionChangeRecord, AbstractSession abstractSession, ClassDescriptor classDescriptor) {
        Object object3;
        Object object4;
        IdentityHashMap<Object, Object> identityHashMap = new IdentityHashMap<Object, Object>();
        IdentityHashMap<Object, Object> identityHashMap2 = new IdentityHashMap<Object, Object>();
        if (object != null) {
            object4 = this.iteratorFor(object);
            while (this.hasNext(object4)) {
                object3 = this.next(object4, abstractSession);
                if (object3 == null) continue;
                identityHashMap.put(object3, object3);
            }
        }
        if (object2 != null) {
            object4 = this.iteratorFor(object2);
            while (this.hasNext(object4)) {
                object3 = this.next(object4, abstractSession);
                if (object3 == null) continue;
                if (identityHashMap.containsKey(object3)) {
                    if (this.compareKeys(object3, abstractSession)) {
                        identityHashMap.remove(object3);
                        continue;
                    }
                    Object object5 = null;
                    object5 = ((UnitOfWorkImpl)abstractSession).isClassReadOnly(object3.getClass()) ? object3 : ((UnitOfWorkImpl)abstractSession).getBackupClone(object3, classDescriptor);
                    ObjectChangeSet objectChangeSet = classDescriptor.getObjectBuilder().createObjectChangeSet(object3, (UnitOfWorkChangeSet)collectionChangeRecord.getOwner().getUOWChangeSet(), abstractSession);
                    objectChangeSet.setOldKey(this.keyFrom(object5, abstractSession));
                    objectChangeSet.setNewKey(this.keyFrom(object3, abstractSession));
                    identityHashMap2.put(object3, object3);
                    continue;
                }
                identityHashMap2.put(object3, object3);
            }
        }
        collectionChangeRecord.addAdditionChange(identityHashMap2, (UnitOfWorkChangeSet)collectionChangeRecord.getOwner().getUOWChangeSet(), abstractSession);
        collectionChangeRecord.addRemoveChange(identityHashMap, (UnitOfWorkChangeSet)collectionChangeRecord.getOwner().getUOWChangeSet(), abstractSession);
    }

    public boolean compareKeys(Object object, AbstractSession abstractSession) {
        return true;
    }

    public Object concatenateContainers(Object object, Object object2) {
        Object object3 = this.containerInstance(this.sizeFor(object) + this.sizeFor(object2));
        Object object4 = this.iteratorFor(object);
        while (this.hasNext(object4)) {
            this.addInto(null, this.next(object4), object3);
        }
        object4 = this.iteratorFor(object2);
        while (this.hasNext(object4)) {
            this.addInto(null, this.next(object4), object3);
        }
        return object3;
    }

    public Object containerInstance() {
        try {
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                try {
                    return AccessController.doPrivileged(new PrivilegedNewInstanceFromClass(this.getContainerClass()));
                }
                catch (PrivilegedActionException privilegedActionException) {
                    throw QueryException.couldNotInstantiateContainerClass(this.getContainerClass(), privilegedActionException.getException());
                }
            }
            return PrivilegedAccessHelper.newInstanceFromClass(this.getContainerClass());
        }
        catch (Exception exception) {
            throw QueryException.couldNotInstantiateContainerClass(this.getContainerClass(), exception);
        }
    }

    public Object containerInstance(int n) {
        if (this.getConstructor() == null) {
            return this.containerInstance();
        }
        try {
            Object[] objectArray = new Object[]{new Integer(n)};
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                try {
                    return AccessController.doPrivileged(new PrivilegedInvokeConstructor(this.getConstructor(), objectArray));
                }
                catch (PrivilegedActionException privilegedActionException) {
                    throw QueryException.couldNotInstantiateContainerClass(this.getContainerClass(), privilegedActionException.getException());
                }
            }
            return PrivilegedAccessHelper.invokeConstructor(this.getConstructor(), objectArray);
        }
        catch (Exception exception) {
            throw QueryException.couldNotInstantiateContainerClass(this.getContainerClass(), exception);
        }
    }

    protected boolean contains(Object object, Object object2) {
        throw QueryException.methodNotValid(this, "contains(Object element, Object container)");
    }

    public boolean contains(Object object, Object object2, AbstractSession abstractSession) {
        if (this.hasElementDescriptor() && this.getElementDescriptor().hasWrapperPolicy()) {
            Object object3 = this.iteratorFor(object2);
            while (this.hasNext(object3)) {
                Object object4 = this.next(object3);
                if (!this.getElementDescriptor().getObjectBuilder().unwrapObject(object4, abstractSession).equals(object)) continue;
                return true;
            }
            return false;
        }
        return this.contains(object, object2);
    }

    protected boolean containsKey(Object object, Object object2) {
        throw QueryException.methodNotValid(this, "containsKey(Object element, Object container)");
    }

    public void convertClassNamesToClasses(ClassLoader classLoader) {
    }

    public Object execute() {
        throw QueryException.methodNotValid(this, "execute()");
    }

    protected Constructor getConstructor() {
        return this.constructor;
    }

    public Class getContainerClass() {
        throw QueryException.methodNotValid(this, "getContainerClass()");
    }

    public String getContainerClassName() {
        throw QueryException.methodNotValid(this, "getContainerClassName()");
    }

    public ClassDescriptor getElementDescriptor() {
        return this.elementDescriptor;
    }

    public boolean hasElementDescriptor() {
        return this.elementDescriptor != null;
    }

    public abstract boolean hasNext(Object var1);

    public boolean hasOrder() {
        return false;
    }

    public void initializeConstructor() {
        try {
            Constructor constructor = null;
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                try {
                    constructor = (Constructor)AccessController.doPrivileged(new PrivilegedGetConstructorFor(this.getContainerClass(), new Class[]{ClassConstants.PINT}, false));
                }
                catch (PrivilegedActionException privilegedActionException) {
                    return;
                }
            } else {
                constructor = PrivilegedAccessHelper.getConstructorFor(this.getContainerClass(), new Class[]{ClassConstants.PINT}, false);
            }
            this.setConstructor(constructor);
        }
        catch (Exception exception) {
            return;
        }
    }

    public boolean isCollectionPolicy() {
        return false;
    }

    public boolean isCursoredStreamPolicy() {
        return false;
    }

    public boolean isScrollableCursorPolicy() {
        return false;
    }

    public boolean isCursorPolicy() {
        return false;
    }

    public boolean isDirectMapPolicy() {
        return false;
    }

    public boolean isEmpty(Object object) {
        return this.sizeFor(object) == 0;
    }

    public boolean isListPolicy() {
        return false;
    }

    public boolean isMapPolicy() {
        return false;
    }

    public boolean isValidContainer(Object object) {
        throw QueryException.methodNotValid(this, "isValidContainer(Object container)");
    }

    public boolean isValidContainerType(Class clazz) {
        throw QueryException.methodNotValid(this, "isValidContainerType(Class containerType)");
    }

    public abstract Object iteratorFor(Object var1);

    public Object keyFrom(Object object, AbstractSession abstractSession) {
        return null;
    }

    public Object mergeCascadeParts(ObjectChangeSet objectChangeSet, MergeManager mergeManager, AbstractSession abstractSession) {
        Object object = null;
        if (mergeManager.shouldMergeChangesIntoDistributedCache()) {
            object = objectChangeSet.getTargetVersionOfSourceObject(abstractSession);
            if (object == null && (objectChangeSet.isNew() || objectChangeSet.isAggregate()) && objectChangeSet.containsChangesFromSynchronization()) {
                if (!mergeManager.getObjectsAlreadyMerged().containsKey(objectChangeSet)) {
                    Class clazz = objectChangeSet.getClassType(mergeManager.getSession());
                    object = mergeManager.getSession().getDescriptor(clazz).getObjectBuilder().buildNewInstance();
                    mergeManager.getObjectsAlreadyMerged().put(objectChangeSet, object);
                } else {
                    object = mergeManager.getObjectsAlreadyMerged().get(objectChangeSet);
                }
            } else {
                object = objectChangeSet.getTargetVersionOfSourceObject(abstractSession, true);
            }
            if (objectChangeSet.containsChangesFromSynchronization()) {
                mergeManager.mergeChanges(object, objectChangeSet);
            }
        } else {
            mergeManager.mergeChanges(objectChangeSet.getUnitOfWorkClone(), objectChangeSet);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mergeChanges(CollectionChangeRecord collectionChangeRecord, Object object, boolean bl, MergeManager mergeManager, AbstractSession abstractSession) {
        Iterator iterator = collectionChangeRecord.getRemoveObjectList().keySet().iterator();
        Object object2 = object;
        if (object instanceof IndirectCollection) {
            object2 = ((IndirectCollection)object).getDelegateObject();
        }
        Object object3 = object2;
        synchronized (object3) {
            while (iterator.hasNext()) {
                ObjectChangeSet objectChangeSet = (ObjectChangeSet)iterator.next();
                this.removeFrom(objectChangeSet.getOldKey(), objectChangeSet.getTargetVersionOfSourceObject(mergeManager.getSession()), object, abstractSession);
                if (mergeManager.shouldMergeChangesIntoDistributedCache()) continue;
                mergeManager.registerRemovedNewObjectIfRequired(objectChangeSet.getUnitOfWorkClone());
            }
            for (ObjectChangeSet objectChangeSet : collectionChangeRecord.getAddObjectList().keySet()) {
                Object object4 = null;
                if (bl) {
                    object4 = this.mergeCascadeParts(objectChangeSet, mergeManager, abstractSession);
                }
                if (object4 == null) {
                    object4 = objectChangeSet.getTargetVersionOfSourceObject(mergeManager.getSession(), false);
                }
                if (mergeManager.shouldMergeChangesIntoDistributedCache()) {
                    if (this.contains(object4, object, mergeManager.getSession())) continue;
                    this.addInto(objectChangeSet.getNewKey(), object4, object, mergeManager.getSession());
                    continue;
                }
                this.addInto(objectChangeSet.getNewKey(), object4, object, mergeManager.getSession());
            }
        }
    }

    protected abstract Object next(Object var1);

    public Object next(Object object, AbstractSession abstractSession) {
        Object object2 = this.next(object);
        if (this.hasElementDescriptor()) {
            object2 = this.getElementDescriptor().getObjectBuilder().unwrapObject(object2, abstractSession);
        }
        return object2;
    }

    public boolean overridesRead() {
        return false;
    }

    public void prepare(DatabaseQuery databaseQuery, AbstractSession abstractSession) throws QueryException {
        if (databaseQuery.isReadAllQuery() && !databaseQuery.isReportQuery() && databaseQuery.shouldUseWrapperPolicy()) {
            this.setElementDescriptor(databaseQuery.getDescriptor());
        } else if (databaseQuery.isDataReadQuery()) {
            ((DataReadQuery)databaseQuery).setContainerPolicy(this);
        }
    }

    public void prepareForExecution() throws QueryException {
    }

    public void recordAddToCollectionInChangeRecord(ObjectChangeSet objectChangeSet, CollectionChangeRecord collectionChangeRecord) {
        if (collectionChangeRecord.getRemoveObjectList().containsKey(objectChangeSet)) {
            collectionChangeRecord.getRemoveObjectList().remove(objectChangeSet);
        } else {
            collectionChangeRecord.getAddObjectList().put(objectChangeSet, objectChangeSet);
        }
    }

    public void recordRemoveFromCollectionInChangeRecord(ObjectChangeSet objectChangeSet, CollectionChangeRecord collectionChangeRecord) {
        if (collectionChangeRecord.getAddObjectList().containsKey(objectChangeSet)) {
            collectionChangeRecord.getAddObjectList().remove(objectChangeSet);
        } else {
            collectionChangeRecord.getRemoveObjectList().put(objectChangeSet, objectChangeSet);
        }
    }

    public void recordUpdateToCollectionInChangeRecord(CollectionChangeEvent collectionChangeEvent, ObjectChangeSet objectChangeSet, CollectionChangeRecord collectionChangeRecord) {
        if (collectionChangeEvent.getChangeType() == CollectionChangeEvent.ADD) {
            this.recordAddToCollectionInChangeRecord(objectChangeSet, collectionChangeRecord);
        } else if (collectionChangeEvent.getChangeType() == CollectionChangeEvent.REMOVE) {
            this.recordRemoveFromCollectionInChangeRecord(objectChangeSet, collectionChangeRecord);
        } else {
            throw ValidationException.wrongCollectionChangeEventType(collectionChangeEvent.getChangeType());
        }
    }

    public Object remoteExecute() {
        return null;
    }

    public void removeAllElements(Object object) {
        this.clear(object);
    }

    protected boolean removeFrom(Object object, Object object2, Object object3) {
        throw QueryException.cannotRemoveFromContainer(object2, object3, this);
    }

    public boolean removeFrom(Object object, Object object2, Object object3, AbstractSession abstractSession) {
        Object object4 = object2;
        if (this.hasElementDescriptor() && this.getElementDescriptor().hasWrapperPolicy()) {
            Object object5 = this.iteratorFor(object3);
            while (this.hasNext(object5)) {
                Object object6 = this.next(object5);
                if (!this.getElementDescriptor().getObjectBuilder().unwrapObject(object6, abstractSession).equals(object2)) continue;
                object4 = object6;
                break;
            }
        }
        return this.removeFrom(object, object4, object3);
    }

    public boolean removeFrom(Object object, Object object2, AbstractSession abstractSession) {
        return this.removeFrom(null, object, object2, abstractSession);
    }

    public void removeFromWithOrder(int n, Object object) {
        throw QueryException.methodDoesNotExistInContainerClass("remove(index)", this.getContainerClass());
    }

    protected void setConstructor(Constructor constructor) {
        this.constructor = constructor;
    }

    public void setContainerClass(Class clazz) {
        throw QueryException.methodNotValid(this, "getContainerClass()");
    }

    public void setContainerClassName(String string) {
        throw QueryException.methodNotValid(this, "getContainerClassName()");
    }

    public void setElementDescriptor(ClassDescriptor classDescriptor) {
        this.elementDescriptor = classDescriptor;
    }

    public void setKeyName(String string, String string2) {
        throw ValidationException.containerPolicyDoesNotUseKeys(this, string);
    }

    public void setKeyName(String string, Class clazz) {
        throw ValidationException.containerPolicyDoesNotUseKeys(this, string);
    }

    public int sizeFor(Object object) {
        throw QueryException.methodNotValid(this, "sizeFor(Object container)");
    }

    public String toString() {
        return Helper.getShortClassName(this.getClass()) + "(" + this.toStringInfo() + ")";
    }

    protected Object toStringInfo() {
        return "";
    }

    public void validateElementAndRehashIfRequired(Object object, Object object2, AbstractSession abstractSession, Object object3) {
    }

    public Vector vectorFor(Object object, AbstractSession abstractSession) {
        Vector<Object> vector = new Vector<Object>(this.sizeFor(object));
        Object object2 = this.iteratorFor(object);
        while (this.hasNext(object2)) {
            vector.addElement(this.next(object2, abstractSession));
        }
        return vector;
    }
}

