/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.sessions.coordination;

import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.persistence.exceptions.CommunicationException;
import org.eclipse.persistence.exceptions.RemoteCommandManagerException;
import org.eclipse.persistence.internal.sessions.coordination.RemoteConnection;
import org.eclipse.persistence.sessions.coordination.Command;
import org.eclipse.persistence.sessions.coordination.RemoteCommandManager;

public class CommandPropagator
implements Runnable {
    protected RemoteCommandManager rcm;
    protected Command command;
    protected RemoteConnection connection;

    public CommandPropagator(RemoteCommandManager remoteCommandManager, Command command) {
        this.rcm = remoteCommandManager;
        this.command = command;
    }

    public CommandPropagator(RemoteCommandManager remoteCommandManager, Command command, RemoteConnection remoteConnection) {
        this(remoteCommandManager, command);
        this.connection = remoteConnection;
    }

    protected RemoteCommandManager getRemoteCommandManager() {
        return this.rcm;
    }

    protected Command getCommand() {
        return this.command;
    }

    public void synchronousPropagateCommand() {
        this.rcm.logDebug("sync_propagation", null);
        Enumeration enumeration = this.rcm.getTransportManager().getConnectionsToExternalServicesForCommandPropagation().elements();
        while (enumeration.hasMoreElements()) {
            this.connection = (RemoteConnection)enumeration.nextElement();
            this.propagateCommand(this.connection);
        }
    }

    public void asynchronousPropagateCommand() {
        this.rcm.logDebug("async_propagation", null);
        this.rcm.getServerPlatform().launchContainerRunnable(this);
    }

    public void propagateCommand(RemoteConnection remoteConnection) {
        Object[] objectArray = new Object[]{this.command.getClass().getName(), remoteConnection.getServiceId()};
        this.rcm.logDebug("propagate_command_to", objectArray);
        try {
            Object object = remoteConnection.executeCommand(this.command);
            if (object != null) {
                this.handleExceptionFromRemoteExecution(remoteConnection, (String)object);
            }
        }
        catch (CommunicationException communicationException) {
            this.handleCommunicationException(remoteConnection, communicationException);
        }
    }

    public void handleExceptionFromRemoteExecution(RemoteConnection remoteConnection, String string) {
        Object[] objectArray = new Object[]{remoteConnection.getServiceId(), string};
        this.rcm.logWarning("failed_command_propagation", objectArray);
        RemoteCommandManagerException remoteCommandManagerException = RemoteCommandManagerException.unableToPropagateCommand(remoteConnection.toString(), new Exception(string));
        this.rcm.handleException(remoteCommandManagerException);
    }

    public void handleCommunicationException(RemoteConnection remoteConnection, CommunicationException communicationException) {
        block4: {
            if (this.rcm.getTransportManager().shouldRemoveConnectionOnError()) {
                Object[] objectArray = new Object[]{remoteConnection.getServiceId(), communicationException.getInternalException()};
                this.rcm.logWarning("drop_connection_on_error", objectArray);
                this.rcm.getTransportManager().removeConnectionToExternalService(remoteConnection);
            } else {
                Object[] objectArray = new Object[]{remoteConnection.getServiceId(), communicationException};
                this.rcm.logWarning("failed_command_propagation", objectArray);
                RemoteCommandManagerException remoteCommandManagerException = RemoteCommandManagerException.unableToPropagateCommand(remoteConnection.toString(), communicationException.getInternalException());
                try {
                    this.rcm.handleException(remoteCommandManagerException);
                }
                catch (RuntimeException runtimeException) {
                    if (this.connection != null) break block4;
                    throw runtimeException;
                }
            }
        }
    }

    public void run() {
        if (this.connection != null) {
            this.propagateCommand(this.connection);
        } else {
            Hashtable hashtable = this.rcm.getTransportManager().getConnectionsToExternalServicesForCommandPropagation();
            Enumeration enumeration = hashtable.elements();
            if (hashtable.size() == 1) {
                this.connection = (RemoteConnection)enumeration.nextElement();
                this.propagateCommand(this.connection);
            } else {
                while (enumeration.hasMoreElements()) {
                    RemoteConnection remoteConnection = (RemoteConnection)enumeration.nextElement();
                    CommandPropagator commandPropagator = new CommandPropagator(this.rcm, this.command, remoteConnection);
                    this.rcm.getServerPlatform().launchContainerRunnable(commandPropagator);
                }
            }
        }
    }
}

