/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.xr;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.persistence.exceptions.DBWSException;
import org.eclipse.persistence.internal.xr.Parameter;
import org.eclipse.persistence.internal.xr.ProcedureArgument;
import org.eclipse.persistence.internal.xr.ProcedureOutputArgument;
import org.eclipse.persistence.internal.xr.QueryHandler;
import org.eclipse.persistence.internal.xr.QueryOperation;
import org.eclipse.persistence.internal.xr.Util;
import org.eclipse.persistence.internal.xr.XRServiceAdapter;
import org.eclipse.persistence.queries.DataModifyQuery;
import org.eclipse.persistence.queries.DataReadQuery;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.queries.StoredProcedureCall;
import org.eclipse.persistence.queries.ValueReadQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoredProcedureQueryHandler
extends QueryHandler {
    protected String name;
    protected List<ProcedureArgument> inArguments = new ArrayList<ProcedureArgument>();
    protected List<ProcedureOutputArgument> inOutArguments = new ArrayList<ProcedureOutputArgument>();
    protected List<ProcedureOutputArgument> outArguments = new ArrayList<ProcedureOutputArgument>();

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public List<ProcedureArgument> getInArguments() {
        return this.inArguments;
    }

    public List<ProcedureOutputArgument> getInOutArguments() {
        return this.inOutArguments;
    }

    public List<ProcedureOutputArgument> getOutArguments() {
        return this.outArguments;
    }

    public boolean isStoredFunctionQueryHandler() {
        return false;
    }

    @Override
    public void initializeDatabaseQuery(XRServiceAdapter xRServiceAdapter, QueryOperation queryOperation) {
        DatabaseQuery databaseQuery;
        if (queryOperation.hasResponse()) {
            QName qName = queryOperation.getResult().getType();
            databaseQuery = queryOperation.isCollection() ? (queryOperation.isSimpleXMLFormat() ? new DataReadQuery() : (!xRServiceAdapter.descriptorsByQName.containsKey(qName) ? new DataReadQuery() : new ReadAllQuery(xRServiceAdapter.getTypeClass(qName)))) : (this.getOutArguments().size() == 0 && this.getInOutArguments().size() == 0 ? (this.isStoredFunctionQueryHandler() ? (!xRServiceAdapter.descriptorsByQName.containsKey(qName) ? new ValueReadQuery() : new ReadObjectQuery(xRServiceAdapter.getTypeClass(qName))) : new DataModifyQuery()) : (!xRServiceAdapter.descriptorsByQName.containsKey(qName) ? (qName.equals(Util.SXF_QNAME) ? new DataReadQuery() : new ValueReadQuery()) : new ReadObjectQuery(xRServiceAdapter.getTypeClass(qName))));
        } else {
            databaseQuery = new DataModifyQuery();
        }
        databaseQuery.bindAllParameters();
        this.setDatabaseQuery(databaseQuery);
    }

    @Override
    public void initializeCall(XRServiceAdapter xRServiceAdapter, QueryOperation queryOperation, DatabaseQuery databaseQuery) {
        StoredProcedureCall storedProcedureCall = this.createCall();
        if (this.getName() != null) {
            storedProcedureCall.setProcedureName(this.getName());
        } else {
            storedProcedureCall.setProcedureName(queryOperation.getName());
        }
        QName qName = queryOperation.getResultType();
        if (this.getInOutArguments().size() + this.getOutArguments().size() > 1 && !queryOperation.isSimpleXMLFormat()) {
            throw DBWSException.multipleOutputArgumentsOnlySupportedForSimpleXML();
        }
        for (Parameter object : queryOperation.getParameters()) {
            ProcedureArgument procedureArgument = this.findInOutArgument(object.getName());
            String string = object.getName();
            if (procedureArgument != null) {
                string = procedureArgument.getName();
            }
            if (procedureArgument != null && procedureArgument instanceof ProcedureOutputArgument) {
                if (this.isCursorType(xRServiceAdapter, object.getType())) {
                    throw DBWSException.inoutCursorArgumentsNotSupported();
                }
                storedProcedureCall.addNamedInOutputArgument(string, object.getName());
                continue;
            }
            storedProcedureCall.addNamedArgument(string, object.getName());
        }
        if (queryOperation.hasResponse()) {
            if (!queryOperation.isSimpleXMLFormat() || storedProcedureCall.isStoredFunctionCall() && !this.isCursorType(xRServiceAdapter, qName)) {
                this.setSingleResult(xRServiceAdapter, storedProcedureCall, qName);
            } else if (storedProcedureCall.isStoredFunctionCall() && this.isCursorType(xRServiceAdapter, qName)) {
                storedProcedureCall.useUnnamedCursorOutputAsResultSet();
            } else if (this.getOutArguments().isEmpty()) {
                storedProcedureCall.useUnnamedCursorOutputAsResultSet();
            } else {
                for (ProcedureOutputArgument procedureOutputArgument : this.getOutArguments()) {
                    if (procedureOutputArgument.getResultType() != null && this.isCursorType(xRServiceAdapter, procedureOutputArgument.getResultType())) {
                        storedProcedureCall.useNamedCursorOutputAsResultSet(procedureOutputArgument.getName());
                        continue;
                    }
                    storedProcedureCall.addNamedOutputArgument(procedureOutputArgument.getName());
                }
            }
        }
        databaseQuery.setCall(storedProcedureCall);
    }

    @Override
    public void initializeArguments(XRServiceAdapter xRServiceAdapter, QueryOperation queryOperation, DatabaseQuery databaseQuery) {
        for (Parameter parameter : queryOperation.getParameters()) {
            databaseQuery.addArgument(parameter.getName());
        }
    }

    protected void setSingleResult(XRServiceAdapter xRServiceAdapter, StoredProcedureCall storedProcedureCall, QName qName) {
        if (this.getOutArguments().size() == 1) {
            ProcedureArgument procedureArgument = this.getOutArguments().get(0);
            if (this.isCursorType(xRServiceAdapter, qName)) {
                storedProcedureCall.useNamedCursorOutputAsResultSet(procedureArgument.getName());
            } else {
                storedProcedureCall.addNamedOutputArgument(procedureArgument.getName());
            }
        }
    }

    protected StoredProcedureCall createCall() {
        StoredProcedureCall storedProcedureCall = new StoredProcedureCall();
        return storedProcedureCall;
    }

    private ProcedureArgument findInOutArgument(String string) {
        for (ProcedureArgument procedureArgument : this.getInArguments()) {
            if (procedureArgument.getParameterName() != null && procedureArgument.getParameterName().equalsIgnoreCase(string)) {
                return procedureArgument;
            }
            if (!procedureArgument.getName().equalsIgnoreCase(string)) continue;
            return procedureArgument;
        }
        for (ProcedureOutputArgument procedureOutputArgument : this.getInOutArguments()) {
            if (procedureOutputArgument.getParameterName() != null && procedureOutputArgument.getParameterName().equalsIgnoreCase(string)) {
                return procedureOutputArgument;
            }
            if (!procedureOutputArgument.getName().equalsIgnoreCase(string)) continue;
            return procedureOutputArgument;
        }
        return null;
    }

    protected boolean isCursorType(XRServiceAdapter xRServiceAdapter, QName qName) {
        return qName.getLocalPart().startsWith("cursor of");
    }
}

