/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.xr;

import java.io.InputStream;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import org.eclipse.persistence.exceptions.DBWSException;
import org.eclipse.persistence.internal.dynamicpersist.BaseEntityClassLoader;
import org.eclipse.persistence.internal.oxm.schema.SchemaModelProject;
import org.eclipse.persistence.internal.oxm.schema.model.Schema;
import org.eclipse.persistence.internal.xr.Operation;
import org.eclipse.persistence.internal.xr.ProjectHelper;
import org.eclipse.persistence.internal.xr.Util;
import org.eclipse.persistence.internal.xr.XRServiceAdapter;
import org.eclipse.persistence.internal.xr.XRServiceModel;
import org.eclipse.persistence.internal.xr.XRSessionConfigLoader;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLConstants;
import org.eclipse.persistence.oxm.XMLContext;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLLogin;
import org.eclipse.persistence.oxm.XMLUnmarshaller;
import org.eclipse.persistence.oxm.schema.XMLSchemaReference;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.factories.SessionManager;

public class XRServiceFactory {
    public XRServiceAdapter xrService;
    public ClassLoader parentClassLoader;
    public InputStream xrSchemaStream;

    public XRServiceAdapter buildService() {
        this.initializeService(this.parentClassLoader, this.xrSchemaStream);
        return this.xrService;
    }

    public XRServiceAdapter buildService(XRServiceModel xRServiceModel) {
        this.xrService = new XRServiceAdapter();
        this.xrService.setName(xRServiceModel.getName());
        this.xrService.setSessionsFile(xRServiceModel.getSessionsFile());
        this.xrService.setOperations(xRServiceModel.getOperations());
        this.initializeService(this.parentClassLoader, this.xrSchemaStream);
        return this.xrService;
    }

    public void initializeService(ClassLoader classLoader, InputStream inputStream) {
        this.parentClassLoader = classLoader;
        this.xrSchemaStream = inputStream;
        this.loadXMLSchema(inputStream);
        this.logoutSessions();
        this.buildSessions();
        this.customizeSession(this.xrService.orSession, this.xrService.oxSession);
        this.buildDescriptorIndex();
        this.validateOperations();
        this.initializeOperations();
        this.loginSessions();
    }

    public void customizeSession(Session session, Session session2) {
    }

    public void loadXMLSchema(InputStream inputStream) {
        SchemaModelProject schemaModelProject = new SchemaModelProject();
        XMLContext xMLContext = new XMLContext(schemaModelProject);
        XMLUnmarshaller xMLUnmarshaller = xMLContext.createUnmarshaller();
        Schema schema = (Schema)xMLUnmarshaller.unmarshal(inputStream);
        NamespaceResolver namespaceResolver = schema.getNamespaceResolver();
        String string = schema.getTargetNamespace();
        namespaceResolver.put("ns1", string);
        this.xrService.schema = schema;
        this.xrService.schemaNamespace = string;
    }

    public void buildSessions() {
        String string;
        BaseEntityClassLoader baseEntityClassLoader = new BaseEntityClassLoader(this.parentClassLoader);
        SessionManager sessionManager = SessionManager.getManager();
        boolean bl = false;
        String string2 = this.xrService.sessionsFile == null ? "eclipselink-dbws-sessions.xml" : this.xrService.sessionsFile;
        for (String string3 : Util.META_INF_PATHS) {
            String string4 = string3 + string2;
            XRSessionConfigLoader xRSessionConfigLoader = new XRSessionConfigLoader(string4);
            xRSessionConfigLoader.setShouldLogin(false);
            try {
                bl = xRSessionConfigLoader.load(sessionManager, baseEntityClassLoader);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            if (bl) break;
        }
        if (!bl) {
            throw DBWSException.couldNotLocateFile("eclipselink-dbws-sessions.xml");
        }
        Map map = sessionManager.getSessions();
        if (!map.containsKey(string = this.xrService.name + "-" + "dbws-or-session")) {
            throw DBWSException.couldNotLocateORSessionForService(this.xrService.name);
        }
        this.xrService.orSession = (Session)map.get(string);
        String string5 = this.xrService.name + "-" + "dbws-ox-session";
        if (!map.containsKey(string5)) {
            throw DBWSException.couldNotLocateOXSessionForService(this.xrService.name);
        }
        this.xrService.oxSession = (Session)map.get(string5);
        ((XMLLogin)this.xrService.oxSession.getDatasourceLogin()).setEqualNamespaceResolvers(false);
        ProjectHelper.fixOROXAccessors(this.xrService.orSession.getProject(), this.xrService.oxSession.getProject());
        this.xrService.xmlContext = new XMLContext(this.xrService.oxSession.getProject());
        this.xrService.oxSession = this.xrService.xmlContext.getSession(0);
    }

    public void loginSessions() {
        ((DatabaseSession)this.xrService.orSession).login();
    }

    public void buildDescriptorIndex() {
        for (XMLDescriptor xMLDescriptor : this.xrService.oxSession.getProject().getOrderedDescriptors()) {
            String string;
            QName qName;
            String string2;
            XMLSchemaReference xMLSchemaReference = xMLDescriptor.getSchemaReference();
            if (xMLSchemaReference == null || xMLSchemaReference.getType() != 1 || (string2 = xMLSchemaReference.getSchemaContext()) == null || string2.lastIndexOf(47) != 0 || (qName = this.resolveName(string = string2.substring(1), xMLDescriptor.getNamespaceResolver())) == null) continue;
            this.xrService.descriptorsByQName.put(qName, xMLDescriptor);
        }
    }

    public void validateOperations() {
        for (Operation operation : this.xrService.getOperationsList()) {
            operation.validate(this.xrService);
        }
    }

    public void initializeOperations() {
        for (Operation operation : this.xrService.getOperationsList()) {
            operation.initialize(this.xrService);
        }
    }

    protected void logoutSessions() {
        String string;
        SessionManager sessionManager = SessionManager.getManager();
        Map map = sessionManager.getSessions();
        Session session = (Session)map.remove(string = this.xrService.name + "-" + "dbws-or-session");
        if (session != null && session.isConnected()) {
            ((DatabaseSession)session).logout();
        }
        String string2 = this.xrService.name + "-" + "dbws-ox-session";
        map.remove(string2);
        this.xrService.orSession = null;
        this.xrService.oxSession = null;
    }

    protected QName resolveName(String string, NamespaceResolver namespaceResolver) {
        if (namespaceResolver == null) {
            return null;
        }
        if ("any".equals(string)) {
            return XMLConstants.ANY_QNAME;
        }
        int n = string.indexOf(58);
        if (n != -1) {
            String string2 = namespaceResolver.resolveNamespacePrefix(string.substring(0, n));
            return new QName(string2, string.substring(n + 1));
        }
        if (namespaceResolver.getDefaultNamespaceURI() != null) {
            return new QName(namespaceResolver.getDefaultNamespaceURI(), string);
        }
        String string3 = namespaceResolver.resolveNamespacePrefix("xmlns");
        return new QName(string3, string);
    }

    public static DocumentBuilder getDocumentBuilder() {
        DocumentBuilder documentBuilder = null;
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
        return documentBuilder;
    }

    public static Transformer getTransformer() {
        Transformer transformer = null;
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformer = transformerFactory.newTransformer();
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            // empty catch block
        }
        return transformer;
    }
}

