/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.mappings;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.OptimisticLockException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.descriptors.CascadeLockingPolicy;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.mappings.RelationalMapping;
import org.eclipse.persistence.mappings.foundation.MapComponentMapping;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.DeleteAllQuery;
import org.eclipse.persistence.queries.DeleteObjectQuery;
import org.eclipse.persistence.queries.InsertObjectQuery;
import org.eclipse.persistence.queries.ObjectLevelModifyQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.WriteObjectQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OneToManyMapping
extends CollectionMapping
implements RelationalMapping,
MapComponentMapping {
    protected transient Vector<DatabaseField> targetForeignKeyFields;
    protected transient Vector<DatabaseField> sourceKeyFields;
    protected transient Map<DatabaseField, DatabaseField> targetForeignKeysToSourceKeys = new HashMap<DatabaseField, DatabaseField>(2);
    protected transient Map<DatabaseField, DatabaseField> sourceKeysToTargetForeignKeys = new HashMap<DatabaseField, DatabaseField>(2);

    public OneToManyMapping() {
        this.sourceKeyFields = NonSynchronizedVector.newInstance(1);
        this.targetForeignKeyFields = NonSynchronizedVector.newInstance(1);
        this.deleteAllQuery = new DeleteAllQuery();
    }

    @Override
    public boolean isRelationalMapping() {
        return true;
    }

    public void addTargetForeignKeyField(DatabaseField databaseField, DatabaseField databaseField2) {
        this.getTargetForeignKeyFields().addElement(databaseField);
        this.getSourceKeyFields().addElement(databaseField2);
    }

    public void addTargetForeignKeyFieldName(String string, String string2) {
        this.addTargetForeignKeyField(new DatabaseField(string), new DatabaseField(string2));
    }

    protected Expression buildDefaultSelectionCriteria() {
        Expression expression = null;
        ExpressionBuilder expressionBuilder = new ExpressionBuilder();
        for (DatabaseField databaseField : this.getTargetForeignKeysToSourceKeys().keySet()) {
            DatabaseField databaseField2 = this.getTargetForeignKeysToSourceKeys().get(databaseField);
            Expression expression2 = ((Expression)expressionBuilder).getField(databaseField).equal(expressionBuilder.getParameter(databaseField2));
            expression = expression2.and(expression);
        }
        return expression;
    }

    public Expression buildSelectionCriteria() {
        Expression expression = null;
        ExpressionBuilder expressionBuilder = new ExpressionBuilder();
        Enumeration<DatabaseField> enumeration = this.getSourceKeyFields().elements();
        Enumeration<DatabaseField> enumeration2 = this.getTargetForeignKeyFields().elements();
        while (enumeration2.hasMoreElements()) {
            DatabaseField databaseField = enumeration2.nextElement();
            DatabaseField databaseField2 = enumeration.nextElement();
            Expression expression2 = ((Expression)expressionBuilder).getField(databaseField).equal(expressionBuilder.getParameter(databaseField2));
            expression = expression2.and(expression);
        }
        return expression;
    }

    @Override
    public Object clone() {
        OneToManyMapping oneToManyMapping = (OneToManyMapping)super.clone();
        oneToManyMapping.setTargetForeignKeysToSourceKeys(new HashMap<DatabaseField, DatabaseField>(this.getTargetForeignKeysToSourceKeys()));
        return oneToManyMapping;
    }

    protected void deleteAll(DeleteObjectQuery deleteObjectQuery) throws DatabaseException {
        Object object = this.getAttributeAccessor().getAttributeValueFromObject(deleteObjectQuery.getObject());
        if (this.usesIndirection() && (object == null || !this.getIndirectionPolicy().objectIsInstantiated(object))) {
            ((DeleteAllQuery)this.getDeleteAllQuery()).executeDeleteAll(deleteObjectQuery.getSession().getSessionForClass(this.getReferenceClass()), deleteObjectQuery.getTranslationRow(), new Vector(0));
            return;
        }
        Object object2 = this.getRealCollectionAttributeValueFromObject(deleteObjectQuery.getObject(), deleteObjectQuery.getSession());
        ((DeleteAllQuery)this.getDeleteAllQuery()).executeDeleteAll(deleteObjectQuery.getSession().getSessionForClass(this.getReferenceClass()), deleteObjectQuery.getTranslationRow(), this.getContainerPolicy().vectorFor(object2, deleteObjectQuery.getSession()));
    }

    protected void deleteReferenceObjectsLeftOnDatabase(DeleteObjectQuery deleteObjectQuery) throws DatabaseException, OptimisticLockException {
        Object object = this.readPrivateOwnedForObject(deleteObjectQuery);
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        Object object2 = containerPolicy.iteratorFor(object);
        while (containerPolicy.hasNext(object2)) {
            deleteObjectQuery.getSession().deleteObject(containerPolicy.next(object2, deleteObjectQuery.getSession()));
        }
    }

    protected Hashtable executeBatchQuery(DatabaseQuery databaseQuery, AbstractSession abstractSession, AbstractRecord abstractRecord) {
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        ContainerPolicy containerPolicy2 = ((ReadAllQuery)databaseQuery).getContainerPolicy();
        Object object = null;
        object = abstractSession.executeQuery(databaseQuery, abstractRecord);
        Hashtable hashtable = new Hashtable(containerPolicy2.sizeFor(object));
        Object object2 = containerPolicy2.iteratorFor(object);
        while (containerPolicy2.hasNext(object2)) {
            Object object3 = containerPolicy2.next(object2, abstractSession);
            CacheKey cacheKey = new CacheKey(this.extractForeignKeyFromReferenceObject(object3, abstractSession));
            Object object4 = hashtable.get(cacheKey);
            if (object4 == null) {
                object4 = containerPolicy.containerInstance();
                hashtable.put(cacheKey, object4);
            }
            containerPolicy.addInto(object3, object4, abstractSession);
        }
        return hashtable;
    }

    protected Vector extractForeignKeyFromReferenceObject(Object object, AbstractSession abstractSession) {
        Vector<Object> vector = new Vector<Object>(this.getTargetForeignKeysToSourceKeys().size());
        for (Map.Entry<DatabaseField, DatabaseField> entry : this.getTargetForeignKeysToSourceKeys().entrySet()) {
            DatabaseField databaseField = entry.getKey();
            DatabaseField databaseField2 = entry.getValue();
            if (object == null) {
                vector.addElement(null);
                continue;
            }
            Object object2 = this.getReferenceDescriptor().getObjectBuilder().extractValueFromObjectForField(object, databaseField, abstractSession);
            try {
                object2 = abstractSession.getDatasourcePlatform().convertObject(object2, this.getDescriptor().getObjectBuilder().getFieldClassification(databaseField2));
            }
            catch (ConversionException conversionException) {
                throw ConversionException.couldNotBeConverted((Object)this, this.getDescriptor(), conversionException);
            }
            vector.addElement(object2);
        }
        return vector;
    }

    protected Vector extractKeyFromRow(AbstractRecord abstractRecord, AbstractSession abstractSession) {
        Vector<Object> vector = new Vector<Object>(this.getTargetForeignKeysToSourceKeys().size());
        for (DatabaseField databaseField : this.getTargetForeignKeysToSourceKeys().values()) {
            Object object = abstractRecord.get(databaseField);
            try {
                object = abstractSession.getDatasourcePlatform().convertObject(object, this.getDescriptor().getObjectBuilder().getFieldClassification(databaseField));
            }
            catch (ConversionException conversionException) {
                throw ConversionException.couldNotBeConverted((Object)this, this.getDescriptor(), conversionException);
            }
            vector.addElement(object);
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object extractResultFromBatchQuery(DatabaseQuery databaseQuery, AbstractRecord abstractRecord, AbstractSession abstractSession, AbstractRecord abstractRecord2) {
        Hashtable hashtable = null;
        DatabaseQuery databaseQuery2 = databaseQuery;
        synchronized (databaseQuery2) {
            hashtable = this.getBatchReadObjects(databaseQuery, abstractSession);
            if (hashtable == null) {
                hashtable = this.executeBatchQuery(databaseQuery, abstractSession, abstractRecord2);
                this.setBatchReadObjects(hashtable, databaseQuery, abstractSession);
            }
        }
        databaseQuery2 = hashtable.get(new CacheKey(this.extractKeyFromRow(abstractRecord, abstractSession)));
        if (databaseQuery2 == null) {
            return this.getContainerPolicy().containerInstance();
        }
        return databaseQuery2;
    }

    public Vector getSourceKeyFieldNames() {
        Vector<String> vector = new Vector<String>(this.getSourceKeyFields().size());
        Enumeration<DatabaseField> enumeration = this.getSourceKeyFields().elements();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement().getQualifiedName());
        }
        return vector;
    }

    public Vector<DatabaseField> getSourceKeyFields() {
        return this.sourceKeyFields;
    }

    public Map<DatabaseField, DatabaseField> getSourceKeysToTargetForeignKeys() {
        return this.sourceKeysToTargetForeignKeys;
    }

    public Vector getTargetForeignKeyFieldNames() {
        Vector<String> vector = new Vector<String>(this.getTargetForeignKeyFields().size());
        Enumeration<DatabaseField> enumeration = this.getTargetForeignKeyFields().elements();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement().getQualifiedName());
        }
        return vector;
    }

    public Vector<DatabaseField> getTargetForeignKeyFields() {
        return this.targetForeignKeyFields;
    }

    public Map<DatabaseField, DatabaseField> getTargetForeignKeysToSourceKeys() {
        return this.targetForeignKeysToSourceKeys;
    }

    public Map getTargetForeignKeyToSourceKeys() {
        return this.getTargetForeignKeysToSourceKeys();
    }

    @Override
    public boolean hasInverseConstraintDependency() {
        return true;
    }

    @Override
    public void initialize(AbstractSession abstractSession) throws DescriptorException {
        super.initialize(abstractSession);
        if (!this.isSourceKeySpecified()) {
            this.setSourceKeyFields(NonSynchronizedVector.newInstance(this.getDescriptor().getPrimaryKeyFields()));
        }
        this.initializeTargetForeignKeysToSourceKeys();
        if (this.shouldInitializeSelectionCriteria()) {
            this.setSelectionCriteria(this.buildDefaultSelectionCriteria());
        }
        this.initializeDeleteAllQuery();
        if (this.getReferenceDescriptor() != null && this.getReferenceDescriptor().hasTablePerClassPolicy()) {
            this.getReferenceDescriptor().getTablePerClassPolicy().prepareChildrenSelectionQuery(this, abstractSession);
        }
    }

    protected void initializeDeleteAllQuery() {
        ((DeleteAllQuery)this.getDeleteAllQuery()).setReferenceClass(this.getReferenceClass());
        if (!this.hasCustomDeleteAllQuery()) {
            if (this.getSelectionCriteria() == null) {
                this.getDeleteAllQuery().setSelectionCriteria(this.buildDefaultSelectionCriteria());
            } else {
                this.getDeleteAllQuery().setSelectionCriteria(this.getSelectionCriteria());
            }
        }
    }

    protected void initializeTargetForeignKeysToSourceKeys() throws DescriptorException {
        Object object;
        int n;
        if (this.getTargetForeignKeyFields().isEmpty()) {
            if (this.shouldInitializeSelectionCriteria()) {
                throw DescriptorException.noTargetForeignKeysSpecified(this);
            }
            return;
        }
        if (this.getTargetForeignKeyFields().size() != this.getSourceKeyFields().size()) {
            throw DescriptorException.targetForeignKeysSizeMismatch(this);
        }
        for (n = 0; n < this.getTargetForeignKeyFields().size(); ++n) {
            object = this.getReferenceDescriptor().buildField(this.getTargetForeignKeyFields().get(n));
            this.getTargetForeignKeyFields().set(n, (DatabaseField)object);
        }
        for (n = 0; n < this.getSourceKeyFields().size(); ++n) {
            object = this.getDescriptor().buildField(this.getSourceKeyFields().get(n));
            this.getSourceKeyFields().set(n, (DatabaseField)object);
        }
        Iterator<DatabaseField> iterator = this.getTargetForeignKeyFields().iterator();
        object = this.getSourceKeyFields().iterator();
        while (iterator.hasNext()) {
            DatabaseField databaseField = iterator.next();
            DatabaseField databaseField2 = (DatabaseField)object.next();
            this.getTargetForeignKeysToSourceKeys().put(databaseField, databaseField2);
            this.getSourceKeysToTargetForeignKeys().put(databaseField2, databaseField);
        }
    }

    @Override
    public boolean isOneToManyMapping() {
        return true;
    }

    protected boolean isSourceKeySpecified() {
        return !this.getSourceKeyFields().isEmpty();
    }

    @Override
    public void postInsert(WriteObjectQuery writeObjectQuery) throws DatabaseException, OptimisticLockException {
        if (!this.shouldObjectModifyCascadeToParts(writeObjectQuery)) {
            return;
        }
        if (writeObjectQuery.shouldCascadeOnlyDependentParts()) {
            return;
        }
        Object object = this.getRealCollectionAttributeValueFromObject(writeObjectQuery.getObject(), writeObjectQuery.getSession());
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        Object object2 = containerPolicy.iteratorFor(object);
        while (containerPolicy.hasNext(object2)) {
            WriteObjectQuery writeObjectQuery2;
            Object object3 = containerPolicy.next(object2, writeObjectQuery.getSession());
            if (this.isPrivateOwned()) {
                writeObjectQuery2 = new InsertObjectQuery();
                writeObjectQuery2.setIsExecutionClone(true);
                writeObjectQuery2.setObject(object3);
                writeObjectQuery2.setCascadePolicy(writeObjectQuery.getCascadePolicy());
                writeObjectQuery.getSession().executeQuery(writeObjectQuery2);
                continue;
            }
            if (writeObjectQuery.getSession().getCommitManager().isCommitInPreModify(object3)) continue;
            writeObjectQuery2 = new WriteObjectQuery();
            writeObjectQuery2.setIsExecutionClone(true);
            writeObjectQuery2.setObject(object3);
            writeObjectQuery2.setCascadePolicy(writeObjectQuery.getCascadePolicy());
            writeObjectQuery.getSession().executeQuery(writeObjectQuery2);
        }
    }

    @Override
    public void postUpdate(WriteObjectQuery writeObjectQuery) throws DatabaseException, OptimisticLockException {
        if (!this.shouldObjectModifyCascadeToParts(writeObjectQuery)) {
            return;
        }
        if (!this.isAttributeValueInstantiatedOrChanged(writeObjectQuery.getObject())) {
            return;
        }
        Object object = this.getRealCollectionAttributeValueFromObject(writeObjectQuery.getObject(), writeObjectQuery.getSession());
        Object object2 = this.readPrivateOwnedForObject(writeObjectQuery);
        this.compareObjectsAndWrite(object2, object, writeObjectQuery);
    }

    @Override
    public void preDelete(DeleteObjectQuery deleteObjectQuery) throws DatabaseException, OptimisticLockException {
        if (!this.shouldObjectModifyCascadeToParts(deleteObjectQuery)) {
            return;
        }
        Object object = this.getRealCollectionAttributeValueFromObject(deleteObjectQuery.getObject(), deleteObjectQuery.getSession());
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        if (this.mustDeleteReferenceObjectsOneByOne()) {
            Object object2 = containerPolicy.iteratorFor(object);
            while (containerPolicy.hasNext(object2)) {
                DeleteObjectQuery deleteObjectQuery2 = new DeleteObjectQuery();
                deleteObjectQuery2.setIsExecutionClone(true);
                deleteObjectQuery2.setObject(containerPolicy.next(object2, deleteObjectQuery.getSession()));
                deleteObjectQuery2.setCascadePolicy(deleteObjectQuery.getCascadePolicy());
                deleteObjectQuery.getSession().executeQuery(deleteObjectQuery2);
            }
            if (!deleteObjectQuery.getSession().isUnitOfWork()) {
                this.deleteReferenceObjectsLeftOnDatabase(deleteObjectQuery);
            }
        } else {
            this.deleteAll(deleteObjectQuery);
        }
    }

    @Override
    public void prepareCascadeLockingPolicy() {
        CascadeLockingPolicy cascadeLockingPolicy = new CascadeLockingPolicy(this.getDescriptor(), this.getReferenceDescriptor());
        cascadeLockingPolicy.setQueryKeyFields(this.getSourceKeysToTargetForeignKeys());
        this.getReferenceDescriptor().addCascadeLockingPolicy(cascadeLockingPolicy);
    }

    @Override
    public void setDeleteAllSQLString(String string) {
        DeleteAllQuery deleteAllQuery = new DeleteAllQuery();
        deleteAllQuery.setSQLString(string);
        this.setCustomDeleteAllQuery(deleteAllQuery);
    }

    public void setSourceKeyFieldNames(Vector vector) {
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance(vector.size());
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ((Vector)nonSynchronizedVector).addElement(new DatabaseField((String)enumeration.nextElement()));
        }
        this.setSourceKeyFields(nonSynchronizedVector);
    }

    public void setSourceKeyFields(Vector<DatabaseField> vector) {
        this.sourceKeyFields = vector;
    }

    public void setTargetForeignKeyFieldName(String string) {
        this.getTargetForeignKeyFields().addElement(new DatabaseField(string));
    }

    public void setTargetForeignKeyFieldNames(String[] stringArray, String[] stringArray2) {
        if (stringArray.length != stringArray2.length) {
            throw DescriptorException.targetForeignKeysSizeMismatch(this);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            this.addTargetForeignKeyFieldName(stringArray[i], stringArray2[i]);
        }
    }

    public void setTargetForeignKeyFieldNames(Vector vector) {
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance(vector.size());
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ((Vector)nonSynchronizedVector).addElement(new DatabaseField((String)enumeration.nextElement()));
        }
        this.setTargetForeignKeyFields(nonSynchronizedVector);
    }

    public void setTargetForeignKeyFields(Vector<DatabaseField> vector) {
        this.targetForeignKeyFields = vector;
    }

    protected void setTargetForeignKeysToSourceKeys(Map<DatabaseField, DatabaseField> map) {
        this.targetForeignKeysToSourceKeys = map;
    }

    @Override
    protected boolean shouldObjectModifyCascadeToParts(ObjectLevelModifyQuery objectLevelModifyQuery) {
        if (this.isReadOnly()) {
            return false;
        }
        if (this.isPrivateOwned()) {
            return true;
        }
        return objectLevelModifyQuery.shouldCascadeAllParts();
    }

    @Override
    public boolean isCascadedLockingSupported() {
        return true;
    }

    @Override
    public boolean isJoiningSupported() {
        return true;
    }

    @Override
    public boolean verifyDelete(Object object, AbstractSession abstractSession) throws DatabaseException {
        if (this.isPrivateOwned()) {
            Object object2 = this.getRealCollectionAttributeValueFromObject(object, abstractSession);
            ContainerPolicy containerPolicy = this.getContainerPolicy();
            Object object3 = containerPolicy.iteratorFor(object2);
            while (containerPolicy.hasNext(object3)) {
                if (abstractSession.verifyDelete(containerPolicy.next(object3, abstractSession))) continue;
                return false;
            }
        }
        return true;
    }
}

