/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm.mappings.nullpolicy;

import java.lang.reflect.Method;
import org.eclipse.persistence.internal.oxm.NillableNodeValue;
import org.eclipse.persistence.internal.oxm.NullCapableValue;
import org.eclipse.persistence.internal.oxm.OptionalNodeValue;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.XPathNode;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.mappings.nullpolicy.AbstractNullPolicy;
import org.eclipse.persistence.oxm.mappings.nullpolicy.XMLNullRepresentationType;
import org.eclipse.persistence.oxm.record.MarshalRecord;
import org.eclipse.persistence.oxm.record.XMLRecord;
import org.eclipse.persistence.sessions.Session;

public class IsSetNullPolicy
extends AbstractNullPolicy {
    private static final Class[] PARAMETER_TYPES = new Class[0];
    private static final Object[] PARAMETERS = new Object[0];
    private String isSetMethodName;
    private Class[] isSetParameterTypes = PARAMETER_TYPES;
    private Object[] isSetParameters = PARAMETERS;
    private Method isSetMethod;

    public IsSetNullPolicy() {
        this.isSetPerformedForAbsentNode = false;
    }

    public IsSetNullPolicy(String string) {
        this();
        this.setIsSetMethodName(string);
    }

    public IsSetNullPolicy(String string, boolean bl, boolean bl2, XMLNullRepresentationType xMLNullRepresentationType) {
        this(string);
        this.setNullRepresentedByEmptyNode(bl);
        this.setNullRepresentedByXsiNil(bl2);
        this.setMarshalNullRepresentation(xMLNullRepresentationType);
    }

    public boolean directMarshal(XPathFragment xPathFragment, MarshalRecord marshalRecord, Object object, Session session, NamespaceResolver namespaceResolver) {
        if (!this.isSet(object)) {
            return false;
        }
        return super.directMarshal(xPathFragment, marshalRecord, object, session, namespaceResolver);
    }

    public boolean compositeObjectMarshal(XPathFragment xPathFragment, MarshalRecord marshalRecord, Object object, Session session, NamespaceResolver namespaceResolver) {
        if (!this.isSet(object)) {
            return false;
        }
        return super.compositeObjectMarshal(xPathFragment, marshalRecord, object, session, namespaceResolver);
    }

    public boolean compositeObjectMarshal(XMLRecord xMLRecord, Object object, XMLField xMLField, AbstractSession abstractSession) {
        if (!this.isSet(object)) {
            return false;
        }
        return super.compositeObjectMarshal(xMLRecord, object, xMLField, abstractSession);
    }

    public void xPathNode(XPathNode xPathNode, NullCapableValue nullCapableValue) {
        if (!this.isNullRepresentedByXsiNil() && !this.getMarshalNullRepresentation().equals((Object)XMLNullRepresentationType.XSI_NIL) && xPathNode.getXPathFragment().isAttribute()) {
            return;
        }
        XPathNode xPathNode2 = xPathNode.getParent();
        if (this.isNullRepresentedByXsiNil() || this.getMarshalNullRepresentation().equals((Object)XMLNullRepresentationType.XSI_NIL)) {
            XPathFragment xPathFragment = new XPathFragment();
            xPathFragment.setXPath("@nil");
            xPathFragment.setNamespaceURI("http://www.w3.org/2001/XMLSchema-instance");
            NillableNodeValue nillableNodeValue = new NillableNodeValue(nullCapableValue);
            xPathNode2.addChild(xPathFragment, nillableNodeValue, null);
        } else {
            OptionalNodeValue optionalNodeValue = new OptionalNodeValue(nullCapableValue);
            xPathNode2.setNodeValue(optionalNodeValue);
        }
    }

    private boolean isSet(Object object) {
        try {
            Boolean bl = (Boolean)PrivilegedAccessHelper.invokeMethod(this.getIsSetMethod(object.getClass()), object, this.isSetParameters);
            return bl;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public String getIsSetMethodName() {
        return this.isSetMethodName;
    }

    public void setIsSetMethodName(String string) {
        this.isSetMethodName = string;
    }

    public Class[] getIsSetParameterTypes() {
        return this.isSetParameterTypes;
    }

    public void setIsSetParameterTypes(Class[] classArray) {
        this.isSetParameterTypes = classArray;
    }

    public Object[] getIsSetParameters() {
        return this.isSetParameters;
    }

    public void setIsSetParameters(Object[] objectArray) {
        this.isSetParameters = objectArray;
    }

    private Method getIsSetMethod(Class clazz) throws NoSuchMethodException {
        if (null == this.isSetMethod) {
            this.isSetMethod = PrivilegedAccessHelper.getPublicMethod(clazz, this.getIsSetMethodName(), this.getIsSetParameterTypes(), false);
        }
        return this.isSetMethod;
    }
}

