/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.database;

import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.expressions.ExpressionOperator;
import org.eclipse.persistence.internal.databaseaccess.DatabaseCall;
import org.eclipse.persistence.internal.databaseaccess.FieldTypeDefinition;
import org.eclipse.persistence.internal.expressions.ExpressionSQLPrinter;
import org.eclipse.persistence.internal.expressions.RelationExpression;
import org.eclipse.persistence.internal.expressions.SQLSelectStatement;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.platform.database.DatabasePlatform;
import org.eclipse.persistence.queries.ValueReadQuery;
import org.eclipse.persistence.tools.schemaframework.FieldDefinition;

public class PostgreSQLPlatform
extends DatabasePlatform {
    private static final String LIMIT = " LIMIT ";
    private static final String OFFSET = " OFFSET ";

    public PostgreSQLPlatform() {
        this.pingSQL = "SELECT 1";
    }

    protected void appendBoolean(Boolean bl, Writer writer) throws IOException {
        if (bl.booleanValue()) {
            writer.write("'1'");
        } else {
            writer.write("'0'");
        }
    }

    public int computeMaxRowsForSQL(int n, int n2) {
        return n2 - (n >= 0 ? n : 0);
    }

    protected void initializePlatformOperators() {
        super.initializePlatformOperators();
        this.addOperator(ExpressionOperator.simpleLogicalNoParens(31, "||"));
        this.addOperator(ExpressionOperator.simpleTwoArgumentFunction(104, "COALESCE"));
        this.addOperator(this.operatorLocate());
        this.addOperator(this.toNumberOperator());
    }

    protected ExpressionOperator toNumberOperator() {
        ExpressionOperator expressionOperator = new ExpressionOperator();
        expressionOperator.setType(5);
        expressionOperator.setSelector(42);
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance(2);
        ((Vector)nonSynchronizedVector).addElement("TO_NUMBER(");
        ((Vector)nonSynchronizedVector).addElement(", '999999999.9999')");
        expressionOperator.printsAs(nonSynchronizedVector);
        expressionOperator.bePrefix();
        expressionOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return expressionOperator;
    }

    public ValueReadQuery getTimestampQuery() {
        if (this.timestampQuery == null) {
            this.timestampQuery = new ValueReadQuery();
            this.timestampQuery.setSQLString("SELECT NOW()");
        }
        return this.timestampQuery;
    }

    public String getInOutputProcedureToken() {
        return "OUT";
    }

    public boolean shouldPrintOutputTokenAtStart() {
        return false;
    }

    public boolean isPostgreSQL() {
        return true;
    }

    protected String getCreateTempTableSqlSuffix() {
        return " ON COMMIT PRESERVE ROWS";
    }

    public boolean shouldPrintAliasForUpdate() {
        return true;
    }

    public boolean supportsIdentity() {
        return true;
    }

    public ValueReadQuery buildSelectQueryForIdentity() {
        ValueReadQuery valueReadQuery = new ValueReadQuery();
        valueReadQuery.setSQLString("select lastval()");
        return valueReadQuery;
    }

    public boolean supportsSequenceObjects() {
        return true;
    }

    public ValueReadQuery buildSelectQueryForSequenceObject(String string, Integer n) {
        return new ValueReadQuery("select nextval('" + this.getQualifiedName(string) + "')");
    }

    protected String getCreateTempTableSqlBodyForTable(DatabaseTable databaseTable) {
        return null;
    }

    public void printFieldIdentityClause(Writer writer) throws ValidationException {
        try {
            writer.write(" SERIAL");
        }
        catch (IOException iOException) {
            throw ValidationException.fileError(iOException);
        }
    }

    protected Hashtable buildFieldTypes() {
        Hashtable<Class<Timestamp>, FieldTypeDefinition> hashtable = new Hashtable<Class<Timestamp>, FieldTypeDefinition>();
        hashtable.put(Boolean.class, new FieldTypeDefinition("BOOLEAN", false));
        hashtable.put(Integer.class, new FieldTypeDefinition("INTEGER", false));
        hashtable.put(Long.class, new FieldTypeDefinition("BIGINT", false));
        hashtable.put(Float.class, new FieldTypeDefinition("FLOAT", false));
        hashtable.put(Double.class, new FieldTypeDefinition("FLOAT", false));
        hashtable.put(Short.class, new FieldTypeDefinition("SMALLINT", false));
        hashtable.put(Byte.class, new FieldTypeDefinition("SMALLINT", false));
        hashtable.put(BigInteger.class, new FieldTypeDefinition("BIGINT", false));
        hashtable.put(BigDecimal.class, new FieldTypeDefinition("DECIMAL", 38));
        hashtable.put(Number.class, new FieldTypeDefinition("DECIMAL", 38));
        hashtable.put(String.class, new FieldTypeDefinition("VARCHAR", 255));
        hashtable.put(Character.class, new FieldTypeDefinition("CHAR", 1));
        hashtable.put(Byte[].class, new FieldTypeDefinition("BYTEA", false));
        hashtable.put(Character[].class, new FieldTypeDefinition("TEXT"));
        hashtable.put(byte[].class, new FieldTypeDefinition("BYTEA", false));
        hashtable.put(char[].class, new FieldTypeDefinition("TEXT"));
        hashtable.put(Blob.class, new FieldTypeDefinition("BYTEA"));
        hashtable.put(Clob.class, new FieldTypeDefinition("TEXT"));
        hashtable.put(Date.class, new FieldTypeDefinition("DATE", false));
        hashtable.put(Time.class, new FieldTypeDefinition("TIME", false));
        hashtable.put(Timestamp.class, new FieldTypeDefinition("TIMESTAMP", false));
        return hashtable;
    }

    protected ExpressionOperator operatorLocate() {
        ExpressionOperator expressionOperator = new ExpressionOperator();
        expressionOperator.setSelector(112);
        Vector<String> vector = new Vector<String>(3);
        vector.addElement("STRPOS(");
        vector.addElement(", ");
        vector.addElement(")");
        expressionOperator.printsAs(vector);
        expressionOperator.bePrefix();
        expressionOperator.setNodeClass(RelationExpression.class);
        return expressionOperator;
    }

    public boolean supportsGlobalTempTables() {
        return true;
    }

    protected String getCreateTempTableSqlPrefix() {
        return "CREATE GLOBAL TEMPORARY TABLE ";
    }

    public int getMaxFieldNameSize() {
        return 63;
    }

    public String getProcedureBeginString() {
        return "AS $$  BEGIN ";
    }

    public String getProcedureEndString() {
        return "; END ; $$ LANGUAGE plpgsql;";
    }

    public String getProcedureCallHeader() {
        return "EXECUTE ";
    }

    public String getAssignmentString() {
        return ":= ";
    }

    public void printFieldTypeSize(Writer writer, FieldDefinition fieldDefinition, FieldTypeDefinition fieldTypeDefinition, boolean bl) throws IOException {
        if (!bl) {
            super.printFieldTypeSize(writer, fieldDefinition, fieldTypeDefinition, bl);
        }
    }

    public void printFieldUnique(Writer writer, boolean bl) throws IOException {
        if (!bl) {
            super.printFieldUnique(writer, bl);
        }
    }

    public boolean shouldUseJDBCOuterJoinSyntax() {
        return false;
    }

    public Writer buildSequenceObjectCreationWriter(Writer writer, String string, int n, int n2) throws IOException {
        writer.write("CREATE SEQUENCE ");
        writer.write(string);
        if (n != 1) {
            writer.write(" INCREMENT BY " + n);
        }
        writer.write(" START WITH " + n2);
        return writer;
    }

    public Writer buildSequenceObjectDeletionWriter(Writer writer, String string) throws IOException {
        writer.write("DROP SEQUENCE ");
        writer.write(string);
        return writer;
    }

    public Writer buildSequenceObjectAlterIncrementWriter(Writer writer, String string, int n) throws IOException {
        writer.write("ALTER SEQUENCE ");
        writer.write(string);
        writer.write(" INCREMENT BY " + n);
        return writer;
    }

    public boolean isAlterSequenceObjectSupported() {
        return true;
    }

    public void printSQLSelectStatement(DatabaseCall databaseCall, ExpressionSQLPrinter expressionSQLPrinter, SQLSelectStatement sQLSelectStatement) {
        int n = 0;
        int n2 = 0;
        if (sQLSelectStatement.getQuery() != null) {
            n = sQLSelectStatement.getQuery().getMaxRows();
            n2 = sQLSelectStatement.getQuery().getFirstResult();
        }
        if (n <= 0 || !this.shouldUseRownumFiltering()) {
            super.printSQLSelectStatement(databaseCall, expressionSQLPrinter, sQLSelectStatement);
            return;
        }
        sQLSelectStatement.setUseUniqueFieldAliases(true);
        databaseCall.setFields(sQLSelectStatement.printSQL(expressionSQLPrinter));
        expressionSQLPrinter.printString(LIMIT);
        expressionSQLPrinter.printParameter(DatabaseCall.MAXROW_FIELD);
        expressionSQLPrinter.printString(OFFSET);
        expressionSQLPrinter.printParameter(DatabaseCall.FIRSTRESULT_FIELD);
        databaseCall.setIgnoreFirstRowMaxResultsSettings(true);
    }
}

