/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sdo.helper;

import commonj.sdo.Property;
import commonj.sdo.Type;
import commonj.sdo.helper.HelperContext;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.eclipse.persistence.internal.descriptors.Namespace;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.oxm.schema.SchemaModelProject;
import org.eclipse.persistence.internal.oxm.schema.model.Annotation;
import org.eclipse.persistence.internal.oxm.schema.model.Any;
import org.eclipse.persistence.internal.oxm.schema.model.AnyAttribute;
import org.eclipse.persistence.internal.oxm.schema.model.Attribute;
import org.eclipse.persistence.internal.oxm.schema.model.Choice;
import org.eclipse.persistence.internal.oxm.schema.model.ComplexContent;
import org.eclipse.persistence.internal.oxm.schema.model.ComplexType;
import org.eclipse.persistence.internal.oxm.schema.model.Element;
import org.eclipse.persistence.internal.oxm.schema.model.Extension;
import org.eclipse.persistence.internal.oxm.schema.model.Import;
import org.eclipse.persistence.internal.oxm.schema.model.Include;
import org.eclipse.persistence.internal.oxm.schema.model.NestedParticle;
import org.eclipse.persistence.internal.oxm.schema.model.Restriction;
import org.eclipse.persistence.internal.oxm.schema.model.Schema;
import org.eclipse.persistence.internal.oxm.schema.model.Sequence;
import org.eclipse.persistence.internal.oxm.schema.model.SimpleComponent;
import org.eclipse.persistence.internal.oxm.schema.model.SimpleType;
import org.eclipse.persistence.internal.oxm.schema.model.TypeDefParticle;
import org.eclipse.persistence.oxm.XMLContext;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLLogin;
import org.eclipse.persistence.oxm.XMLMarshaller;
import org.eclipse.persistence.oxm.platform.DOMPlatform;
import org.eclipse.persistence.sdo.SDOConstants;
import org.eclipse.persistence.sdo.SDOProperty;
import org.eclipse.persistence.sdo.SDOType;
import org.eclipse.persistence.sdo.helper.SDOTypeHelper;
import org.eclipse.persistence.sdo.helper.SDOXMLHelper;
import org.eclipse.persistence.sdo.helper.SchemaLocationResolver;

public class SDOSchemaGenerator {
    private Map namespaceToSchemaLocation;
    private SchemaLocationResolver schemaLocationResolver;
    private List allTypes;
    private Schema generatedSchema;
    private HelperContext aHelperContext;

    public SDOSchemaGenerator(HelperContext helperContext) {
        this.aHelperContext = helperContext;
    }

    public String generate(List list, SchemaLocationResolver schemaLocationResolver) {
        Object object;
        Object object2;
        Object object3;
        this.schemaLocationResolver = schemaLocationResolver;
        if (list == null || list.size() == 0) {
            throw new IllegalArgumentException("No Schema was generated from null or empty list of types.");
        }
        String string = null;
        Type type = (Type)list.get(0);
        string = type.getURI();
        this.allTypes = list;
        this.generateSchema(string, list);
        SchemaModelProject schemaModelProject = new SchemaModelProject();
        Vector vector = this.generatedSchema.getNamespaceResolver().getNamespaces();
        XMLDescriptor xMLDescriptor = (XMLDescriptor)schemaModelProject.getDescriptor(Schema.class);
        for (int i = 0; i < vector.size(); ++i) {
            object3 = (Namespace)vector.get(i);
            xMLDescriptor.getNamespaceResolver().put(((Namespace)object3).getPrefix(), ((Namespace)object3).getNamespaceURI());
            if (!((Namespace)object3).getNamespaceURI().equals("commonj.sdo") && !((Namespace)object3).getNamespaceURI().equals("commonj.sdo/xml") && !((Namespace)object3).getNamespaceURI().equals("commonj.sdo/java") || this.importExists(this.generatedSchema.getImports(), ((Namespace)object3).getNamespaceURI())) continue;
            object2 = new Import();
            ((Import)object2).setNamespace(((Namespace)object3).getNamespaceURI());
            object = "classpath:/xml/";
            if (((Namespace)object3).getNamespaceURI().equals("commonj.sdo")) {
                object = (String)object + "sdoModel.xsd";
            } else if (((Namespace)object3).getNamespaceURI().equals("commonj.sdo/xml")) {
                object = (String)object + "sdoXML.xsd";
            } else if (((Namespace)object3).getNamespaceURI().equals("commonj.sdo/java")) {
                object = (String)object + "sdoJava.xsd";
            }
            try {
                new URL((String)object);
                ((Include)object2).setSchemaLocation((String)object);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            this.generatedSchema.getImports().add(object2);
        }
        XMLLogin xMLLogin = new XMLLogin();
        xMLLogin.setDatasourcePlatform(new DOMPlatform());
        schemaModelProject.setDatasourceLogin(xMLLogin);
        object3 = new XMLContext(schemaModelProject);
        object2 = ((XMLContext)object3).createMarshaller();
        object = new StringWriter();
        ((XMLMarshaller)object2).marshal((Object)this.generatedSchema, (Writer)object);
        return ((StringWriter)object).toString();
    }

    public String generate(List list, Map map) {
        Object object;
        if (list == null || list.size() == 0) {
            throw new IllegalArgumentException("No Schema was generated from null or empty list of types.");
        }
        String string = null;
        this.namespaceToSchemaLocation = map;
        Type type = (Type)list.get(0);
        if (type == null) {
            throw new IllegalArgumentException("No Schema was generated from a list of types containing null elements");
        }
        string = type.getURI();
        this.allTypes = list;
        this.generateSchema(string, list);
        SchemaModelProject schemaModelProject = new SchemaModelProject();
        Vector vector = this.generatedSchema.getNamespaceResolver().getNamespaces();
        for (int i = 0; i < vector.size(); ++i) {
            object = (Namespace)vector.get(i);
            ((XMLDescriptor)schemaModelProject.getDescriptor(Schema.class)).getNamespaceResolver().put(((Namespace)object).getPrefix(), ((Namespace)object).getNamespaceURI());
        }
        XMLLogin xMLLogin = new XMLLogin();
        xMLLogin.setDatasourcePlatform(new DOMPlatform());
        schemaModelProject.setDatasourceLogin(xMLLogin);
        object = new XMLContext(schemaModelProject);
        XMLMarshaller xMLMarshaller = ((XMLContext)object).createMarshaller();
        StringWriter stringWriter = new StringWriter();
        xMLMarshaller.marshal((Object)this.generatedSchema, stringWriter);
        return stringWriter.toString();
    }

    private void generateSchema(String string, List list) {
        this.generatedSchema = new Schema();
        this.generatedSchema.setTargetNamespace(string);
        this.generatedSchema.setDefaultNamespace(string);
        this.generatedSchema.setAttributeFormDefault(false);
        this.generatedSchema.setElementFormDefault(true);
        Element element = null;
        for (int i = 0; i < list.size(); ++i) {
            Object object;
            Object object2;
            String string2;
            Type type = (Type)list.get(i);
            if (type.getBaseTypes() == null || type.getBaseTypes().size() > 1) {
                // empty if block
            }
            if ((string2 = type.getURI()) != string) {
                // empty if block
            }
            if (!type.isDataType() && (object2 = ((SDOType)type).getInstanceClassName()) != null) {
                object = null;
                int n = ((String)object2).lastIndexOf(46);
                if (n != -1) {
                    object = ((String)object2).substring(0, n);
                }
                if (object != null) {
                    element = object;
                }
            }
            if (type.isDataType()) {
                object2 = this.generateSimpleType(type);
                this.generatedSchema.addTopLevelSimpleTypes((SimpleType)object2);
                continue;
            }
            object2 = this.generateComplexType(type);
            this.generatedSchema.addTopLevelComplexTypes((ComplexType)object2);
            object = this.buildElementForComplexType(this.generatedSchema, (ComplexType)object2);
            if (object == null) continue;
            this.generatedSchema.addTopLevelElement((Element)object);
        }
        if (element != null) {
            this.getPrefixForURI("commonj.sdo/java");
            this.generatedSchema.getAttributesMap().put(SDOConstants.SDOJAVA_PACKAGE_QNAME, element);
        }
    }

    private SimpleType generateSimpleType(Type type) {
        Object object;
        Object object2;
        Object object3;
        SimpleType simpleType = new SimpleType();
        String string = ((SDOType)type).getXsdLocalName();
        if (string != null) {
            simpleType.setName(string);
        } else {
            simpleType.setName(type.getName());
        }
        if (((SDOType)type).getAppInfoElements() != null && ((SDOType)type).getAppInfoElements().size() > 0) {
            object3 = new Annotation();
            ((Annotation)object3).setAppInfo(((SDOType)type).getAppInfoElements());
            simpleType.setAnnotation((Annotation)object3);
        }
        if (string != null && !string.equals(type.getName())) {
            object3 = this.getPrefixForURI("commonj.sdo/xml");
            object2 = new QName("commonj.sdo/xml", "name", (String)object3);
            simpleType.getAttributesMap().put(object2, type.getName());
        }
        if (type.getAliasNames() != null && type.getAliasNames().size() > 0) {
            object3 = this.getPrefixForURI("commonj.sdo/xml");
            object2 = this.buildAliasNameString(type.getAliasNames());
            object = new QName("commonj.sdo/xml", "aliasName", (String)object3);
            simpleType.getAttributesMap().put(object, object2);
        }
        if ((object3 = type.get((Property)SDOConstants.JAVA_CLASS_PROPERTY)) != null && object3 instanceof String) {
            object2 = this.getPrefixForURI("commonj.sdo/java");
            object = new QName("commonj.sdo/java", "instanceClass", (String)object2);
            simpleType.getAttributesMap().put(object, object3);
        }
        object2 = null;
        if (type.getBaseTypes() != null && type.getBaseTypes().size() > 0 && (Type)type.getBaseTypes().get(0) != null) {
            object2 = (SDOType)type.getBaseTypes().get(0);
        }
        if (object2 != null) {
            object = new Restriction();
            this.addTypeToListIfNeeded(type, (Type)object2);
            QName qName = ((SDOTypeHelper)this.aHelperContext.getTypeHelper()).getXSDTypeFromSDOType((Type)object2);
            if (qName != null) {
                String string2 = this.getPrefixStringForURI(qName.getNamespaceURI());
                ((Restriction)object).setBaseType(string2 + qName.getLocalPart());
            } else {
                String string3 = this.getPrefixStringForURI(((SDOType)object2).getURI());
                ((Restriction)object).setBaseType(string3 + ((SDOType)object2).getName());
            }
            simpleType.setRestriction((Restriction)object);
        }
        return simpleType;
    }

    private ComplexType generateComplexType(Type type) {
        QName qName;
        Object object;
        Object object2;
        ComplexType complexType = new ComplexType();
        String string = ((SDOType)type).getXsdLocalName();
        if (string != null) {
            complexType.setName(string);
        } else {
            complexType.setName(type.getName());
        }
        if (string != null && !string.equals(type.getName())) {
            object2 = this.getPrefixForURI("commonj.sdo/xml");
            object = new QName("commonj.sdo/xml", "name", (String)object2);
            complexType.getAttributesMap().put(object, type.getName());
        }
        complexType.setAbstractValue(type.isAbstract());
        if (((SDOType)type).getAppInfoElements() != null && ((SDOType)type).getAppInfoElements().size() > 0) {
            object2 = new Annotation();
            ((Annotation)object2).setAppInfo(((SDOType)type).getAppInfoElements());
            complexType.setAnnotation((Annotation)object2);
        }
        if (type.getAliasNames() != null && type.getAliasNames().size() > 0) {
            object2 = this.getPrefixForURI("commonj.sdo/xml");
            object = this.buildAliasNameString(type.getAliasNames());
            qName = new QName("commonj.sdo/xml", "aliasName", (String)object2);
            complexType.getAttributesMap().put(qName, object);
        }
        complexType.setMixed(type.isSequenced());
        object2 = null;
        if (type.getBaseTypes() != null && type.getBaseTypes().size() > 0 && (Type)type.getBaseTypes().get(0) != null) {
            object2 = (Type)type.getBaseTypes().get(0);
        }
        if (object2 != null) {
            this.addTypeToListIfNeeded(type, (Type)object2);
            object = new Extension();
            qName = ((SDOTypeHelper)this.aHelperContext.getTypeHelper()).getXSDTypeFromSDOType((Type)object2);
            if (qName != null) {
                ((Extension)object).setBaseType(this.getPrefixStringForURI(qName.getNamespaceURI()) + qName.getLocalPart());
            } else if (object2.getURI() == null || object2.getURI().equalsIgnoreCase(this.generatedSchema.getTargetNamespace())) {
                ((Extension)object).setBaseType(object2.getName());
            } else {
                ((Extension)object).setBaseType(this.getPrefixStringForURI(object2.getURI()) + object2.getName());
            }
            this.buildElementsAndAttributes(object, type);
            ComplexContent complexContent = new ComplexContent();
            complexContent.setExtension((Extension)object);
            complexType.setComplexContent(complexContent);
            return complexType;
        }
        this.buildElementsAndAttributes(complexType, type);
        return complexType;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void buildElementsAndAttributes(Object object, Type type) {
        Object object2;
        List list = type.getDeclaredProperties();
        TypeDefParticle typeDefParticle = null;
        if (list == null || list.size() == 0) {
            if (!type.isOpen()) return;
            typeDefParticle = new Sequence();
        } else if (type.isSequenced()) {
            typeDefParticle = new Choice();
            typeDefParticle.setMaxOccurs("unbounded");
        } else {
            typeDefParticle = new Sequence();
        }
        for (int i = 0; i < list.size(); ++i) {
            object2 = (Property)list.get(i);
            if (this.aHelperContext.getXSDHelper().isElement((Property)object2)) {
                Element element = this.buildElement((Property)object2, (NestedParticle)((Object)typeDefParticle));
                typeDefParticle.addElement(element);
                continue;
            }
            if (!this.aHelperContext.getXSDHelper().isAttribute((Property)object2)) continue;
            Attribute attribute = this.buildAttribute((Property)object2);
            if (object instanceof ComplexType) {
                ((ComplexType)object).getOrderedAttributes().add(attribute);
                continue;
            }
            if (!(object instanceof Extension)) continue;
            ((Extension)object).getOrderedAttributes().add(attribute);
        }
        if (type.isOpen()) {
            Any any = new Any();
            any.setProcessContents("lax");
            any.setMaxOccurs("unbounded");
            typeDefParticle.addAny(any);
            object2 = new AnyAttribute();
            ((AnyAttribute)object2).setProcessContents("lax");
            if (object instanceof ComplexType) {
                ((ComplexType)object).setAnyAttribute((AnyAttribute)object2);
            }
        }
        if (typeDefParticle.isEmpty()) return;
        if (object instanceof ComplexType) {
            ((ComplexType)object).setTypeDefParticle(typeDefParticle);
            return;
        } else {
            if (!(object instanceof Extension)) return;
            ((Extension)object).setTypeDefParticle(typeDefParticle);
        }
    }

    private void addSimpleComponentAnnotations(SimpleComponent simpleComponent, Property property, boolean bl) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        String string;
        if (property.isReadOnly()) {
            string = this.getPrefixForURI("commonj.sdo/xml");
            object5 = new QName("commonj.sdo/xml", "readOnly", string);
            simpleComponent.getAttributesMap().put(object5, "true");
        }
        if (property.getAliasNames() != null && property.getAliasNames().size() > 0) {
            string = this.getPrefixForURI("commonj.sdo/xml");
            object5 = this.buildAliasNameString(property.getAliasNames());
            object4 = new QName("commonj.sdo/xml", "aliasName", string);
            simpleComponent.getAttributesMap().put(object4, object5);
        }
        if ((string = ((SDOProperty)property).getXsdLocalName()) != null && !string.equals(property.getName())) {
            object5 = this.getPrefixForURI("commonj.sdo/xml");
            object4 = new QName("commonj.sdo/xml", "name", (String)object5);
            simpleComponent.getAttributesMap().put(object4, property.getName());
        }
        if (bl && !property.isContainment() && !property.getType().isDataType() || !bl && !property.getType().isDataType()) {
            object5 = this.getPrefixForURI("commonj.sdo/xml");
            object4 = property.getType().getURI();
            object3 = property.getType().getName();
            if (object4 != null && (object2 = this.getPrefixForURI((String)object4)) != null) {
                object3 = (String)object2 + ":" + (String)object3;
            }
            object2 = new QName("commonj.sdo/xml", "propertyType", (String)object5);
            simpleComponent.getAttributesMap().put(object2, object3);
        }
        if (property.getOpposite() != null) {
            object5 = property.getOpposite().getName();
            object4 = this.getPrefixForURI("commonj.sdo/xml");
            object3 = new QName("commonj.sdo/xml", "oppositeProperty", (String)object4);
            simpleComponent.getAttributesMap().put(object3, object5);
        }
        if ((object4 = (Type)property.get((Property)(object5 = this.aHelperContext.getTypeHelper().getOpenContentProperty("commonj.sdo/xml", "dataType")))) == null) {
            object4 = this.getAutomaticDataTypeForType(property.getType());
        }
        if (object4 != null) {
            String string2;
            object3 = this.getPrefixForURI("commonj.sdo/xml");
            object2 = new QName("commonj.sdo/xml", "dataType", (String)object3);
            object = object4.getName();
            if (object4.getURI() != null && (string2 = this.getPrefixForURI(object4.getURI())) != null) {
                object = string2 + ":" + (String)object;
            }
            simpleComponent.getAttributesMap().put(object2, object);
        }
        if (bl) {
            object3 = (String)property.get((Property)SDOConstants.MIME_TYPE_PROPERTY);
            if (object3 != null) {
                object2 = this.getPrefixForURI("http://www.w3.org/2005/05/xmlmime");
                object = new QName(SDOConstants.XML_MIME_TYPE_QNAME.getNamespaceURI(), SDOConstants.XML_MIME_TYPE_QNAME.getLocalPart(), (String)object2);
                simpleComponent.getAttributesMap().put(object, object3);
            } else {
                object3 = (String)property.get((Property)SDOConstants.MIME_TYPE_PROPERTY_PROPERTY);
                if (object3 != null) {
                    object2 = this.getPrefixForURI("org.eclipse.persistence.sdo");
                    object = new QName(SDOConstants.XML_MIME_TYPE_PROPERTY_QNAME.getNamespaceURI(), SDOConstants.XML_MIME_TYPE_PROPERTY_QNAME.getLocalPart(), (String)object2);
                    simpleComponent.getAttributesMap().put(object, object3);
                }
            }
        }
    }

    private String buildAliasNameString(List list) {
        String string = new String();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            String string2 = (String)list.get(i);
            string = string + string2;
            if (i >= n - 1) continue;
            string = string + " ";
        }
        return string;
    }

    private Element buildElement(Property property, NestedParticle nestedParticle) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Element element = new Element();
        String string = ((SDOProperty)property).getXsdLocalName();
        if (string != null) {
            element.setName(string);
        } else {
            element.setName(property.getName());
        }
        element.setMinOccurs("0");
        element.setNillable(property.isNullable());
        if (((SDOProperty)property).getAppInfoElements() != null && ((SDOProperty)property).getAppInfoElements().size() > 0) {
            object4 = new Annotation();
            ((Annotation)object4).setAppInfo(((SDOProperty)property).getAppInfoElements());
            element.setAnnotation((Annotation)object4);
        }
        if (((SDOProperty)property).isDefaultSet() && !property.isMany() && property.getType().isDataType()) {
            object4 = ((SDOXMLHelper)this.aHelperContext.getXMLHelper()).getXmlConversionManager();
            element.setDefaultValue((String)((XMLConversionManager)object4).convertObject(property.getDefault(), ClassConstants.STRING, ((SDOProperty)property).getXsdType()));
        }
        this.addSimpleComponentAnnotations(element, property, true);
        object4 = null;
        QName qName = ((SDOProperty)property).getXsdType();
        if (qName != null) {
            object4 = ((SDOTypeHelper)this.aHelperContext.getTypeHelper()).getType(qName.getNamespaceURI(), qName.getLocalPart());
            if (property.getType() == SDOConstants.SDO_STRING && object4 != SDOConstants.SDO_STRING) {
                object3 = this.getPrefixForURI("commonj.sdo/xml");
                object2 = new QName("commonj.sdo/xml", "string", (String)object3);
                element.getAttributesMap().put(object2, "true");
            }
        }
        if (!property.isContainment() && !property.getType().isDataType()) {
            qName = SDOConstants.ANY_URI_QNAME;
        }
        if ((object3 = property.getType()) != null) {
            if (property.getContainingType() != null) {
                this.addTypeToListIfNeeded(property.getContainingType(), (Type)object3);
            }
            if (qName == null) {
                qName = ((SDOTypeHelper)this.aHelperContext.getTypeHelper()).getXSDTypeFromSDOType((Type)object3);
            }
            if (qName != null) {
                element.setType(this.getPrefixStringForURI(qName.getNamespaceURI()) + qName.getLocalPart());
                if (object4 != null) {
                    this.addTypeToListIfNeeded(property.getContainingType(), (Type)object4);
                }
            } else if (object3.getURI() == null || object3.getURI().equalsIgnoreCase(this.generatedSchema.getTargetNamespace())) {
                object2 = ((SDOType)object3).getXsdLocalName();
                if (object2 != null) {
                    element.setType((String)object2);
                } else {
                    element.setType(object3.getName());
                }
            } else {
                object2 = null;
                object = ((SDOType)object3).getXsdLocalName();
                object2 = object != null ? object : object3.getName();
                element.setType(this.getPrefixStringForURI(object3.getURI()) + (String)object2);
            }
        } else {
            element.setType("anyURI");
        }
        if (property.isMany()) {
            element.setMaxOccurs("unbounded");
        } else if (nestedParticle.getMaxOccurs() == "unbounded") {
            object2 = this.getPrefixForURI("commonj.sdo/xml");
            object = new QName("commonj.sdo/xml", "many", (String)object2);
            element.getAttributesMap().put(object, "false");
        }
        return element;
    }

    private Attribute buildAttribute(Property property) {
        String string;
        Object object;
        Object object2;
        Attribute attribute = new Attribute();
        String string2 = ((SDOProperty)property).getXsdLocalName();
        if (string2 != null) {
            attribute.setName(string2);
        } else {
            attribute.setName(property.getName());
        }
        if (((SDOProperty)property).getAppInfoElements() != null && ((SDOProperty)property).getAppInfoElements().size() > 0) {
            object2 = new Annotation();
            ((Annotation)object2).setAppInfo(((SDOProperty)property).getAppInfoElements());
            attribute.setAnnotation((Annotation)object2);
        }
        if (((SDOProperty)property).isDefaultSet() && !property.isMany() && property.getType().isDataType()) {
            object2 = ((SDOXMLHelper)this.aHelperContext.getXMLHelper()).getXmlConversionManager();
            attribute.setDefaultValue((String)((XMLConversionManager)object2).convertObject(property.getDefault(), ClassConstants.STRING, ((SDOProperty)property).getXsdType()));
        }
        this.addSimpleComponentAnnotations(attribute, property, false);
        object2 = property.getType();
        QName qName = ((SDOProperty)property).getXsdType();
        if (qName != null) {
            object = ((SDOTypeHelper)this.aHelperContext.getTypeHelper()).getType(qName.getNamespaceURI(), qName.getLocalPart());
            if (property.getType() == SDOConstants.SDO_STRING && object != SDOConstants.SDO_STRING) {
                string = this.getPrefixForURI("commonj.sdo/xml");
                QName qName2 = new QName("commonj.sdo/xml", "string", string);
                attribute.getAttributesMap().put(qName2, "true");
            }
        }
        if (!object2.isDataType()) {
            qName = SDOConstants.ANY_URI_QNAME;
        }
        if (object2 != null) {
            if (property.getContainingType() != null) {
                this.addTypeToListIfNeeded(property.getContainingType(), (Type)object2);
            }
            if (qName == null) {
                qName = ((SDOTypeHelper)this.aHelperContext.getTypeHelper()).getXSDTypeFromSDOType((Type)object2);
            }
            if (qName != null) {
                attribute.setType(this.getPrefixStringForURI(qName.getNamespaceURI()) + qName.getLocalPart());
            } else if (object2.getURI() == null || object2.getURI().equalsIgnoreCase(this.generatedSchema.getTargetNamespace())) {
                object = ((SDOType)object2).getXsdLocalName();
                if (object != null) {
                    attribute.setType((String)object);
                } else {
                    attribute.setType(object2.getName());
                }
            } else {
                object = null;
                string = ((SDOType)object2).getXsdLocalName();
                object = string != null ? string : object2.getName();
                attribute.setType(this.getPrefixStringForURI(object2.getURI()) + (String)object);
            }
        }
        return attribute;
    }

    private void addTypeToListIfNeeded(Type type, Type type2) {
        if (!(type2.getURI() == null || type2.getURI().equals("commonj.sdo") || type2.getURI().equals("commonj.sdo/java") || type2.getURI().equals("commonj.sdo/xml"))) {
            boolean bl = this.allTypes.contains(type2);
            String string = null;
            if (this.namespaceToSchemaLocation != null) {
                string = (String)this.namespaceToSchemaLocation.get(type2.getURI());
                if (type2.getURI().equals(this.generatedSchema.getTargetNamespace())) {
                    if (!bl) {
                        this.allTypes.add(type2);
                    }
                } else if (!this.importExists(this.generatedSchema.getImports(), string)) {
                    Import import_ = new Import();
                    import_.setSchemaLocation(string);
                    import_.setNamespace(type2.getURI());
                    this.generatedSchema.getImports().add(import_);
                }
            } else if (this.schemaLocationResolver != null) {
                string = this.schemaLocationResolver.resolveSchemaLocation(type, type2);
                if (string != null) {
                    if (type2.getURI().equals(this.generatedSchema.getTargetNamespace())) {
                        if (!this.importExists(this.generatedSchema.getIncludes(), string)) {
                            Include include = new Include();
                            include.setSchemaLocation(string);
                            this.generatedSchema.getIncludes().add(include);
                            this.allTypes.remove(type2);
                        }
                    } else if (!this.importExists(this.generatedSchema.getImports(), string)) {
                        Import import_ = new Import();
                        import_.setSchemaLocation(string);
                        import_.setNamespace(type2.getURI());
                        this.generatedSchema.getImports().add(import_);
                    }
                } else if (!bl && type2.getURI().equals(this.generatedSchema.getTargetNamespace())) {
                    this.allTypes.add(type2);
                }
            } else if (!bl && type2.getURI().equals(this.generatedSchema.getTargetNamespace())) {
                this.allTypes.add(type2);
            }
        }
    }

    private Element buildElementForComplexType(Schema schema, ComplexType complexType) {
        Element element = new Element();
        String string = complexType.getName();
        if (string == null) {
            return null;
        }
        String string2 = Character.toLowerCase(string.charAt(0)) + string.substring(1, string.length());
        Object v = schema.getTopLevelElements().get(string2);
        if (v != null) {
            element.setName(string);
        } else {
            element.setName(string2);
        }
        element.setType(complexType.getName());
        return element;
    }

    private String getPrefixStringForURI(String string) {
        if (null == string || "".equals(string)) {
            return "";
        }
        String string2 = this.getPrefixForURI(string);
        if (string2 == null) {
            return "";
        }
        return string2 + ":";
    }

    private String getPrefixForURI(String string) {
        String string2 = null;
        if (string.equals(this.generatedSchema.getTargetNamespace())) {
            return null;
        }
        if (string.equals("http://www.w3.org/2001/XMLSchema")) {
            return "xsd";
        }
        if (string.equals("commonj.sdo")) {
            string2 = this.generatedSchema.getNamespaceResolver().resolveNamespaceURI(string);
            if (string2 == null) {
                string2 = this.generatedSchema.getNamespaceResolver().generatePrefix("sdo");
                this.generatedSchema.getNamespaceResolver().put(string2, string);
            }
        } else if (string.equals("commonj.sdo/java")) {
            string2 = this.generatedSchema.getNamespaceResolver().resolveNamespaceURI(string);
            if (string2 == null) {
                string2 = this.generatedSchema.getNamespaceResolver().generatePrefix("sdoJava");
                this.generatedSchema.getNamespaceResolver().put(string2, string);
            }
        } else if (string.equals("commonj.sdo/xml") && (string2 = this.generatedSchema.getNamespaceResolver().resolveNamespaceURI(string)) == null) {
            string2 = this.generatedSchema.getNamespaceResolver().generatePrefix("sdoXML");
            this.generatedSchema.getNamespaceResolver().put(string2, string);
        }
        if (string2 == null) {
            string2 = this.generatedSchema.getNamespaceResolver().resolveNamespaceURI(string);
        }
        if (string2 != null) {
            return string2;
        }
        String string3 = this.generatedSchema.getNamespaceResolver().generatePrefix();
        this.generatedSchema.getNamespaceResolver().put(string3, string);
        return string3;
    }

    private Type getAutomaticDataTypeForType(Type type) {
        if (type == SDOConstants.SDO_BOOLEANOBJECT) {
            return SDOConstants.SDO_BOOLEANOBJECT;
        }
        if (type == SDOConstants.SDO_BYTEOBJECT) {
            return SDOConstants.SDO_BYTEOBJECT;
        }
        if (type == SDOConstants.SDO_CHARACTEROBJECT) {
            return SDOConstants.SDO_CHARACTEROBJECT;
        }
        if (type == SDOConstants.SDO_DOUBLEOBJECT) {
            return SDOConstants.SDO_DOUBLEOBJECT;
        }
        if (type == SDOConstants.SDO_INTOBJECT) {
            return SDOConstants.SDO_INTOBJECT;
        }
        if (type == SDOConstants.SDO_FLOATOBJECT) {
            return SDOConstants.SDO_FLOATOBJECT;
        }
        if (type == SDOConstants.SDO_LONGOBJECT) {
            return SDOConstants.SDO_LONGOBJECT;
        }
        if (type == SDOConstants.SDO_SHORTOBJECT) {
            return SDOConstants.SDO_SHORTOBJECT;
        }
        if (type == SDOConstants.SDO_DATE) {
            return SDOConstants.SDO_DATE;
        }
        if (type == SDOConstants.SDO_DATETIME) {
            return SDOConstants.SDO_DATETIME;
        }
        return null;
    }

    private boolean importExists(List list, String string) {
        for (int i = 0; i < list.size(); ++i) {
            Include include = (Include)list.get(i);
            if (include.getSchemaLocation() == null || !include.getSchemaLocation().equals(string)) continue;
            return true;
        }
        return false;
    }
}

