/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sdo.helper;

import commonj.sdo.DataObject;
import commonj.sdo.Property;
import commonj.sdo.Sequence;
import commonj.sdo.helper.DataHelper;
import commonj.sdo.impl.HelperProvider;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.exceptions.SDOException;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.sdo.SDOConstants;
import org.eclipse.persistence.sdo.SDODataObject;
import org.eclipse.persistence.sdo.helper.ListWrapper;

public class XPathEngine {
    private static final int SET = 1;
    private static final int ISSET = 2;
    private static final int UNSET = 3;
    protected static XPathEngine defaultXPathEngine;

    private XPathEngine() {
    }

    public static XPathEngine getInstance() {
        if (defaultXPathEngine == null) {
            defaultXPathEngine = new XPathEngine();
        }
        return defaultXPathEngine;
    }

    public boolean isSet(String string, DataObject dataObject) {
        try {
            return this.processPath(string, null, dataObject, false, 2);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void unset(String string, DataObject dataObject) {
        this.processPath(string, null, dataObject, false, 3);
    }

    public void set(String string, Object object, DataObject dataObject, boolean bl) {
        this.processPath(string, object, dataObject, bl, 1);
    }

    public Object get(String string, DataObject dataObject) {
        if (string == null || string.equals("")) {
            return null;
        }
        if (string.equals("..")) {
            return dataObject.getContainer();
        }
        if (string.equals("/")) {
            return dataObject.getRootObject();
        }
        int n = (string = this.getLocalName(string)).indexOf(47);
        if (n > -1) {
            if (n == string.length() - 1) {
                return this.getValueForFragment(string.substring(0, n), dataObject);
            }
            Object object = this.getValueForFragment(string.substring(0, n), dataObject);
            DataObject dataObject2 = (DataObject)object;
            return this.get(string.substring(n + 1, string.length()), dataObject2);
        }
        return this.getValueForFragment(string, dataObject);
    }

    private boolean processPath(String string, Object object, DataObject dataObject, boolean bl, int n) {
        int n2 = (string = this.getLocalName(string)).lastIndexOf(47);
        if (-1 < n2) {
            String string2 = string.substring(n2 + 1);
            return this.setIsSetUnSet(string2, string, dataObject, object, n2, bl, n);
        }
        String string3 = string;
        return this.setIsSetUnSet(string3, string, dataObject, object, n2, bl, n);
    }

    private boolean setIsSetUnSet(String string, String string2, DataObject dataObject, Object object, int n, boolean bl, int n2) {
        DataObject dataObject2;
        Object object2;
        int n3 = string.lastIndexOf(46);
        int n4 = string.lastIndexOf(91);
        int n5 = string.lastIndexOf(93);
        int n6 = this.getNumberInFrag(string, n3, n4, n5);
        String string3 = this.getPropertyNameInFrag(string, n6, n3, n4);
        if (-1 < n) {
            object2 = this.get(string2.substring(0, n), dataObject);
            if (object2 == null || object2 instanceof ListWrapper) {
                throw SDOException.cannotPerformOperationOnProperty(string3, string2);
            }
            dataObject2 = (SDODataObject)object2;
        } else {
            dataObject2 = dataObject;
        }
        object2 = dataObject2.getInstanceProperty(string3);
        switch (n2) {
            case 1: {
                if (object2 == null) {
                    object2 = ((SDODataObject)dataObject2).defineOpenContentProperty(string3, object);
                }
                if (object2 != null) {
                    this.set((Property)object2, dataObject2, n6, object, bl);
                }
                return false;
            }
            case 2: {
                if (object2 == null) {
                    return false;
                }
                return this.isSet((Property)object2, dataObject2);
            }
            case 3: {
                if (object2 == null) {
                    return false;
                }
                this.unSet((Property)object2, dataObject2, n6);
                return false;
            }
        }
        return false;
    }

    private boolean isSet(Property property, DataObject dataObject) {
        return dataObject.isSet(property);
    }

    private void unSet(Property property, DataObject dataObject, int n) {
        if (n == -1) {
            dataObject.unset(property);
        } else {
            List list = dataObject.getList(property);
            if (n <= list.size()) {
                list.remove(n);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void set(Property property, DataObject dataObject, int n, Object object, boolean bl) {
        if (n == -1) {
            if (dataObject == null) throw new IllegalArgumentException("lastDataObject is null");
            if (bl) {
                object = DataHelper.INSTANCE.convert(property, object);
            }
            dataObject.set(property, object);
            return;
        } else {
            Sequence sequence;
            List list = dataObject.getList(property);
            if (bl) {
                object = DataHelper.INSTANCE.convert(property.getType(), object);
            }
            if ((sequence = dataObject.getSequence()) != null) {
                sequence.setValue(n, object);
                return;
            } else {
                list.set(n, object);
            }
        }
    }

    private String getLocalName(String string) {
        int n = string.indexOf(58);
        if (n > -1) {
            String string2 = string.substring(n + 1, string.length());
            return string2;
        }
        return string;
    }

    private Object getValueForFragment(String string, DataObject dataObject) {
        int n = string.lastIndexOf(46);
        int n2 = string.lastIndexOf(91);
        int n3 = string.lastIndexOf(93);
        int n4 = this.getNumberInFrag(string, n, n2, n3);
        String string2 = this.getPropertyNameInFrag(string, n4, n, n2);
        int n5 = this.isQueryPath(string, n2, n3);
        if (n5 == -1) {
            return this.getObjectByFragment(string2, n4, dataObject);
        }
        return this.getDataObjectFromQuery(string, n2, n3, n5, dataObject, string2);
    }

    private String getPropertyNameInFrag(String string, int n, int n2, int n3) {
        int n4 = 0;
        if (string.indexOf(64) != -1) {
            ++n4;
        }
        if (n3 != -1) {
            return string.substring(n4, n3);
        }
        if (n2 != -1 && n != -1) {
            return string.substring(n4, n2);
        }
        return string.substring(n4);
    }

    private int getNumberInFrag(String string, int n, int n2, int n3) {
        if (n2 != -1 && n3 != -1 && n2 < n3) {
            return this.acquireNumberInBrackets(string, n2, n3);
        }
        if (n != -1) {
            return this.acquireNumberAtDot(string, n);
        }
        return -1;
    }

    private int isQueryPath(String string, int n, int n2) {
        if (n != -1 && n2 != -1 && n < n2) {
            return string.substring(n, n2).indexOf(61);
        }
        return -1;
    }

    private DataObject getDataObjectFromQuery(String string, int n, int n2, int n3, DataObject dataObject, String string2) {
        try {
            String string3 = string.substring(n + 1, n3 + n).trim();
            List list = dataObject.getList(dataObject.getInstanceProperty(string2));
            String string4 = string.substring(n3 + n + 1, n2);
            String string5 = null;
            int n4 = string4.indexOf(39);
            int n5 = string4.lastIndexOf(39);
            if (n4 == -1 && n5 == -1) {
                n4 = string4.indexOf("\"");
                n5 = string4.lastIndexOf("\"");
            }
            string5 = n4 != -1 && n5 != -1 && n4 < n5 ? string4.substring(n4 + 1, n5) : string4.trim();
            Iterator iterator = list.iterator();
            Object object = string5;
            Object object22 = null;
            while (iterator.hasNext()) {
                DataObject dataObject2 = (DataObject)iterator.next();
                Property property = dataObject2.getInstanceProperty(string3);
                if (property == null) continue;
                try {
                    object = XMLConversionManager.getDefaultXMLManager().convertObject(object, property.getType().getInstanceClass());
                }
                catch (ConversionException conversionException) {
                    // empty catch block
                }
                if (!property.isMany()) {
                    object22 = dataObject2.get(property);
                    if (!object22.equals(object)) continue;
                    return dataObject2;
                }
                List list2 = dataObject2.getList(property);
                for (Object object22 : list2) {
                    if (!object22.equals(object)) continue;
                    return dataObject2;
                }
            }
            return null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    private Object getObjectByFragment(String string, int n, DataObject dataObject) {
        Property property = dataObject.getInstanceProperty(string);
        if (property == null) {
            return null;
        }
        if (property.isMany() && n > -1) {
            return dataObject.getList(property).get(n);
        }
        return dataObject.get(property);
    }

    private int acquireNumberInBrackets(String string, int n, int n2) {
        String string2 = string.substring(n + 1, n2);
        if (string2.matches("[1-9][0-9]*")) {
            return Integer.parseInt(string2) - 1;
        }
        return -1;
    }

    private int acquireNumberAtDot(String string, int n) {
        int n2 = -1;
        String string2 = string.substring(n + 1);
        if (string2.matches("[0-9]+")) {
            n2 = Integer.parseInt(string2);
        }
        return n2;
    }

    public Object convertObjectToValueByPath(String string, Class clazz, DataObject dataObject) throws ClassCastException {
        if (null == string || string == "") {
            throw new ClassCastException("Attempting null value conversion.");
        }
        try {
            Property property;
            SDODataObject sDODataObject;
            int n;
            String string2;
            int n2 = string.lastIndexOf(47);
            int n3 = -1;
            if (-1 < n2) {
                string2 = string.substring(n2 + 1);
                n = string2.lastIndexOf(46);
                int n4 = string2.lastIndexOf(91);
                int n5 = string2.lastIndexOf(93);
                n3 = this.getNumberInFrag(string2, n, n4, n5);
                String string3 = this.getPropertyNameInFrag(string2, n3, n, n4);
                sDODataObject = (SDODataObject)dataObject.getDataObject(string.substring(0, n2));
                if (sDODataObject == null) {
                    return null;
                }
                property = sDODataObject.getInstanceProperty(string3);
            } else {
                string2 = string;
                n = string2.lastIndexOf(46);
                int n6 = string2.lastIndexOf(91);
                int n7 = string2.lastIndexOf(93);
                n3 = this.getNumberInFrag(string2, n, n6, n7);
                String string4 = this.getPropertyNameInFrag(string2, n3, n, n6);
                sDODataObject = (SDODataObject)dataObject;
                if (sDODataObject == null) {
                    return null;
                }
                property = dataObject.getInstanceProperty(string4);
            }
            if (property != null && clazz == Date.class && property.getType().equals(SDOConstants.SDO_STRING)) {
                string2 = HelperProvider.getDefaultContext().getDataHelper();
                String string5 = n3 == -1 ? (String)sDODataObject.get(property) : (String)sDODataObject.getList(property).get(n3);
                return string2.toDate(string5);
            }
            return sDODataObject.convertObjectToValue(property, n3, clazz);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ClassCastException("Conversion is not supported.");
        }
    }
}

