/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sessions.server;

import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.persistence.exceptions.ConcurrencyException;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.internal.databaseaccess.Accessor;
import org.eclipse.persistence.internal.databaseaccess.DatasourceAccessor;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.localization.ToStringLocalization;
import org.eclipse.persistence.sessions.Login;
import org.eclipse.persistence.sessions.server.ServerSession;

public class ConnectionPool {
    protected boolean isConnected;
    protected int maxNumberOfConnections;
    protected int minNumberOfConnections;
    protected Vector connectionsAvailable;
    protected Vector connectionsUsed;
    protected Login login;
    protected String name;
    protected ServerSession owner;
    protected boolean checkConnections;

    public ConnectionPool() {
        this.maxNumberOfConnections = 50;
        this.minNumberOfConnections = 3;
        this.checkConnections = false;
        this.resetConnections();
    }

    public ConnectionPool(String string, Login login, int n, int n2, ServerSession serverSession) {
        this.login = login;
        this.owner = serverSession;
        this.name = string;
        this.maxNumberOfConnections = n2;
        this.minNumberOfConnections = n;
        this.checkConnections = false;
        this.resetConnections();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Accessor acquireConnection() throws ConcurrencyException {
        while (this.connectionsAvailable.isEmpty()) {
            if (this.connectionsUsed.size() + this.connectionsAvailable.size() < this.maxNumberOfConnections) {
                Accessor accessor = this.buildConnection();
                this.connectionsUsed.add(accessor);
                return accessor;
            }
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                throw ConcurrencyException.waitFailureOnClientSession(interruptedException);
            }
        }
        Accessor accessor = (Accessor)this.connectionsAvailable.get(0);
        this.connectionsAvailable.remove(accessor);
        if (this.checkConnections) {
            for (int i = this.connectionsAvailable.size(); i >= 0; --i) {
                if (this.getOwner().getLogin().isConnectionHealthValidatedOnError() && this.getOwner().getServerPlatform().wasFailureCommunicationBased(null, accessor, this.getOwner())) {
                    try {
                        accessor.closeConnection();
                    }
                    catch (Exception exception) {
                    }
                    finally {
                        accessor.releaseCustomizer();
                    }
                    if (this.connectionsAvailable.isEmpty()) {
                        this.checkConnections = false;
                        return this.acquireConnection();
                    }
                    accessor = (Accessor)this.connectionsAvailable.get(0);
                    this.connectionsAvailable.remove(accessor);
                    continue;
                }
                this.checkConnections = false;
                break;
            }
        }
        this.connectionsUsed.add(accessor);
        if (this.getOwner().isInProfile()) {
            this.getOwner().updateProfile(this.getName(), new Integer(this.getConnectionsUsed().size()));
        }
        return accessor;
    }

    protected Accessor buildConnection() {
        Login login = (Login)this.getLogin().clone();
        Accessor accessor = login.buildAccessor();
        accessor.connect(login, this.getOwner());
        return accessor;
    }

    public Vector getConnectionsAvailable() {
        return this.connectionsAvailable;
    }

    protected Vector getConnectionsUsed() {
        return this.connectionsUsed;
    }

    public Login getLogin() {
        return this.login;
    }

    public int getMaxNumberOfConnections() {
        return this.maxNumberOfConnections;
    }

    public int getMinNumberOfConnections() {
        return this.minNumberOfConnections;
    }

    public String getName() {
        return this.name;
    }

    protected ServerSession getOwner() {
        return this.owner;
    }

    public int getTotalNumberOfConnections() {
        return this.getConnectionsUsed().size() + this.getConnectionsAvailable().size();
    }

    public boolean hasConnectionAvailable() {
        return !this.getConnectionsAvailable().isEmpty();
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    public boolean isThereConflictBetweenLoginAndType() {
        return this.getLogin().shouldUseExternalConnectionPooling();
    }

    public synchronized void releaseConnection(Accessor accessor) throws DatabaseException {
        if (accessor instanceof DatasourceAccessor) {
            ((DatasourceAccessor)accessor).resetStatmentsCount();
        }
        this.connectionsUsed.remove(accessor);
        if (!accessor.isValid()) {
            this.getOwner().setCheckConnections();
            try {
                accessor.disconnect(this.getOwner());
            }
            catch (DatabaseException databaseException) {}
        } else if (this.connectionsUsed.size() + this.connectionsAvailable.size() < this.minNumberOfConnections) {
            this.connectionsAvailable.add(accessor);
        } else {
            accessor.disconnect(this.getOwner());
        }
        if (this.getOwner().isInProfile()) {
            this.getOwner().updateProfile(this.getName(), new Integer(this.getConnectionsUsed().size()));
        }
        this.notify();
    }

    public void resetConnections() {
        this.connectionsUsed = new Vector();
        this.connectionsAvailable = new Vector();
        this.checkConnections = false;
    }

    public void setCheckConnections() {
        this.checkConnections = true;
    }

    protected void setConnectionsAvailable(Vector vector) {
        this.connectionsAvailable = vector;
    }

    protected void setConnectionsUsed(Vector vector) {
        this.connectionsUsed = vector;
    }

    public void setIsConnected(boolean bl) {
        this.isConnected = bl;
    }

    public void setLogin(Login login) {
        this.login = login;
    }

    public void setMaxNumberOfConnections(int n) {
        this.maxNumberOfConnections = n;
    }

    public void setMinNumberOfConnections(int n) {
        this.minNumberOfConnections = n;
    }

    public void setName(String string) {
        this.name = string;
    }

    protected void setOwner(ServerSession serverSession) {
        this.owner = serverSession;
    }

    public synchronized void shutDown() {
        this.setIsConnected(false);
        Enumeration enumeration = this.getConnectionsAvailable().elements();
        while (enumeration.hasMoreElements()) {
            try {
                ((Accessor)enumeration.nextElement()).disconnect(this.getOwner());
            }
            catch (DatabaseException databaseException) {}
        }
        enumeration = this.getConnectionsUsed().elements();
        while (enumeration.hasMoreElements()) {
            try {
                ((Accessor)enumeration.nextElement()).disconnect(this.getOwner());
            }
            catch (DatabaseException databaseException) {}
        }
        this.resetConnections();
    }

    public synchronized void startUp() {
        for (int i = this.getMinNumberOfConnections(); i > 0; --i) {
            this.getConnectionsAvailable().addElement(this.buildConnection());
        }
        this.setIsConnected(true);
    }

    public String toString() {
        Object[] objectArray = new Object[]{new Integer(this.getMinNumberOfConnections()), new Integer(this.getMaxNumberOfConnections())};
        return Helper.getShortClassName(this.getClass()) + ToStringLocalization.buildMessage("min_max", objectArray);
    }
}

