/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.schemaframework;

import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.tools.schemaframework.DatabaseObjectDefinition;
import org.eclipse.persistence.tools.schemaframework.FieldDefinition;

public class TypeDefinition
extends DatabaseObjectDefinition {
    protected Vector fields = new Vector();

    public void addField(String string, Class clazz) {
        this.addField(new FieldDefinition(string, clazz));
    }

    public void addField(String string, Class clazz, int n) {
        this.addField(new FieldDefinition(string, clazz, n));
    }

    public void addField(String string, Class clazz, int n, int n2) {
        this.addField(new FieldDefinition(string, clazz, n, n2));
    }

    public void addField(String string, String string2) {
        this.addField(new FieldDefinition(string, string2));
    }

    public void addField(FieldDefinition fieldDefinition) {
        this.getFields().addElement(fieldDefinition);
    }

    public Writer buildCreationWriter(AbstractSession abstractSession, Writer writer) throws ValidationException {
        try {
            writer.write("CREATE TYPE " + this.getFullName() + " AS OBJECT (");
            Enumeration enumeration = this.getFields().elements();
            while (enumeration.hasMoreElements()) {
                FieldDefinition fieldDefinition = (FieldDefinition)enumeration.nextElement();
                fieldDefinition.appendTypeString(writer, abstractSession);
                if (!enumeration.hasMoreElements()) continue;
                writer.write(", ");
            }
            writer.write(")");
        }
        catch (IOException iOException) {
            throw ValidationException.fileError(iOException);
        }
        return writer;
    }

    public Writer buildDeletionWriter(AbstractSession abstractSession, Writer writer) throws ValidationException {
        try {
            writer.write("DROP TYPE " + this.getFullName());
        }
        catch (IOException iOException) {
            throw ValidationException.fileError(iOException);
        }
        return writer;
    }

    public Vector getFields() {
        return this.fields;
    }

    public void setFields(Vector vector) {
        this.fields = vector;
    }
}

